/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import java.awt.Dialog;
import javax.swing.SwingUtilities;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.ppoints.GlobalProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointWizard;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.ui.Bundle;
import org.netbeans.modules.profiler.ppoints.ui.ProfilingPointsWindow;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.NodeAction;

public class InsertProfilingPointAction
extends NodeAction {
    public InsertProfilingPointAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(InsertProfilingPointAction.class);
    }

    public String getName() {
        return Bundle.InsertProfilingPointAction_ActionName();
    }

    public void performAction(Lookup.Provider project) {
        if (ProfilingPointsManager.getDefault().isProfilingSessionInProgress()) {
            ProfilerDialogs.displayWarning((String)Bundle.InsertProfilingPointAction_ProfilingInProgressMsg());
            return;
        }
        if (ProjectUtilities.getOpenedProjects().length == 0) {
            ProfilerDialogs.displayWarning((String)Bundle.InsertProfilingPointAction_NoProjectMsg());
            return;
        }
        ProfilingPointWizard ppWizard = ProfilingPointWizard.getDefault();
        WizardDescriptor wd = ppWizard.getWizardDescriptor(project);
        if (wd != null) {
            Dialog d = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wd);
            d.setVisible(true);
            boolean createPPoint = wd.getValue() == WizardDescriptor.FINISH_OPTION;
            ProfilingPoint profilingPoint = ppWizard.finish(!createPPoint);
            if (createPPoint) {
                ProfilingPointsManager.getDefault().addProfilingPoint(profilingPoint);
                if (profilingPoint instanceof GlobalProfilingPoint) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!ProfilingPointsWindow.getDefault().isOpened()) {
                                ProfilingPointsWindow.getDefault().open();
                                ProfilingPointsWindow.getDefault().requestVisible();
                            }
                        }
                    });
                }
            }
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] nodes) {
        return true;
    }

    protected void performAction(Node[] nodes) {
        this.performAction((Lookup.Provider)null);
    }
}

