/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.ProfilerControlPanel2;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.project.ProjectStorage;
import org.netbeans.modules.profiler.ppoints.Bundle;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.TimedGlobalProfilingPoint;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.ProfilingPointReport;
import org.netbeans.modules.profiler.ppoints.ui.TimedTakeSnapshotCustomizer;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public final class TimedTakeSnapshotProfilingPoint
extends TimedGlobalProfilingPoint
implements PropertyChangeListener {
    public static final String TAKEN_HEAPDUMP_PREFIX = "heapdump-";
    static final String PROPERTY_TYPE = "p_snapshot";
    public static final String TYPE_PROFDATA_KEY = "profdata";
    public static final String TYPE_HEAPDUMP_KEY = "heapdump";
    static final String PROPERTY_TARGET = "p_target";
    public static final String TARGET_PROJECT_KEY = "project";
    public static final String TARGET_CUSTOM_KEY = "custom";
    static final String PROPERTY_CUSTOM_FILE = "p_file";
    static final String PROPERTY_RESET_RESULTS = "p_reset_results";
    private static final String SNAPSHOT_LOCATION_URLMASK = "file:";
    private static final String NO_DATA_AVAILABLE_MESSAGE = Bundle.TimedTakeSnapshotProfilingPoint_NoDataAvailableMsg();
    private List<Result> results = new ArrayList<Result>();
    private final Object resultsSync = new Object();
    private String snapshotFile = System.getProperty("java.io.tmpdir");
    private String snapshotTarget = "project";
    private String snapshotType = "profdata";
    private WeakReference<Report> reportReference;
    private boolean resetResults = false;

    public TimedTakeSnapshotProfilingPoint(String name, Lookup.Provider project, ProfilingPointFactory factory) {
        super(name, project, factory);
        this.getChangeSupport().addPropertyChangeListener(this);
    }

    public void setResetResults(boolean resetResults) {
        if (this.resetResults == resetResults) {
            return;
        }
        this.resetResults = resetResults;
        this.getChangeSupport().firePropertyChange(PROPERTY_RESET_RESULTS, !this.resetResults, this.resetResults);
    }

    public boolean getResetResults() {
        return this.resetResults;
    }

    public void setSnapshotFile(String snapshotFile) {
        if (snapshotFile == null || !new File(snapshotFile).exists()) {
            return;
        }
        if (this.snapshotFile != null && new File(this.snapshotFile).equals(new File(snapshotFile))) {
            return;
        }
        String oldSnapshotFile = this.snapshotFile;
        this.snapshotFile = snapshotFile;
        this.getChangeSupport().firePropertyChange(PROPERTY_CUSTOM_FILE, oldSnapshotFile, snapshotFile);
    }

    public String getSnapshotFile() {
        return this.snapshotFile;
    }

    public void setSnapshotTarget(String snapshotTarget) {
        if (!snapshotTarget.equals(TARGET_PROJECT_KEY) && !snapshotTarget.equals(TARGET_CUSTOM_KEY)) {
            throw new IllegalArgumentException("Invalid snapshot target category: " + snapshotTarget);
        }
        if (this.snapshotTarget.equals(snapshotTarget)) {
            return;
        }
        String oldSnapshotTarget = this.snapshotTarget;
        this.snapshotTarget = snapshotTarget;
        this.getChangeSupport().firePropertyChange(PROPERTY_TARGET, oldSnapshotTarget, snapshotTarget);
    }

    public String getSnapshotTarget() {
        return this.snapshotTarget;
    }

    public void setSnapshotType(String snapshotType) {
        if (snapshotType == null || !snapshotType.equals(TYPE_PROFDATA_KEY) && !snapshotType.equals(TYPE_HEAPDUMP_KEY)) {
            throw new IllegalArgumentException("Invalid snapshot type: " + snapshotType);
        }
        if (this.snapshotType.equals(snapshotType)) {
            return;
        }
        String oldSnapshotType = this.snapshotType;
        this.snapshotType = snapshotType;
        this.getChangeSupport().firePropertyChange(PROPERTY_TYPE, oldSnapshotType, snapshotType);
    }

    public String getSnapshotType() {
        return this.snapshotType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasResults() {
        Object object = this.resultsSync;
        synchronized (object) {
            return !this.results.isEmpty();
        }
    }

    @Override
    public void hideResults() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Report report = TimedTakeSnapshotProfilingPoint.this.getReport(false);
                if (report != null) {
                    report.close();
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Report report = this.getReport(false);
        if (report != null) {
            if (evt.getPropertyName() == "p_name") {
                report.refreshProperties();
            }
            report.refresh();
        }
    }

    @Override
    public void showResults(URL url) {
        Report topComponent = this.getReport(true);
        topComponent.open();
        topComponent.requestActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getResultsText() {
        Object object = this.resultsSync;
        synchronized (object) {
            if (this.hasResults()) {
                int size = this.results.size();
                String string = size == 1 ? Bundle.TimedTakeSnapshotProfilingPoint_OneHitString(Utils.formatLocalProfilingPointTime(this.results.get(size - 1).getTimestamp())) : Bundle.TimedTakeSnapshotProfilingPoint_NHitsString(size, Utils.formatLocalProfilingPointTime(this.results.get(size - 1).getTimestamp()));
                return string;
            }
            return Bundle.TimedTakeSnapshotProfilingPoint_NoResultsString();
        }
    }

    @Override
    protected void updateCustomizer(ValidityAwarePanel c) {
        TimedTakeSnapshotCustomizer customizer = (TimedTakeSnapshotCustomizer)c;
        customizer.setPPName(this.getName());
        customizer.setPPType(TYPE_PROFDATA_KEY.equals(this.getSnapshotType()));
        customizer.setPPTarget(TARGET_PROJECT_KEY.equals(this.getSnapshotTarget()));
        customizer.setPPFile(this.getSnapshotFile());
        customizer.setPPResetResults(this.getResetResults());
        customizer.setTimeCondition(this.getCondition());
    }

    FileObject getSnapshotDirectory() throws IOException {
        if (this.snapshotTarget.equals(TARGET_PROJECT_KEY)) {
            return ProjectStorage.getSettingsFolder((Lookup.Provider)this.getProject(), (boolean)true);
        }
        File f = new File(this.snapshotFile);
        f.mkdirs();
        return FileUtil.toFileObject((File)FileUtil.normalizeFile((File)f));
    }

    @Override
    void setValues(ValidityAwarePanel c) {
        TimedTakeSnapshotCustomizer customizer = (TimedTakeSnapshotCustomizer)c;
        this.setName(customizer.getPPName());
        this.setSnapshotType(customizer.getPPType() ? TYPE_PROFDATA_KEY : TYPE_HEAPDUMP_KEY);
        this.setSnapshotTarget(customizer.getPPTarget() ? TARGET_PROJECT_KEY : TARGET_CUSTOM_KEY);
        this.setSnapshotFile(customizer.getPPFile());
        this.setResetResults(customizer.getPPResetResults());
        this.setCondition(customizer.getTimeCondition());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void hit(long hitValue) {
        String snapshotFilename;
        long currentTime = System.currentTimeMillis();
        if (this.snapshotType.equals(TYPE_HEAPDUMP_KEY)) {
            snapshotFilename = this.takeHeapdumpHit();
        } else {
            snapshotFilename = this.takeSnapshotHit();
            if (this.getResetResults()) {
                try {
                    ResultsManager.getDefault().reset();
                    TargetAppRunner runner = Profiler.getDefault().getTargetAppRunner();
                    if (runner.targetJVMIsAlive()) {
                        runner.resetTimers();
                    }
                }
                catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                    // empty catch block
                }
            }
        }
        Object object = this.resultsSync;
        synchronized (object) {
            if (ProfilingPointsManager.getDefault().belowMaxHits(this.results.size())) {
                this.results.add(new Result(currentTime, snapshotFilename));
            }
        }
        this.getChangeSupport().firePropertyChange("p_results", false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void reset() {
        Object object = this.resultsSync;
        synchronized (object) {
            boolean change = this.hasResults();
            this.results.clear();
            if (change) {
                this.getChangeSupport().firePropertyChange("p_results", false, true);
            }
        }
    }

    private String getCurrentHeapDumpFilename() {
        try {
            String fileName = TAKEN_HEAPDUMP_PREFIX + System.currentTimeMillis();
            FileObject folder = this.getSnapshotDirectory();
            return FileUtil.toFile((FileObject)folder).getAbsolutePath() + File.separator + FileUtil.findFreeFileName((FileObject)folder, (String)fileName, (String)"hprof") + "." + "hprof";
        }
        catch (IOException e) {
            return null;
        }
    }

    private Report getReport(boolean create) {
        Report report;
        Report report2 = report = this.reportReference == null ? null : (Report)((Object)this.reportReference.get());
        if (report == null && create) {
            report = new Report();
            this.reportReference = new WeakReference<Report>(report);
        }
        return report;
    }

    private String takeHeapdumpHit() {
        TargetAppRunner runner = Profiler.getDefault().getTargetAppRunner();
        if (runner.getProfilingSessionStatus().remoteProfiling) {
            return Bundle.TimedTakeSnapshotProfilingPoint_NoDataRemoteMsg();
        }
        if (!runner.hasSupportedJDKForHeapDump()) {
            return Bundle.TimedTakeSnapshotProfilingPoint_NoDataJdkMsg();
        }
        String dumpFileName = this.getCurrentHeapDumpFilename();
        if (dumpFileName == null) {
            return NO_DATA_AVAILABLE_MESSAGE;
        }
        boolean heapdumpTaken = false;
        try {
            heapdumpTaken = runner.getProfilerClient().takeHeapDump(dumpFileName);
        }
        catch (Exception ex) {
            ProfilerLogger.log((Exception)ex);
        }
        if (heapdumpTaken) {
            ProfilerControlPanel2.getDefault().refreshSnapshotsList();
            try {
                return new File(dumpFileName).toURI().toURL().toExternalForm();
            }
            catch (MalformedURLException ex) {
                ProfilerLogger.log((Exception)ex);
                return NO_DATA_AVAILABLE_MESSAGE;
            }
        }
        return NO_DATA_AVAILABLE_MESSAGE;
    }

    private static LoadedSnapshot takeSnapshot() {
        return ResultsManager.getDefault().prepareSnapshot();
    }

    private String takeSnapshotHit() {
        LoadedSnapshot loadedSnapshot = null;
        String snapshotFilename = null;
        loadedSnapshot = TimedTakeSnapshotProfilingPoint.takeSnapshot();
        if (loadedSnapshot != null) {
            try {
                FileObject snapshotDirectory = this.getSnapshotDirectory();
                FileObject profFile = snapshotDirectory.createData(ResultsManager.getDefault().getDefaultSnapshotFileName(loadedSnapshot), "nps");
                ResultsManager.getDefault().saveSnapshot(loadedSnapshot, profFile);
                snapshotFilename = FileUtil.toFile((FileObject)profFile).toURI().toURL().toExternalForm();
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(65536, (Throwable)e);
            }
        }
        return snapshotFilename == null ? NO_DATA_AVAILABLE_MESSAGE : snapshotFilename;
    }

    private class Report
    extends ProfilingPointReport {
        private HTMLTextArea dataArea;
        private HTMLTextArea headerArea;

        public Report() {
            this.initDefaults();
            this.initComponents();
            this.refresh();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void refresh() {
            StringBuilder headerAreaTextBuilder = new StringBuilder();
            headerAreaTextBuilder.append(this.getHeaderName());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderType());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderEnabled());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderProject());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderMode());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderTarget());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderResetResults());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderHitsCount());
            this.headerArea.setText(headerAreaTextBuilder.toString());
            StringBuilder dataAreaTextBuilder = new StringBuilder();
            Object object = TimedTakeSnapshotProfilingPoint.this.resultsSync;
            synchronized (object) {
                if (TimedTakeSnapshotProfilingPoint.this.results.isEmpty()) {
                    dataAreaTextBuilder.append(ProfilingPointReport.getNoDataHint(TimedTakeSnapshotProfilingPoint.this));
                } else {
                    for (int i = 0; i < TimedTakeSnapshotProfilingPoint.this.results.size(); ++i) {
                        dataAreaTextBuilder.append("&nbsp;&nbsp;");
                        dataAreaTextBuilder.append(this.getDataResultItem(i));
                        dataAreaTextBuilder.append("<br>");
                    }
                    ProfilingPointsManager m = ProfilingPointsManager.getDefault();
                    if (!m.belowMaxHits(TimedTakeSnapshotProfilingPoint.this.results.size())) {
                        dataAreaTextBuilder.append(m.getTruncatedResultsText());
                    }
                }
            }
            this.dataArea.setText(dataAreaTextBuilder.toString());
        }

        void refreshProperties() {
            this.setName(TimedTakeSnapshotProfilingPoint.this.getName());
            this.setIcon(((ImageIcon)TimedTakeSnapshotProfilingPoint.this.getFactory().getIcon()).getImage());
            this.getAccessibleContext().setAccessibleDescription(Bundle.TimedTakeSnapshotProfilingPoint_ReportAccessDescr(this.getName()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getDataResultItem(int index) {
            Object object = TimedTakeSnapshotProfilingPoint.this.resultsSync;
            synchronized (object) {
                Result result = (Result)TimedTakeSnapshotProfilingPoint.this.results.get(index);
                String resultString = result.getResultString();
                String snapshotInformation = resultString.startsWith(TimedTakeSnapshotProfilingPoint.SNAPSHOT_LOCATION_URLMASK) ? "<a href='" + resultString + "'>" + Bundle.TimedTakeSnapshotProfilingPoint_OpenSnapshotString() + "</a>" : resultString;
                return Bundle.TimedTakeSnapshotProfilingPoint_HitString(index + 1, Utils.formatLocalProfilingPointTime(result.getTimestamp()), snapshotInformation);
            }
        }

        private String getHeaderEnabled() {
            return Bundle.TimedTakeSnapshotProfilingPoint_HeaderEnabledString(TimedTakeSnapshotProfilingPoint.this.isEnabled());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getHeaderHitsCount() {
            Object object = TimedTakeSnapshotProfilingPoint.this.resultsSync;
            synchronized (object) {
                return Bundle.TimedTakeSnapshotProfilingPoint_HeaderHitsString(TimedTakeSnapshotProfilingPoint.this.results.size());
            }
        }

        private String getHeaderMode() {
            return TimedTakeSnapshotProfilingPoint.this.getSnapshotType().equals(TimedTakeSnapshotProfilingPoint.TYPE_PROFDATA_KEY) ? Bundle.TimedTakeSnapshotProfilingPoint_HeaderModeDataString() : Bundle.TimedTakeSnapshotProfilingPoint_HeaderModeDumpString();
        }

        private String getHeaderName() {
            return "<h2><b>" + TimedTakeSnapshotProfilingPoint.this.getName() + "</b></h2>";
        }

        private String getHeaderProject() {
            return Bundle.TimedTakeSnapshotProfilingPoint_HeaderProjectString(ProjectUtilities.getDisplayName((Lookup.Provider)TimedTakeSnapshotProfilingPoint.this.getProject()));
        }

        private String getHeaderResetResults() {
            return Bundle.TimedTakeSnapshotProfilingPoint_HeaderResetResultsString(TimedTakeSnapshotProfilingPoint.this.getResetResults());
        }

        private String getHeaderTarget() {
            return TimedTakeSnapshotProfilingPoint.this.getSnapshotTarget().equals(TimedTakeSnapshotProfilingPoint.TARGET_PROJECT_KEY) ? Bundle.TimedTakeSnapshotProfilingPoint_HeaderTargetProjectString() : Bundle.TimedTakeSnapshotProfilingPoint_HeaderTargetCustomString(TimedTakeSnapshotProfilingPoint.this.getSnapshotFile());
        }

        private String getHeaderType() {
            return Bundle.TimedTakeSnapshotProfilingPoint_HeaderTypeString(TimedTakeSnapshotProfilingPoint.this.getFactory().getType());
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            JPanel contentsPanel = new JPanel(new BorderLayout());
            contentsPanel.setBackground(UIUtils.getProfilerResultsBackground());
            contentsPanel.setOpaque(true);
            contentsPanel.setBorder(BorderFactory.createMatteBorder(0, 15, 15, 15, UIUtils.getProfilerResultsBackground()));
            this.headerArea = new HTMLTextArea();
            JScrollPane headerAreaScrollPane = new JScrollPane((Component)this.headerArea, 20, 30);
            headerAreaScrollPane.setBorder(BorderFactory.createMatteBorder(0, 0, 15, 0, UIUtils.getProfilerResultsBackground()));
            headerAreaScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            contentsPanel.add((Component)headerAreaScrollPane, "North");
            this.dataArea = new HTMLTextArea(){

                protected void showURL(URL url) {
                    File resolvedFile = null;
                    try {
                        resolvedFile = new File(url.toURI());
                    }
                    catch (URISyntaxException ex) {
                        ex.printStackTrace();
                    }
                    File snapshotFile = resolvedFile;
                    if (snapshotFile != null && snapshotFile.exists()) {
                        String type = TimedTakeSnapshotProfilingPoint.this.getSnapshotType();
                        if (type.equals(TimedTakeSnapshotProfilingPoint.TYPE_PROFDATA_KEY) || type.equals(TimedTakeSnapshotProfilingPoint.TYPE_HEAPDUMP_KEY)) {
                            ResultsManager.getDefault().openSnapshot(snapshotFile);
                        }
                    } else {
                        ProfilerDialogs.displayWarning((String)Bundle.TimedTakeSnapshotProfilingPoint_SnapshotNotAvailableMsg());
                    }
                }
            };
            JScrollPane dataAreaScrollPane = new JScrollPane((Component)this.dataArea, 20, 30);
            TitledBorder tb = new TitledBorder(Bundle.TimedTakeSnapshotProfilingPoint_DataString());
            tb.setTitleFont(Utils.getTitledBorderFont(tb).deriveFont(1));
            tb.setTitleColor(UIManager.getColor("Label.foreground"));
            dataAreaScrollPane.setBorder(tb);
            dataAreaScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            dataAreaScrollPane.setBackground(UIUtils.getProfilerResultsBackground());
            contentsPanel.add((Component)dataAreaScrollPane, "Center");
            this.add(contentsPanel, "Center");
        }

        private void initDefaults() {
            this.refreshProperties();
            this.setFocusable(true);
        }
    }

    private static class Result {
        private final String resultString;
        private final long timestamp;

        public Result(long timestamp, String resultString) {
            this.timestamp = timestamp;
            this.resultString = resultString;
        }

        public String getResultString() {
            return this.resultString;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

