/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.ppoints.Bundle;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.ProfilingPointReport;
import org.netbeans.modules.profiler.ppoints.ui.StopwatchCustomizer;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.openide.util.Lookup;

public final class StopwatchProfilingPoint
extends CodeProfilingPoint.Paired
implements PropertyChangeListener {
    private static final String ANNOTATION_ENABLED = "stopwatchProfilingPoint";
    private static final String ANNOTATION_DISABLED = "stopwatchProfilingPointD";
    private Annotation endAnnotation;
    private Annotation startAnnotation;
    private List<Result> results = new ArrayList<Result>();
    private final Object resultsSync = new Object();
    private WeakReference<Report> reportReference;

    public StopwatchProfilingPoint(String name, CodeProfilingPoint.Location startLocation, CodeProfilingPoint.Location endLocation, Lookup.Provider project, ProfilingPointFactory factory) {
        super(name, startLocation, endLocation, project, factory);
        this.getChangeSupport().addPropertyChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasResults() {
        Object object = this.resultsSync;
        synchronized (object) {
            return this.results.size() > 0;
        }
    }

    @Override
    public void hideResults() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Report report = StopwatchProfilingPoint.this.getReport(false);
                if (report != null) {
                    report.close();
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Report report = this.getReport(false);
        if (report != null) {
            if (evt.getPropertyName() == "p_name") {
                report.refreshProperties();
            }
            report.refresh();
        }
    }

    @Override
    public void showResults(URL url) {
        Report topComponent = this.getReport(true);
        topComponent.open();
        topComponent.requestActive();
    }

    @Override
    protected CodeProfilingPoint.Annotation getEndAnnotation() {
        if (!this.usesEndLocation()) {
            this.endAnnotation = null;
        } else if (this.endAnnotation == null) {
            this.endAnnotation = new Annotation(false);
        }
        return this.endAnnotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getResultsText() {
        Object object = this.resultsSync;
        synchronized (object) {
            if (this.hasResults()) {
                return this.results.size() == 1 ? Bundle.StopwatchProfilingPoint_OneHitString(Utils.formatProfilingPointTime(this.results.get(this.results.size() - 1).getTimestamp())) : Bundle.StopwatchProfilingPoint_NHitsString(this.results.size(), Utils.formatProfilingPointTime(this.results.get(this.results.size() - 1).getTimestamp()));
            }
            return Bundle.StopwatchProfilingPoint_NoResultsString();
        }
    }

    @Override
    protected CodeProfilingPoint.Annotation getStartAnnotation() {
        if (this.startAnnotation == null) {
            this.startAnnotation = new Annotation(true);
        }
        return this.startAnnotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void timeAdjust(int threadId, long timeDiff0, long timeDiff1) {
        if (this.usesEndLocation()) {
            Object object = this.resultsSync;
            synchronized (object) {
                for (Result result : this.results) {
                    if (result.getEndTimestamp() != -1L || result.getThreadID() != threadId) continue;
                    result.timeAdjust(timeDiff0);
                }
            }
        }
    }

    @Override
    protected void updateCustomizer(ValidityAwarePanel c) {
        StopwatchCustomizer customizer = (StopwatchCustomizer)c;
        customizer.setPPName(this.getName());
        customizer.setPPStartLocation(this.getStartLocation());
        customizer.setPPEndLocation(this.getEndLocation());
    }

    @Override
    protected boolean usesEndLocation() {
        return this.getEndLocation() != null;
    }

    @Override
    void setValues(ValidityAwarePanel c) {
        StopwatchCustomizer customizer = (StopwatchCustomizer)c;
        this.setName(customizer.getPPName());
        this.setStartLocation(customizer.getPPStartLocation());
        this.setEndLocation(customizer.getPPEndLocation());
        Utils.checkLocation(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void hit(RuntimeProfilingPoint.HitEvent hitEvent, int index) {
        block5: {
            Object object = this.resultsSync;
            synchronized (object) {
                block4: {
                    if (this.usesEndLocation() && index != 0) break block4;
                    if (!ProfilingPointsManager.getDefault().belowMaxHits(this.results.size())) break block5;
                    this.results.add(new Result(hitEvent.getTimestamp(), hitEvent.getThreadId()));
                    break block5;
                }
                for (Result result : this.results) {
                    if (result.getEndTimestamp() != -1L || result.getThreadID() != hitEvent.getThreadId()) continue;
                    result.setEndTimestamp(hitEvent.getTimestamp());
                    break;
                }
            }
        }
        this.getChangeSupport().firePropertyChange("p_results", false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void reset() {
        Object object = this.resultsSync;
        synchronized (object) {
            boolean change = this.results.size() > 0;
            this.results.clear();
            if (change) {
                this.getChangeSupport().firePropertyChange("p_results", false, true);
            }
        }
    }

    private Report getReport(boolean create) {
        Report report;
        Report report2 = report = this.reportReference == null ? null : (Report)((Object)this.reportReference.get());
        if (report == null && create) {
            report = new Report();
            this.reportReference = new WeakReference<Report>(report);
        }
        return report;
    }

    private class Annotation
    extends CodeProfilingPoint.Annotation {
        private boolean isStartAnnotation;

        public Annotation(boolean isStartAnnotation) {
            this.isStartAnnotation = isStartAnnotation;
        }

        public String getAnnotationType() {
            return StopwatchProfilingPoint.this.isEnabled() ? StopwatchProfilingPoint.ANNOTATION_ENABLED : StopwatchProfilingPoint.ANNOTATION_DISABLED;
        }

        public String getShortDescription() {
            if (!StopwatchProfilingPoint.this.usesEndLocation()) {
                return StopwatchProfilingPoint.this.getName();
            }
            return this.isStartAnnotation ? Bundle.StopwatchProfilingPoint_AnnotationStartString(StopwatchProfilingPoint.this.getName()) : Bundle.StopwatchProfilingPoint_AnnotationEndString(StopwatchProfilingPoint.this.getName());
        }

        @Override
        public CodeProfilingPoint profilingPoint() {
            return StopwatchProfilingPoint.this;
        }
    }

    private class Report
    extends ProfilingPointReport {
        private static final String START_LOCATION_URLMASK = "file:/1";
        private static final String END_LOCATION_URLMASK = "file:/2";
        private HTMLTextArea dataArea;
        private HTMLTextArea headerArea;

        public Report() {
            this.initDefaults();
            this.initComponents();
            this.refresh();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void refresh() {
            StringBuilder headerAreaTextBuilder = new StringBuilder();
            headerAreaTextBuilder.append(this.getHeaderName());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderType());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderEnabled());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderProject());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderStartLocation());
            headerAreaTextBuilder.append("<br>");
            if (StopwatchProfilingPoint.this.usesEndLocation()) {
                headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                headerAreaTextBuilder.append(this.getHeaderEndLocation());
                headerAreaTextBuilder.append("<br>");
            }
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderMeasureLocation());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderHitsCount());
            this.headerArea.setText(headerAreaTextBuilder.toString());
            StringBuilder dataAreaTextBuilder = new StringBuilder();
            Object object = StopwatchProfilingPoint.this.resultsSync;
            synchronized (object) {
                if (StopwatchProfilingPoint.this.results.isEmpty()) {
                    dataAreaTextBuilder.append(ProfilingPointReport.getNoDataHint(StopwatchProfilingPoint.this));
                } else {
                    for (int i = 0; i < StopwatchProfilingPoint.this.results.size(); ++i) {
                        dataAreaTextBuilder.append("&nbsp;&nbsp;");
                        dataAreaTextBuilder.append(this.getDataResultItem(i));
                        dataAreaTextBuilder.append("<br>");
                    }
                    ProfilingPointsManager m = ProfilingPointsManager.getDefault();
                    if (!m.belowMaxHits(StopwatchProfilingPoint.this.results.size())) {
                        dataAreaTextBuilder.append(m.getTruncatedResultsText());
                    }
                }
            }
            this.dataArea.setText(dataAreaTextBuilder.toString());
        }

        void refreshProperties() {
            this.setName(StopwatchProfilingPoint.this.getName());
            this.setIcon(((ImageIcon)StopwatchProfilingPoint.this.getFactory().getIcon()).getImage());
            this.getAccessibleContext().setAccessibleDescription(Bundle.StopwatchProfilingPoint_ReportAccessDescr(this.getName()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getDataResultItem(int index) {
            Object object = StopwatchProfilingPoint.this.resultsSync;
            synchronized (object) {
                Result result = (Result)StopwatchProfilingPoint.this.results.get(index);
                String hitTime = Utils.formatProfilingPointTimeHiRes(result.getTimestamp());
                if (!StopwatchProfilingPoint.this.usesEndLocation()) {
                    return Bundle.StopwatchProfilingPoint_HitString(index + 1, hitTime);
                }
                if (result.getEndTimestamp() == -1L) {
                    return Bundle.StopwatchProfilingPoint_HitDurationPendingString(index + 1, hitTime);
                }
                return Bundle.StopwatchProfilingPoint_HitDurationKnownString(index + 1, hitTime, Utils.getDurationInMicroSec(result.getTimestamp(), result.getEndTimestamp() - result.getTimeAdjustment()));
            }
        }

        private String getHeaderEnabled() {
            return Bundle.StopwatchProfilingPoint_HeaderEnabledString(StopwatchProfilingPoint.this.isEnabled());
        }

        private String getHeaderEndLocation() {
            CodeProfilingPoint.Location location = StopwatchProfilingPoint.this.getEndLocation();
            File file = new File(location.getFile());
            String shortFileName = file.getName();
            int lineNumber = location.getLine();
            String locationUrl = "<a href='file:/2'>";
            return Bundle.StopwatchProfilingPoint_HeaderEndLocationString(locationUrl + shortFileName, lineNumber) + "</a>";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getHeaderHitsCount() {
            Object object = StopwatchProfilingPoint.this.resultsSync;
            synchronized (object) {
                return Bundle.StopwatchProfilingPoint_HeaderHitsString(StopwatchProfilingPoint.this.results.size());
            }
        }

        private String getHeaderMeasureLocation() {
            return StopwatchProfilingPoint.this.usesEndLocation() ? Bundle.StopwatchProfilingPoint_HeaderMeasureDurationString() : Bundle.StopwatchProfilingPoint_HeaderMeasureTimestampString();
        }

        private String getHeaderName() {
            return "<h2><b>" + StopwatchProfilingPoint.this.getName() + "</b></h2>";
        }

        private String getHeaderProject() {
            return Bundle.StopwatchProfilingPoint_HeaderProjectString(ProjectUtilities.getDisplayName((Lookup.Provider)StopwatchProfilingPoint.this.getProject()));
        }

        private String getHeaderStartLocation() {
            CodeProfilingPoint.Location location = StopwatchProfilingPoint.this.getStartLocation();
            File file = new File(location.getFile());
            String shortFileName = file.getName();
            int lineNumber = location.getLine();
            String locationUrl = "<a href='file:/1'>";
            return StopwatchProfilingPoint.this.usesEndLocation() ? Bundle.StopwatchProfilingPoint_HeaderStartLocationString(locationUrl + shortFileName, lineNumber) + "</a>" : Bundle.StopwatchProfilingPoint_HeaderLocationString(locationUrl + shortFileName, lineNumber) + "</a>";
        }

        private String getHeaderType() {
            return Bundle.StopwatchProfilingPoint_HeaderTypeString(StopwatchProfilingPoint.this.getFactory().getType());
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            JPanel contentsPanel = new JPanel(new BorderLayout());
            contentsPanel.setBackground(UIUtils.getProfilerResultsBackground());
            contentsPanel.setOpaque(true);
            contentsPanel.setBorder(BorderFactory.createMatteBorder(0, 15, 15, 15, UIUtils.getProfilerResultsBackground()));
            this.headerArea = new HTMLTextArea(){

                protected void showURL(URL url) {
                    String urlString = url.toString();
                    if (Report.START_LOCATION_URLMASK.equals(urlString)) {
                        Utils.openLocation(StopwatchProfilingPoint.this.getStartLocation());
                    } else if (StopwatchProfilingPoint.this.usesEndLocation()) {
                        Utils.openLocation(StopwatchProfilingPoint.this.getEndLocation());
                    }
                }
            };
            JScrollPane headerAreaScrollPane = new JScrollPane((Component)this.headerArea, 20, 30);
            headerAreaScrollPane.setBorder(BorderFactory.createMatteBorder(0, 0, 15, 0, UIUtils.getProfilerResultsBackground()));
            headerAreaScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            contentsPanel.add((Component)headerAreaScrollPane, "North");
            this.dataArea = new HTMLTextArea();
            JScrollPane dataAreaScrollPane = new JScrollPane((Component)this.dataArea, 20, 30);
            TitledBorder tb = new TitledBorder(Bundle.StopwatchProfilingPoint_DataString());
            tb.setTitleFont(Utils.getTitledBorderFont(tb).deriveFont(1));
            tb.setTitleColor(UIManager.getColor("Label.foreground"));
            dataAreaScrollPane.setBorder(tb);
            dataAreaScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            dataAreaScrollPane.setBackground(UIUtils.getProfilerResultsBackground());
            contentsPanel.add((Component)dataAreaScrollPane, "Center");
            this.add(contentsPanel, "Center");
        }

        private void initDefaults() {
            this.refreshProperties();
            this.setFocusable(true);
        }
    }

    private static class Result {
        private final int threadId;
        private final long timestamp;
        private long endTimestamp = -1L;
        private long timeAdjustment;

        private Result(long timestamp, int threadId) {
            this.timestamp = timestamp;
            this.threadId = threadId;
        }

        private void setEndTimestamp(long endTimestamp) {
            this.endTimestamp = endTimestamp;
        }

        private long getEndTimestamp() {
            return this.endTimestamp;
        }

        private int getThreadID() {
            return this.threadId;
        }

        private long getTimeAdjustment() {
            return this.timeAdjustment;
        }

        private long getTimestamp() {
            return this.timestamp;
        }

        private void timeAdjust(long timeDiff) {
            this.timeAdjustment += timeDiff;
        }
    }
}

