/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.ppoints.Bundle;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.ProfilingPointReport;
import org.netbeans.modules.profiler.ppoints.ui.ResetResultsCustomizer;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.openide.util.Lookup;

public final class ResetResultsProfilingPoint
extends CodeProfilingPoint.Single
implements PropertyChangeListener {
    private static final String ANNOTATION_ENABLED = "resetResultsProfilingPoint";
    private static final String ANNOTATION_DISABLED = "resetResultsProfilingPointD";
    private Annotation annotation;
    private List<Result> results = new ArrayList<Result>();
    private final Object resultsSync = new Object();
    private WeakReference<Report> reportReference;

    public ResetResultsProfilingPoint(String name, CodeProfilingPoint.Location location, Lookup.Provider project, ProfilingPointFactory factory) {
        super(name, location, project, factory);
        this.getChangeSupport().addPropertyChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasResults() {
        Object object = this.resultsSync;
        synchronized (object) {
            return this.results.size() > 0;
        }
    }

    @Override
    public void hideResults() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Report report = ResetResultsProfilingPoint.this.getReport(false);
                if (report != null) {
                    report.close();
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Report report = this.getReport(false);
        if (report != null) {
            if (evt.getPropertyName() == "p_name") {
                report.refreshProperties();
            }
            report.refresh();
        }
    }

    @Override
    public void showResults(URL url) {
        Report topComponent = this.getReport(true);
        topComponent.open();
        topComponent.requestActive();
    }

    @Override
    protected CodeProfilingPoint.Annotation getAnnotation() {
        if (this.annotation == null) {
            this.annotation = new Annotation();
        }
        return this.annotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getResultsText() {
        Object object = this.resultsSync;
        synchronized (object) {
            if (this.hasResults()) {
                return this.results.size() == 1 ? Bundle.ResetResultsProfilingPoint_OneHitString(Utils.formatProfilingPointTime(this.results.get(this.results.size() - 1).getTimestamp())) : Bundle.ResetResultsProfilingPoint_NHitsString(this.results.size(), Utils.formatProfilingPointTime(this.results.get(this.results.size() - 1).getTimestamp()));
            }
            return Bundle.LoadGenProfilingPoint_NoResultsString();
        }
    }

    @Override
    protected void updateCustomizer(ValidityAwarePanel c) {
        ResetResultsCustomizer customizer = (ResetResultsCustomizer)c;
        customizer.setPPName(this.getName());
        customizer.setPPLocation(this.getLocation());
    }

    @Override
    void setValues(ValidityAwarePanel c) {
        ResetResultsCustomizer customizer = (ResetResultsCustomizer)c;
        this.setName(customizer.getPPName());
        this.setLocation(customizer.getPPLocation());
        Utils.checkLocation(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void hit(RuntimeProfilingPoint.HitEvent hitEvent, int index) {
        Object object = this.resultsSync;
        synchronized (object) {
            if (ProfilingPointsManager.getDefault().belowMaxHits(this.results.size())) {
                this.results.add(new Result(hitEvent.getTimestamp(), hitEvent.getThreadId()));
            }
        }
        this.getChangeSupport().firePropertyChange("p_results", false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void reset() {
        Object object = this.resultsSync;
        synchronized (object) {
            boolean change = this.results.size() > 0;
            this.results.clear();
            if (change) {
                this.getChangeSupport().firePropertyChange("p_results", false, true);
            }
        }
    }

    private Report getReport(boolean create) {
        Report report;
        Report report2 = report = this.reportReference == null ? null : (Report)((Object)this.reportReference.get());
        if (report == null && create) {
            report = new Report();
            this.reportReference = new WeakReference<Report>(report);
        }
        return report;
    }

    private class Annotation
    extends CodeProfilingPoint.Annotation {
        private Annotation() {
        }

        public String getAnnotationType() {
            return ResetResultsProfilingPoint.this.isEnabled() ? ResetResultsProfilingPoint.ANNOTATION_ENABLED : ResetResultsProfilingPoint.ANNOTATION_DISABLED;
        }

        public String getShortDescription() {
            return ResetResultsProfilingPoint.this.getName();
        }

        @Override
        public CodeProfilingPoint profilingPoint() {
            return ResetResultsProfilingPoint.this;
        }
    }

    private class Report
    extends ProfilingPointReport {
        private HTMLTextArea dataArea;
        private HTMLTextArea headerArea;

        public Report() {
            this.initDefaults();
            this.initComponents();
            this.refresh();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void refresh() {
            StringBuilder headerAreaTextBuilder = new StringBuilder();
            headerAreaTextBuilder.append(this.getHeaderName());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderType());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderEnabled());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderProject());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderLocation());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderHitsCount());
            this.headerArea.setText(headerAreaTextBuilder.toString());
            StringBuilder dataAreaTextBuilder = new StringBuilder();
            Object object = ResetResultsProfilingPoint.this.resultsSync;
            synchronized (object) {
                if (ResetResultsProfilingPoint.this.results.isEmpty()) {
                    dataAreaTextBuilder.append(ProfilingPointReport.getNoDataHint(ResetResultsProfilingPoint.this));
                } else {
                    for (int i = 0; i < ResetResultsProfilingPoint.this.results.size(); ++i) {
                        dataAreaTextBuilder.append("&nbsp;&nbsp;");
                        dataAreaTextBuilder.append(this.getDataResultItem(i));
                        dataAreaTextBuilder.append("<br>");
                    }
                    ProfilingPointsManager m = ProfilingPointsManager.getDefault();
                    if (!m.belowMaxHits(ResetResultsProfilingPoint.this.results.size())) {
                        dataAreaTextBuilder.append(m.getTruncatedResultsText());
                    }
                }
            }
            this.dataArea.setText(dataAreaTextBuilder.toString());
        }

        void refreshProperties() {
            this.setName(ResetResultsProfilingPoint.this.getName());
            this.setIcon(((ImageIcon)ResetResultsProfilingPoint.this.getFactory().getIcon()).getImage());
            this.getAccessibleContext().setAccessibleDescription(Bundle.ResetResultsProfilingPoint_ReportAccessDescr(this.getName()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getDataResultItem(int index) {
            Object object = ResetResultsProfilingPoint.this.resultsSync;
            synchronized (object) {
                Result result = (Result)ResetResultsProfilingPoint.this.results.get(index);
                return Bundle.ResetResultsProfilingPoint_HitSuccessString(index + 1, Utils.formatProfilingPointTimeHiRes(result.getTimestamp()));
            }
        }

        private String getHeaderEnabled() {
            return Bundle.ResetResultsProfilingPoint_HeaderEnabledString(ResetResultsProfilingPoint.this.isEnabled());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getHeaderHitsCount() {
            Object object = ResetResultsProfilingPoint.this.resultsSync;
            synchronized (object) {
                return Bundle.ResetResultsProfilingPoint_HeaderHitsString(ResetResultsProfilingPoint.this.results.size());
            }
        }

        private String getHeaderLocation() {
            CodeProfilingPoint.Location location = ResetResultsProfilingPoint.this.getLocation();
            String shortFileName = new File(location.getFile()).getName();
            int lineNumber = location.getLine();
            return Bundle.ResetResultsProfilingPoint_HeaderLocationString(shortFileName, lineNumber);
        }

        private String getHeaderName() {
            return "<h2><b>" + ResetResultsProfilingPoint.this.getName() + "</b></h2>";
        }

        private String getHeaderProject() {
            return Bundle.ResetResultsProfilingPoint_HeaderProjectString(ProjectUtilities.getDisplayName((Lookup.Provider)ResetResultsProfilingPoint.this.getProject()));
        }

        private String getHeaderType() {
            return Bundle.ResetResultsProfilingPoint_HeaderTypeString(ResetResultsProfilingPoint.this.getFactory().getType());
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            JPanel contentsPanel = new JPanel(new BorderLayout());
            contentsPanel.setBackground(UIUtils.getProfilerResultsBackground());
            contentsPanel.setOpaque(true);
            contentsPanel.setBorder(BorderFactory.createMatteBorder(0, 15, 15, 15, UIUtils.getProfilerResultsBackground()));
            this.headerArea = new HTMLTextArea(){

                protected void showURL(URL url) {
                    Utils.openLocation(ResetResultsProfilingPoint.this.getLocation());
                }
            };
            JScrollPane headerAreaScrollPane = new JScrollPane((Component)this.headerArea, 20, 30);
            headerAreaScrollPane.setBorder(BorderFactory.createMatteBorder(0, 0, 15, 0, UIUtils.getProfilerResultsBackground()));
            headerAreaScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            contentsPanel.add((Component)headerAreaScrollPane, "North");
            this.dataArea = new HTMLTextArea();
            JScrollPane dataAreaScrollPane = new JScrollPane((Component)this.dataArea, 20, 30);
            TitledBorder tb = new TitledBorder(Bundle.ResetResultsProfilingPoint_DataString());
            tb.setTitleFont(Utils.getTitledBorderFont(tb).deriveFont(1));
            tb.setTitleColor(UIManager.getColor("Label.foreground"));
            dataAreaScrollPane.setBorder(tb);
            dataAreaScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            dataAreaScrollPane.setBackground(UIUtils.getProfilerResultsBackground());
            contentsPanel.add((Component)dataAreaScrollPane, "Center");
            this.add(contentsPanel, "Center");
        }

        private void initDefaults() {
            this.refreshProperties();
            this.setFocusable(true);
        }
    }

    private static class Result {
        private final int threadId;
        private final long timestamp;

        public Result(long timestamp, int threadId) {
            this.timestamp = timestamp;
            this.threadId = threadId;
        }

        public int getThreadID() {
            return this.threadId;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

