/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.Properties;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.openide.ErrorManager;
import org.openide.util.Lookup;

public abstract class CodeProfilingPoint
extends ProfilingPoint {
    static final String PROPERTY_LOCATION = "p_location";
    static final String PROPERTY_ANNOTATION = "p_annotation";

    CodeProfilingPoint(String name, Lookup.Provider project, ProfilingPointFactory factory) {
        super(name, project, factory);
    }

    public abstract RuntimeProfilingPoint[] createRuntimeProfilingPoints();

    public Location getLocation() {
        Annotation firstAnnotation = this.getAnnotations()[0];
        return firstAnnotation == null ? null : this.getLocation(firstAnnotation);
    }

    public abstract Annotation[] getAnnotations();

    abstract void setLocation(Annotation var1, Location var2);

    abstract Location getLocation(Annotation var1);

    String getServerHandlerClassName() {
        return ((CodeProfilingPointFactory)this.getFactory()).getServerHandlerClassName();
    }

    String getServerInfo() {
        return null;
    }

    RuntimeProfilingPoint createRuntimeProfilingPoint(Location location) {
        ProfilingPointsManager ppManager = ProfilingPointsManager.getDefault();
        String className = Utils.getClassName(location);
        if (className == null) {
            return null;
        }
        return new RuntimeProfilingPoint(ppManager.createUniqueRuntimeProfilingPointIdentificator(), className, location.getLine(), location.getOffset(), this.getServerHandlerClassName(), this.getServerInfo());
    }

    abstract void hit(RuntimeProfilingPoint.HitEvent var1, int var2);

    void internalUpdateLocation(Annotation annotation, int line) {
        Location location = this.getLocation(annotation);
        if (location != null) {
            location.line = line;
        }
    }

    public static abstract class Annotation
    extends org.openide.text.Annotation {
        public abstract CodeProfilingPoint profilingPoint();

        void fireDescriptionChanged() {
            this.firePropertyChange("shortDescription", false, true);
        }

        void fireTypeChanged() {
            this.firePropertyChange("annotationType", false, true);
        }
    }

    public static final class Location {
        public static final String PROPERTY_LOCATION_FILE = "p_location_file";
        public static final String PROPERTY_LOCATION_LINE = "p_location_line";
        public static final String PROPERTY_LOCATION_OFFSET = "p_location_offset";
        public static final int OFFSET_START = Integer.MIN_VALUE;
        public static final int OFFSET_END = Integer.MAX_VALUE;
        public static final Location EMPTY = new Location("", 0, Integer.MIN_VALUE);
        private String file;
        private int line;
        private int offset;

        public Location(String file, int line, int offset) {
            this.file = file;
            this.line = line;
            this.offset = offset;
        }

        public String getFile() {
            return this.file;
        }

        public int getLine() {
            return this.line;
        }

        public boolean isLineEnd() {
            return this.getOffset() == Integer.MAX_VALUE;
        }

        public boolean isLineStart() {
            return this.getOffset() == Integer.MIN_VALUE;
        }

        public int getOffset() {
            return this.offset;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Location)) {
                return false;
            }
            Location location = (Location)object;
            return this.file.equals(location.file) && this.line == location.line && this.offset == location.offset;
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + (this.file != null ? this.file.hashCode() : 0);
            hash = 79 * hash + this.line;
            hash = 79 * hash + this.offset;
            return hash;
        }

        public static Location load(Lookup.Provider project, int index, Properties properties) {
            return Location.load(project, index, null, properties);
        }

        public static Location load(Lookup.Provider project, int index, String prefix, Properties properties) {
            String absPrefix = prefix == null ? index + "_" : index + "_" + prefix;
            String relUrl = properties.getProperty(absPrefix + PROPERTY_LOCATION_FILE, null);
            String lineStr = properties.getProperty(absPrefix + PROPERTY_LOCATION_LINE, null);
            String offsetStr = properties.getProperty(absPrefix + PROPERTY_LOCATION_OFFSET, null);
            if (relUrl == null || lineStr == null || offsetStr == null) {
                return null;
            }
            Location location = null;
            String url = Utils.getAbsolutePath(project, relUrl);
            try {
                location = new Location(url, Integer.parseInt(lineStr), Integer.parseInt(offsetStr));
            }
            catch (Exception e) {
                ErrorManager.getDefault().log(65536, e.getMessage());
            }
            return location;
        }

        public void store(Lookup.Provider project, int index, Properties properties) {
            this.store(project, index, null, properties);
        }

        public void store(Lookup.Provider project, int index, String prefix, Properties properties) {
            String absPrefix = prefix == null ? index + "_" : index + "_" + prefix;
            properties.put(absPrefix + PROPERTY_LOCATION_FILE, Utils.getRelativePath(project, this.file));
            properties.put(absPrefix + PROPERTY_LOCATION_LINE, Integer.toString(this.line));
            properties.put(absPrefix + PROPERTY_LOCATION_OFFSET, Integer.toString(this.offset));
        }

        public String toString() {
            return "File: " + this.getFile() + ", line: " + this.getLine() + ", offset: " + this.getOffset();
        }
    }

    public static abstract class Paired
    extends CodeProfilingPoint {
        private Location endLocation;
        private Location startLocation;

        Paired(String name, Location startLocation, Location endLocation, Lookup.Provider project, ProfilingPointFactory factory) {
            super(name, project, factory);
            this.startLocation = startLocation;
            this.endLocation = endLocation;
        }

        @Override
        public boolean isValid() {
            if (this.startLocation == null) {
                return false;
            }
            String filename = this.startLocation.getFile();
            File file = new File(filename);
            if (!(filename.endsWith(".java") && file.exists() && file.isFile())) {
                return false;
            }
            if (!this.usesEndLocation()) {
                return true;
            }
            if (this.endLocation == null) {
                return false;
            }
            filename = this.endLocation.getFile();
            file = new File(filename);
            return filename.endsWith(".java") && file.exists() && file.isFile();
        }

        @Override
        public void setEnabled(boolean enabled) {
            if (this.isEnabled() != enabled) {
                super.setEnabled(enabled);
                this.getStartAnnotation().fireTypeChanged();
                if (this.usesEndLocation()) {
                    this.getEndAnnotation().fireTypeChanged();
                }
            }
        }

        public void setEndLocation(Location endLocation) {
            Annotation[] annotationArray;
            Annotation[] annotationArray2;
            if (this.endLocation == null && endLocation == null || this.endLocation != null && this.endLocation.equals(endLocation)) {
                return;
            }
            Annotation oldAnnotation = this.getEndAnnotation();
            Location oldLocation = this.endLocation;
            this.endLocation = endLocation;
            Annotation newAnnotation = this.getEndAnnotation();
            PropertyChangeSupport propertyChangeSupport = this.getChangeSupport();
            if (oldAnnotation == null) {
                annotationArray2 = new Annotation[]{};
            } else {
                Annotation[] annotationArray3 = new Annotation[1];
                annotationArray2 = annotationArray3;
                annotationArray3[0] = oldAnnotation;
            }
            if (newAnnotation == null) {
                annotationArray = new Annotation[]{};
            } else {
                Annotation[] annotationArray4 = new Annotation[1];
                annotationArray = annotationArray4;
                annotationArray4[0] = newAnnotation;
            }
            propertyChangeSupport.firePropertyChange(CodeProfilingPoint.PROPERTY_ANNOTATION, annotationArray2, annotationArray);
            this.getChangeSupport().firePropertyChange(CodeProfilingPoint.PROPERTY_LOCATION, oldLocation == null ? Location.EMPTY : oldLocation, endLocation == null ? Location.EMPTY : endLocation);
        }

        public Location getEndLocation() {
            return this.endLocation;
        }

        public void setStartLocation(Location startLocation) {
            if (this.startLocation.equals(startLocation)) {
                return;
            }
            Annotation oldAnnotation = this.getStartAnnotation();
            Location oldLocation = this.startLocation;
            this.startLocation = startLocation;
            Annotation newAnnotation = this.getStartAnnotation();
            this.getChangeSupport().firePropertyChange(CodeProfilingPoint.PROPERTY_ANNOTATION, new Annotation[]{oldAnnotation}, new Annotation[]{newAnnotation});
            this.getChangeSupport().firePropertyChange(CodeProfilingPoint.PROPERTY_LOCATION, oldLocation, startLocation);
        }

        public Location getStartLocation() {
            return this.startLocation;
        }

        @Override
        public RuntimeProfilingPoint[] createRuntimeProfilingPoints() {
            RuntimeProfilingPoint rpp1 = this.createRuntimeProfilingPoint(this.getStartLocation());
            if (rpp1 == null) {
                return new RuntimeProfilingPoint[0];
            }
            if (this.usesEndLocation()) {
                RuntimeProfilingPoint rpp2 = this.createRuntimeProfilingPoint(this.getEndLocation());
                if (rpp2 == null) {
                    return new RuntimeProfilingPoint[0];
                }
                return new RuntimeProfilingPoint[]{rpp1, rpp2};
            }
            return new RuntimeProfilingPoint[]{rpp1};
        }

        protected abstract Annotation getEndAnnotation();

        protected abstract Annotation getStartAnnotation();

        protected abstract boolean usesEndLocation();

        protected void timeAdjust(int threadId, long timeDiff0, long timeDiff1) {
        }

        @Override
        public Annotation[] getAnnotations() {
            Annotation[] annotationArray;
            if (this.usesEndLocation()) {
                Annotation[] annotationArray2 = new Annotation[2];
                annotationArray2[0] = this.getStartAnnotation();
                annotationArray = annotationArray2;
                annotationArray2[1] = this.getEndAnnotation();
            } else {
                Annotation[] annotationArray3 = new Annotation[1];
                annotationArray = annotationArray3;
                annotationArray3[0] = this.getStartAnnotation();
            }
            return annotationArray;
        }

        @Override
        public void setLocation(Annotation annotation, Location location) {
            if (((Object)((Object)annotation)).equals((Object)this.getStartAnnotation())) {
                this.setStartLocation(location);
            } else if (((Object)((Object)annotation)).equals((Object)this.getEndAnnotation())) {
                this.setEndLocation(location);
            }
        }

        @Override
        Location getLocation(Annotation annotation) {
            if (((Object)((Object)annotation)).equals((Object)this.getStartAnnotation())) {
                return this.getStartLocation();
            }
            if (((Object)((Object)annotation)).equals((Object)this.getEndAnnotation())) {
                return this.getEndLocation();
            }
            return null;
        }
    }

    public static abstract class Single
    extends CodeProfilingPoint {
        private Location location;

        Single(String name, Location location, Lookup.Provider project, ProfilingPointFactory factory) {
            super(name, project, factory);
            this.location = location;
        }

        @Override
        public boolean isValid() {
            if (this.location == null) {
                return false;
            }
            String filename = this.location.getFile();
            File file = new File(filename);
            return filename.endsWith(".java") && file.exists() && file.isFile();
        }

        @Override
        public void setEnabled(boolean enabled) {
            if (this.isEnabled() != enabled) {
                super.setEnabled(enabled);
                this.getAnnotation().fireTypeChanged();
            }
        }

        public void setLocation(Location location) {
            if (this.location.equals(location)) {
                return;
            }
            Annotation oldAnnotation = this.getAnnotation();
            Location oldLocation = this.location;
            this.location = location;
            Annotation newAnnotation = this.getAnnotation();
            this.getChangeSupport().firePropertyChange(CodeProfilingPoint.PROPERTY_ANNOTATION, new Annotation[]{oldAnnotation}, new Annotation[]{newAnnotation});
            this.getChangeSupport().firePropertyChange(CodeProfilingPoint.PROPERTY_LOCATION, oldLocation, location);
        }

        @Override
        public Location getLocation() {
            return this.location;
        }

        @Override
        public RuntimeProfilingPoint[] createRuntimeProfilingPoints() {
            RuntimeProfilingPoint rpp = this.createRuntimeProfilingPoint(this.getLocation());
            if (rpp == null) {
                return new RuntimeProfilingPoint[0];
            }
            return new RuntimeProfilingPoint[]{rpp};
        }

        protected abstract Annotation getAnnotation();

        @Override
        public Annotation[] getAnnotations() {
            return new Annotation[]{this.getAnnotation()};
        }

        @Override
        public void setLocation(Annotation annotation, Location location) {
            if (((Object)((Object)annotation)).equals((Object)this.getAnnotation())) {
                this.setLocation(location);
            }
        }

        @Override
        Location getLocation(Annotation annotation) {
            if (((Object)((Object)annotation)).equals((Object)this.getAnnotation())) {
                return this.getLocation();
            }
            return null;
        }
    }
}

