/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Externalizable;
import java.io.ObjectStreamException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.modules.javadoc.search.DocIndexItem;
import org.netbeans.modules.javadoc.search.IndexListCellRenderer;
import org.netbeans.modules.javadoc.search.JavadocRegistry;
import org.netbeans.modules.javadoc.search.JavadocSearchEngine;
import org.netbeans.modules.javadoc.search.NoJavadocException;
import org.netbeans.modules.javadoc.search.SrcFinder;
import org.netbeans.modules.javadoc.settings.DocumentationSettings;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public final class IndexSearch
extends TopComponent
implements Externalizable {
    private static final String INDEX_SEARCH_HELP_CTX_KEY = "javadoc.search.window";
    private static final Dimension PREFFERED_SIZE = new Dimension(580, 430);
    static Logger LOG = Logger.getLogger(IndexSearch.class.getName());
    static final long serialVersionUID = 1200348578933093459L;
    private static Reference<IndexSearch> refIndexSearch;
    private static Object[] MRU;
    private static final RequestProcessor RP;
    private final SearchTask searchTask = new SearchTask(this);
    private boolean stopState = false;
    private DocumentationSettings ds = DocumentationSettings.getDefault();
    private String quickFind;
    private String currentSort = "A";
    private JScrollPane resultsScrollPane;
    private JList resultsList;
    private JSplitPane splitPanel;
    private List<DocIndexItem> results = new ArrayList<DocIndexItem>();
    private DefaultListModel referenceModel = null;
    private DefaultListModel typeModel = null;
    private DefaultListModel alphaModel = null;
    private int oldSplit = DocumentationSettings.getDefault().getIdxSearchSplit();
    private final DefaultListModel waitModel = new DefaultListModel();
    private final DefaultListModel initModel = new DefaultListModel();
    private final DefaultListModel notModel = new DefaultListModel();
    private boolean setDividerLocation;
    private Object loadingToken;
    private RequestProcessor.Task task = null;
    private final Object LOCK = new Object();
    private JToggleButton byNameButton;
    private JToggleButton byReferenceButton;
    private JToggleButton byTypeButton;
    private JButton helpButton;
    private JPanel jPanel1;
    private JToggleButton quickViewButton;
    private JButton searchButton;
    private JComboBox searchComboBox;
    private JButton sourceButton;

    public IndexSearch() {
        ResourceBundle b = NbBundle.getBundle(IndexSearch.class);
        DocIndexItem dii = new DocIndexItem(b.getString("CTL_SEARCH_Wait"), "", null, "");
        dii.setIconIndex(14);
        this.waitModel.addElement(dii);
        dii = new DocIndexItem(b.getString("CTL_SEARCH_InitRoots"), "", null, "");
        dii.setIconIndex(14);
        this.initModel.addElement(dii);
        DocIndexItem diin = new DocIndexItem(b.getString("CTL_SEARCH_NotFound"), "", null, "");
        diin.setIconIndex(13);
        this.notModel.addElement(diin);
        this.initComponents();
        this.putClientProperty("TabPolicy", "HideWhenAlone");
        ComboBoxEditor editor = this.searchComboBox.getEditor();
        editor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndexSearch.this.searchButtonActionPerformed(evt);
            }
        });
        this.splitPanel = new JSplitPane(0);
        this.splitPanel.setPreferredSize(PREFFERED_SIZE);
        this.setDividerLocation = true;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.add(this.splitPanel, gridBagConstraints1);
        this.resultsScrollPane = new JScrollPane();
        this.resultsList = new JList();
        this.resultsList.setSelectionMode(0);
        this.resultsList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                IndexSearch.this.resultsListKeyPressed(evt);
            }
        });
        this.resultsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                IndexSearch.this.resultsListMouseClicked(evt);
            }
        });
        this.resultsScrollPane.setViewportView(this.resultsList);
        this.splitPanel.setTopComponent(this.resultsScrollPane);
        this.splitPanel.setBottomComponent((Component)this.createBrowser());
        DefaultListModel listModel = new DefaultListModel();
        this.resultsList.setModel(listModel);
        IndexListCellRenderer cr = new IndexListCellRenderer();
        this.resultsList.setCellRenderer(cr);
        this.resultsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting()) {
                    IndexSearch.this.showHelp();
                }
            }
        });
        this.resultsScrollPane.validate();
        this.sourceButton.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/javadoc/resources/showSource.gif", (boolean)false));
        this.byReferenceButton.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/javadoc/resources/refSort.gif", (boolean)false));
        this.byTypeButton.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/javadoc/resources/typeSort.gif", (boolean)false));
        this.byNameButton.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/javadoc/resources/alphaSort.gif", (boolean)false));
        this.quickViewButton.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/javadoc/resources/list_only.gif", (boolean)false));
        this.quickViewButton.setSelectedIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/javadoc/resources/list_html.gif", (boolean)false));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.byReferenceButton);
        bg.add(this.byTypeButton);
        bg.add(this.byNameButton);
        this.searchButton.setToolTipText(b.getString("CTL_SEARCH_search_ToolTip"));
        this.byReferenceButton.setToolTipText(b.getString("CTL_SEARCH_byReference_ToolTip"));
        this.byTypeButton.setToolTipText(b.getString("CTL_SEARCH_byType_ToolTip"));
        this.byNameButton.setToolTipText(b.getString("CTL_SEARCH_byName_ToolTip"));
        this.quickViewButton.setToolTipText(b.getString("CTL_SEARCH_quickView_ToolTip"));
        this.sourceButton.setToolTipText(b.getString("CTL_SEARCH_showSource_ToolTip"));
        this.searchComboBox.setToolTipText(b.getString("ACS_SEARCH_SearchComboBoxA11yDesc"));
        this.resultsList.setToolTipText(b.getString("ACS_SEARCH_ResultsListA11yDesc"));
        if (!Utilities.isMac()) {
            this.byReferenceButton.setMnemonic(b.getString("CTL_SEARCH_byReference_Mnemonic").charAt(0));
            this.byTypeButton.setMnemonic(b.getString("CTL_SEARCH_byType_Mnemonic").charAt(0));
            this.byNameButton.setMnemonic(b.getString("CTL_SEARCH_byName_Mnemonic").charAt(0));
            this.quickViewButton.setMnemonic(b.getString("CTL_SEARCH_quickView_Mnemonic").charAt(0));
            this.sourceButton.setMnemonic(b.getString("CTL_SEARCH_showSource_Mnemonic").charAt(0));
        }
        Mnemonics.setLocalizedText((AbstractButton)this.searchButton, (String)NbBundle.getMessage(IndexSearch.class, (String)"CTL_SEARCH_ButtonFind"));
        this.stopState = false;
        Mnemonics.setLocalizedText((AbstractButton)this.helpButton, (String)NbBundle.getMessage(IndexSearch.class, (String)"CTL_SEARCH_ButtonHelp"));
        this.initAccessibility();
        this.resolveButtonState();
    }

    public int getPersistenceType() {
        return 2;
    }

    protected String preferredID() {
        return "JavaDocIndexSearch";
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(INDEX_SEARCH_HELP_CTX_KEY);
    }

    private void initAccessibility() {
        ResourceBundle b = NbBundle.getBundle(IndexSearch.class);
        this.getAccessibleContext().setAccessibleName(b.getString("ACS_SEARCH_PanelA11yName"));
        this.getAccessibleContext().setAccessibleDescription(b.getString("ACS_SEARCH_PanelA11yDesc"));
        this.searchComboBox.getAccessibleContext().setAccessibleName(b.getString("ACS_SEARCH_SearchComboBoxA11yName"));
        this.searchComboBox.getAccessibleContext().setAccessibleDescription(b.getString("ACS_SEARCH_SearchComboBoxA11yDesc"));
        this.resultsList.getAccessibleContext().setAccessibleName(b.getString("ACS_SEARCH_ResultsListA11yName"));
        this.resultsList.getAccessibleContext().setAccessibleDescription(b.getString("ACS_SEARCH_ResultsListA11yDesc"));
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.searchComboBox = new JComboBox<Object>(MRU);
        this.searchButton = new JButton();
        this.sourceButton = new JButton();
        this.byNameButton = new JToggleButton();
        this.byReferenceButton = new JToggleButton();
        this.byTypeButton = new JToggleButton();
        this.quickViewButton = new JToggleButton();
        this.helpButton = new JButton();
        FormListener formListener = new FormListener();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(8, 8, 8, 8)));
        this.jPanel1.setLayout(new GridBagLayout());
        this.searchComboBox.setEditable(true);
        this.searchComboBox.addActionListener(formListener);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 8);
        this.jPanel1.add((Component)this.searchComboBox, gridBagConstraints);
        this.searchButton.setText("Search");
        this.searchButton.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.jPanel1.add((Component)this.searchButton, gridBagConstraints);
        this.sourceButton.setPreferredSize(new Dimension(25, 25));
        this.sourceButton.setMinimumSize(new Dimension(25, 25));
        this.sourceButton.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.jPanel1.add((Component)this.sourceButton, gridBagConstraints);
        this.byNameButton.setSelected(true);
        this.byNameButton.setPreferredSize(new Dimension(25, 25));
        this.byNameButton.setActionCommand("A");
        this.byNameButton.setMinimumSize(new Dimension(25, 25));
        this.byNameButton.setRequestFocusEnabled(false);
        this.byNameButton.addActionListener(formListener);
        this.jPanel1.add((Component)this.byNameButton, new GridBagConstraints());
        this.byReferenceButton.setPreferredSize(new Dimension(25, 25));
        this.byReferenceButton.setActionCommand("R");
        this.byReferenceButton.setMinimumSize(new Dimension(25, 25));
        this.byReferenceButton.setRequestFocusEnabled(false);
        this.byReferenceButton.addActionListener(formListener);
        this.jPanel1.add((Component)this.byReferenceButton, new GridBagConstraints());
        this.byTypeButton.setPreferredSize(new Dimension(25, 25));
        this.byTypeButton.setActionCommand("T");
        this.byTypeButton.setMinimumSize(new Dimension(25, 25));
        this.byTypeButton.setRequestFocusEnabled(false);
        this.byTypeButton.addActionListener(formListener);
        this.jPanel1.add((Component)this.byTypeButton, new GridBagConstraints());
        this.quickViewButton.setSelected(true);
        this.quickViewButton.setRequestFocusEnabled(false);
        this.quickViewButton.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel1.add((Component)this.quickViewButton, gridBagConstraints);
        this.helpButton.setToolTipText(NbBundle.getBundle(IndexSearch.class).getString("CTL_SEARCH_ButtonHelp_tooltip"));
        this.helpButton.setText("Help");
        this.helpButton.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel1.add((Component)this.helpButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add(this.jPanel1, gridBagConstraints);
    }

    private void helpButtonActionPerformed(ActionEvent evt) {
        this.getHelpCtx().display();
    }

    private void showSource(ActionEvent evt) {
        this.showSource();
    }

    private void sortButtonActionPerformed(ActionEvent evt) {
        this.currentSort = evt.getActionCommand();
        this.ds.setIdxSearchSort(this.currentSort);
        this.sortResults();
    }

    private void quickViewButtonActionPerformed(ActionEvent evt) {
        if (this.quickViewButton.isSelected()) {
            this.splitPanel.setDividerLocation(this.oldSplit == 100 ? 0.5 : (double)this.oldSplit / 100.0);
            this.ds.setIdxSearchSplit(this.oldSplit == 100 ? 50 : this.oldSplit);
            this.ds.setIdxSearchNoHtml(false);
            this.showHelp();
        } else {
            this.oldSplit = (int)((double)this.splitPanel.getDividerLocation() / this.splitPanel.getSize().getHeight() * 100.0);
            this.splitPanel.setDividerLocation(1.0);
            this.ds.setIdxSearchSplit(100);
            this.ds.setIdxSearchNoHtml(true);
        }
    }

    private void resultsListKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10 || evt.getKeyCode() == 32) {
            this.showHelpExternal();
        }
    }

    private void resultsListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            if (evt.isShiftDown()) {
                this.showSource();
                evt.consume();
            } else {
                this.showHelpExternal();
            }
        }
    }

    private void showHelp() {
        this.loadingToken = new Object();
        if (null != this.task) {
            this.task.cancel();
        }
        this.task = RP.create(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IndexSearch.this.doShowHelp(IndexSearch.this.loadingToken);
                    }
                });
            }
        });
        this.task.schedule(150);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doShowHelp(Object token) {
        if (token != this.loadingToken) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.splitPanel.getDividerLocation() == 100) {
                return;
            }
            if (this.resultsList.getMinSelectionIndex() < 0) {
                return;
            }
            DocIndexItem dii = (DocIndexItem)this.resultsList.getModel().getElementAt(this.resultsList.getMinSelectionIndex());
            try {
                URL url = dii.getURL();
                if (url == null) {
                    return;
                }
                String strUrl = url.toString();
                if (strUrl.startsWith("nbfs:") && strUrl.charAt(5) != '/') {
                    url = new URL("nbfs:/" + strUrl.substring(5));
                }
                HtmlBrowser browser = this.createBrowser();
                browser.setURL(url);
                int splitPosition = this.splitPanel.getDividerLocation();
                if (token != this.loadingToken) {
                    return;
                }
                this.splitPanel.setBottomComponent((Component)browser);
                this.splitPanel.setDividerLocation(splitPosition);
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
        }
    }

    private void showHelpExternal() {
        if (this.resultsList.getMinSelectionIndex() < 0) {
            return;
        }
        DocIndexItem dii = (DocIndexItem)this.resultsList.getModel().getElementAt(this.resultsList.getMinSelectionIndex());
        try {
            URL url = dii.getURL();
            if (url == null) {
                return;
            }
            String strUrl = url.toString();
            if (strUrl.startsWith("nbfs:") && strUrl.charAt(5) != '/') {
                url = new URL("nbfs:/" + strUrl.substring(5));
            }
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private void showSource() {
        if (this.resultsList.getMinSelectionIndex() < 0) {
            return;
        }
        DocIndexItem dii = (DocIndexItem)this.resultsList.getModel().getElementAt(this.resultsList.getMinSelectionIndex());
        try {
            if (dii.getURL() == null) {
                return;
            }
            Object[] e = SrcFinder.findSource(dii.getPackage(), dii.getURL());
            if (e != null) {
                FileObject toOpen = (FileObject)e[0];
                ElementHandle eh = (ElementHandle)e[1];
                ElementOpen.open((FileObject)toOpen, (ElementHandle)eh);
            } else {
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(IndexSearch.class, (String)"MSG_SEARCH_SrcNotFound"));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private void searchComboBoxActionPerformed(ActionEvent evt) {
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        if (evt != null && this.stopState) {
            this.searchTask.stopSearch();
        } else if (this.searchComboBox.getEditor().getItem().toString() != null && this.searchComboBox.getEditor().getItem().toString().length() > 0) {
            this.go();
        }
    }

    private void searchStoped(final List<DocIndexItem> newResults) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                IndexSearch.this.results = newResults;
                Mnemonics.setLocalizedText((AbstractButton)IndexSearch.this.searchButton, (String)NbBundle.getMessage(IndexSearch.class, (String)"CTL_SEARCH_ButtonFind"));
                IndexSearch.this.stopState = false;
                IndexSearch.this.referenceModel = (IndexSearch.this.typeModel = (IndexSearch.this.alphaModel = null));
                IndexSearch.this.sortResults();
                if (IndexSearch.this.resultsList.getModel().getSize() > 0) {
                    IndexSearch.this.resultsList.setSelectedIndex(0);
                    IndexSearch.this.resultsList.grabFocus();
                }
            }
        });
    }

    void setTextToFind(String toFind) {
        this.quickFind = toFind;
    }

    public void open() {
        super.open();
        if (this.quickFind != null) {
            this.searchComboBox.getEditor().setItem(this.quickFind);
            this.searchButtonActionPerformed(null);
        }
        this.quickFind = null;
        this.searchComboBox.getEditor().selectAll();
        if (this.setDividerLocation) {
            this.setDividerLocation = false;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IndexSearch.this.splitPanel.setDividerLocation((double)IndexSearch.this.oldSplit / 100.0);
                }
            });
        }
    }

    protected void componentClosed() {
        double proportional;
        int currSplit;
        int split;
        super.componentClosed();
        if (!this.quickViewButton.isSelected() && (split = this.ds.getIdxSearchSplit()) != (currSplit = (int)((proportional = (double)this.splitPanel.getDividerLocation() / (double)(this.splitPanel.getHeight() - this.splitPanel.getDividerSize())) * 100.0))) {
            this.ds.setIdxSearchSplit(currSplit);
        }
    }

    Dimension getPrefferedSize() {
        return PREFFERED_SIZE;
    }

    public static IndexSearch getDefault() {
        IndexSearch indexSearch;
        if (refIndexSearch == null || null == (indexSearch = refIndexSearch.get())) {
            indexSearch = new IndexSearch();
            refIndexSearch = new SoftReference<IndexSearch>(indexSearch);
            indexSearch.setName(NbBundle.getMessage(IndexSearch.class, (String)"CTL_SEARCH_WindowTitle"));
            indexSearch.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/javadoc/resources/searchDoc.gif"));
        }
        return indexSearch;
    }

    public void resolveButtonState() {
        this.currentSort = this.ds.getIdxSearchSort();
        boolean noHtml = this.ds.isIdxSearchNoHtml();
        this.byNameButton.setSelected(this.currentSort.equals("A"));
        this.byReferenceButton.setSelected(this.currentSort.equals("R"));
        this.byTypeButton.setSelected(this.currentSort.equals("T"));
        this.quickViewButton.setSelected(!noHtml);
    }

    private Object readResolve() throws ObjectStreamException {
        return IndexSearch.getDefault();
    }

    void go() {
        String toFind = this.searchComboBox.getEditor().getItem().toString().trim();
        this.results = new ArrayList<DocIndexItem>();
        this.referenceModel = null;
        this.typeModel = null;
        this.alphaModel = null;
        for (int i = 0; i < this.searchComboBox.getItemCount(); ++i) {
            if (!this.searchComboBox.getItemAt(i).toString().equals(toFind) && i < 10) continue;
            this.searchComboBox.removeItemAt(i);
        }
        this.searchComboBox.insertItemAt(toFind, 0);
        this.mirrorMRUStrings();
        this.searchComboBox.getEditor().setItem(toFind);
        this.resultsList.setModel(this.waitModel);
        Mnemonics.setLocalizedText((AbstractButton)this.searchButton, (String)NbBundle.getMessage(IndexSearch.class, (String)"CTL_SEARCH_ButtonStop"));
        this.stopState = true;
        this.searchTask.addSearch(toFind);
    }

    private void mirrorMRUStrings() {
        ComboBoxModel model = this.searchComboBox.getModel();
        int size = model.getSize();
        MRU = new Object[size];
        for (int i = 0; i < size; ++i) {
            IndexSearch.MRU[i] = model.getElementAt(i);
        }
    }

    DefaultListModel generateModel(Comparator<DocIndexItem> comp) {
        DefaultListModel<DocIndexItem> model = new DefaultListModel<DocIndexItem>();
        Collections.sort(this.results, comp);
        String pckg = null;
        for (DocIndexItem dii : this.results) {
            if (comp == DocIndexItem.REFERENCE_COMPARATOR && !dii.getPackage().equals(pckg) && dii.getIconIndex() != 1) {
                DocIndexItem ndii = new DocIndexItem("PACKAGE ", dii.getPackage(), null, "");
                ndii.setIconIndex(1);
                model.addElement(ndii);
                pckg = dii.getPackage();
            }
            model.addElement(dii);
        }
        return model;
    }

    void sortResults() {
        if (this.results.size() < 1) {
            this.resultsList.setModel(this.notModel);
        } else if (this.currentSort.equals("R")) {
            if (this.referenceModel == null) {
                this.resultsList.setModel(this.waitModel);
                this.resultsList.invalidate();
                this.resultsList.revalidate();
                this.referenceModel = this.generateModel(DocIndexItem.REFERENCE_COMPARATOR);
            }
            this.resultsList.setModel(this.referenceModel);
        } else if (this.currentSort.equals("T")) {
            if (this.typeModel == null) {
                this.resultsList.setModel(this.waitModel);
                this.resultsList.invalidate();
                this.resultsList.revalidate();
                this.typeModel = this.generateModel(DocIndexItem.TYPE_COMPARATOR);
            }
            this.resultsList.setModel(this.typeModel);
        } else if (this.currentSort.equals("A")) {
            if (this.alphaModel == null) {
                this.resultsList.setModel(this.waitModel);
                this.resultsList.invalidate();
                this.resultsList.revalidate();
                this.alphaModel = this.generateModel(DocIndexItem.ALPHA_COMPARATOR);
            }
            this.resultsList.setModel(this.alphaModel);
        }
        this.resultsList.invalidate();
        this.resultsList.revalidate();
        this.resultsList.repaint();
    }

    private HtmlBrowser createBrowser() {
        HtmlBrowser quickBrowser = new HtmlBrowser(true, false);
        quickBrowser.setEnableLocation(false);
        quickBrowser.setEnableHome(false);
        quickBrowser.setBorder((Border)new EmptyBorder(new Insets(8, 0, 0, 0)));
        quickBrowser.setToolTipText(NbBundle.getMessage(IndexSearch.class, (String)"ACS_SEARCH_QuickBrowserA11yDesc"));
        quickBrowser.getAccessibleContext().setAccessibleName(NbBundle.getMessage(IndexSearch.class, (String)"ACS_SEARCH_QuickBrowserA11yName"));
        quickBrowser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IndexSearch.class, (String)"ACS_SEARCH_QuickBrowserA11yDesc"));
        return quickBrowser;
    }

    private void stopWorld() {
        this.searchButton.setEnabled(false);
        this.searchComboBox.setEnabled(false);
        this.resultsList.setModel(this.initModel);
    }

    private void resumeWorld() {
        this.searchButton.setEnabled(true);
        this.searchComboBox.setEnabled(true);
        this.resultsList.setModel(this.waitModel);
    }

    static {
        MRU = new Object[0];
        RP = new RequestProcessor(IndexSearch.class.getName(), 1, false, false);
    }

    private class FormListener
    implements ActionListener {
        private FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == IndexSearch.this.searchComboBox) {
                IndexSearch.this.searchComboBoxActionPerformed(evt);
            } else if (evt.getSource() == IndexSearch.this.searchButton) {
                IndexSearch.this.searchButtonActionPerformed(evt);
            } else if (evt.getSource() == IndexSearch.this.sourceButton) {
                IndexSearch.this.showSource(evt);
            } else if (evt.getSource() == IndexSearch.this.byNameButton) {
                IndexSearch.this.sortButtonActionPerformed(evt);
            } else if (evt.getSource() == IndexSearch.this.byReferenceButton) {
                IndexSearch.this.sortButtonActionPerformed(evt);
            } else if (evt.getSource() == IndexSearch.this.byTypeButton) {
                IndexSearch.this.sortButtonActionPerformed(evt);
            } else if (evt.getSource() == IndexSearch.this.quickViewButton) {
                IndexSearch.this.quickViewButtonActionPerformed(evt);
            } else if (evt.getSource() == IndexSearch.this.helpButton) {
                IndexSearch.this.helpButtonActionPerformed(evt);
            }
        }
    }

    private static final class SearchTask
    implements Runnable {
        private static final RequestProcessor RP = new RequestProcessor(IndexSearch.class.getName(), 1);
        private final IndexSearch indexSearch;
        private final RequestProcessor.Task task;
        private final List<String> queries;
        private boolean rootsInited = false;
        private JavadocSearchEngine searchEngine;

        private SearchTask(IndexSearch indexSearch) {
            this.indexSearch = indexSearch;
            this.task = RP.create((Runnable)this);
            this.queries = new ArrayList<String>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSearch(String toFind) {
            SearchTask searchTask = this;
            synchronized (searchTask) {
                this.queries.add(toFind);
            }
            LOG.fine("SearchTask.addSearch: " + toFind);
            this.task.schedule(0);
        }

        public void stopSearch() {
            this.searchEngine.stop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String toFind;
            this.initRoots();
            SearchTask searchTask = this;
            synchronized (searchTask) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("SearchTask.run: " + this.queries.size() + ", " + this.queries.toString());
                }
                toFind = this.queries.remove(0);
                if (this.isCanceled()) {
                    LOG.fine("SearchTask.cancel");
                    return;
                }
            }
            this.searchEngine = JavadocSearchEngine.getDefault();
            this.search(toFind, this.searchEngine, new ArrayList<DocIndexItem>());
        }

        private synchronized boolean isCanceled() {
            return !this.queries.isEmpty();
        }

        private void initRoots() {
            if (this.rootsInited) {
                return;
            }
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SearchTask.this.indexSearch.stopWorld();
                    }
                });
                JavadocRegistry.getDefault().getDocRoots();
                LOG.fine("SearchTask.initRoots");
                this.rootsInited = true;
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SearchTask.this.indexSearch.resumeWorld();
                    }
                });
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        private void search(final String toFind, final JavadocSearchEngine engine, final List<DocIndexItem> results) {
            try {
                engine.search(new String[]{toFind}, new JavadocSearchEngine.SearchEngineCallback(){

                    @Override
                    public void finished() {
                        LOG.fine("SearchTask.finished: " + toFind);
                        SearchTask.this.showResult(results);
                    }

                    @Override
                    public void addItem(DocIndexItem item) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("SearchTask.addItem: " + toFind + ", item: " + item.toString());
                        }
                        results.add(item);
                        if (SearchTask.this.isCanceled()) {
                            LOG.fine("SearchTask.addItem.stopEngine: " + toFind + ", item: " + item.toString());
                            engine.stop();
                        }
                    }
                });
            }
            catch (NoJavadocException noJdc) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)noJdc.getMessage()));
                this.indexSearch.searchStoped(results);
            }
        }

        private void showResult(List<DocIndexItem> results) {
            if (!this.isCanceled()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "SearchTask.showResult: " + results.size(), new Exception());
                }
                this.indexSearch.searchStoped(results);
            }
        }
    }
}

