/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Comparator;

final class DocIndexItem {
    public static final Comparator<DocIndexItem> REFERENCE_COMPARATOR = new ReferenceComparator();
    public static final Comparator<DocIndexItem> TYPE_COMPARATOR = new TypeComparator();
    public static final Comparator<DocIndexItem> ALPHA_COMPARATOR = new AlphaComparator();
    private String text = null;
    private URL contextURL = null;
    private String spec = null;
    private String remark = null;
    private String pckg = null;
    private String declaringClass = null;
    private int iconIndex = 0;

    public DocIndexItem(String text, String remark, URL contextURL, String spec) {
        this.text = text;
        this.remark = remark;
        this.contextURL = contextURL;
        this.spec = spec;
        if (spec != null) {
            int offset = spec.startsWith("../") ? 3 : (spec.startsWith("./") ? 2 : 0);
            int length = spec.lastIndexOf(47);
            length = length < 0 ? spec.length() : length + 1;
            this.pckg = spec.substring(offset, length);
            this.pckg = this.pckg.replace('/', '.');
        }
    }

    public URL getURL() throws MalformedURLException {
        return this.contextURL != null ? new URL(this.contextURL, this.spec) : null;
    }

    public String toString() {
        if (this.remark != null) {
            return this.text + this.remark;
        }
        return this.text;
    }

    public int getIconIndex() {
        return this.iconIndex;
    }

    public void setIconIndex(int iconIndex) {
        this.iconIndex = iconIndex;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getPackage() {
        return this.pckg == null ? "" : this.pckg;
    }

    public void setPackage(String pckg) {
        this.pckg = pckg;
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public void setDeclaringClass(String declaringClass) {
        this.declaringClass = declaringClass;
    }

    public String getField() {
        return this.text != null ? this.text : "";
    }

    public void setField(String text) {
        this.text = text;
    }

    static final class AlphaComparator
    implements Comparator<DocIndexItem> {
        AlphaComparator() {
        }

        @Override
        public int compare(DocIndexItem dii1, DocIndexItem dii2) {
            return dii1.toString().compareTo(dii2.toString());
        }

        @Override
        public boolean equals(Object comp) {
            return comp instanceof AlphaComparator;
        }

        public int hashCode() {
            return 33;
        }
    }

    static final class ReferenceComparator
    implements Comparator<DocIndexItem> {
        ReferenceComparator() {
        }

        @Override
        public int compare(DocIndexItem dii1, DocIndexItem dii2) {
            int res = dii1.getPackage().compareTo(dii2.getPackage());
            return res != 0 ? res : ALPHA_COMPARATOR.compare(dii1, dii2);
        }

        @Override
        public boolean equals(Object comp) {
            return comp instanceof ReferenceComparator;
        }

        public int hashCode() {
            return 353;
        }
    }

    static final class TypeComparator
    implements Comparator<DocIndexItem> {
        TypeComparator() {
        }

        @Override
        public int compare(DocIndexItem dii1, DocIndexItem dii2) {
            return dii1.getIconIndex() - dii2.getIconIndex();
        }

        @Override
        public boolean equals(Object comp) {
            return comp instanceof TypeComparator;
        }

        public int hashCode() {
            return -34;
        }
    }
}

