/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.hints;

import com.sun.javadoc.Doc;
import com.sun.javadoc.Tag;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.javadoc.hints.JavadocHintProvider;
import org.netbeans.modules.javadoc.hints.JavadocUtilities;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

final class RemoveTagFix
implements Fix,
CancellableTask<WorkingCopy> {
    private String tagName;
    private final JavadocUtilities.TagHandle tagHandle;
    private final ElementHandle handle;
    private final FileObject file;
    private final SourceVersion spec;
    private Position[] tagBounds;
    private boolean isFormattingTouched = false;
    private Document doc;

    RemoveTagFix(String tagName, JavadocUtilities.TagHandle tagHandle, ElementHandle elmHandle, FileObject file, SourceVersion spec) {
        this.tagName = tagName;
        this.tagHandle = tagHandle;
        this.handle = elmHandle;
        this.file = file;
        this.spec = spec;
    }

    public String getText() {
        return NbBundle.getMessage(JavadocHintProvider.class, (String)"REMOVE_TAG_HINT", (Object)this.tagName);
    }

    public ChangeInfo implement() {
        return this.implement(true);
    }

    private void prepareRemoveTag(final CompilationInfo ci, Element elm) throws IOException, BadLocationException {
        final Doc jdoc = ci.getElementUtilities().javaDocFor(elm);
        if (jdoc != null) {
            final Tag tag = this.tagHandle.resolve(jdoc);
            if (tag == null) {
                return;
            }
            NbDocument.runAtomicAsUser((StyledDocument)((StyledDocument)this.doc), (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        RemoveTagFix.access$002(RemoveTagFix.this, JavadocUtilities.findTagBounds(ci, RemoveTagFix.this.doc, tag));
                        Position[] jdBounds = JavadocUtilities.findDocBounds(ci, RemoveTagFix.this.doc, jdoc);
                        RemoveTagFix.access$002(RemoveTagFix.this, RemoveTagFix.this.expand2LineBounds(RemoveTagFix.this.doc, RemoveTagFix.this.tagBounds, jdBounds));
                    }
                    catch (BadLocationException ex) {
                        Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
            });
        }
    }

    private void removeTag(final Indent indent) throws BadLocationException {
        if (this.tagBounds == null || this.doc == null) {
            return;
        }
        NbDocument.runAtomicAsUser((StyledDocument)((StyledDocument)this.doc), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    RemoveTagFix.this.doc.remove(RemoveTagFix.this.tagBounds[0].getOffset(), RemoveTagFix.this.tagBounds[1].getOffset() - RemoveTagFix.this.tagBounds[0].getOffset());
                    if (indent != null) {
                        indent.reindent(RemoveTagFix.this.tagBounds[1].getOffset());
                    }
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeInfo implement(boolean open) {
        JavaSource js = JavaSource.forFileObject((FileObject)this.file);
        Indent indent = null;
        try {
            js.runModificationTask((Task)this).commit();
            Indent indent2 = indent = this.isFormattingTouched ? Indent.get((Document)this.doc) : null;
            if (indent != null) {
                indent.lock();
            }
            this.removeTag(indent);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (IOException ex) {
            Logger.getLogger(JavadocHintProvider.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        finally {
            if (indent != null) {
                indent.unlock();
            }
        }
        return null;
    }

    public void cancel() {
    }

    public void run(WorkingCopy wc) throws Exception {
        wc.toPhase(JavaSource.Phase.RESOLVED);
        Element elm = this.handle.resolve((CompilationInfo)wc);
        Tree t = null;
        if (elm != null) {
            t = wc.getTrees().getTree(elm);
        }
        this.doc = wc.getDocument();
        if (t != null && this.doc != null) {
            this.prepareRemoveTag((CompilationInfo)wc, elm);
        }
    }

    private static CharSequence getCharSequence(Document doc, int jdBegin, int jdEnd) throws BadLocationException {
        CharSequence cs = (CharSequence)doc.getProperty(CharSequence.class);
        if (cs == null) {
            cs = doc.getText(jdBegin, jdEnd - jdBegin + 1);
        }
        return cs;
    }

    private Position[] expand2LineBounds(Document doc, Position[] tagBounds, Position[] jdBounds) throws BadLocationException {
        int lineEnd;
        int lineBegin;
        int jdBeginLine = NbDocument.findLineNumber((StyledDocument)((StyledDocument)doc), (int)jdBounds[0].getOffset());
        int jdEndLine = NbDocument.findLineNumber((StyledDocument)((StyledDocument)doc), (int)jdBounds[1].getOffset());
        int tagBeginLine = NbDocument.findLineNumber((StyledDocument)((StyledDocument)doc), (int)tagBounds[0].getOffset());
        int tagEndLine = NbDocument.findLineNumber((StyledDocument)((StyledDocument)doc), (int)tagBounds[0].getOffset());
        CharSequence cs = RemoveTagFix.getCharSequence(doc, jdBounds[0].getOffset(), jdBounds[1].getOffset());
        if (jdBeginLine != tagBeginLine && (lineBegin = RemoveTagFix.findLineHead(cs, tagBounds[0].getOffset(), jdBounds[0].getOffset())) != tagBounds[0].getOffset()) {
            tagBounds[0] = doc.createPosition(lineBegin);
            boolean bl = this.isFormattingTouched = tagBeginLine == jdEndLine;
        }
        if (jdEndLine != tagEndLine && jdBeginLine != tagBeginLine && (lineEnd = RemoveTagFix.findLineTail(cs, tagBounds[0].getOffset(), tagBounds[1].getOffset(), jdBounds[1].getOffset())) != tagBounds[1].getOffset()) {
            tagBounds[1] = doc.createPosition(lineEnd);
        }
        return tagBounds;
    }

    private static int findLineHead(CharSequence cs, int offset, int stop) {
        for (int i = offset; i > stop; --i) {
            char c = cs.charAt(i);
            if (c != '\n') continue;
            return i + 1;
        }
        return offset;
    }

    private static int findLineTail(CharSequence cs, int tagBegin, int tagEnd, int stop) {
        if (cs.charAt(tagEnd) != '@') {
            for (int i = tagEnd; i < stop; ++i) {
                char c = cs.charAt(i);
                if (c != '\n') continue;
                return i + 1;
            }
        } else {
            for (int i = tagEnd - 1; i > tagBegin; --i) {
                char c = cs.charAt(i);
                if (c != '\n') continue;
                return i + 1;
            }
        }
        return tagEnd;
    }

    static /* synthetic */ Position[] access$002(RemoveTagFix x0, Position[] x1) {
        x0.tagBounds = x1;
        return x1;
    }
}

