/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.ScheduledTimerDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Method;
import java.util.logging.Level;
import javax.ejb.MessageDriven;
import javax.ejb.Schedule;
import javax.ejb.Singleton;
import javax.ejb.Stateless;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.ejb.deployment.annotation.handlers.AbstractAttributeHandler;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ScheduleHandler
extends AbstractAttributeHandler {
    public Class<? extends Annotation> getAnnotationType() {
        return Schedule.class;
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, EjbContext[] ejbContexts) throws AnnotationProcessorException {
        return this.processSchedule((Schedule)ainfo.getAnnotation(), ainfo, ejbContexts);
    }

    protected HandlerProcessingResult processSchedule(Schedule sch, AnnotationInfo ainfo, EjbContext[] ejbContexts) throws AnnotationProcessorException {
        for (EjbContext ejbContext : ejbContexts) {
            Method annMethod;
            EjbDescriptor ejbDesc = ejbContext.getDescriptor();
            if (!ElementType.METHOD.equals((Object)ainfo.getElementType()) || ejbDesc.hasScheduledTimerMethodFromDD(annMethod = (Method)ainfo.getAnnotatedElement())) continue;
            ScheduledTimerDescriptor sd = new ScheduledTimerDescriptor();
            sd.setSecond(sch.second());
            sd.setMinute(sch.minute());
            sd.setHour(sch.hour());
            sd.setDayOfMonth(sch.dayOfMonth());
            sd.setMonth(sch.month());
            sd.setDayOfWeek(sch.dayOfWeek());
            sd.setYear(sch.year());
            sd.setTimezone(sch.timezone());
            sd.setPersistent(sch.persistent());
            sd.setInfo(sch.info());
            sd.setTimeoutMethod(new MethodDescriptor(annMethod));
            ejbDesc.addScheduledTimerDescriptor(sd);
            if (!this.logger.isLoggable(Level.FINE)) continue;
            this.logger.fine("@@@ Found Schedule on " + annMethod);
            this.logger.fine("@@@ TimerConfig : " + (sd.getInfo() != null && !sd.getInfo().equals("") ? sd.getInfo() : null) + " # " + sd.getPersistent());
        }
        return this.getDefaultProcessedResult();
    }

    public Class<? extends Annotation>[] getTypeDependencies() {
        return new Class[]{Stateless.class, Singleton.class, MessageDriven.class};
    }

    @Override
    protected boolean supportTypeInheritance() {
        return true;
    }
}

