/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.annotation.handlers;

import com.sun.enterprise.deployment.AnnotationTypesProvider;
import com.sun.enterprise.deployment.DummyEjbDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbBundleContext;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.context.EjbsContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractHandler;
import java.io.Externalizable;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.Local;
import javax.ejb.LocalBean;
import javax.ejb.LocalHome;
import javax.ejb.Remote;
import javax.ejb.RemoteHome;
import javax.ejb.TimedObject;
import javax.ejb.Timeout;
import javax.jws.WebService;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.component.Habitat;

public abstract class AbstractEjbHandler
extends AbstractHandler {
    private AnnotationTypesProvider provider = null;

    public AbstractEjbHandler() {
        Habitat h = Globals.getDefaultHabitat();
        if (h != null) {
            this.provider = (AnnotationTypesProvider)h.getComponent(AnnotationTypesProvider.class, "EJB");
        }
    }

    protected abstract String getAnnotatedName(Annotation var1);

    protected abstract boolean isValidEjbDescriptor(EjbDescriptor var1, Annotation var2);

    protected abstract EjbDescriptor createEjbDescriptor(String var1, AnnotationInfo var2) throws AnnotationProcessorException;

    protected abstract HandlerProcessingResult setEjbDescriptorInfo(EjbDescriptor var1, AnnotationInfo var2) throws AnnotationProcessorException;

    public HandlerProcessingResult processAnnotation(AnnotationInfo ainfo) throws AnnotationProcessorException {
        String elementName;
        AnnotatedElementHandler aeHandler;
        Class ejbClass = (Class)ainfo.getAnnotatedElement();
        Annotation annotation = ainfo.getAnnotation();
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("@ process ejb annotation " + annotation + " in " + ejbClass);
        }
        if ((aeHandler = ainfo.getProcessingContext().getHandler()) != null && aeHandler instanceof EjbContext) {
            EjbContext context = (EjbContext)aeHandler;
            EjbDescriptor desc = context.getDescriptor();
            if (this.isValidEjbDescriptor(desc, annotation)) {
                return this.getDefaultProcessedResult();
            }
            this.log(Level.SEVERE, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.notcompsuperclass", "The annotation symbol defined in super-class is not compatible with {0} ejb {1}.", new Object[]{desc.getType(), desc.getName()}));
            return this.getDefaultFailedResult();
        }
        if (aeHandler == null || !(aeHandler instanceof EjbBundleContext)) {
            return this.getInvalidAnnotatedElementHandlerResult(ainfo.getProcessingContext().getHandler(), ainfo);
        }
        EjbBundleContext ctx = (EjbBundleContext)aeHandler;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("My context is " + ctx);
        }
        if ((elementName = this.getAnnotatedName(annotation)).length() == 0) {
            elementName = ejbClass.getSimpleName();
        }
        EjbBundleDescriptor currentBundle = ctx.getDescriptor();
        EjbDescriptor ejbDesc = null;
        try {
            ejbDesc = currentBundle.getEjbByName(elementName);
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        if (ejbDesc != null && !(ejbDesc instanceof DummyEjbDescriptor)) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Overriding rules apply for " + ejbClass.getName());
            }
            if (!this.isValidEjbDescriptor(ejbDesc, annotation)) {
                this.log(Level.SEVERE, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.wrongejbtype", "Wrong annotation symbol for ejb {0}", new Object[]{ejbDesc}));
                return this.getDefaultFailedResult();
            }
            String descriptorEjbClass = ejbDesc.getEjbClassName();
            if (descriptorEjbClass == null) {
                ejbDesc.setEjbClassName(ejbClass.getName());
                ejbDesc.applyDefaultClassToLifecycleMethods();
            } else if (!descriptorEjbClass.equals(ejbClass.getName())) {
                this.log(Level.SEVERE, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.ejbclsmismatch", "", new Object[]{descriptorEjbClass, elementName, ejbClass.getName()}));
                return this.getDefaultFailedResult();
            }
        } else {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Creating a new descriptor for " + ejbClass.getName());
            }
            EjbDescriptor dummyEjbDesc = ejbDesc;
            ejbDesc = this.createEjbDescriptor(elementName, ainfo);
            if (dummyEjbDesc != null) {
                currentBundle.removeEjb(dummyEjbDesc);
                ejbDesc.addEjbDescriptor(dummyEjbDesc);
                ejbDesc.setEjbClassName(ejbClass.getName());
            }
            currentBundle.addEjb(ejbDesc);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("New " + this.getAnnotationType().getName() + " bean " + elementName);
            }
        }
        EjbDescriptor[] ejbDescs = currentBundle.getEjbByClassName(ejbClass.getName());
        HandlerProcessingResult procResult = null;
        for (EjbDescriptor next : ejbDescs) {
            procResult = this.setEjbDescriptorInfo(next, ainfo);
            this.doTimedObjectProcessing(ejbClass, next);
        }
        Object annContext = null;
        annContext = ejbDescs.length == 1 ? new EjbContext(ejbDesc, ejbClass) : new EjbsContext(ejbDescs, ejbClass);
        ctx.getProcessingContext().pushHandler((AnnotatedElementHandler)annContext);
        return procResult;
    }

    private void doTimedObjectProcessing(Class ejbClass, EjbDescriptor ejbDesc) {
        MethodDescriptor timeoutMethodDesc = null;
        block0: for (Class nextClass = ejbClass; nextClass != Object.class && nextClass != null && timeoutMethodDesc == null; nextClass = nextClass.getSuperclass()) {
            Method[] methods;
            for (Method m : methods = nextClass.getDeclaredMethods()) {
                if (m.getAnnotation(Timeout.class) == null) continue;
                timeoutMethodDesc = new MethodDescriptor(m, "Bean");
                continue block0;
            }
        }
        if (timeoutMethodDesc == null && TimedObject.class.isAssignableFrom(ejbClass)) {
            timeoutMethodDesc = new MethodDescriptor("ejbTimeout", "@Timeout method", new String[]{"javax.ejb.Timer"}, "Bean");
        }
        if (timeoutMethodDesc != null) {
            ejbDesc.setEjbTimeoutMethod(timeoutMethodDesc);
        }
    }

    protected HandlerProcessingResult setBusinessAndHomeInterfaces(EjbDescriptor ejbDesc, AnnotationInfo ainfo) throws AnnotationProcessorException {
        LocalHome localHome;
        RemoteHome remoteHomeAnn;
        Local localBusAnn;
        HashSet<Class> localBusIntfs = new HashSet<Class>();
        HashSet<Class> remoteBusIntfs = new HashSet<Class>();
        HashSet<Class> clientInterfaces = new HashSet<Class>();
        Class ejbClass = (Class)ainfo.getAnnotatedElement();
        Remote remoteBusAnn = ejbClass.getAnnotation(Remote.class);
        boolean emptyRemoteBusAnn = false;
        if (remoteBusAnn != null) {
            for (Class next : remoteBusAnn.value()) {
                clientInterfaces.add(next);
                remoteBusIntfs.add(next);
            }
            emptyRemoteBusAnn = remoteBusIntfs.isEmpty();
        }
        if ((localBusAnn = ejbClass.getAnnotation(Local.class)) != null) {
            for (Class next : localBusAnn.value()) {
                clientInterfaces.add(next);
                localBusIntfs.add(next);
            }
        }
        LinkedList eligibleInterfaces = new LinkedList();
        for (Class<?> clazz : ejbClass.getInterfaces()) {
            if (this.excludedFromImplementsClause(clazz)) continue;
            eligibleInterfaces.add(clazz);
        }
        LocalBean localBeanAnn = ejbClass.getAnnotation(LocalBean.class);
        if (localBeanAnn != null) {
            ejbDesc.setLocalBean(true);
        }
        int nonImplementsClauseBusinessInterfaceCount = remoteBusIntfs.size() + localBusIntfs.size() + ejbDesc.getRemoteBusinessClassNames().size() + ejbDesc.getLocalBusinessClassNames().size();
        for (Class clazz : eligibleInterfaces) {
            String nextIntfName = clazz.getName();
            if (remoteBusIntfs.contains(clazz) || localBusIntfs.contains(clazz) || ejbDesc.getRemoteBusinessClassNames().contains(nextIntfName) || ejbDesc.getLocalBusinessClassNames().contains(nextIntfName)) continue;
            if (clazz.getAnnotation(Local.class) != null) {
                clientInterfaces.add(clazz);
                localBusIntfs.add(clazz);
                continue;
            }
            if (clazz.getAnnotation(Remote.class) != null) {
                clientInterfaces.add(clazz);
                remoteBusIntfs.add(clazz);
                continue;
            }
            if (nonImplementsClauseBusinessInterfaceCount != 0 || ejbDesc.isLocalBean()) continue;
            if (emptyRemoteBusAnn) {
                remoteBusIntfs.add(clazz);
            } else {
                localBusIntfs.add(clazz);
            }
            clientInterfaces.add(clazz);
        }
        if (localBusIntfs.size() > 0) {
            for (Class clazz : localBusIntfs) {
                ejbDesc.addLocalBusinessClassName(clazz.getName());
            }
        }
        if (remoteBusIntfs.size() > 0) {
            for (Class clazz : remoteBusIntfs) {
                ejbDesc.addRemoteBusinessClassName(clazz.getName());
            }
        }
        if ((remoteHomeAnn = ejbClass.getAnnotation(RemoteHome.class)) != null) {
            Class clazz = remoteHomeAnn.value();
            Class remoteIntf = this.getComponentIntfFromHome(clazz);
            if (EJBHome.class.isAssignableFrom(clazz) && remoteIntf != null) {
                clientInterfaces.add(clazz);
                ejbDesc.setHomeClassName(clazz.getName());
                ejbDesc.setRemoteClassName(remoteIntf.getName());
            } else {
                this.log(Level.SEVERE, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.invalidremotehome", "Encountered invalid @RemoteHome interface {0}.", new Object[]{clazz}));
                return this.getDefaultFailedResult();
            }
        }
        if ((localHome = ejbClass.getAnnotation(LocalHome.class)) != null) {
            Class localHome2 = localHome.value();
            Class localIntf = this.getComponentIntfFromHome(localHome2);
            if (EJBLocalHome.class.isAssignableFrom(localHome2) && localIntf != null) {
                clientInterfaces.add(localHome2);
                ejbDesc.setLocalHomeClassName(localHome2.getName());
                ejbDesc.setLocalClassName(localIntf.getName());
            } else {
                this.log(Level.SEVERE, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.invalidlocalhome", "Encountered invalid @LocalHome interface {0}.", new Object[]{localHome2}));
                return this.getDefaultFailedResult();
            }
        }
        boolean canDoWebServiceAnnCheck = false;
        try {
            canDoWebServiceAnnCheck = this.provider.getType("javax.jws.WebService") != null;
        }
        catch (Exception e) {
            this.log(Level.FINE, ainfo, e.getMessage());
        }
        if (!ejbDesc.isLocalBean() && clientInterfaces.size() == 0 && !ejbDesc.hasWebServiceEndpointInterface() && (!canDoWebServiceAnnCheck || canDoWebServiceAnnCheck && ejbClass.getAnnotation(WebService.class) == null)) {
            ejbDesc.setLocalBean(true);
        }
        if (ejbDesc.isLocalBean()) {
            this.addNoInterfaceLocalBeanClasses(ejbDesc, ejbClass);
        }
        return this.getDefaultProcessedResult();
    }

    private void addNoInterfaceLocalBeanClasses(EjbDescriptor ejbDesc, Class ejbClass) {
        for (Class nextClass = ejbClass; nextClass != Object.class && nextClass != null; nextClass = nextClass.getSuperclass()) {
            ejbDesc.addNoInterfaceLocalBeanClass(nextClass.getName());
        }
    }

    private Class getComponentIntfFromHome(Class homeIntf) {
        Method[] methods;
        Class<?> componentIntf = null;
        for (Method m : methods = homeIntf.getMethods()) {
            if (!m.getName().startsWith("create")) continue;
            componentIntf = m.getReturnType();
            break;
        }
        return componentIntf;
    }

    protected boolean excludedFromImplementsClause(Class intf) {
        return intf == Serializable.class || intf == Externalizable.class || intf.getPackage() != null && intf.getPackage().getName().equals("javax.ejb");
    }

    protected void doDescriptionProcessing(String description, EjbDescriptor ejbDescriptor) {
        if (description != null && !description.equals("")) {
            ejbDescriptor.setDescription(description);
        }
    }

    protected void doMappedNameProcessing(String mappedName, EjbDescriptor ejbDesc) {
        if (ejbDesc.getMappedName().equals("") && !mappedName.equals("")) {
            ejbDesc.setMappedName(mappedName);
        }
    }
}

