/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.lib.api;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.css.lib.api.CssTokenIdCategory;
import org.netbeans.modules.css.lib.nblexer.CssLanguageHierarchy;

public enum CssTokenId implements TokenId
{
    EOF(-1, CssTokenIdCategory.OTHERS),
    ERROR(0, CssTokenIdCategory.ERRORS),
    AND(18, CssTokenIdCategory.KEYWORDS),
    NOT(17, CssTokenIdCategory.KEYWORDS),
    ONLY(16, CssTokenIdCategory.KEYWORDS),
    RESOLUTION(76, CssTokenIdCategory.NUMBERS),
    WS(4, CssTokenIdCategory.WHITESPACES),
    CHARSET_SYM(9, CssTokenIdCategory.KEYWORDS),
    STRING(7, CssTokenIdCategory.STRINGS),
    SEMI(10, CssTokenIdCategory.SEPARATORS),
    IMPORT_SYM(11, CssTokenIdCategory.KEYWORDS),
    URI(8, CssTokenIdCategory.URIS),
    COMMA(15, CssTokenIdCategory.SEPARATORS),
    MEDIA_SYM(12, CssTokenIdCategory.KEYWORDS),
    LBRACE(13, CssTokenIdCategory.BRACES),
    RBRACE(14, CssTokenIdCategory.BRACES),
    IDENT(6, CssTokenIdCategory.IDENTIFIERS),
    PAGE_SYM(25, CssTokenIdCategory.KEYWORDS),
    COLON(44, CssTokenIdCategory.SEPARATORS),
    DCOLON(55, CssTokenIdCategory.SEPARATORS),
    SOLIDUS(45, CssTokenIdCategory.OTHERS),
    PLUS(46, CssTokenIdCategory.OPERATORS),
    GREATER(47, CssTokenIdCategory.OPERATORS),
    TILDE(48, CssTokenIdCategory.OPERATORS),
    MINUS(49, CssTokenIdCategory.OPERATORS),
    STAR(50, CssTokenIdCategory.OPERATORS),
    HASH(52, CssTokenIdCategory.HASHES),
    DOT(53, CssTokenIdCategory.OPERATORS),
    LBRACKET(54, CssTokenIdCategory.BRACES),
    OPEQ(57, CssTokenIdCategory.OTHERS),
    INCLUDES(58, CssTokenIdCategory.OPERATORS),
    DASHMATCH(59, CssTokenIdCategory.OPERATORS),
    RBRACKET(63, CssTokenIdCategory.BRACES),
    LPAREN(64, CssTokenIdCategory.BRACES),
    RPAREN(65, CssTokenIdCategory.BRACES),
    IMPORTANT_SYM(66, CssTokenIdCategory.KEYWORDS),
    NUMBER(67, CssTokenIdCategory.NUMBERS),
    PERCENTAGE(68, CssTokenIdCategory.NUMBERS),
    LENGTH(69, CssTokenIdCategory.NUMBERS),
    EMS(70, CssTokenIdCategory.NUMBERS),
    REM(71, CssTokenIdCategory.NUMBERS),
    EXS(72, CssTokenIdCategory.NUMBERS),
    ANGLE(73, CssTokenIdCategory.NUMBERS),
    TIME(74, CssTokenIdCategory.NUMBERS),
    FREQ(75, CssTokenIdCategory.NUMBERS),
    HEXCHAR(78, CssTokenIdCategory.NUMBERS),
    NONASCII(79, CssTokenIdCategory.OTHERS),
    UNICODE(80, CssTokenIdCategory.OTHERS),
    ESCAPE(81, CssTokenIdCategory.OTHERS),
    NMSTART(82, CssTokenIdCategory.OTHERS),
    NMCHAR(83, CssTokenIdCategory.OTHERS),
    NAME(56, CssTokenIdCategory.OTHERS),
    URL(84, CssTokenIdCategory.URIS),
    A(85, CssTokenIdCategory.OTHERS),
    B(86, CssTokenIdCategory.OTHERS),
    C(87, CssTokenIdCategory.OTHERS),
    D(88, CssTokenIdCategory.OTHERS),
    E(89, CssTokenIdCategory.OTHERS),
    F(90, CssTokenIdCategory.OTHERS),
    G(91, CssTokenIdCategory.OTHERS),
    H(92, CssTokenIdCategory.OTHERS),
    I(93, CssTokenIdCategory.OTHERS),
    J(94, CssTokenIdCategory.OTHERS),
    K(95, CssTokenIdCategory.OTHERS),
    L(96, CssTokenIdCategory.OTHERS),
    M(97, CssTokenIdCategory.OTHERS),
    N(98, CssTokenIdCategory.OTHERS),
    O(99, CssTokenIdCategory.OTHERS),
    P(100, CssTokenIdCategory.OTHERS),
    Q(101, CssTokenIdCategory.OTHERS),
    R(102, CssTokenIdCategory.OTHERS),
    S(103, CssTokenIdCategory.OTHERS),
    T(104, CssTokenIdCategory.OTHERS),
    U(105, CssTokenIdCategory.OTHERS),
    V(106, CssTokenIdCategory.OTHERS),
    W(107, CssTokenIdCategory.OTHERS),
    X(108, CssTokenIdCategory.OTHERS),
    Y(109, CssTokenIdCategory.OTHERS),
    Z(110, CssTokenIdCategory.OTHERS),
    COMMENT(111, CssTokenIdCategory.COMMENTS),
    CDO(112, CssTokenIdCategory.OTHERS),
    CDC(113, CssTokenIdCategory.OTHERS),
    INVALID(114, CssTokenIdCategory.OTHERS),
    DIMENSION(77, CssTokenIdCategory.NUMBERS),
    NL(115, CssTokenIdCategory.OTHERS),
    PIPE(51, CssTokenIdCategory.OPERATORS),
    GEN(19, CssTokenIdCategory.OTHERS),
    NAMESPACE_SYM(5, CssTokenIdCategory.KEYWORDS),
    TOPLEFTCORNER_SYM(28, CssTokenIdCategory.KEYWORDS),
    TOPLEFT_SYM(29, CssTokenIdCategory.KEYWORDS),
    TOPCENTER_SYM(30, CssTokenIdCategory.KEYWORDS),
    TOPRIGHT_SYM(31, CssTokenIdCategory.KEYWORDS),
    TOPRIGHTCORNER_SYM(32, CssTokenIdCategory.KEYWORDS),
    BOTTOMLEFTCORNER_SYM(33, CssTokenIdCategory.KEYWORDS),
    BOTTOMLEFT_SYM(34, CssTokenIdCategory.KEYWORDS),
    BOTTOMCENTER_SYM(35, CssTokenIdCategory.KEYWORDS),
    BOTTOMRIGHT_SYM(36, CssTokenIdCategory.KEYWORDS),
    BOTTOMRIGHTCORNER_SYM(37, CssTokenIdCategory.KEYWORDS),
    LEFTTOP_SYM(38, CssTokenIdCategory.KEYWORDS),
    LEFTMIDDLE_SYM(39, CssTokenIdCategory.KEYWORDS),
    LEFTBOTTOM_SYM(40, CssTokenIdCategory.KEYWORDS),
    RIGHTTOP_SYM(41, CssTokenIdCategory.KEYWORDS),
    RIGHTMIDDLE_SYM(42, CssTokenIdCategory.KEYWORDS),
    RIGHTBOTTOM_SYM(43, CssTokenIdCategory.KEYWORDS),
    COUNTER_STYLE_SYM(26, CssTokenIdCategory.KEYWORDS),
    BEGINS(60, CssTokenIdCategory.OPERATORS),
    ENDS(61, CssTokenIdCategory.OPERATORS),
    CONTAINS(62, CssTokenIdCategory.OPERATORS),
    FONT_FACE_SYM(27, CssTokenIdCategory.KEYWORDS),
    HASH_CHAR_ONLY(116, CssTokenIdCategory.OTHERS),
    MOZ_DOCUMENT_SYM(21, CssTokenIdCategory.KEYWORDS),
    MOZ_DOMAIN(23, CssTokenIdCategory.URIS),
    MOZ_URL_PREFIX(22, CssTokenIdCategory.URIS),
    MOZ_REGEXP(24, CssTokenIdCategory.STRINGS),
    GENERIC_AT_RULE(20, CssTokenIdCategory.KEYWORDS);

    private static final Map<Integer, CssTokenId> codesMap;
    private final CssTokenIdCategory primaryCategory;
    private final int code;
    private static final Language<CssTokenId> language;

    public static CssTokenId forTokenTypeCode(int tokenTypeCode) {
        return codesMap.get(tokenTypeCode);
    }

    private CssTokenId(int code, CssTokenIdCategory primaryCategory) {
        this.primaryCategory = primaryCategory;
        this.code = code;
    }

    public static Language<CssTokenId> language() {
        return language;
    }

    public String primaryCategory() {
        return this.primaryCategory.name().toLowerCase();
    }

    public CssTokenIdCategory getTokenCategory() {
        return this.primaryCategory;
    }

    static {
        codesMap = new HashMap<Integer, CssTokenId>();
        for (CssTokenId id : CssTokenId.values()) {
            codesMap.put(id.code, id);
        }
        language = new CssLanguageHierarchy().language();
    }
}

