/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javap;

import com.sun.tools.classfile.AttributeException;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.classfile.DescriptorException;
import com.sun.tools.javap.Context;
import com.sun.tools.javap.Messages;
import com.sun.tools.javap.Options;
import java.io.PrintWriter;

public class BasicWriter {
    private String[] spaces = new String[80];
    private LineWriter lineWriter;
    private PrintWriter out;
    protected Messages messages;

    protected BasicWriter(Context context) {
        this.lineWriter = LineWriter.instance(context);
        this.out = context.get(PrintWriter.class);
        this.messages = context.get(Messages.class);
        if (this.messages == null) {
            throw new AssertionError();
        }
    }

    protected void print(String s) {
        this.lineWriter.print(s);
    }

    protected void print(Object o) {
        this.lineWriter.print(o == null ? null : o.toString());
    }

    protected void println() {
        this.lineWriter.println();
    }

    protected void println(String s) {
        this.lineWriter.print(s);
        this.lineWriter.println();
    }

    protected void println(Object o) {
        this.lineWriter.print(o == null ? null : o.toString());
        this.lineWriter.println();
    }

    protected void indent(int delta) {
        this.lineWriter.indent(delta);
    }

    protected void tab() {
        this.lineWriter.tab();
    }

    protected void setPendingNewline(boolean b) {
        this.lineWriter.pendingNewline = b;
    }

    protected String report(AttributeException e) {
        this.out.println("Error: " + e.getMessage());
        return "???";
    }

    protected String report(ConstantPoolException e) {
        this.out.println("Error: " + e.getMessage());
        return "???";
    }

    protected String report(DescriptorException e) {
        this.out.println("Error: " + e.getMessage());
        return "???";
    }

    protected String report(String msg) {
        this.out.println("Error: " + msg);
        return "???";
    }

    protected String space(int w) {
        if (w < this.spaces.length && this.spaces[w] != null) {
            return this.spaces[w];
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < w; ++i) {
            sb.append(" ");
        }
        String s = sb.toString();
        if (w < this.spaces.length) {
            this.spaces[w] = s;
        }
        return s;
    }

    private static class LineWriter {
        private PrintWriter out;
        private StringBuilder buffer;
        private int indentCount;
        private int indentWidth;
        private int tabColumn;
        private boolean pendingNewline;

        static LineWriter instance(Context context) {
            LineWriter instance = context.get(LineWriter.class);
            if (instance == null) {
                instance = new LineWriter(context);
            }
            return instance;
        }

        protected LineWriter(Context context) {
            context.put(LineWriter.class, this);
            Options options = Options.instance(context);
            this.indentWidth = options.indentWidth;
            this.tabColumn = options.tabColumn;
            this.out = context.get(PrintWriter.class);
            this.buffer = new StringBuilder();
        }

        protected void print(String s) {
            if (this.pendingNewline) {
                this.println();
                this.pendingNewline = false;
            }
            if (s == null) {
                s = "null";
            }
            block3: for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                switch (c) {
                    case '\n': {
                        this.println();
                        continue block3;
                    }
                    default: {
                        if (this.buffer.length() == 0) {
                            this.indent();
                        }
                        this.buffer.append(c);
                    }
                }
            }
        }

        protected void println() {
            this.out.println(this.buffer);
            this.buffer.setLength(0);
        }

        protected void indent(int delta) {
            this.indentCount += delta;
        }

        protected void tab() {
            if (this.buffer.length() == 0) {
                this.indent();
            }
            this.space(this.indentCount * this.indentWidth + this.tabColumn - this.buffer.length());
        }

        private void indent() {
            this.space(this.indentCount * this.indentWidth);
        }

        private void space(int n) {
            for (int i = 0; i < n; ++i) {
                this.buffer.append(' ');
            }
        }
    }
}

