/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.TypeVariable;
import com.sun.javadoc.WildcardType;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import com.sun.tools.javadoc.ClassDocImpl;
import com.sun.tools.javadoc.DocEnv;
import com.sun.tools.javadoc.ParameterizedTypeImpl;
import com.sun.tools.javadoc.PrimitiveType;
import com.sun.tools.javadoc.TypeVariableImpl;
import com.sun.tools.javadoc.WildcardTypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeMaker {
    public static com.sun.javadoc.Type getType(DocEnv env, Type t) {
        return TypeMaker.getType(env, t, true);
    }

    public static com.sun.javadoc.Type getType(DocEnv env, Type t, boolean errToClassDoc) {
        if (env.legacyDoclet) {
            t = env.types.erasure(t);
        }
        switch (t.tag) {
            case 10: {
                if (ClassDocImpl.isGeneric((Symbol.ClassSymbol)t.tsym)) {
                    return env.getParameterizedType((Type.ClassType)t);
                }
                return env.getClassDoc((Symbol.ClassSymbol)t.tsym);
            }
            case 15: {
                Type.WildcardType a = (Type.WildcardType)t;
                return new WildcardTypeImpl(env, a);
            }
            case 14: {
                return new TypeVariableImpl(env, (Type.TypeVar)t);
            }
            case 11: {
                return new ArrayTypeImpl(env, t);
            }
            case 1: {
                return PrimitiveType.byteType;
            }
            case 2: {
                return PrimitiveType.charType;
            }
            case 3: {
                return PrimitiveType.shortType;
            }
            case 4: {
                return PrimitiveType.intType;
            }
            case 5: {
                return PrimitiveType.longType;
            }
            case 6: {
                return PrimitiveType.floatType;
            }
            case 7: {
                return PrimitiveType.doubleType;
            }
            case 8: {
                return PrimitiveType.booleanType;
            }
            case 9: {
                return PrimitiveType.voidType;
            }
            case 19: {
                if (!errToClassDoc) break;
                return env.getClassDoc((Symbol.ClassSymbol)t.tsym);
            }
        }
        return new PrimitiveType(t.tsym.getQualifiedName().toString());
    }

    public static com.sun.javadoc.Type[] getTypes(DocEnv env, List<Type> ts) {
        return TypeMaker.getTypes(env, ts, new com.sun.javadoc.Type[ts.length()]);
    }

    public static com.sun.javadoc.Type[] getTypes(DocEnv env, List<Type> ts, com.sun.javadoc.Type[] res) {
        int i = 0;
        for (Type t : ts) {
            res[i++] = TypeMaker.getType(env, t);
        }
        return res;
    }

    public static String getTypeName(Type t, boolean full) {
        switch (t.tag) {
            case 11: {
                StringBuilder s = new StringBuilder();
                while (t.tag == 11) {
                    s.append("[]");
                    t = ((Type.ArrayType)t).elemtype;
                }
                s.insert(0, TypeMaker.getTypeName(t, full));
                return s.toString();
            }
            case 10: {
                return ClassDocImpl.getClassName((Symbol.ClassSymbol)t.tsym, full);
            }
        }
        return t.tsym.getQualifiedName().toString();
    }

    static String getTypeString(DocEnv env, Type t, boolean full) {
        switch (t.tag) {
            case 11: {
                StringBuilder s = new StringBuilder();
                while (t.tag == 11) {
                    s.append("[]");
                    t = env.types.elemtype(t);
                }
                s.insert(0, TypeMaker.getTypeString(env, t, full));
                return s.toString();
            }
            case 10: {
                return ParameterizedTypeImpl.parameterizedTypeToString(env, (Type.ClassType)t, full);
            }
            case 15: {
                Type.WildcardType a = (Type.WildcardType)t;
                return WildcardTypeImpl.wildcardTypeToString(env, a, full);
            }
        }
        return t.tsym.getQualifiedName().toString();
    }

    static String typeParametersString(DocEnv env, Symbol sym, boolean full) {
        if (env.legacyDoclet || sym.type.getTypeArguments().isEmpty()) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        for (Type t : sym.type.getTypeArguments()) {
            s.append(s.length() == 0 ? "<" : ", ");
            s.append(TypeVariableImpl.typeVarToString(env, (Type.TypeVar)t, full));
        }
        s.append(">");
        return s.toString();
    }

    static String typeArgumentsString(DocEnv env, Type.ClassType cl, boolean full) {
        if (env.legacyDoclet || ((List)cl.getTypeArguments()).isEmpty()) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        for (Type t : cl.getTypeArguments()) {
            s.append(s.length() == 0 ? "<" : ", ");
            s.append(TypeMaker.getTypeString(env, t, full));
        }
        s.append(">");
        return s.toString();
    }

    private static class ArrayTypeImpl
    implements com.sun.javadoc.Type {
        Type arrayType;
        DocEnv env;
        private com.sun.javadoc.Type skipArraysCache = null;

        ArrayTypeImpl(DocEnv env, Type arrayType) {
            this.env = env;
            this.arrayType = arrayType;
        }

        private com.sun.javadoc.Type skipArrays() {
            if (this.skipArraysCache == null) {
                Type t = this.arrayType;
                while (t.tag == 11) {
                    t = this.env.types.elemtype(t);
                }
                this.skipArraysCache = TypeMaker.getType(this.env, t);
            }
            return this.skipArraysCache;
        }

        public String dimension() {
            StringBuilder dimension = new StringBuilder();
            Type t = this.arrayType;
            while (t.tag == 11) {
                dimension.append("[]");
                t = this.env.types.elemtype(t);
            }
            return dimension.toString();
        }

        public String typeName() {
            return this.skipArrays().typeName();
        }

        public String qualifiedTypeName() {
            return this.skipArrays().qualifiedTypeName();
        }

        public String simpleTypeName() {
            return this.skipArrays().simpleTypeName();
        }

        public ClassDoc asClassDoc() {
            return this.skipArrays().asClassDoc();
        }

        public ParameterizedType asParameterizedType() {
            return this.skipArrays().asParameterizedType();
        }

        public TypeVariable asTypeVariable() {
            return this.skipArrays().asTypeVariable();
        }

        public WildcardType asWildcardType() {
            return null;
        }

        public AnnotationTypeDoc asAnnotationTypeDoc() {
            return this.skipArrays().asAnnotationTypeDoc();
        }

        public boolean isPrimitive() {
            return this.skipArrays().isPrimitive();
        }

        public String toString() {
            return this.qualifiedTypeName() + this.dimension();
        }
    }
}

