/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterRef;
import com.sun.enterprise.config.serverbeans.LbConfig;
import com.sun.enterprise.config.serverbeans.LbConfigs;
import com.sun.enterprise.config.serverbeans.LoadBalancer;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.internal.api.Target;
import org.glassfish.loadbalancer.admin.cli.CreateHTTPLBRefCommand;
import org.glassfish.loadbalancer.admin.cli.LBCommandsBase;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-http-lb-ref")
@Scoped(value=PerLookup.class)
@I18n(value="delete.http.lb.ref")
@TargetType(value={CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
@ExecuteOn(value={RuntimeType.DAS})
public final class DeleteHTTPLBRefCommand
extends LBCommandsBase
implements AdminCommand {
    @Param(optional=true)
    String config;
    @Param(optional=true)
    String lbname;
    @Param(optional=true, defaultValue="false")
    String force;
    @Param(primary=true)
    String target;
    @Inject
    LbConfigs lbconfigs;
    @Inject
    Target tgt;
    @Inject
    Logger logger;
    private ActionReport report;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateHTTPLBRefCommand.class);

    public void execute(AdminCommandContext context) {
        String msg;
        this.report = context.getActionReport();
        this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        boolean isCluster = this.tgt.isCluster(this.target);
        this.logger.fine("[LB-ADMIN] deleteLBRef called for target " + this.target);
        if (this.config != null && this.lbname != null) {
            String msg2 = localStrings.getLocalString("EitherConfigOrLBName", "Either LB name or LB config name, not both");
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg2);
            return;
        }
        if (this.config == null && this.lbname == null) {
            String msg3 = localStrings.getLocalString("SpecifyConfigOrLBName", "Please specify either LB name or LB config name.");
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg3);
            return;
        }
        if (this.config != null) {
            if (this.lbconfigs.getLbConfig(this.config) == null) {
                String msg4 = localStrings.getLocalString("LbConfigDoesNotExist", "Specified LB config {0} does not exist", new Object[]{this.config});
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg4);
                return;
            }
        } else if (this.lbname != null) {
            LoadBalancer lb = this.domain.getLoadBalancers().getLoadBalancer(this.lbname);
            this.config = lb.getLbConfigName();
        }
        if (isCluster) {
            this.deleteClusterFromLBConfig(this.config, this.target);
            msg = localStrings.getLocalString("http_lb_admin.DeleteClusterFromConfig", "Deleted cluster {0} from Lb", new Object[]{this.target, this.config});
            this.logger.info(msg);
        } else if (this.domain.isServer(this.target)) {
            this.deleteServerFromLBConfig(this.config, this.target);
            msg = localStrings.getLocalString("http_lb_admin.DeleteServerFromConfig", "Deleted server {0} from Lb", new Object[]{this.target, this.config});
            this.logger.info(msg);
        } else {
            msg = localStrings.getLocalString("InvalidTarget", "Invalid target", new Object[]{this.target});
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            return;
        }
    }

    private void deleteServerFromLBConfig(String configName, String serverName) {
        LbConfig lbConfig = this.lbconfigs.getLbConfig(configName);
        ServerRef sRef = (ServerRef)lbConfig.getRefByRef(ServerRef.class, serverName);
        if (sRef == null) {
            String msg = localStrings.getLocalString("ServerNotDefined", "Server {0} cannot be used as target", new Object[]{this.target});
            this.logger.finest("Server " + serverName + " does not exist in any cluster in the domain");
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            return;
        }
        if (!Boolean.parseBoolean(this.force)) {
            if (Boolean.parseBoolean(sRef.getLbEnabled())) {
                String msg = localStrings.getLocalString("ServerNeedsToBeDisabled", "Server [{0}] needs to be disabled before it can be removed from the load balancer.", new Object[]{serverName});
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg);
                return;
            }
            Server s = this.domain.getServerNamed(serverName);
            if (s == null) {
                String msg = localStrings.getLocalString("ServerNotDefined", "Server {0} cannot be used as target", new Object[]{this.target});
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg);
                return;
            }
            List appRefs = this.domain.getApplicationRefsInTarget(this.target);
            if (appRefs == null) {
                String msg = localStrings.getLocalString("AppRefsNotDefined", "Application refs does not exist in server {0}", new Object[]{this.target});
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg);
                return;
            }
            boolean appLbEnabled = false;
            for (ApplicationRef aRef : appRefs) {
                if (!Boolean.parseBoolean(aRef.getLbEnabled())) continue;
                appLbEnabled = true;
                break;
            }
            if (appLbEnabled) {
                String msg = localStrings.getLocalString("AppsNotDisabled", "All referenced applications must be disabled in LB");
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg);
                return;
            }
        }
        this.removeServerRef(lbConfig, sRef);
    }

    private void deleteClusterFromLBConfig(String configName, String clusterName) {
        LbConfig lbConfig = this.lbconfigs.getLbConfig(configName);
        ClusterRef cRef = (ClusterRef)lbConfig.getRefByRef(ClusterRef.class, clusterName);
        if (cRef == null) {
            String msg = localStrings.getLocalString("ClusterNotDefined", "Cluster {0} cannot be used as target", new Object[]{this.target});
            this.logger.finest("Cluster " + clusterName + " does not exist.");
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            return;
        }
        if (!Boolean.parseBoolean(this.force)) {
            Cluster c = this.domain.getClusterNamed(clusterName);
            if (c == null) {
                String msg = localStrings.getLocalString("ClusterNotDefined", "Cluster {0} cannot be used as target", new Object[]{this.target});
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg);
                return;
            }
            List sRefs = c.getServerRef();
            boolean refLbEnabled = false;
            for (ServerRef ref : sRefs) {
                if (!Boolean.parseBoolean(ref.getLbEnabled())) continue;
                refLbEnabled = true;
            }
            if (refLbEnabled) {
                String msg = localStrings.getLocalString("ServerNeedsToBeDisabled", "Server [{0}] needs to be disabled before it can be removed from the load balancer.", new Object[]{this.target});
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg);
                return;
            }
        }
        this.removeClusterRef(lbConfig, cRef);
    }

    public void removeServerRef(LbConfig lc, final ServerRef sRef) {
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<LbConfig>(){

                public Object run(LbConfig param) throws PropertyVetoException, TransactionFailure {
                    param.getClusterRefOrServerRef().remove(sRef);
                    return Boolean.TRUE;
                }
            }, (ConfigBeanProxy)lc);
        }
        catch (TransactionFailure ex) {
            String msg = localStrings.getLocalString("FailedToRemoveServerRef", "Failed to remove server-ref");
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            this.report.setFailureCause((Throwable)ex);
            return;
        }
    }

    public void removeClusterRef(LbConfig lc, final ClusterRef cRef) {
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<LbConfig>(){

                public Object run(LbConfig param) throws PropertyVetoException, TransactionFailure {
                    param.getClusterRefOrServerRef().remove(cRef);
                    return Boolean.TRUE;
                }
            }, (ConfigBeanProxy)lc);
        }
        catch (TransactionFailure ex) {
            String msg = localStrings.getLocalString("FailedToRemoveClusterRef", "Failed to remove cluster-ref");
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            this.report.setFailureCause((Throwable)ex);
            return;
        }
    }
}

