/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.drilldown;

import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.profiler.categorization.api.Category;
import org.netbeans.modules.profiler.drilldown.DrillDown;
import org.netbeans.modules.profiler.drilldown.DrillDownPieChartModel;

public class ProjectPieChartModel
extends DrillDownPieChartModel {
    public ProjectPieChartModel(DrillDown model) {
        super(model);
    }

    public String getItemName(int index) {
        return this.getItemNameAt(this.getMappedIndex(index));
    }

    public double getItemValue(int index) {
        return this.getItemValueAt(this.getMappedIndex(index));
    }

    public double getItemValueRel(int index) {
        long allTime = this.drillDown.getCurrentTime(false);
        if (LOGGER.isLoggable(Level.FINEST)) {
            long allTimeCalc = 0L;
            List<Category> subCategories = this.getSubCategories();
            for (int i = 0; i < subCategories.size(); ++i) {
                allTimeCalc = (long)((double)allTimeCalc + this.getItemValueAt(i));
            }
            if (allTimeCalc != allTime) {
                LOGGER.log(Level.FINEST, "time mismatch: {0} != {1}", new Object[]{allTime, allTimeCalc});
            }
        }
        if (allTime == 0L) {
            return 1.0;
        }
        return this.getItemValueAt(this.getMappedIndex(index)) / (double)allTime;
    }

    public boolean isSelectable(int index) {
        List<Category> subs = this.drillDown.getSubCategories();
        if (subs.size() <= index) {
            return false;
        }
        if (index != -1) {
            return this.drillDown.canDrilldown(subs.get(index));
        }
        return false;
    }

    private String getItemNameAt(int index) {
        List<Category> subCategories = this.getSubCategories();
        if (subCategories.size() <= index) {
            return "";
        }
        return subCategories.get(index).getLabel();
    }

    private double getItemValueAt(int index) {
        List<Category> subCategories = this.getSubCategories();
        if (subCategories.size() <= index) {
            return 0.0;
        }
        if (index == -1 || this.drillDown.isCurrent(this.drillDown.getSubCategories().get(index))) {
            return this.drillDown.getCurrentTime(true);
        }
        return this.drillDown.getCategoryTime(subCategories.get(index), false);
    }
}

