/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.drilldown;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.RuntimeCPUCCTNode;
import org.netbeans.lib.profiler.ui.charts.PieChart;
import org.netbeans.lib.profiler.ui.charts.PieChartModel;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.cpu.StatisticsPanel;
import org.netbeans.lib.profiler.ui.cpu.statistics.StatisticalModule;
import org.netbeans.modules.profiler.categorization.api.Category;
import org.netbeans.modules.profiler.drilldown.DrillDown;
import org.netbeans.modules.profiler.drilldown.DrillDownListener;
import org.netbeans.modules.profiler.drilldown.ProjectPieChartModel;

public class DrillDownPanel
extends StatisticalModule {
    private DrillDownListener listener = new DrillDownListener(){

        @Override
        public void dataChanged() {
        }

        public void drillDownPathChanged(List list) {
            DrillDownPanel.this.updateCrumbNav();
        }
    };
    private HTMLTextArea crumbNav;
    private DrillDown ddModel;
    private PieChart pieChart;
    private ProjectPieChartModel pieModel = null;
    private StatisticsPanel panel = null;
    private String lastNavigableCategoryId = null;

    public DrillDownPanel(DrillDown model) {
        this.ddModel = model;
        this.ddModel.addListener(this.listener);
        this.initComponents();
    }

    public void addSnippet(StatisticalModule component) {
        this.panel.addSnippet((JComponent)component);
    }

    public void pause() {
    }

    public void refresh(RuntimeCPUCCTNode appNode) {
    }

    public void removeSnippet(StatisticalModule component) {
        this.panel.removeSnippet((JComponent)component);
    }

    public void resume() {
    }

    private synchronized HTMLTextArea getCrumbNav() {
        if (this.crumbNav == null) {
            this.crumbNav = new HTMLTextArea();
            this.crumbNav.setOpaque(false);
            this.crumbNav.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    String query = e.getURL().getQuery();
                    if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                        return;
                    }
                    int index = e.getURL().getQuery().lastIndexOf(61);
                    if (index <= -1) {
                        return;
                    }
                    DrillDownPanel.this.ddModel.drillup(query.substring(index + 1));
                }
            });
            this.updateCrumbNav();
        }
        return this.crumbNav;
    }

    private synchronized PieChart getPieChart() {
        if (this.pieChart == null) {
            this.pieChart = new PieChart();
            this.pieModel = new ProjectPieChartModel(this.ddModel);
            this.pieChart.setModel((PieChartModel)this.pieModel);
        }
        return this.pieChart;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.panel = new StatisticsPanel(this.getCrumbNav(), this.getPieChart(), new Runnable(){

            @Override
            public void run() {
                DrillDownPanel.this.navigateOneLevelBack();
            }
        });
        this.panel.addListener(new StatisticsPanel.Listener(){

            public void itemClicked(int itemIndex) {
                DrillDownPanel.this.pieModel.drilldown(itemIndex);
            }
        });
        this.add((Component)this.panel, "Center");
    }

    private void navigateOneLevelBack() {
        if (this.lastNavigableCategoryId != null) {
            this.ddModel.drillup(this.lastNavigableCategoryId);
        }
    }

    private synchronized void updateCrumbNav() {
        StringBuilder sb = new StringBuilder();
        this.lastNavigableCategoryId = null;
        int counter = this.ddModel.getDrillDownPath().size() - 1;
        for (Category category : this.ddModel.getDrillDownPath()) {
            if (sb.length() > 0) {
                sb.append("/");
            }
            if (counter-- > 0) {
                sb.append("<a href=\"http://localhost/category?id=").append(category.getId()).append("\">").append(category.getLabel()).append("</a>");
                this.lastNavigableCategoryId = category.getId();
            } else {
                sb.append(category.getLabel());
            }
            this.crumbNav.setText(sb.toString());
        }
    }
}

