/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.drilldown;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.results.cpu.cct.CCTResultsFilter;
import org.netbeans.lib.profiler.results.cpu.cct.TimeCollector;
import org.netbeans.modules.profiler.categorization.api.Categorization;
import org.netbeans.modules.profiler.categorization.api.Category;
import org.netbeans.modules.profiler.categorization.api.CategoryLeaf;
import org.netbeans.modules.profiler.drilldown.DrillDownListener;
import org.netbeans.modules.profiler.utilities.Visitable;
import org.netbeans.modules.profiler.utilities.Visitor;
import org.openide.util.Lookup;

public class DrillDown
implements CCTResultsFilter.Evaluator {
    private static final String SELF_CATEGORY_ID = "SELF_CATEGORY";
    private final List<Category> ddPath = new ArrayList<Category>(5);
    private final ProfilerClient client;
    private final Set listeners = Collections.synchronizedSet(new HashSet());
    private final boolean secondTime;
    private final boolean validFlag;
    private Category currentCategory;
    private Categorization categorization;
    private final List<Category> subCategories = new ArrayList<Category>();

    public DrillDown(Categorization cat, ProfilerClient client, boolean secondTimeStamp) {
        this.secondTime = secondTimeStamp;
        this.client = client;
        this.categorization = cat;
        if (this.categorization == null) {
            this.validFlag = false;
        } else {
            this.reset();
            this.validFlag = !this.categorization.getRoot().getSubcategories().isEmpty();
        }
    }

    public DrillDown(Categorization cat, ProfilerClient client) {
        this(cat, client, false);
    }

    public boolean isCurrent(Category category) {
        return this.currentCategory.equals((Object)category);
    }

    public Category getCurrentCategory() {
        return this.currentCategory != null ? this.currentCategory : null;
    }

    public long getCurrentTime(boolean net) {
        return this.getCategoryTime(this.currentCategory, net);
    }

    public List<Category> getDrillDownPath() {
        ArrayList<Category> rslt = new ArrayList<Category>(this.ddPath);
        return rslt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCategoryTime(Category category, boolean net) {
        TimeCollector tc = (TimeCollector)Lookup.getDefault().lookup(TimeCollector.class);
        TimeTouple time = null;
        try {
            tc.beginTrans(false);
            if (net || category.getId().equals(SELF_CATEGORY_ID)) {
                time = new TimeTouple(tc.getNetTime0(category.getAssignedMark()), tc.getNetTime1(category.getAssignedMark()));
            } else {
                long time0 = 0L;
                long time1 = 0L;
                for (Mark mark : this.categorization.getAllMarks(category)) {
                    time0 += tc.getNetTime0(mark);
                    time1 += tc.getNetTime1(mark);
                }
                time = new TimeTouple(time0, time1);
            }
            long l = time != null ? (this.secondTime ? time.time1 : time.time0) : 0L;
            return l;
        }
        finally {
            tc.endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Category> getSubCategories() {
        List<Category> list = this.subCategories;
        synchronized (list) {
            return new ArrayList<Category>(this.subCategories);
        }
    }

    public Category getTopCategory() {
        return this.categorization.getRoot();
    }

    public long getTopTime(boolean net) {
        return this.getCategoryTime(this.getTopCategory(), net);
    }

    public boolean isValid() {
        return this.validFlag;
    }

    public void addListener(DrillDownListener drillDownListener) {
        this.listeners.add(drillDownListener);
    }

    public boolean canDrilldown(Category cat) {
        return !this.getCurrentCategory().getId().equals(cat.getId());
    }

    public void drilldown(String catId) {
        if (this.getCurrentCategory().getId().equals(SELF_CATEGORY_ID)) {
            return;
        }
        for (Category category : this.subCategories) {
            if (!category.getId().equals(catId)) continue;
            this.currentCategory = category;
            this.ddPath.add(this.currentCategory);
            this.updateSubCategories();
            this.fireDrillDownChange();
            break;
        }
    }

    public void drillup() {
        if (this.ddPath.size() == 1) {
            return;
        }
        this.ddPath.remove(this.ddPath.size() - 1);
        this.currentCategory = this.ddPath.get(this.ddPath.size() - 1);
        this.updateSubCategories();
        this.fireDrillDownChange();
    }

    public void drillup(String catId) {
        boolean found = false;
        ArrayList<Category> toRemove = new ArrayList<Category>();
        for (Category catInPath : this.ddPath) {
            if (!found) {
                if (!catInPath.getId().equals(catId)) continue;
                this.currentCategory = catInPath;
                found = true;
                continue;
            }
            toRemove.add(catInPath);
        }
        if (found) {
            this.ddPath.removeAll(toRemove);
            this.updateSubCategories();
            this.fireDrillDownChange();
        }
    }

    public boolean evaluate(Mark categoryMark) {
        if (this.currentCategory == null || this.currentCategory.getAssignedMark() == Mark.DEFAULT && this.currentCategory.getSubcategories().size() > 1) {
            return true;
        }
        Boolean passed = (Boolean)this.currentCategory.accept((Visitor)new Visitor<Visitable<Category>, Boolean, Mark>(){

            public Boolean visit(Visitable<Category> visitable, Mark parameter) {
                if (((Category)visitable.getValue()).getAssignedMark().equals((Object)parameter)) {
                    return Boolean.TRUE;
                }
                return null;
            }
        }, (Object)categoryMark);
        return passed != null ? passed : false;
    }

    public void refresh() {
        this.fireDataChange();
    }

    public void removeListener(DrillDownListener drillDownListener) {
        this.listeners.remove(drillDownListener);
    }

    public void reset() {
        this.ddPath.clear();
        this.ddPath.add(this.categorization.getRoot());
        this.currentCategory = this.categorization.getRoot();
        this.updateSubCategories();
        this.fireDrillDownChange();
    }

    private void fireDataChange() {
        HashSet tmpListeners = new HashSet(this.listeners);
        Iterator iter = tmpListeners.iterator();
        while (iter.hasNext()) {
            ((DrillDownListener)iter.next()).dataChanged();
        }
    }

    private void fireDrillDownChange() {
        HashSet tmpListeners = new HashSet(this.listeners);
        Iterator iter = tmpListeners.iterator();
        while (iter.hasNext()) {
            ((DrillDownListener)iter.next()).drillDownPathChanged(this.getDrillDownPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSubCategories() {
        List<Category> list = this.subCategories;
        synchronized (list) {
            this.subCategories.clear();
            this.subCategories.addAll(this.currentCategory.getSubcategories());
            if (this.currentCategory.getId().equals(SELF_CATEGORY_ID) || this.currentCategory.getAssignedMark().equals((Object)Mark.DEFAULT)) {
                this.subCategories.add((Category)new CategoryLeaf(SELF_CATEGORY_ID, this.getCurrentCategory().getLabel(), this.getCurrentCategory().getAssignedMark()));
            } else {
                this.subCategories.add((Category)new CategoryLeaf(SELF_CATEGORY_ID, this.getCurrentCategory().getLabel() + "(Self)", this.getCurrentCategory().getAssignedMark()));
            }
        }
    }

    private static class TimeTouple {
        public static final TimeTouple ZERO = new TimeTouple(0L, 0L);
        final long time0;
        final long time1;

        public TimeTouple(long time0, long time1) {
            this.time0 = time0;
            this.time1 = time1;
        }
    }
}

