/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.NativeRemoteCommandsBase;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.io.FileListerRelative;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.zip.ZipFileException;
import com.sun.enterprise.util.zip.ZipWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=PerLookup.class)
abstract class InstallNodeBaseCommand
extends NativeRemoteCommandsBase {
    @Param(name="archive", optional=true)
    private String archive;
    @Param(name="installdir", optional=true, defaultValue="${com.sun.aas.productRoot}")
    private String installDir;
    @Param(optional=true, defaultValue="false")
    private boolean create;
    @Param(optional=true, defaultValue="false")
    private boolean save;
    @Param(name="force", optional=true, defaultValue="false")
    private boolean force;
    @Inject
    private Habitat habitat;
    private String archiveName;
    private boolean delete = true;

    InstallNodeBaseCommand() {
    }

    abstract void copyToHosts(File var1, ArrayList<String> var2) throws CommandException;

    abstract void precopy() throws CommandException;

    @Override
    protected void validate() throws CommandException {
        super.validate();
        Globals.setDefaultHabitat(this.habitat);
        this.installDir = this.resolver.resolve(this.installDir);
        if (!this.force) {
            for (String host : this.hosts) {
                if (!this.checkIfNodeExistsForHost(host, this.installDir)) continue;
                throw new CommandException(Strings.get("node.already.configured", host, this.installDir));
            }
        }
        if (InstallNodeBaseCommand.ok((String)this.archive)) {
            this.archive = SmartFile.sanitize((String)this.archive);
        }
    }

    protected int executeCommand() throws CommandException {
        File zipFile = null;
        try {
            ArrayList<String> binDirFiles = new ArrayList<String>();
            this.precopy();
            zipFile = this.createZipFileIfNeeded(binDirFiles);
            this.copyToHosts(zipFile, binDirFiles);
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommandException((Throwable)e);
        }
        finally {
            if (!this.save && this.delete && zipFile != null && !zipFile.delete()) {
                zipFile.deleteOnExit();
            }
        }
        return 0;
    }

    final String getInstallDir() {
        return this.installDir;
    }

    final String getArchiveName() {
        return this.archiveName;
    }

    final boolean getForce() {
        return this.force;
    }

    private File createZipFileIfNeeded(ArrayList<String> binDirFiles) throws IOException, ZipFileException {
        String baseRootValue = this.getSystemProperty("com.sun.aas.productRoot");
        File installRoot = new File(baseRootValue);
        File zipFileLocation = null;
        File glassFishZipFile = null;
        if (this.archive != null) {
            this.archive = this.archive.replace('\\', '/');
            this.archiveName = this.archive.substring(this.archive.lastIndexOf("/") + 1, this.archive.length());
            zipFileLocation = new File(this.archive.substring(0, this.archive.lastIndexOf("/")));
            glassFishZipFile = new File(this.archive);
            if (glassFishZipFile.exists() && !this.create) {
                logger.finer("Found " + this.archive);
                this.delete = false;
                return glassFishZipFile;
            }
            if (!zipFileLocation.canWrite()) {
                throw new IOException("Cannot write to " + this.archive);
            }
        } else {
            zipFileLocation = new File(".");
            if (!zipFileLocation.canWrite()) {
                zipFileLocation = new File(System.getProperty("java.io.tmpdir"));
            }
            glassFishZipFile = File.createTempFile("glassfish", ".zip", zipFileLocation);
            String filePath = glassFishZipFile.getCanonicalPath();
            filePath = filePath.replaceAll("\\\\", "/");
            this.archiveName = filePath.substring(filePath.lastIndexOf("/") + 1, filePath.length());
        }
        FileListerRelative lister = new FileListerRelative(installRoot);
        lister.keepEmptyDirectories();
        String[] files = lister.getFiles();
        List<String> resultFiles1 = Arrays.asList(files);
        ArrayList<String> resultFiles = new ArrayList<String>(resultFiles1);
        logger.finer("Number of files to be zipped = " + resultFiles.size());
        Iterator<String> iter = resultFiles.iterator();
        while (iter.hasNext()) {
            String fileName = iter.next();
            String fPath = fileName.substring(fileName.lastIndexOf("/") + 1);
            if (fPath.equals(glassFishZipFile.getName())) {
                logger.finer("Removing file = " + fileName);
                iter.remove();
                continue;
            }
            if (fileName.contains("domains") || fileName.contains("nodes")) {
                iter.remove();
                continue;
            }
            if (!InstallNodeBaseCommand.isFileWithinBinDirectory(fileName)) continue;
            binDirFiles.add(fileName);
        }
        logger.finer("Final number of files to be zipped = " + resultFiles.size());
        String[] filesToZip = new String[resultFiles.size()];
        filesToZip = resultFiles.toArray(filesToZip);
        ZipWriter writer = new ZipWriter(FileUtils.safeGetCanonicalPath((File)glassFishZipFile), installRoot.toString(), filesToZip);
        writer.safeWrite();
        logger.info("Created installation zip " + FileUtils.safeGetCanonicalPath((File)glassFishZipFile));
        return glassFishZipFile;
    }

    private static boolean isFileWithinBinDirectory(String file) {
        boolean ret = false;
        File f = new File(file);
        String s = f.getParentFile().getName();
        if (s.equals("bin")) {
            ret = true;
        }
        return ret;
    }

    public static String toString(InputStream ins) throws IOException {
        int n;
        StringWriter sw = new StringWriter();
        InputStreamReader reader = new InputStreamReader(ins);
        char[] buffer = new char[4096];
        while ((n = reader.read(buffer)) >= 0) {
            sw.write(buffer, 0, n);
        }
        return sw.toString();
    }

    private String getIP(String host) throws CommandException {
        try {
            return InetAddress.getByName(host).getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new CommandException(Strings.get("cantResolveIpAddress", host));
        }
    }
}

