/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.utils;

import java.util.Iterator;

public class ImmutableList
implements Iterable {
    private static final LoadFactor[] distributionMap = new LoadFactor[]{new LoadFactor(2, 3.0f), new LoadFactor(6, 0.3f), new LoadFactor(10, 0.5f), new LoadFactor(50, 0.1f)};
    private final Object slotsGuard = new Object();
    private int[] slotLimits;
    private Object[] storageSlots;
    private float loadFactor = 1.75f;
    private int availableSize;
    private int currentIndex;
    private int currentSlot;
    private int initialSize = 1;
    private int size;
    private int slotCount;
    private int slotInitialSize = 1;

    public ImmutableList() {
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object item) {
        Object object = this.slotsGuard;
        synchronized (object) {
            this.accomodate(++this.size);
            ((Object[])this.storageSlots[this.currentSlot])[this.currentIndex] = item;
        }
    }

    public void clear() {
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int index) {
        Object object = this.slotsGuard;
        synchronized (object) {
            Object[] slot = null;
            int lowerLimit = 0;
            for (int i = 0; i < this.slotCount; ++i) {
                if (this.slotLimits[i] > index) {
                    slot = (Object[])this.storageSlots[i];
                    break;
                }
                lowerLimit = this.slotLimits[i];
            }
            if (slot == null) {
                return null;
            }
            return ((Object[])slot)[index - lowerLimit];
        }
    }

    public Object get(Object template) {
        for (Object obj : this) {
            if (!obj.equals(template)) continue;
            return obj;
        }
        return null;
    }

    public Iterator iterator() {
        return new InnerIterator();
    }

    public static void main(String[] args) {
        int i;
        ImmutableList list = new ImmutableList();
        for (i = 0; i < 10000; ++i) {
            list.add(i);
        }
        System.out.println("ready");
        for (i = 0; i < 10000; ++i) {
            System.out.println(i + " = " + list.get(i));
        }
        list.clear();
        for (i = 0; i < 100000; ++i) {
            list.add(i);
        }
        System.out.println("ready");
        for (i = 0; i < 100000; ++i) {
            System.out.println(i + " = " + list.get(i));
        }
    }

    public int size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accomodate(int newSize) {
        Object object = this.slotsGuard;
        synchronized (object) {
            if (this.slotCount == 0) {
                this.slotLimits = new int[this.initialSize];
                this.storageSlots = new Object[this.initialSize];
                this.storageSlots[0] = new Object[this.slotInitialSize];
                this.availableSize = this.slotLimits[0] = this.slotInitialSize;
                this.slotCount = 1;
                this.currentSlot = 0;
                this.currentIndex = 0;
                return;
            }
            if (newSize > this.availableSize) {
                int newSlotSize = (int)((float)this.availableSize * this.findLoadFactor(this.availableSize) + 0.5f);
                newSlotSize = newSlotSize > 0 ? newSize : 1;
                Object[] newSlot = new Object[newSlotSize];
                this.availableSize += newSlotSize;
                if (this.slotCount == this.storageSlots.length) {
                    int newSlotsSize = (int)((float)this.slotCount * this.loadFactor + 0.5f);
                    Object[] newStorageSlots = new Object[newSlotsSize];
                    int[] newSlotLimits = new int[newSlotsSize];
                    System.arraycopy(this.storageSlots, 0, newStorageSlots, 0, this.storageSlots.length);
                    System.arraycopy(this.slotLimits, 0, newSlotLimits, 0, this.slotLimits.length);
                    this.storageSlots = newStorageSlots;
                    this.slotLimits = newSlotLimits;
                }
                this.currentSlot = this.slotCount;
                this.currentIndex = 0;
                this.storageSlots[this.slotCount] = newSlot;
                this.slotLimits[this.slotCount] = this.availableSize;
                ++this.slotCount;
                return;
            }
            this.currentIndex = this.slotCount > 1 ? newSize - this.slotLimits[this.slotCount - 2] - 1 : newSize - 1;
        }
    }

    private float findLoadFactor(int origSize) {
        for (int i = 0; i < distributionMap.length; ++i) {
            if (ImmutableList.distributionMap[i].upperLimit <= origSize) continue;
            return ImmutableList.distributionMap[i].factor;
        }
        return 0.01f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        Object object = this.slotsGuard;
        synchronized (object) {
            this.storageSlots = null;
            this.slotLimits = null;
            this.slotCount = 0;
            this.size = 0;
        }
    }

    private class InnerIterator
    implements Iterator {
        private int counter = 0;

        @Override
        public boolean hasNext() {
            return this.counter < ImmutableList.this.size;
        }

        public Object next() {
            return ImmutableList.this.get(this.counter++);
        }

        @Override
        public void remove() {
        }
    }

    private static final class LoadFactor {
        public static final float DEFAULT_FACTOR = 0.01f;
        public final float factor;
        public final int upperLimit;

        public LoadFactor(int upperLimit, float loadFactor) {
            this.upperLimit = upperLimit;
            this.factor = loadFactor;
        }
    }
}

