/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.CCTProvider;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;

public interface MemoryCCTProvider
extends CCTProvider {
    public long[] getAllocObjectNumbers();

    public int getCurrentEpoch();

    public ObjectNumbersContainer getLivenessObjectNumbers();

    public int getNProfiledClasses();

    public long[] getObjectsSizePerClass();

    public RuntimeMemoryCCTNode[] getStacksForClasses();

    public void beginTrans(boolean var1);

    public boolean classMarkedUnprofiled(int var1);

    public PresoObjAllocCCTNode createPresentationCCT(int var1, boolean var2) throws ClientUtils.TargetAppOrVMTerminated;

    public void endTrans();

    public void markClassUnprofiled(int var1);

    public void updateInternals();

    public static interface Listener
    extends CCTProvider.Listener {
    }

    public static class ObjectNumbersContainer {
        public float[] avgObjectAge;
        public int[] maxSurvGen;
        public long[] nTrackedAllocObjects;
        public int[] nTrackedLiveObjects;
        public long[] trackedLiveObjectsSize;
        public int nInstrClasses;

        ObjectNumbersContainer(long[] nTrackedAllocObjects, int[] nTrackedLiveObjects, long[] trackedLiveObjectsSize, float[] avgObjectAge, int[] maxSurvGen, boolean[] unprofiledClass, int nProfiledClasses) {
            this.nInstrClasses = nProfiledClasses;
            int len = nProfiledClasses;
            this.nTrackedAllocObjects = new long[len];
            this.nTrackedLiveObjects = new int[len];
            this.trackedLiveObjectsSize = new long[len];
            this.avgObjectAge = avgObjectAge;
            this.maxSurvGen = maxSurvGen;
            if (nTrackedAllocObjects != null) {
                System.arraycopy(nTrackedAllocObjects, 0, this.nTrackedAllocObjects, 0, len);
            }
            if (nTrackedLiveObjects != null) {
                System.arraycopy(nTrackedLiveObjects, 0, this.nTrackedLiveObjects, 0, len);
            }
            if (trackedLiveObjectsSize != null) {
                System.arraycopy(trackedLiveObjectsSize, 0, this.trackedLiveObjectsSize, 0, len);
            }
            for (int i = 0; i < unprofiledClass.length; ++i) {
                if (!unprofiledClass[i]) continue;
                this.nTrackedAllocObjects[i] = -1L;
                this.nTrackedLiveObjects[i] = 0;
                this.trackedLiveObjectsSize[i] = 0L;
                this.avgObjectAge[i] = 0.0f;
                this.maxSurvGen[i] = 0;
            }
        }
    }
}

