/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.util.regex.PatternSyntaxException;
import org.netbeans.lib.profiler.utils.IntSorter;
import org.netbeans.lib.profiler.utils.LongSorter;
import org.netbeans.lib.profiler.utils.StringSorter;

public abstract class FlatProfileContainer {
    public static final int SORT_BY_NAME = 1;
    public static final int SORT_BY_TIME = 2;
    public static final int SORT_BY_SECONDARY_TIME = 3;
    public static final int SORT_BY_INV_NUMBER = 4;
    protected static boolean staticUsePrimaryTime;
    protected int[] methodIds;
    protected final char[] methodMarks;
    protected int[] nInvocations;
    protected float[] percent;
    protected long[] timeInMcs0;
    protected long[] timeInMcs1;
    protected boolean collectingTwoTimeStamps;
    protected long nTotalInvocations;
    private int nRows;
    private int totalMethods;

    public FlatProfileContainer(long[] timeInMcs0, long[] timeInMcs1, int[] nInvocations, char[] marks, int nMethods) {
        this.timeInMcs0 = timeInMcs0;
        this.timeInMcs1 = timeInMcs1;
        this.nInvocations = nInvocations;
        this.methodMarks = marks;
        this.totalMethods = nMethods;
    }

    public boolean isCollectingTwoTimeStamps() {
        return this.collectingTwoTimeStamps;
    }

    public int getMethodIdAtRow(int row) {
        return this.methodIds[row];
    }

    public abstract String getMethodNameAtRow(int var1);

    public int getNInvocationsAtRow(int row) {
        return this.nInvocations[row];
    }

    public int getNRows() {
        return this.nRows;
    }

    public long getNTotalInvocations() {
        return this.nTotalInvocations;
    }

    public float getPercentAtRow(int row) {
        return this.percent[row];
    }

    public long getTimeInMcs0AtRow(int row) {
        return this.timeInMcs0[row];
    }

    public long getTimeInMcs1AtRow(int row) {
        return this.timeInMcs1[row];
    }

    public abstract double getWholeGraphNetTime0();

    public abstract double getWholeGraphNetTime1();

    public void filterOriginalData(String[] filters, int type, double valueFilter) {
        if ((type == 0 || filters == null || filters[0].isEmpty()) && valueFilter == 0.0) {
            this.nRows = this.totalMethods;
            return;
        }
        this.nRows = this.totalMethods;
        for (int i = 0; i < this.nRows; ++i) {
            int endIdx;
            if (this.passedFilters(this.getMethodNameAtRow(i), filters, type) || i >= (endIdx = --this.nRows)) continue;
            int tmp = this.methodIds[i];
            this.methodIds[i] = this.methodIds[endIdx];
            this.methodIds[endIdx] = tmp;
            long time = this.timeInMcs0[i];
            this.timeInMcs0[i] = this.timeInMcs0[endIdx];
            this.timeInMcs0[endIdx] = time;
            if (this.collectingTwoTimeStamps) {
                time = this.timeInMcs1[i];
                this.timeInMcs1[i] = this.timeInMcs1[endIdx];
                this.timeInMcs1[endIdx] = time;
            }
            tmp = this.nInvocations[i];
            this.nInvocations[i] = this.nInvocations[endIdx];
            this.nInvocations[endIdx] = tmp;
            --i;
        }
    }

    public void sortBy(int sortCrit, boolean order) {
        switch (sortCrit) {
            case 1: {
                this.sortDataByMethodName(order);
                break;
            }
            case 2: {
                this.sortDataByTime(true, order);
                break;
            }
            case 3: {
                this.sortDataByTime(false, order);
                break;
            }
            case 4: {
                this.sortDataByInvNumber(order);
            }
        }
    }

    protected void removeZeroInvocationEntries() {
        this.nRows = 0;
        for (int i = 1; i < this.totalMethods; ++i) {
            if (this.nInvocations[i] <= 0) continue;
            ++this.nRows;
        }
        long[] oldTime0 = this.timeInMcs0;
        long[] oldTime1 = this.timeInMcs1;
        int[] oldNInvocations = this.nInvocations;
        this.timeInMcs0 = new long[this.nRows];
        if (this.collectingTwoTimeStamps) {
            this.timeInMcs1 = new long[this.nRows];
        }
        this.nInvocations = new int[this.nRows];
        this.methodIds = new int[this.nRows];
        int k = 0;
        for (int i = 1; i < this.totalMethods; ++i) {
            if (oldNInvocations[i] <= 0) continue;
            long time = oldTime0[i];
            if (time < 0L) {
                time = 0L;
            }
            this.timeInMcs0[k] = time;
            if (this.collectingTwoTimeStamps) {
                time = oldTime1[i];
                if (time < 0L) {
                    time = 0L;
                }
                this.timeInMcs1[k] = time;
            }
            this.nInvocations[k] = oldNInvocations[i];
            this.nTotalInvocations += (long)oldNInvocations[i];
            this.methodIds[k] = i;
            ++k;
        }
        this.totalMethods = this.nRows;
    }

    private void calculatePercent(boolean usePrimaryTime) {
        this.percent = new float[this.nRows];
        double wholeNetTime = this.getWholeGraphNetTime0();
        long[] tpm = this.timeInMcs0;
        if (this.collectingTwoTimeStamps && !usePrimaryTime) {
            wholeNetTime = this.getWholeGraphNetTime1();
            tpm = this.timeInMcs1;
        }
        for (int i = 0; i < this.nRows; ++i) {
            this.percent[i] = (float)(wholeNetTime > 0.0 ? (double)tpm[i] / wholeNetTime * 100.0 : 0.0);
        }
        staticUsePrimaryTime = usePrimaryTime;
    }

    private boolean passedFilter(String value, String filter, int type) {
        switch (type) {
            case 20: {
                return value.toLowerCase().contains(filter);
            }
            case 25: {
                return !value.toLowerCase().contains(filter);
            }
            case 50: {
                try {
                    return value.matches(filter);
                }
                catch (PatternSyntaxException e) {
                    return false;
                }
            }
        }
        return false;
    }

    private boolean passedFilters(String value, String[] filters, int type) {
        for (int i = 0; i < filters.length; ++i) {
            if (!this.passedFilter(value, filters[i], type)) continue;
            return true;
        }
        return false;
    }

    private void sortDataByInvNumber(boolean sortOrder) {
        if (this.percent == null || this.percent.length != this.nRows) {
            this.calculatePercent(staticUsePrimaryTime);
        }
        new IntSorter(this.nInvocations, 0, this.nRows){

            @Override
            protected void swap(int a, int b) {
                super.swap(a, b);
                long tmp = FlatProfileContainer.this.timeInMcs0[a];
                FlatProfileContainer.this.timeInMcs0[a] = FlatProfileContainer.this.timeInMcs0[b];
                FlatProfileContainer.this.timeInMcs0[b] = tmp;
                if (FlatProfileContainer.this.collectingTwoTimeStamps) {
                    tmp = FlatProfileContainer.this.timeInMcs1[a];
                    FlatProfileContainer.this.timeInMcs1[a] = FlatProfileContainer.this.timeInMcs1[b];
                    FlatProfileContainer.this.timeInMcs1[b] = tmp;
                }
                int itmp = FlatProfileContainer.this.methodIds[a];
                FlatProfileContainer.this.methodIds[a] = FlatProfileContainer.this.methodIds[b];
                FlatProfileContainer.this.methodIds[b] = itmp;
                if (FlatProfileContainer.this.percent != null) {
                    float ftmp = FlatProfileContainer.this.percent[a];
                    FlatProfileContainer.this.percent[a] = FlatProfileContainer.this.percent[b];
                    FlatProfileContainer.this.percent[b] = ftmp;
                }
            }
        }.sort(sortOrder);
    }

    private void sortDataByMethodName(boolean sortOrder) {
        String[] fullMethodNames = new String[this.nRows];
        if (this.percent == null || this.percent.length != this.nRows) {
            this.calculatePercent(staticUsePrimaryTime);
        }
        for (int i = 0; i < this.nRows; ++i) {
            fullMethodNames[i] = this.getMethodNameAtRow(i);
        }
        new StringSorter(fullMethodNames, 0, this.nRows){

            @Override
            protected void swap(int a, int b) {
                super.swap(a, b);
                long tmp = FlatProfileContainer.this.timeInMcs0[a];
                FlatProfileContainer.this.timeInMcs0[a] = FlatProfileContainer.this.timeInMcs0[b];
                FlatProfileContainer.this.timeInMcs0[b] = tmp;
                if (FlatProfileContainer.this.collectingTwoTimeStamps) {
                    tmp = FlatProfileContainer.this.timeInMcs1[a];
                    FlatProfileContainer.this.timeInMcs1[a] = FlatProfileContainer.this.timeInMcs1[b];
                    FlatProfileContainer.this.timeInMcs1[b] = tmp;
                }
                int itmp = FlatProfileContainer.this.methodIds[a];
                FlatProfileContainer.this.methodIds[a] = FlatProfileContainer.this.methodIds[b];
                FlatProfileContainer.this.methodIds[b] = itmp;
                itmp = FlatProfileContainer.this.nInvocations[a];
                FlatProfileContainer.this.nInvocations[a] = FlatProfileContainer.this.nInvocations[b];
                FlatProfileContainer.this.nInvocations[b] = itmp;
                if (FlatProfileContainer.this.percent != null) {
                    float ftmp = FlatProfileContainer.this.percent[a];
                    FlatProfileContainer.this.percent[a] = FlatProfileContainer.this.percent[b];
                    FlatProfileContainer.this.percent[b] = ftmp;
                }
            }
        }.sort(sortOrder);
    }

    private void sortDataByTime(boolean usePrimaryTime, boolean sortOrder) {
        int len;
        long[] tpmA = null;
        long[] tpmB = null;
        if (this.percent == null || usePrimaryTime != staticUsePrimaryTime || this.percent.length != this.nRows) {
            this.calculatePercent(usePrimaryTime);
        }
        if (this.collectingTwoTimeStamps) {
            if (usePrimaryTime) {
                tpmA = this.timeInMcs0;
                tpmB = this.timeInMcs1;
            } else {
                tpmA = this.timeInMcs1;
                tpmB = this.timeInMcs0;
            }
        } else {
            tpmA = this.timeInMcs0;
        }
        final long[] tpmBF = tpmB;
        new LongSorter(tpmA, 0, this.nRows){

            @Override
            protected void swap(int a, int b) {
                super.swap(a, b);
                if (FlatProfileContainer.this.collectingTwoTimeStamps) {
                    long tmp = tpmBF[a];
                    tpmBF[a] = tpmBF[b];
                    tpmBF[b] = tmp;
                }
                int itmp = FlatProfileContainer.this.methodIds[a];
                FlatProfileContainer.this.methodIds[a] = FlatProfileContainer.this.methodIds[b];
                FlatProfileContainer.this.methodIds[b] = itmp;
                itmp = FlatProfileContainer.this.nInvocations[a];
                FlatProfileContainer.this.nInvocations[a] = FlatProfileContainer.this.nInvocations[b];
                FlatProfileContainer.this.nInvocations[b] = itmp;
                if (FlatProfileContainer.this.percent != null) {
                    float ftmp = FlatProfileContainer.this.percent[a];
                    FlatProfileContainer.this.percent[a] = FlatProfileContainer.this.percent[b];
                    FlatProfileContainer.this.percent[b] = ftmp;
                }
            }
        }.sort(sortOrder);
        for (len = this.nRows - 1; len >= 0 && tpmA[len] == 0L; --len) {
        }
        if (len < this.nRows - 1) {
            new IntSorter(this.nInvocations, len + 1, this.nRows - len - 1){

                @Override
                protected void swap(int a, int b) {
                    super.swap(a, b);
                    if (FlatProfileContainer.this.collectingTwoTimeStamps) {
                        long tmp = tpmBF[a];
                        tpmBF[a] = tpmBF[b];
                        tpmBF[b] = tmp;
                    }
                    int itmp = FlatProfileContainer.this.methodIds[a];
                    FlatProfileContainer.this.methodIds[a] = FlatProfileContainer.this.methodIds[b];
                    FlatProfileContainer.this.methodIds[b] = itmp;
                }
            }.sort(sortOrder);
        }
    }
}

