/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ProfilingPointsProcessor;
import org.netbeans.lib.profiler.global.InstrumentationFilter;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.results.BaseCallGraphBuilder;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.RuntimeCCTNodeProcessor;
import org.netbeans.lib.profiler.results.cpu.CPUCCTContainer;
import org.netbeans.lib.profiler.results.cpu.CPUCCTProvider;
import org.netbeans.lib.profiler.results.cpu.CPUProfilingResultListener;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.MethodInfoMapper;
import org.netbeans.lib.profiler.results.cpu.ThreadInfo;
import org.netbeans.lib.profiler.results.cpu.ThreadInfos;
import org.netbeans.lib.profiler.results.cpu.TimingAdjusterOld;
import org.netbeans.lib.profiler.results.cpu.cct.CPUCCTNodeFactory;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MarkedCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MethodCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.RuntimeCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.ServletRequestCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.SimpleCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.ThreadCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.TimedCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.marking.MarkingEngine;

public class CPUCallGraphBuilder
extends BaseCallGraphBuilder
implements CPUProfilingResultListener,
CPUCCTProvider {
    private CPUCCTNodeFactory factory;
    private DebugInfoCollector debugCollector = null;
    private InstrumentationFilter instrFilter;
    private boolean stackIntegrityViolationReported;
    private long delta;
    private MethodInfoMapper methodInfoMapper = MethodInfoMapper.DEFAULT;
    private TimingAdjusterOld timingAdjuster = TimingAdjusterOld.getDefault();
    private final ThreadInfos threadInfos = new ThreadInfos();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CPUCCTContainer[] createPresentationCCTs(CPUResultsSnapshot cpuSnapshot) {
        this.threadInfos.beginTrans(false);
        try {
            String[] threadNames = this.threadInfos.getThreadNames();
            if (threadNames == null) {
                CPUCCTContainer[] cPUCCTContainerArray = null;
                return cPUCCTContainerArray;
            }
            int len = threadNames.length;
            if (len == 0) {
                CPUCCTContainer[] cPUCCTContainerArray = null;
                return cPUCCTContainerArray;
            }
            ArrayList<CPUCCTContainer> ccts = new ArrayList<CPUCCTContainer>(len);
            int threadId = 0;
            for (int i = 0; i < len; ++i) {
                ThreadInfo ti = this.threadInfos.threadInfos[i];
                if (ti == null || ti.stack[0] == null) continue;
                double[] activeTimes = this.calculateThreadActiveTimes(ti);
                TimedCPUCCTNode rootNode = ti.stack[0];
                CPUCCTContainer cct = new CPUCCTContainer(rootNode, cpuSnapshot, this.methodInfoMapper, this.timingAdjuster, this.instrFilter, ti.totalNNodes, activeTimes, threadId++, threadNames[i]);
                if (cct.rootNode == null || cct.rootNode.getNChildren() <= 0) continue;
                ccts.add(cct);
            }
            CPUCCTContainer[] cPUCCTContainerArray = ccts.toArray(new CPUCCTContainer[ccts.size()]);
            return cPUCCTContainerArray;
        }
        finally {
            this.threadInfos.endTrans();
        }
    }

    public void setMethodInfoMapper(MethodInfoMapper mapper) {
        this.methodInfoMapper = mapper != null ? mapper : MethodInfoMapper.DEFAULT;
    }

    protected boolean isCollectingTwoTimeStamps() {
        return this.status.collectingTwoTimeStamps();
    }

    protected long getDumpAbsTimeStamp() {
        return this.status.dumpAbsTimeStamp;
    }

    @Override
    public void methodEntry(int methodId, int threadId, int methodType, long timeStamp0, long timeStamp1) {
        if (!this.isReady() || this.threadInfos.threadInfos == null) {
            return;
        }
        ThreadInfo ti = this.threadInfos.threadInfos[threadId];
        if (ti == null) {
            return;
        }
        switch (methodType) {
            case 1: {
                this.plainMethodEntry(methodId, ti, timeStamp0, timeStamp1);
                break;
            }
            case 2: {
                this.rootMethodEntry(methodId, ti, timeStamp0, timeStamp1);
                break;
            }
            case 3: {
                this.markerMethodEntry(methodId, ti, timeStamp0, timeStamp1);
            }
        }
        this.batchNotEmpty = true;
    }

    @Override
    public void methodEntryUnstamped(int methodId, int threadId, int methodType) {
        if (!this.isReady() || this.threadInfos.threadInfos == null) {
            return;
        }
        ThreadInfo ti = this.threadInfos.threadInfos[threadId];
        if (ti == null) {
            return;
        }
        switch (methodType) {
            case 1: {
                this.plainMethodEntry(methodId, ti);
                break;
            }
            case 3: {
                this.markerMethodEntry(methodId, ti);
            }
        }
        this.batchNotEmpty = true;
    }

    @Override
    public void methodExit(int methodId, int threadId, int methodType, long timeStamp0, long timeStamp1) {
        if (!this.isReady() || this.threadInfos.threadInfos == null) {
            return;
        }
        ThreadInfo ti = this.threadInfos.threadInfos[threadId];
        if (ti == null) {
            return;
        }
        TimedCPUCCTNode oldNode = null;
        switch (methodType) {
            case 1: 
            case 3: {
                oldNode = this.plainMethodExit(methodId, ti, timeStamp0, timeStamp1);
                break;
            }
            case 2: {
                oldNode = this.rootMethodExit(methodId, ti, timeStamp0, timeStamp1);
            }
        }
        if (oldNode != null) {
            TimedCPUCCTNode oneMoreNode = ti.peek();
            if (oneMoreNode instanceof MarkedCPUCCTNode) {
                ti.pop();
                oneMoreNode = ti.peek();
            }
            if (oneMoreNode instanceof ServletRequestCPUCCTNode) {
                ti.pop();
            }
        }
        this.batchNotEmpty = true;
    }

    @Override
    public void methodExitUnstamped(int methodId, int threadId, int methodType) {
        if (!this.isReady() || this.threadInfos.threadInfos == null) {
            return;
        }
        ThreadInfo ti = this.threadInfos.threadInfos[threadId];
        if (ti == null) {
            return;
        }
        TimedCPUCCTNode oldNode = null;
        switch (methodType) {
            case 1: 
            case 3: {
                oldNode = this.plainMethodExit(methodId, ti);
            }
        }
        if (oldNode != null) {
            TimedCPUCCTNode oneMoreNode = ti.peek();
            if (oneMoreNode instanceof MarkedCPUCCTNode) {
                ti.pop();
                oneMoreNode = ti.peek();
            }
            if (oneMoreNode instanceof ServletRequestCPUCCTNode) {
                ti.pop();
            }
        }
        this.batchNotEmpty = true;
    }

    @Override
    public void monitorEntry(int threadId, long timeStamp0, long timeStamp1) {
        this.waitEntry(threadId, timeStamp0, timeStamp1);
        this.batchNotEmpty = true;
    }

    @Override
    public void monitorExit(int threadId, long timeStamp0, long timeStamp1) {
        this.waitExit(threadId, timeStamp0, timeStamp1);
        this.batchNotEmpty = true;
    }

    @Override
    public void newThread(int threadId, String threadName, String threadClassName) {
        if (!this.isReady()) {
            return;
        }
        LOGGER.log(Level.FINEST, "New thread creation for thread id = {0}, name = {1}", new Object[]{threadId, threadName});
        this.threadInfos.newThreadInfo(threadId, threadName, threadClassName);
        this.batchNotEmpty = true;
    }

    @Override
    public void servletRequest(int threadId, int requestType, String servletPath, int sessionId) {
        ServletRequestCPUCCTNode servletNode;
        if (!this.isReady() || this.threadInfos.threadInfos == null) {
            return;
        }
        ThreadInfo ti = this.threadInfos.threadInfos[threadId];
        if (ti == null) {
            return;
        }
        TimedCPUCCTNode curNode = ti.peek();
        if (curNode == null) {
            curNode = this.factory.createThreadNode(threadId);
            ++ti.totalNNodes;
            ti.push(curNode);
            --ti.totalNInv;
        }
        if ((servletNode = ServletRequestCPUCCTNode.Locator.locate(requestType, servletPath, curNode.getChildren())) == null) {
            servletNode = this.factory.createServletRequestNode(requestType, servletPath);
            curNode.attachNodeAsChild(servletNode);
        }
        ti.push(servletNode);
    }

    @Override
    public void sleepEntry(int threadId, long timeStamp0, long timeStamp1) {
        long diff;
        if (!this.isReady() || this.threadInfos.threadInfos == null) {
            return;
        }
        ThreadInfo ti = this.threadInfos.threadInfos[threadId];
        TimedCPUCCTNode curNode = ti.stack[ti.stackTopIdx];
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("ENTRY SLEEP: " + this.debugNode(curNode) + ", time: " + timeStamp0 + ", delta: " + (timeStamp0 - this.delta) + ", ti: " + ti);
            this.delta = timeStamp0;
        }
        if ((diff = timeStamp0 - ti.topMethodEntryTime0) > 0L) {
            curNode.addNetTime0(diff);
        } else {
            timeStamp0 = ti.topMethodEntryTime0;
        }
        ti.topMethodEntryTime0 = timeStamp0;
        curNode.setLastWaitOrSleepStamp(timeStamp0);
        this.batchNotEmpty = true;
    }

    @Override
    public void sleepExit(int threadId, long timeStamp0, long timeStamp1) {
        if (!this.isReady() || this.threadInfos.threadInfos == null) {
            return;
        }
        ThreadInfo ti = this.threadInfos.threadInfos[threadId];
        TimedCPUCCTNode curNode = ti.stack[ti.stackTopIdx];
        long lastSleep = timeStamp0 - curNode.getLastWaitOrSleepStamp();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("EXIT SLEEP: " + this.debugNode(curNode) + ", time: " + timeStamp0 + ", delta: " + (timeStamp0 - this.delta) + ", slept: " + lastSleep + ", ti: " + ti);
            this.delta = timeStamp0;
            lastSleep = 0L;
        }
        curNode.setLastWaitOrSleepStamp(0L);
        curNode.addSleepTime0(lastSleep);
        if (timeStamp0 - ti.topMethodEntryTime0 > 0L) {
            ti.topMethodEntryTime0 = timeStamp0;
        }
        this.batchNotEmpty = true;
    }

    @Override
    public void threadsResume(long timeStamp0, long timeStamp1) {
        if (!this.isReady() || this.threadInfos.threadInfos == null) {
            return;
        }
        ThreadInfo[] tis = this.threadInfos.threadInfos;
        for (int i = 0; i < tis.length; ++i) {
            ThreadInfo ti = tis[i];
            if (ti == null || ti.stackTopIdx < 0) continue;
            ti.topMethodEntryTime0 = timeStamp0;
            if (this.isCollectingTwoTimeStamps()) {
                ti.topMethodEntryTime1 = timeStamp1;
            }
            if (this.isCollectingTwoTimeStamps()) {
                ti.rootMethodEntryTimeAbs = timeStamp0;
                ti.rootMethodEntryTimeThreadCPU = timeStamp1;
                continue;
            }
            ti.rootMethodEntryTimeAbs = timeStamp0;
        }
        this.batchNotEmpty = true;
    }

    @Override
    public void threadsSuspend(long timeStamp0, long timeStamp1) {
        if (!this.isReady() || this.threadInfos.threadInfos == null) {
            return;
        }
        ThreadInfo[] tis = this.threadInfos.threadInfos;
        for (int i = 0; i < tis.length; ++i) {
            ThreadInfo ti = tis[i];
            if (ti == null || ti.stackTopIdx < 0) continue;
            TimedCPUCCTNode curNode = ti.stack[ti.stackTopIdx];
            long diff = timeStamp0 - ti.topMethodEntryTime0;
            if (diff > 0L) {
                curNode.addNetTime0(diff);
            }
            if (this.isCollectingTwoTimeStamps()) {
                ti.rootGrossTimeAbs += timeStamp0 - ti.rootMethodEntryTimeAbs;
                diff = timeStamp1 - ti.topMethodEntryTime1;
                if (diff > 0L) {
                    curNode.addNetTime1(diff);
                }
                ti.rootGrossTimeThreadCPU += timeStamp1 - ti.rootMethodEntryTimeThreadCPU;
                continue;
            }
            ti.rootGrossTimeAbs += timeStamp0 - ti.rootMethodEntryTimeAbs;
        }
        this.batchNotEmpty = true;
    }

    @Override
    public void timeAdjust(final int threadId, final long timeDiff0, final long timeDiff1) {
        if (!this.isReady() || this.threadInfos.threadInfos == null) {
            return;
        }
        final ProfilingPointsProcessor ppp = TargetAppRunner.getDefault().getProfilingPointsProcessor();
        ThreadInfo ti = this.threadInfos.threadInfos[threadId];
        ti.rootMethodEntryTimeAbs += timeDiff0;
        ti.rootMethodEntryTimeThreadCPU += timeDiff1;
        ti.topMethodEntryTime0 += timeDiff0;
        if (this.isCollectingTwoTimeStamps()) {
            ti.topMethodEntryTime1 += timeDiff1;
        }
        if (ppp != null) {
            this.afterBatchCommands.add(new Runnable(){

                @Override
                public void run() {
                    ppp.timeAdjust(threadId, timeDiff0, timeDiff1);
                }
            });
        }
        this.batchNotEmpty = true;
    }

    @Override
    public void waitEntry(int threadId, long timeStamp0, long timeStamp1) {
        long diff;
        if (!this.isReady() || this.threadInfos.threadInfos == null) {
            return;
        }
        ThreadInfo ti = this.threadInfos.threadInfos[threadId];
        TimedCPUCCTNode curNode = ti.stack[ti.stackTopIdx];
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("ENTRY WAIT: " + this.debugNode(curNode) + ", time: " + timeStamp0 + ", delta: " + (timeStamp0 - this.delta) + ", ti: " + ti);
            this.delta = timeStamp0;
            LOGGER.finest(this.dumpStack(ti));
        }
        if ((diff = timeStamp0 - ti.topMethodEntryTime0) > 0L) {
            curNode.addNetTime0(diff);
        } else {
            timeStamp0 = ti.topMethodEntryTime0;
        }
        ti.topMethodEntryTime0 = timeStamp0;
        curNode.setLastWaitOrSleepStamp(timeStamp0);
        this.batchNotEmpty = true;
    }

    @Override
    public void waitExit(int threadId, long timeStamp0, long timeStamp1) {
        if (!this.isReady() || this.threadInfos.threadInfos == null) {
            return;
        }
        ThreadInfo ti = this.threadInfos.threadInfos[threadId];
        TimedCPUCCTNode curNode = ti.stack[ti.stackTopIdx];
        long lastWait = timeStamp0 - curNode.getLastWaitOrSleepStamp();
        curNode.setLastWaitOrSleepStamp(0L);
        curNode.addWaitTime0(lastWait);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("EXIT WAIT: " + this.debugNode(curNode) + ", time: " + timeStamp0 + ", delta: " + (timeStamp0 - this.delta) + ", waited: " + lastWait + ", ti: " + ti);
            this.delta = timeStamp0;
            LOGGER.finest(this.dumpStack(ti));
        }
        if (timeStamp0 - ti.topMethodEntryTime0 > 0L) {
            ti.topMethodEntryTime0 = timeStamp0;
        }
        this.batchNotEmpty = true;
    }

    protected long[][] getAllThreadsActiveTimes() {
        int len = this.threadInfos.getThreadNames().length;
        long[][] res = new long[2][len];
        for (int i = 0; i < len; ++i) {
            ThreadInfo ti = this.threadInfos.threadInfos[i];
            double[] times = this.calculateThreadActiveTimes(ti);
            res[0][i] = (long)((times[0] - times[2]) * 1000.0 / (double)this.timingAdjuster.getInstrTimingData().timerCountsInSecond0);
            res[1][i] = times[1] != -1.0 ? (long)((times[1] - times[3]) * 1000.0 / (double)this.timingAdjuster.getInstrTimingData().timerCountsInSecond1) : -1L;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RuntimeCCTNode getAppRootNode() {
        if (this.threadInfos.isEmpty()) {
            return null;
        }
        SimpleCPUCCTNode appNode = null;
        this.threadInfos.beginTrans(false);
        try {
            appNode = new SimpleCPUCCTNode(((ProfilerClient)this.clientRef.get()).getStatus().getNInstrMethods());
            int len = this.threadInfos.getThreadNames() != null ? this.threadInfos.getThreadNames().length : 0;
            for (int i = 0; i < len; ++i) {
                ThreadInfo ti = this.threadInfos.threadInfos[i];
                if (ti == null || ti.stack[0] == null) continue;
                appNode.attachNodeAsChild(ti.stack[0]);
            }
        }
        finally {
            this.threadInfos.endTrans();
        }
        return appNode;
    }

    double[] calculateThreadActiveTimes(ThreadInfo ti) {
        TimedCPUCCTNode rootNode = ti.stack[0];
        if (rootNode == null) {
            return new double[]{0.0, 0.0, 0.0, 0.0};
        }
        long rootGrossTimeAbs = ti.rootGrossTimeAbs;
        if (ti.stackTopIdx != -1) {
            long time0 = this.getDumpAbsTimeStamp();
            if (ti.topMethodEntryTime0 > time0) {
                time0 = ti.topMethodEntryTime0;
            }
            rootGrossTimeAbs += time0 - ti.rootMethodEntryTimeAbs;
        }
        long rootGrossTimeCPU = ti.rootGrossTimeThreadCPU;
        if (ti.stackTopIdx != -1) {
            rootGrossTimeCPU = this.isCollectingTwoTimeStamps() ? (rootGrossTimeCPU += ti.topMethodEntryTime1 - ti.rootMethodEntryTimeThreadCPU) : -1L;
        }
        int nRootInv = rootNode.getNCalls();
        double timeInInjectedCodeInThreadCPUCounts = 0.0;
        double timeInInjectedCodeInAbsCounts = this.timingAdjuster.delta(nRootInv, (int)(ti.totalNInv - (long)nRootInv), false);
        timeInInjectedCodeInThreadCPUCounts = this.isCollectingTwoTimeStamps() ? this.timingAdjuster.delta(nRootInv, (int)(ti.totalNInv - (long)nRootInv), true) : timeInInjectedCodeInAbsCounts * (double)this.timingAdjuster.getInstrTimingData().timerCountsInSecond1 / (double)this.timingAdjuster.getInstrTimingData().timerCountsInSecond0;
        return new double[]{rootGrossTimeAbs, rootGrossTimeCPU, timeInInjectedCodeInAbsCounts, timeInInjectedCodeInThreadCPUCounts};
    }

    @Override
    protected void doBatchStart() {
        ProfilerClient client = this.getClient();
        if (client != null) {
            this.timingAdjuster = TimingAdjusterOld.getInstance(client.getStatus());
        }
        if (this.factory == null) {
            this.factory = new CPUCCTNodeFactory(this.isCollectingTwoTimeStamps());
        }
        this.threadInfos.beginTrans(true);
    }

    @Override
    protected void doBatchStop() {
        this.threadInfos.endTrans();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doReset() {
        boolean threadLocked = this.threadInfos.beginTrans(true, true);
        if (threadLocked) {
            try {
                this.threadInfos.reset();
            }
            finally {
                this.threadInfos.endTrans();
            }
        }
    }

    @Override
    protected void doShutdown() {
        this.threadInfos.reset();
        this.factory = null;
        this.instrFilter = null;
    }

    @Override
    protected void doStartup(final ProfilerClient profilerClient) {
        this.instrFilter = profilerClient.getSettings().getInstrumentationFilter();
        this.setMethodInfoMapper(new MethodInfoMapper(){
            private final String INVALID_MID = ResourceBundle.getBundle("org.netbeans.lib.profiler.results.cpu.Bundle").getString("MSG_INVALID_METHODID");

            @Override
            public String getInstrMethodClass(int methodId) {
                String[] cNames = profilerClient.getStatus().getInstrMethodClasses();
                if (methodId < cNames.length) {
                    return cNames[methodId];
                }
                LOGGER.log(Level.WARNING, this.INVALID_MID, new Object[]{methodId, cNames.length - 1});
                return null;
            }

            @Override
            public String getInstrMethodName(int methodId) {
                String[] mNames = profilerClient.getStatus().getInstrMethodNames();
                if (methodId < mNames.length) {
                    return mNames[methodId];
                }
                LOGGER.log(Level.WARNING, this.INVALID_MID, new Object[]{methodId, mNames.length - 1});
                return null;
            }

            @Override
            public String getInstrMethodSignature(int methodId) {
                String[] sNames = profilerClient.getStatus().getInstrMethodSignatures();
                if (methodId < sNames.length) {
                    return sNames[methodId];
                }
                LOGGER.log(Level.WARNING, this.INVALID_MID, new Object[]{methodId, sNames.length - 1});
                return null;
            }

            @Override
            public int getMinMethodId() {
                return profilerClient.getStatus().getStartingMethodId();
            }

            @Override
            public int getMaxMethodId() {
                return profilerClient.getStatus().getNInstrMethods() + profilerClient.getStatus().getStartingMethodId() - 1;
            }

            @Override
            public void lock(boolean mutable) {
                profilerClient.getStatus().beginTrans(mutable);
            }

            @Override
            public void unlock() {
                profilerClient.getStatus().endTrans();
            }
        });
        profilerClient.registerCPUCCTProvider(this);
    }

    protected void setFactory(CPUCCTNodeFactory factory) {
        this.factory = factory;
    }

    protected void setFilter(InstrumentationFilter filter) {
        this.instrFilter = filter;
    }

    private synchronized DebugInfoCollector getDebugCollector() {
        if (this.debugCollector == null) {
            this.debugCollector = new DebugInfoCollector();
        }
        return this.debugCollector;
    }

    protected boolean isReady() {
        return this.status != null && this.factory != null && this.instrFilter != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String debugMethod(int methodId) {
        StringBuilder buffer = new StringBuilder();
        try {
            this.methodInfoMapper.lock(false);
            buffer.append(this.methodInfoMapper.getInstrMethodClass(methodId)).append('.').append(this.methodInfoMapper.getInstrMethodName(methodId));
            buffer.append(this.methodInfoMapper.getInstrMethodSignature(methodId)).append(" (methodId = ").append(methodId).append(')');
        }
        finally {
            this.methodInfoMapper.unlock();
        }
        return buffer.toString();
    }

    private String debugNode(RuntimeCPUCCTNode node) {
        return this.getDebugCollector().getInfo(node);
    }

    private String dumpStack(ThreadInfo ti) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("*** Thread stack dump:\n");
        for (int i = ti.stackTopIdx; i >= 0; --i) {
            DebugInfoCollector collector = new DebugInfoCollector();
            TimedCPUCCTNode frame = ti.stack[i];
            RuntimeCCTNodeProcessor.process(frame, collector);
            buffer.append(collector.getInfo(frame)).append('\n');
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimedCPUCCTNode markerMethodEntry(int methodId, ThreadInfo ti, long timeStamp0, long timeStamp1, boolean stamped) {
        TimedCPUCCTNode curNode;
        Mark mark = MarkingEngine.getDefault().markMethod(methodId, this.status);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "MarkerMEntry{0} for tId = {1}, time: {2}, method:  {3}, inRoot: {4}, rootEntryTimeThread: {5}", new Object[]{!stamped ? "(unstamped)" : "", ti.threadId, timeStamp0, this.debugMethod(methodId), ti.rootMethodEntryTimeAbs, ti.rootMethodEntryTimeThreadCPU});
        }
        if ((curNode = ti.peek()) == null) {
            TimedCPUCCTNode rootNode = this.factory.createThreadNode(ti.threadId);
            ++ti.totalNNodes;
            ti.push(rootNode);
            --ti.totalNInv;
            if (!mark.isDefault()) {
                curNode = this.factory.createCategory(mark);
                rootNode.attachNodeAsChild(curNode);
                ++ti.totalNNodes;
                ti.push(curNode);
                rootNode = curNode;
            }
            curNode = this.factory.createMethodNode(methodId);
            rootNode.attachNodeAsChild(curNode);
            ++ti.totalNNodes;
            ti.push(curNode);
            ti.topMethodEntryTime0 = timeStamp0;
            if (this.isCollectingTwoTimeStamps()) {
                ti.topMethodEntryTime1 = timeStamp1;
            }
        } else {
            MethodCPUCCTNode calleeNode;
            if (stamped) {
                long diff = timeStamp0 - ti.topMethodEntryTime0;
                if (diff > 0L) {
                    curNode.addNetTime0(diff);
                } else {
                    timeStamp0 = ti.topMethodEntryTime0;
                }
                ti.topMethodEntryTime0 = timeStamp0;
                if (this.isCollectingTwoTimeStamps()) {
                    diff = timeStamp1 - ti.topMethodEntryTime1;
                    if (diff > 0L) {
                        curNode.addNetTime1(diff);
                    } else {
                        timeStamp1 = ti.topMethodEntryTime1;
                    }
                    ti.topMethodEntryTime1 = timeStamp1;
                }
            }
            if (!mark.isDefault()) {
                MarkedCPUCCTNode calleeNode2 = MarkedCPUCCTNode.Locator.locate(mark, curNode.getChildren());
                if (calleeNode2 == null) {
                    calleeNode2 = this.factory.createCategory(mark);
                    curNode.attachNodeAsChild(calleeNode2);
                    ++ti.totalNNodes;
                }
                ti.push(calleeNode2);
                curNode = calleeNode2;
            }
            if ((calleeNode = MethodCPUCCTNode.Locator.locate(methodId, curNode.getChildren())) == null) {
                calleeNode = this.factory.createMethodNode(methodId);
                curNode.attachNodeAsChild(calleeNode);
                ++ti.totalNNodes;
            }
            ti.push(calleeNode);
            curNode = calleeNode;
        }
        if (!ti.isInRoot()) {
            curNode.setFilteredStatus(2);
            if (stamped) {
                ti.rootMethodEntryTimeAbs = timeStamp0;
                ti.rootMethodEntryTimeThreadCPU = timeStamp1;
                ti.topMethodEntryTime0 = timeStamp0;
                if (this.isCollectingTwoTimeStamps()) {
                    ti.topMethodEntryTime1 = timeStamp1;
                }
            }
        } else {
            try {
                this.methodInfoMapper.lock(false);
                String jvmClassName = this.methodInfoMapper.getInstrMethodClass(((MethodCPUCCTNode)curNode).getMethodId()).replace('.', '/');
                ProfilerClient client = this.getClient();
                if (client != null) {
                    if (!client.getSettings().getInstrumentationFilter().passesFilter(jvmClassName)) {
                        curNode.setFilteredStatus(2);
                    }
                } else {
                    curNode.setFilteredStatus(2);
                }
            }
            finally {
                this.methodInfoMapper.unlock();
            }
        }
        return curNode;
    }

    private TimedCPUCCTNode markerMethodEntry(int methodId, ThreadInfo ti, long timeStamp0, long timeStamp1) {
        return this.markerMethodEntry(methodId, ti, timeStamp0, timeStamp1, true);
    }

    private TimedCPUCCTNode markerMethodEntry(int methodId, ThreadInfo ti) {
        return this.markerMethodEntry(methodId, ti, 0L, 0L, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimedCPUCCTNode plainMethodEntry(int methodId, ThreadInfo ti, long timeStamp0, long timeStamp1, boolean stamped) {
        MethodCPUCCTNode methodNode;
        if (LOGGER.isLoggable(Level.FINEST) && LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "MethodEntry {0} for tId = {1}, time: {2}, delta: {3}, method:  {4}", new Object[]{!stamped ? "(unstamped)" : "", ti.threadId, timeStamp0, timeStamp0 - this.delta, this.debugMethod(methodId)});
        }
        TimedCPUCCTNode curNode = ti.peek();
        if (stamped) {
            long diff = timeStamp0 - ti.topMethodEntryTime0;
            if (diff > 0L) {
                curNode.addNetTime0(diff);
            } else {
                timeStamp0 = ti.topMethodEntryTime0;
            }
            ti.topMethodEntryTime0 = timeStamp0;
            if (this.isCollectingTwoTimeStamps()) {
                diff = timeStamp1 - ti.topMethodEntryTime1;
                if (diff > 0L) {
                    curNode.addNetTime1(diff);
                } else {
                    timeStamp1 = ti.topMethodEntryTime1;
                }
                ti.topMethodEntryTime1 = timeStamp1;
            }
        }
        if ((methodNode = MethodCPUCCTNode.Locator.locate(methodId, curNode.getChildren())) != null) {
            ti.push(methodNode);
            return methodNode;
        }
        methodNode = this.factory.createMethodNode(methodId);
        curNode.attachNodeAsChild(methodNode);
        curNode = methodNode;
        ++ti.totalNNodes;
        ti.push(curNode);
        if (!ti.isInRoot()) {
            try {
                this.methodInfoMapper.lock(false);
                String jvmClassName = this.methodInfoMapper.getInstrMethodClass(((MethodCPUCCTNode)curNode).getMethodId()).replace('.', '/');
                ProfilerClient client = this.getClient();
                if (client != null) {
                    if (!client.getSettings().getInstrumentationFilter().passesFilter(jvmClassName)) {
                        curNode.setFilteredStatus(2);
                    }
                } else {
                    curNode.setFilteredStatus(2);
                }
            }
            finally {
                this.methodInfoMapper.unlock();
            }
        }
        return curNode;
    }

    private TimedCPUCCTNode plainMethodEntry(int methodId, ThreadInfo ti, long timeStamp0, long timeStamp1) {
        return this.plainMethodEntry(methodId, ti, timeStamp0, timeStamp1, true);
    }

    private TimedCPUCCTNode plainMethodEntry(int methodId, ThreadInfo ti) {
        return this.plainMethodEntry(methodId, ti, 0L, 0L, false);
    }

    private TimedCPUCCTNode plainMethodExit(int methodId, ThreadInfo ti, long timeStamp0, long timeStamp1, boolean stamped) {
        TimedCPUCCTNode curNode;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "MethodExit{0}: {1}, time: {2}, delta: {3}, ti: {4}", new Object[]{!stamped ? "(unstamped)" : "", this.debugMethod(methodId), timeStamp0, timeStamp0 - this.delta, ti});
            this.delta = timeStamp0;
        }
        if ((curNode = ti.peek()) == null) {
            LOGGER.severe("*** Profiler engine warning: critical: stack integrity violation on method exit.\n*** methodId on simulated stack top is unidentifiable\n");
            return null;
        }
        if (!(curNode instanceof MethodCPUCCTNode)) {
            LOGGER.severe("*** Profiler engine warning: critical: stack integrity violation on method exit.\n*** methodId on simulated stack top is unidentifiable\n");
            return null;
        }
        MethodCPUCCTNode methodNode = (MethodCPUCCTNode)curNode;
        if (methodId != methodNode.getMethodId()) {
            StringBuilder message = new StringBuilder();
            message.append("*** Profiler engine warning: ").append("critical: stack integrity violation on method exit.\n");
            message.append("*** methodId on simulated stack top: ").append(methodNode.getMethodId());
            message.append(", received methodId (should match) = ").append(methodId).append('\n');
            message.append("received method debug: ").append(this.debugMethod(methodId)).append('\n');
            message.append("*** Please report this problem to feedback@profiler.netbeans.org");
            if (!this.stackIntegrityViolationReported) {
                message.append(this.dumpStack(ti));
                this.stackIntegrityViolationReported = true;
            }
            message.append('\n');
            LOGGER.severe(message.toString());
            return null;
        }
        if (stamped) {
            long diff = timeStamp0 - ti.topMethodEntryTime0;
            if (diff > 0L) {
                curNode.addNetTime0(diff);
            } else {
                timeStamp0 = ti.topMethodEntryTime0;
            }
            if (this.isCollectingTwoTimeStamps()) {
                diff = timeStamp1 - ti.topMethodEntryTime1;
                if (diff > 0L) {
                    curNode.addNetTime1(diff);
                } else {
                    timeStamp1 = ti.topMethodEntryTime1;
                }
            }
        }
        TimedCPUCCTNode oldNode = ti.pop();
        if (stamped) {
            ti.topMethodEntryTime0 = timeStamp0;
            if (this.isCollectingTwoTimeStamps()) {
                ti.topMethodEntryTime1 = timeStamp1;
            }
        }
        return oldNode;
    }

    private TimedCPUCCTNode plainMethodExit(int methodId, ThreadInfo ti, long timeStamp0, long timeStamp1) {
        return this.plainMethodExit(methodId, ti, timeStamp0, timeStamp1, true);
    }

    private TimedCPUCCTNode plainMethodExit(int methodId, ThreadInfo ti) {
        return this.plainMethodExit(methodId, ti, 0L, 0L, false);
    }

    private TimedCPUCCTNode rootMethodEntry(int methodId, ThreadInfo ti, long timeStamp0, long timeStamp1) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "RootMEntry for tId = {0}, time: {1}, method:  {2}", new Object[]{ti.threadId, timeStamp0, this.debugMethod(methodId)});
        }
        Mark mark = MarkingEngine.getDefault().markMethod(methodId, this.status);
        TimedCPUCCTNode curNode = ti.peek();
        if (ti.isInRoot()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("*** Profiler engine warning: ").append("critical: at root method entry thread stack is not at 0 - should not happen!\n");
            buffer.append("*** thread = ").append(this.threadInfos.threadNames[ti.threadId]);
            buffer.append(", ti.stackTopIdx = ").append(ti.stackTopIdx);
            if (curNode != null) {
                buffer.append(", curNode = ").append(curNode).append('\n');
            }
            buffer.append("*** Please report this problem to feedback@profiler.netbeans.org");
            LOGGER.severe(buffer.toString());
        }
        if (curNode == null) {
            TimedCPUCCTNode rootNode = this.factory.createThreadNode(ti.threadId);
            ++ti.totalNNodes;
            ti.push(rootNode);
            --ti.totalNInv;
            if (!mark.isDefault()) {
                curNode = this.factory.createCategory(mark);
                rootNode.attachNodeAsChild(curNode);
                ++ti.totalNNodes;
                ti.push(curNode);
                rootNode = curNode;
            }
            curNode = this.factory.createMethodNode(methodId);
            rootNode.attachNodeAsChild(curNode);
            ++ti.totalNNodes;
        } else {
            TimedCPUCCTNode calleeNode;
            if (!mark.isDefault()) {
                calleeNode = MarkedCPUCCTNode.Locator.locate(mark, curNode.getChildren());
                if (calleeNode == null) {
                    calleeNode = this.factory.createCategory(mark);
                    curNode.attachNodeAsChild(calleeNode);
                    ++ti.totalNNodes;
                }
                ti.push(calleeNode);
                curNode = calleeNode;
            }
            if ((calleeNode = MethodCPUCCTNode.Locator.locate(methodId, curNode.getChildren())) == null) {
                calleeNode = this.factory.createMethodNode(methodId);
                curNode.attachNodeAsChild(calleeNode);
                ++ti.totalNNodes;
            }
            curNode = calleeNode;
        }
        ti.push(curNode);
        ti.rootMethodEntryTimeAbs = timeStamp0;
        ti.rootMethodEntryTimeThreadCPU = timeStamp1;
        ti.topMethodEntryTime0 = timeStamp0;
        if (this.isCollectingTwoTimeStamps()) {
            ti.topMethodEntryTime1 = timeStamp1;
        }
        ++ti.inRoot;
        return curNode;
    }

    private TimedCPUCCTNode rootMethodExit(int methodId, ThreadInfo ti, long timeStamp0, long timeStamp1) {
        TimedCPUCCTNode curNode;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "RootMExit for tId = {0}, time: {1}, delta: {2}, method: {3}", new Object[]{ti.threadId, timeStamp0, timeStamp0 - this.delta, this.debugMethod(methodId)});
            this.delta = timeStamp0;
        }
        if ((curNode = ti.peek()) == null) {
            LOGGER.severe("*** Profiler engine warning: critical: stack integrity violation on root method exit.\n*** methodId on simulated stack top is unidentifiable\n");
            return null;
        }
        if (!(curNode instanceof MethodCPUCCTNode)) {
            LOGGER.severe("*** Profiler engine warning: critical: stack integrity violation on root method exit.\n*** methodId on simulated stack top is unidentifiable\n");
            return null;
        }
        MethodCPUCCTNode methodNode = (MethodCPUCCTNode)curNode;
        if (methodId != methodNode.getMethodId()) {
            StringBuilder message = new StringBuilder();
            message.append("*** Profiler engine warning: ").append("critical: stack integrity violation on root thod exit.\n");
            message.append("*** methodId on simulated stack top: ").append(methodNode.getMethodId()).append('\n');
            message.append(", received methodId (should match) = ").append(methodId).append('\n');
            message.append("received method debug: ").append(this.debugMethod(methodId)).append('\n');
            message.append("*** Please report this problem to feedback@profiler.netbeans.org");
            if (this.status != null && this.status.getInstrMethodClasses() != null && !this.stackIntegrityViolationReported) {
                message.append(this.dumpStack(ti));
                this.stackIntegrityViolationReported = true;
            }
            message.append('\n');
            LOGGER.severe(message.toString());
            return null;
        }
        long diff = timeStamp0 - ti.topMethodEntryTime0;
        if (diff > 0L) {
            curNode.addNetTime0(diff);
        } else {
            timeStamp0 = ti.topMethodEntryTime0;
        }
        if (this.isCollectingTwoTimeStamps()) {
            diff = timeStamp1 - ti.topMethodEntryTime1;
            if (diff > 0L) {
                curNode.addNetTime1(diff);
            } else {
                timeStamp1 = ti.topMethodEntryTime1;
            }
        }
        --ti.inRoot;
        TimedCPUCCTNode oldNode = ti.pop();
        if (ti.isInRoot()) {
            ti.topMethodEntryTime0 = timeStamp0;
            if (this.isCollectingTwoTimeStamps()) {
                ti.topMethodEntryTime1 = timeStamp1;
            }
        } else {
            ti.rootGrossTimeAbs += timeStamp0 - ti.rootMethodEntryTimeAbs;
            ti.rootGrossTimeThreadCPU += timeStamp1 - ti.rootMethodEntryTimeThreadCPU;
            ti.rootMethodEntryTimeAbs = 0L;
            ti.rootMethodEntryTimeThreadCPU = 0L;
        }
        return oldNode;
    }

    private class DebugInfoCollector
    extends RuntimeCCTNodeProcessor.PluginAdapter {
        private StringBuffer buffer = new StringBuffer();

        public StringBuffer getBuffer() {
            return this.buffer;
        }

        public synchronized String getInfo(RuntimeCPUCCTNode node) {
            this.buffer = new StringBuffer();
            RuntimeCCTNodeProcessor.process(node, this);
            return this.buffer.toString();
        }

        @Override
        public void onNode(MethodCPUCCTNode node) {
            this.buffer.append(CPUCallGraphBuilder.this.debugMethod(node.getMethodId()));
        }

        @Override
        public void onNode(ServletRequestCPUCCTNode node) {
            this.buffer.append("Boundary");
        }

        @Override
        public void onNode(ThreadCPUCCTNode node) {
            this.buffer.append("threadId = ").append(node.getThreadId());
        }

        @Override
        public void onNode(MarkedCPUCCTNode node) {
            this.buffer.append("Category ").append(node.getMark());
        }
    }
}

