/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.WindowEvent;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.JHelp;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.search.MergingSearchEngine;
import javax.help.search.SearchEngine;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.javahelp.AbstractHelp;
import org.netbeans.modules.javahelp.HelpAction;
import org.netbeans.modules.javahelp.HyperlinkEventProcessor;
import org.netbeans.modules.javahelp.Installer;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public final class JavaHelp
extends AbstractHelp
implements AWTEventListener {
    private HelpSet master = null;
    private final Map<HelpSet, Reference<JHelp>> availableJHelps = new HashMap<HelpSet, Reference<JHelp>>();
    private JFrame frameViewer = null;
    private JDialog dialogViewer = null;
    private boolean reparentToFrameLater = false;
    private Stack<Dialog> currentModalDialogs = new Stack();
    private boolean currentModalDialogsReady = false;
    private JHelp lastJH = null;
    private static final BoundedRangeModel mergeModel = new DefaultBoundedRangeModel(0, 0, 0, 0);
    private ProgressHandle progressHandle = null;
    private static final boolean isJdk15;
    private static RequestProcessor helpLoader;
    private static int modalExcludedSupported;

    public JavaHelp() {
        Installer.log.fine("JavaHelp created");
        if (!JavaHelp.isModalExcludedSupported()) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 64L);
        }
    }

    void deactivate() {
        if (!JavaHelp.isModalExcludedSupported()) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
    }

    private synchronized HelpSet getMaster() {
        if (this.master == null) {
            ClassLoader classLoader = JavaHelp.class.getClassLoader();
            try {
                this.master = new HelpSet(classLoader, new URL("nbresloc:/org/netbeans/modules/javahelp/resources/masterHelpSet.xml"));
                Collection<? extends HelpSet> collection = this.getHelpSets();
                ArrayList<HelpSet> arrayList = new ArrayList<HelpSet>(Math.min(1, collection.size()));
                for (HelpSet helpSet : collection) {
                    if (!this.shouldMerge(helpSet)) continue;
                    arrayList.add(helpSet);
                }
                mergeModel.setValue(0);
                mergeModel.setMaximum(arrayList.size());
                for (HelpSet helpSet : arrayList) {
                    this.master.add(helpSet);
                    mergeModel.setValue(mergeModel.getValue() + 1);
                }
            }
            catch (HelpSetException helpSetException) {
                Installer.log.log(Level.WARNING, null, helpSetException);
                this.master = new HelpSet();
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                throw new IllegalStateException();
            }
        }
        return this.master;
    }

    synchronized SearchEngine createSearchEngine() {
        MergingSearchEngine mergingSearchEngine = null;
        Collection<? extends HelpSet> collection = this.getHelpSets();
        for (HelpSet helpSet : collection) {
            NavigatorView navigatorView;
            if (!this.shouldMerge(helpSet) || null == (navigatorView = JavaHelp.findNavigatorView(helpSet))) continue;
            if (null == mergingSearchEngine) {
                mergingSearchEngine = new MergingSearchEngine(navigatorView);
                continue;
            }
            mergingSearchEngine.merge(navigatorView);
        }
        return mergingSearchEngine;
    }

    private static NavigatorView findNavigatorView(HelpSet helpSet) {
        for (NavigatorView navigatorView : helpSet.getNavigatorViews()) {
            if (null == navigatorView.getParameters() || navigatorView.getParameters().get("engine") == null) continue;
            return navigatorView;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void helpSetsChanged() {
        JavaHelp javaHelp = this;
        synchronized (javaHelp) {
            this.master = null;
        }
        mergeModel.setValue(0);
        mergeModel.setMaximum(0);
        super.helpSetsChanged();
    }

    private Dialog currentModalDialog() {
        if (this.currentModalDialogs.empty()) {
            Window window = HelpAction.WindowActivatedDetector.getCurrentActivatedWindow();
            if (!this.currentModalDialogsReady && window instanceof Dialog && !(window instanceof ProgressDialog) && window != this.dialogViewer && ((Dialog)window).isModal()) {
                Installer.log.fine("Early-opened modal dialog: " + window.getName() + " [" + ((Dialog)window).getTitle() + "]");
                return (Dialog)window;
            }
            return null;
        }
        return this.currentModalDialogs.peek();
    }

    private void ensureFrameViewer() {
        Installer.log.fine("ensureFrameViewer");
        if (this.frameViewer == null) {
            Installer.log.fine("\tcreating new");
            this.frameViewer = new JFrame();
            this.frameViewer.setIconImage(ImageUtilities.loadImage((String)"org/netbeans/modules/javahelp/resources/help.gif"));
            this.frameViewer.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavaHelp.class, (String)"ACSD_JavaHelp_viewer"));
            if (JavaHelp.isModalExcludedSupported()) {
                JavaHelp.setModalExcluded(this.frameViewer);
                this.frameViewer.getRootPane().putClientProperty("netbeans.helpframe", Boolean.TRUE);
            }
        }
    }

    private void ensureDialogViewer() {
        Installer.log.fine("ensureDialogViewer");
        Dialog dialog = this.currentModalDialog();
        if (this.dialogViewer != null && this.dialogViewer.getOwner() != dialog) {
            Installer.log.fine("\tdisposing old");
            this.dialogViewer.setVisible(false);
            this.dialogViewer.dispose();
            this.dialogViewer = null;
        }
        if (this.dialogViewer == null) {
            Installer.log.fine("\tcreating new");
            this.dialogViewer = new JDialog(dialog);
            this.dialogViewer.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavaHelp.class, (String)"ACSD_JavaHelp_viewer"));
        }
    }

    private void displayHelpInFrame(JHelp jHelp) {
        Installer.log.fine("displayHelpInFrame");
        if (jHelp == null) {
            jHelp = this.lastJH;
        }
        if (jHelp == null) {
            throw new IllegalStateException();
        }
        boolean bl = this.frameViewer == null;
        this.ensureFrameViewer();
        if (this.dialogViewer != null) {
            Installer.log.fine("\tdisposing old dialog");
            this.dialogViewer.setVisible(false);
            this.dialogViewer.getContentPane().removeAll();
            this.dialogViewer.dispose();
            this.dialogViewer = null;
        }
        if (this.frameViewer.getContentPane().getComponentCount() > 0 && this.frameViewer.getContentPane().getComponent(0) != jHelp) {
            Installer.log.fine("\treplacing content");
            this.frameViewer.getContentPane().removeAll();
        }
        if (this.frameViewer.getContentPane().getComponentCount() == 0) {
            Installer.log.fine("\tadding content");
            this.frameViewer.getContentPane().add((Component)jHelp, "Center");
            this.frameViewer.setTitle(jHelp.getModel().getHelpSet().getTitle());
            this.frameViewer.pack();
        }
        if (bl) {
            Rectangle rectangle = Utilities.getUsableScreenBounds();
            Dimension dimension = this.frameViewer.getSize();
            dimension.width = (int)(1.3 * (double)dimension.width);
            dimension.height = (int)(1.3 * (double)dimension.height);
            this.frameViewer.setSize(dimension);
            if (dimension.width > rectangle.width) {
                dimension.width = rectangle.width;
            }
            if (dimension.height > rectangle.height) {
                dimension.height = rectangle.height;
            }
            if (dimension.width > rectangle.width || dimension.height > rectangle.height) {
                this.frameViewer.setSize(dimension);
            }
            this.frameViewer.setLocation(new Point(rectangle.x + rectangle.width - this.frameViewer.getSize().width, rectangle.y));
        }
        this.frameViewer.setState(0);
        if (this.frameViewer.isVisible()) {
            this.frameViewer.repaint();
            this.frameViewer.toFront();
            Installer.log.fine("\talready visible, just repainting");
        } else {
            this.frameViewer.setVisible(true);
        }
        this.lastJH = jHelp;
    }

    private void displayHelpInDialog(JHelp jHelp) {
        Installer.log.fine("displayHelpInDialog");
        if (jHelp == null) {
            jHelp = this.lastJH;
        }
        if (jHelp == null) {
            throw new IllegalStateException();
        }
        this.ensureDialogViewer();
        Rectangle rectangle = null;
        if (this.frameViewer != null) {
            Installer.log.fine("\thiding old frame viewer");
            if (this.frameViewer.isVisible()) {
                rectangle = this.frameViewer.getBounds();
                this.frameViewer.setVisible(false);
            }
            this.frameViewer.getContentPane().removeAll();
        }
        if (this.dialogViewer.getContentPane().getComponentCount() > 0 && this.dialogViewer.getContentPane().getComponent(0) != jHelp) {
            Installer.log.fine("\tchanging content");
            this.dialogViewer.getContentPane().removeAll();
        }
        if (this.dialogViewer.getContentPane().getComponentCount() == 0) {
            Installer.log.fine("\tadding content");
            this.dialogViewer.getContentPane().add((Component)jHelp, "Center");
            this.dialogViewer.setTitle(jHelp.getModel().getHelpSet().getTitle());
            this.dialogViewer.pack();
        }
        if (rectangle != null) {
            Installer.log.fine("\tcopying bounds from frame viewer: " + rectangle);
            this.dialogViewer.setBounds(rectangle);
        }
        this.rearrange(this.currentModalDialog());
        if (this.dialogViewer.isVisible()) {
            Installer.log.fine("\talready visible, just repainting");
            this.dialogViewer.repaint();
        } else {
            this.dialogViewer.setVisible(true);
        }
        this.lastJH = jHelp;
    }

    public void showHelp(HelpCtx helpCtx, final boolean bl) {
        HelpCtx helpCtx2;
        HelpCtx helpCtx3 = helpCtx2 = helpCtx != null ? helpCtx : HelpCtx.DEFAULT_HELP;
        if (!SwingUtilities.isEventDispatchThread()) {
            Installer.log.fine("showHelp later...");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JavaHelp.this.showHelp(helpCtx2, bl);
                }
            });
            return;
        }
        LogRecord logRecord = new LogRecord(Level.FINE, "LOG_SHOWING_HELP");
        logRecord.setParameters(new Object[]{helpCtx2.getHelpID()});
        logRecord.setResourceBundleName("org.netbeans.modules.javahelp.Bundle");
        logRecord.setResourceBundle(NbBundle.getBundle(JavaHelp.class));
        logRecord.setLoggerName(Installer.UI.getName());
        Installer.log.log(logRecord);
        Installer.UI.log(logRecord);
        LogRecord logRecord2 = new LogRecord(Level.INFO, "USG_HELP_SHOW");
        logRecord2.setParameters(new Object[]{helpCtx2.getHelpID()});
        logRecord2.setResourceBundleName("org.netbeans.modules.javahelp.Bundle");
        logRecord2.setResourceBundle(NbBundle.getBundle(JavaHelp.class));
        logRecord2.setLoggerName(Installer.USG.getName());
        Installer.USG.log(logRecord2);
        final HelpSet[] helpSetArray = new HelpSet[1];
        Runnable runnable = new Runnable(){

            public void run() {
                String string = helpCtx2.getHelpID();
                if (bl || helpCtx2.equals((Object)HelpCtx.DEFAULT_HELP) || string == null) {
                    Installer.log.fine("getting master...");
                    helpSetArray[0] = JavaHelp.this.getMaster();
                    Installer.log.fine("getting master...done");
                }
                if (helpSetArray[0] == null || string != null && !helpSetArray[0].getCombinedMap().isValidID(string, helpSetArray[0])) {
                    Installer.log.fine("finding help set for " + string + "...");
                    helpSetArray[0] = JavaHelp.this.findHelpSetForID(string);
                    Installer.log.fine("finding help set for " + string + "...done");
                }
            }
        };
        if (this.master == null) {
            Installer.log.fine("showing progress dialog...");
            this.progressHandle = ProgressHandleFactory.createHandle((String)"");
            this.createProgressDialog(runnable, this.currentModalDialog()).setVisible(true);
            this.progressHandle.finish();
            Installer.log.fine("dialog done.");
        } else {
            runnable.run();
        }
        HelpSet helpSet = helpSetArray[0];
        if (helpSet == null) {
            return;
        }
        JHelp jHelp = this.createAndDisplayJHelp(helpSet);
        if (jHelp == null) {
            return;
        }
        this.displayInJHelp(jHelp, helpCtx2.getHelpID(), helpCtx2.getHelp());
    }

    void showHelp(URL uRL) {
        JHelp jHelp = this.createAndDisplayJHelp(this.getMaster());
        if (jHelp == null) {
            return;
        }
        this.displayInJHelp(jHelp, null, uRL);
    }

    private JHelp createAndDisplayJHelp(HelpSet helpSet) {
        JHelp jHelp = this.createJHelp(helpSet);
        if (jHelp == null) {
            return null;
        }
        if (JavaHelp.isModalExcludedSupported()) {
            this.displayHelpInFrame(jHelp);
        } else if (this.currentModalDialog() == null) {
            Installer.log.fine("showing as non-dialog");
            this.displayHelpInFrame(jHelp);
        } else {
            Installer.log.fine("showing as dialog");
            this.displayHelpInDialog(jHelp);
        }
        return jHelp;
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        WindowEvent windowEvent = (WindowEvent)aWTEvent;
        int n = windowEvent.getID();
        Window window = windowEvent.getWindow();
        if (n == 201 && window == this.dialogViewer) {
            Installer.log.fine("7. Dialog viewer open. Viewer closed. rTFL = false.");
            this.reparentToFrameLater = false;
        }
        if (n != 202 && n != 200) {
            return;
        }
        if (window instanceof Dialog) {
            Dialog dialog = (Dialog)window;
            String string = dialog.getClass().getName();
            if (dialog.isModal() && !(dialog instanceof ProgressDialog) || dialog == this.dialogViewer) {
                if ("sun.awt.windows.WPageDialog".equals(string) || "sun.awt.windows.WPrintDialog".equals(string) || "sun.print.ServiceDialog".equals(string) || "apple.awt.CPrinterJobDialog".equals(string) || "apple.awt.CPrinterPageDialog".equals(string)) {
                    return;
                }
                if (dialog instanceof JDialog && "true".equals(((JDialog)dialog).getRootPane().getClientProperty("javahelp.ignore.modality"))) {
                    return;
                }
                if (Installer.log.isLoggable(Level.FINE)) {
                    Installer.log.fine("modal (or viewer) dialog event: " + windowEvent + " [" + dialog.getTitle() + "]");
                }
                if (n == 202) {
                    if (dialog != this.dialogViewer) {
                        if (dialog == this.currentModalDialog()) {
                            if (!this.currentModalDialogs.isEmpty()) {
                                this.currentModalDialogs.pop();
                                this.currentModalDialogsReady = true;
                            } else {
                                Installer.log.log(Level.WARNING, null, new IllegalStateException("Please see IZ #24993"));
                            }
                            this.showDialogStack();
                            if (!(this.frameViewer != null && this.frameViewer.isVisible() && this.frameViewer.getState() != 1 || this.dialogViewer != null && this.dialogViewer.isVisible())) {
                                if (!this.reparentToFrameLater) {
                                    Installer.log.fine("2. No viewer open, !rTFL. Top dialog closed. Pop it.");
                                } else if (this.currentModalDialog() == null) {
                                    Installer.log.fine("3. No viewer open, rTFL. Only top dialog closed. Pop it. Create frame viewer.");
                                    if (this.frameViewer != null) {
                                        this.frameViewer.dispose();
                                        this.frameViewer = null;
                                    }
                                    this.displayHelpInFrame(null);
                                } else {
                                    Installer.log.fine("4. No viewer open, rTFL. Some top dialog closed. Pop it. Create dialog viewer.");
                                    this.displayHelpInDialog(null);
                                }
                            } else if (this.dialogViewer != null && this.dialogViewer.isVisible()) {
                                Installer.log.warning("dialogViewer should not still be open");
                            } else {
                                Installer.log.warning("frameViewer visible when a dialog was closing");
                            }
                        } else {
                            Installer.log.fine("some random modal dialog closed: " + dialog.getName() + " [" + dialog.getTitle() + "]");
                        }
                    }
                } else if (dialog != this.dialogViewer) {
                    this.currentModalDialogs.push(dialog);
                    this.showDialogStack();
                    if (!(this.frameViewer != null && this.frameViewer.isVisible() && this.frameViewer.getState() != 1 || this.dialogViewer != null && this.dialogViewer.isVisible())) {
                        Installer.log.fine("1. No viewer open. Dialog opened. Push it on stack. rTFL = false.");
                        this.reparentToFrameLater = false;
                    } else if (this.frameViewer != null && this.frameViewer.isVisible()) {
                        Installer.log.fine("5. Frame viewer open. Dialog opened. Push it. Close frame viewer. Create dialog viewer. rTFL = true.");
                        this.displayHelpInDialog(null);
                        this.reparentToFrameLater = true;
                    } else if (this.dialogViewer != null && this.dialogViewer.isVisible()) {
                        Installer.log.fine("6. Dialog viewer open. Dialog opened. Push it. Reparent dialog viewer.");
                        this.displayHelpInDialog(null);
                    } else {
                        Installer.log.warning("logic error");
                    }
                }
            }
        }
    }

    private void showDialogStack() {
        if (Installer.log.isLoggable(Level.FINE)) {
            StringBuffer stringBuffer = new StringBuffer("new modal dialog stack: [");
            boolean bl = true;
            Iterator iterator = this.currentModalDialogs.iterator();
            while (iterator.hasNext()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(((Dialog)iterator.next()).getTitle());
            }
            stringBuffer.append("]");
            Installer.log.fine(stringBuffer.toString());
        }
    }

    private void rearrange(Dialog dialog) {
        Rectangle rectangle;
        Rectangle rectangle2 = dialog.getBounds();
        if (rectangle2.intersects(rectangle = this.dialogViewer.getBounds())) {
            Installer.log.fine("modal dialog and dialog viewer overlap");
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = dimension.width - rectangle2.width - rectangle.width;
            int n2 = dimension.height - rectangle2.height - rectangle.height;
            if (n >= n2) {
                int n3 = rectangle2.x + rectangle2.width / 2;
                int n4 = rectangle.x + rectangle.width / 2;
                if (n3 <= n4) {
                    Installer.log.fine(" send help to the right");
                    if (rectangle2.x + rectangle2.width + rectangle.width <= dimension.width) {
                        Installer.log.fine("there is enough place fo help");
                        rectangle.x = rectangle2.x + rectangle2.width;
                    } else {
                        Installer.log.fine("there is not enough place");
                        if (rectangle2.width + rectangle.width < dimension.width) {
                            Installer.log.fine("relocate both");
                            rectangle.x = dimension.width - rectangle.width;
                            rectangle2.x = rectangle.x - rectangle2.width;
                        } else {
                            Installer.log.fine("relocate both and resize help");
                            rectangle2.x = 0;
                            rectangle.x = rectangle2.width;
                            rectangle.width = dimension.width - rectangle2.width;
                        }
                    }
                } else {
                    Installer.log.fine("send help to the left");
                    if (rectangle2.x - rectangle.width > 0) {
                        Installer.log.fine("there is enough place for help");
                        rectangle.x = rectangle2.x - rectangle.width;
                    } else {
                        Installer.log.fine("there is not enough place");
                        if (rectangle2.width + rectangle.width < dimension.width) {
                            Installer.log.fine("relocate both");
                            rectangle.x = 0;
                            rectangle2.x = rectangle.width;
                        } else {
                            Installer.log.fine("relocate both and resize help");
                            rectangle2.x = dimension.width - rectangle2.width;
                            rectangle.x = 0;
                            rectangle.width = rectangle2.x;
                        }
                    }
                }
            } else {
                int n5 = rectangle2.y + rectangle2.height / 2;
                int n6 = rectangle.y + rectangle.height / 2;
                if (n5 <= n6) {
                    Installer.log.fine(" send help to the bottom");
                    if (rectangle2.y + rectangle2.height + rectangle.height <= dimension.height) {
                        Installer.log.fine("there is enough place fo help");
                        rectangle.y = rectangle2.y + rectangle2.height;
                    } else {
                        Installer.log.fine("there is not enough place");
                        if (rectangle2.height + rectangle.height < dimension.height) {
                            Installer.log.fine("relocate both");
                            rectangle.y = dimension.height - rectangle.height;
                            rectangle2.y = rectangle.y - rectangle2.height;
                        } else {
                            Installer.log.fine("relocate both and resize help");
                            rectangle2.y = 0;
                            rectangle.y = rectangle2.height;
                            rectangle.height = dimension.height - rectangle2.height;
                        }
                    }
                } else {
                    Installer.log.fine("send help to the top");
                    if (rectangle2.y - rectangle.height > 0) {
                        Installer.log.fine("there is enough place for help");
                        rectangle.y = rectangle2.y - rectangle.height;
                    } else {
                        Installer.log.fine("there is not enough place");
                        if (rectangle2.height + rectangle.height < dimension.height) {
                            Installer.log.fine("relocate both");
                            rectangle.y = 0;
                            rectangle2.y = rectangle.height;
                        } else {
                            Installer.log.fine("relocate both and resize help");
                            rectangle2.y = dimension.height - rectangle2.height;
                            rectangle.y = 0;
                            rectangle.height = rectangle2.y;
                        }
                    }
                }
            }
            dialog.setBounds(rectangle2);
            this.dialogViewer.setBounds(rectangle);
        }
    }

    private JDialog createProgressDialog(Runnable runnable, Dialog dialog) {
        return dialog == null ? new ProgressDialog(runnable, WindowManager.getDefault().getMainWindow()) : new ProgressDialog(runnable, dialog);
    }

    private static RequestProcessor getHelpLoader() {
        if (helpLoader == null) {
            helpLoader = new RequestProcessor("org.netbeans.modules.javahelp.JavaHelp");
        }
        return helpLoader;
    }

    private HelpSet findHelpSetForID(String string) {
        if (string != null) {
            for (HelpSet helpSet : this.getHelpSets()) {
                if (!helpSet.getCombinedMap().isValidID(string, helpSet)) continue;
                return helpSet;
            }
            JavaHelp.warnBadID(string);
        }
        return this.getMaster();
    }

    public Boolean isValidID(String string, boolean bl) {
        if (bl || this.helpSetsReady()) {
            Iterator<? extends HelpSet> iterator = this.getHelpSets().iterator();
            if ("org.netbeans.api.javahelp.MASTER_ID".equals(string)) {
                if (iterator.hasNext()) {
                    Installer.log.fine("master id, and >=1 help set");
                    return Boolean.TRUE;
                }
                Installer.log.fine("master id, and 0 help sets");
                return Boolean.FALSE;
            }
            while (iterator.hasNext()) {
                HelpSet helpSet = iterator.next();
                if (!helpSet.getCombinedMap().isValidID(string, helpSet)) continue;
                Installer.log.fine("found normal valid id " + string + " in " + helpSet.getTitle());
                return Boolean.TRUE;
            }
            Installer.log.fine("did not find id " + string);
            return Boolean.FALSE;
        }
        Installer.log.fine("not checking " + string + " specifically");
        return null;
    }

    private static void warnBadID(String string) {
        Installer.log.fine(NbBundle.getMessage(JavaHelp.class, (String)"MSG_jh_id_not_found", (Object)string));
    }

    private synchronized void displayInJHelp(JHelp jHelp, String string, URL uRL) {
        if (jHelp == null) {
            throw new NullPointerException();
        }
        if (jHelp.getModel() == null) {
            throw new IllegalArgumentException();
        }
        Installer.log.fine("displayInJHelp: " + string + " " + uRL);
        try {
            if (string != null && !string.equals("org.netbeans.api.javahelp.MASTER_ID")) {
                HelpSet helpSet = jHelp.getModel().getHelpSet();
                if (helpSet.getCombinedMap().isValidID(string, helpSet)) {
                    jHelp.setCurrentID(string);
                } else {
                    JavaHelp.warnBadID(string);
                }
            } else if (uRL != null) {
                jHelp.setCurrentURL(uRL);
            }
        }
        catch (RuntimeException runtimeException) {
            Installer.log.log(Level.WARNING, null, runtimeException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JHelp createJHelp(HelpSet helpSet) {
        JHelp jHelp;
        Object object;
        if (helpSet == null) {
            throw new NullPointerException();
        }
        Object object2 = this.availableJHelps;
        synchronized (object2) {
            object = this.availableJHelps.get(helpSet);
            if (object != null && (jHelp = ((Reference)object).get()) != null) {
                return jHelp;
            }
        }
        object2 = null;
        try {
            object2 = helpSet.getTitle();
            jHelp = new JHelp(helpSet);
            this.adjust(jHelp);
        }
        catch (RuntimeException runtimeException) {
            Installer.log.log(Level.WARNING, "While trying to display: " + (String)object2, runtimeException);
            return null;
        }
        object = this.availableJHelps;
        synchronized (object) {
            this.availableJHelps.put(helpSet, new SoftReference<JHelp>(jHelp));
        }
        try {
            object = helpSet.getHomeID();
            if (object != null) {
                jHelp.setCurrentID((Map.ID)object);
            }
        }
        catch (Exception exception) {
            Installer.log.log(Level.WARNING, null, exception);
        }
        return jHelp;
    }

    private void adjust(JHelp jHelp) {
        JEditorPane jEditorPane = (JEditorPane)this.getContentViewer(jHelp);
        if (jEditorPane == null) {
            Installer.log.severe("Unable to find a JavaHelp Content Viewer component.");
            Installer.log.severe("JavaHelp loaded from: " + JavaHelp.getCodeLocation(jHelp.getClass()));
            Installer.log.severe("Current thread: " + Thread.currentThread().toString());
            return;
        }
        this.adjustFontSize(jEditorPane);
        HyperlinkEventProcessor.addTo(jEditorPane);
    }

    private static String getCodeLocation(Class clazz) {
        String string = "unknown code location";
        try {
            string = clazz.getProtectionDomain().getCodeSource().getLocation().toString();
        }
        catch (Exception exception) {
            Installer.log.log(Level.SEVERE, "unknown code location", exception);
        }
        return string;
    }

    private void adjustFontSize(JEditorPane jEditorPane) {
        if (jEditorPane != null) {
            jEditorPane.putClientProperty("JEditorPane.w3cLengthUnits", Boolean.TRUE);
            jEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        }
    }

    Component getContentViewer(Component component) {
        if (JavaHelp.isContentViewer(component)) {
            return component;
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                component = this.getContentViewer(componentArray[i]);
                if (!JavaHelp.isContentViewer(component)) continue;
                return component;
            }
        }
        return null;
    }

    static boolean isContentViewer(Component component) {
        return component instanceof JEditorPane;
    }

    private static boolean isModalExcludedSupported() {
        if (modalExcludedSupported == -1) {
            modalExcludedSupported = 0;
            if (isJdk15) {
                try {
                    Class<?> clazz = Class.forName("sun.awt.SunToolkit");
                    Method method = clazz.getMethod("isModalExcludedSupported", new Class[0]);
                    Boolean bl = (Boolean)method.invoke(null, new Object[0]);
                    modalExcludedSupported = bl != false ? 1 : 0;
                    Installer.log.fine("isModalExcludedSupported = " + modalExcludedSupported);
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    Installer.log.info("isModalExcludedSupported() failed  " + throwable);
                }
            } else {
                Class<?> clazz = null;
                try {
                    clazz = Class.forName("java.awt.Dialog$ModalExclusionType");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Installer.log.info("Cannot get class java.awt.Dialog$ModalExclusionType " + classNotFoundException);
                    return false;
                }
                Method method = null;
                try {
                    method = Toolkit.class.getMethod("isModalExclusionTypeSupported", clazz);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Installer.log.info("Cannot get method isModalExcludedSupported " + noSuchMethodException);
                    return false;
                }
                Method method2 = null;
                try {
                    method2 = clazz.getMethod("valueOf", String.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Installer.log.info("Cannot get method valueOf " + noSuchMethodException);
                    return false;
                }
                Object object = null;
                try {
                    object = method2.invoke(null, "APPLICATION_EXCLUDE");
                }
                catch (IllegalAccessException illegalAccessException) {
                    Installer.log.info("Cannot invoke method valueOf " + illegalAccessException);
                    return false;
                }
                catch (InvocationTargetException invocationTargetException) {
                    Installer.log.info("Cannot invoke method valueOf " + invocationTargetException);
                    return false;
                }
                try {
                    Boolean bl = (Boolean)method.invoke((Object)Toolkit.getDefaultToolkit(), object);
                    modalExcludedSupported = bl != false ? 1 : 0;
                    Installer.log.fine("isModalExcludedSupported = " + modalExcludedSupported);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Installer.log.info("Cannot invoke method isModalExcludedSupported " + illegalAccessException);
                    return false;
                }
                catch (InvocationTargetException invocationTargetException) {
                    Installer.log.info("Cannot invoke method isModalExcludedSupported " + invocationTargetException);
                    return false;
                }
            }
        }
        return modalExcludedSupported == 1;
    }

    private static void setModalExcluded(Window window) {
        if (modalExcludedSupported == 0) {
            return;
        }
        if (isJdk15) {
            try {
                Class<?> clazz = Class.forName("sun.awt.SunToolkit");
                Method method = clazz.getMethod("setModalExcluded", Window.class);
                method.invoke(null, window);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                Installer.log.info("setModalExcluded(Window) failed  " + throwable);
                modalExcludedSupported = 0;
            }
        } else {
            Class<?> clazz = null;
            try {
                clazz = Class.forName("java.awt.Dialog$ModalExclusionType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                Installer.log.info("Cannot get class java.awt.Dialog$ModalExclusionType " + classNotFoundException);
                modalExcludedSupported = 0;
                return;
            }
            Method method = null;
            try {
                method = clazz.getMethod("valueOf", String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Installer.log.info("Cannot get method valueOf(String) " + noSuchMethodException);
                modalExcludedSupported = 0;
                return;
            }
            Object object = null;
            try {
                object = method.invoke(null, "APPLICATION_EXCLUDE");
            }
            catch (IllegalAccessException illegalAccessException) {
                Installer.log.info("Cannot invoke method valueOf(String) " + illegalAccessException);
                modalExcludedSupported = 0;
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
                Installer.log.info("Cannot invoke method valueOf(String) " + invocationTargetException);
                modalExcludedSupported = 0;
                return;
            }
            Method method2 = null;
            try {
                method2 = Window.class.getMethod("setModalExclusionType", clazz);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Installer.log.info("Cannot get method setModalExclusionType " + noSuchMethodException);
                modalExcludedSupported = 0;
                return;
            }
            try {
                method2.invoke((Object)window, object);
            }
            catch (IllegalAccessException illegalAccessException) {
                Installer.log.info("Cannot invoke method setModalExclusionType " + illegalAccessException);
                modalExcludedSupported = 0;
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
                Installer.log.info("Cannot invoke method setModalExclusionType " + invocationTargetException);
                modalExcludedSupported = 0;
                return;
            }
        }
    }

    static {
        String string = System.getProperty("java.version");
        isJdk15 = string.startsWith("1.5");
        helpLoader = null;
        modalExcludedSupported = -1;
    }

    private final class ProgressDialog
    extends JDialog
    implements TaskListener,
    Runnable {
        private Runnable run;

        public ProgressDialog(Runnable runnable, Dialog dialog) {
            super(dialog, NbBundle.getMessage(JavaHelp.class, (String)"TITLE_loading_help_sets"), true);
            this.init(runnable);
        }

        public ProgressDialog(Runnable runnable, Frame frame) {
            super(frame, NbBundle.getMessage(JavaHelp.class, (String)"TITLE_loading_help_sets"), true);
            this.init(runnable);
        }

        private void init(Runnable runnable) {
            this.run = runnable;
            JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)JavaHelp.this.progressHandle);
            jComponent.setPreferredSize(new Dimension(3 * jComponent.getPreferredSize().width, 3 * jComponent.getPreferredSize().height));
            jComponent.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.getContentPane().add(jComponent);
            JavaHelp.this.progressHandle.start();
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavaHelp.class, (String)"ACSD_Loading_Dialog"));
            this.pack();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = this.getSize();
            this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        }

        public void setVisible(boolean bl) {
            if (bl && this.run != null) {
                Installer.log.fine("posting request from progress dialog...");
                JavaHelp.getHelpLoader().post(this.run).addTaskListener((TaskListener)this);
                this.run = null;
            }
            super.setVisible(bl);
        }

        public void taskFinished(Task task) {
            Installer.log.fine("posting request from progress dialog...request finished.");
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            this.setVisible(false);
            this.dispose();
        }
    }
}

