/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManagerListener;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Lookup;
import org.netbeans.spi.debugger.ActionsProvider;
import org.netbeans.spi.debugger.ActionsProviderListener;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

public final class ActionsManager {
    public static final Object ACTION_STEP_OVER = "stepOver";
    public static final Object ACTION_RUN_INTO_METHOD = "runIntoMethod";
    public static final Object ACTION_STEP_INTO = "stepInto";
    public static final Object ACTION_STEP_OUT = "stepOut";
    public static final Object ACTION_STEP_OPERATION = "stepOperation";
    public static final Object ACTION_CONTINUE = "continue";
    public static final Object ACTION_START = "start";
    public static final Object ACTION_KILL = "kill";
    public static final Object ACTION_MAKE_CALLER_CURRENT = "makeCallerCurrent";
    public static final Object ACTION_MAKE_CALLEE_CURRENT = "makeCalleeCurrent";
    public static final Object ACTION_PAUSE = "pause";
    public static final Object ACTION_RUN_TO_CURSOR = "runToCursor";
    public static final Object ACTION_POP_TOPMOST_CALL = "popTopmostCall";
    public static final Object ACTION_FIX = "fix";
    public static final Object ACTION_RESTART = "restart";
    public static final Object ACTION_TOGGLE_BREAKPOINT = "toggleBreakpoint";
    public static final Object ACTION_NEW_WATCH = "newWatch";
    public static final Object ACTION_EVALUATE = "evaluate";
    private final Vector<ActionsManagerListener> listener = new Vector();
    private final HashMap<String, List<ActionsManagerListener>> listeners = new HashMap();
    private HashMap<Object, ArrayList<ActionsProvider>> actionProviders;
    private final Object actionProvidersLock = new Object();
    private final AtomicBoolean actionProvidersInitialized = new AtomicBoolean(false);
    private MyActionListener actionListener = new MyActionListener();
    private Lookup lookup;
    private boolean doiingDo = false;
    private boolean destroy = false;
    private List<? extends ActionsProvider> aps;
    private boolean listerersLoaded = false;
    private List lazyListeners;

    ActionsManager(Lookup lookup) {
        this.lookup = lookup;
    }

    public final void doAction(Object action) {
        this.doiingDo = true;
        ArrayList<ActionsProvider> l = this.getActionProvidersForActionWithInit(action);
        boolean done = false;
        if (l != null) {
            int k = l.size();
            for (int i = 0; i < k; ++i) {
                ActionsProvider ap = l.get(i);
                if (!ap.isEnabled(action)) continue;
                done = true;
                ap.doAction(action);
            }
        }
        if (done) {
            this.fireActionDone(action);
        }
        this.doiingDo = false;
        if (this.destroy) {
            this.destroyIn();
        }
    }

    public final Task postAction(final Object action) {
        this.doiingDo = true;
        ArrayList<ActionsProvider> l = this.getActionProvidersForActionWithInit(action);
        boolean posted = false;
        int k = l != null ? l.size() : 0;
        ArrayList<ActionsProvider> postedActions = new ArrayList<ActionsProvider>(k);
        final AsynchActionTask task = new AsynchActionTask(postedActions);
        if (l != null) {
            int i;
            for (i = 0; i < k; ++i) {
                ActionsProvider ap = l.get(i);
                if (!ap.isEnabled(action)) continue;
                postedActions.add(ap);
                posted = true;
            }
            if (posted) {
                final int[] count = new int[]{0};
                Runnable notifier = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        int[] nArray = count;
                        synchronized (count) {
                            count[0] = count[0] - 1;
                            if (count[0] == 0) {
                                task.actionDone();
                                ActionsManager.this.fireActionDone(action);
                                ActionsManager.this.doiingDo = false;
                                if (ActionsManager.this.destroy) {
                                    ActionsManager.this.destroyIn();
                                }
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                };
                count[0] = k = postedActions.size();
                for (i = 0; i < k; ++i) {
                    ((ActionsProvider)postedActions.get(i)).postAction(action, notifier);
                }
            }
        }
        if (!posted) {
            this.doiingDo = false;
            if (this.destroy) {
                this.destroyIn();
            }
            task.actionDone();
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isEnabled(Object action) {
        ArrayList<ActionsProvider> l;
        boolean doInit = false;
        Object object = this.actionProvidersLock;
        synchronized (object) {
            if (this.actionProviders == null) {
                this.actionProviders = new HashMap();
                doInit = true;
            }
        }
        if (doInit) {
            if (SwingUtilities.isEventDispatchThread()) {
                new RequestProcessor(ActionsManager.class).post(new Runnable(){

                    @Override
                    public void run() {
                        ActionsManager.this.initActionImpls();
                    }
                });
            } else {
                this.initActionImpls();
            }
        }
        if ((l = this.getActionProvidersForAction(action)) != null) {
            int k = l.size();
            for (int i = 0; i < k; ++i) {
                ActionsProvider ap = l.get(i);
                if (!ap.isEnabled(action)) continue;
                return true;
            }
        }
        return false;
    }

    public void destroy() {
        if (!this.doiingDo) {
            this.destroyIn();
        }
        this.destroy = true;
    }

    public void addActionsManagerListener(ActionsManagerListener l) {
        this.listener.addElement(l);
    }

    public void removeActionsManagerListener(ActionsManagerListener l) {
        this.listener.removeElement(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionsManagerListener(String propertyName, ActionsManagerListener l) {
        HashMap<String, List<ActionsManagerListener>> hashMap = this.listeners;
        synchronized (hashMap) {
            List<ActionsManagerListener> ls = this.listeners.get(propertyName);
            if (ls == null) {
                ls = new ArrayList<ActionsManagerListener>();
                this.listeners.put(propertyName, ls);
            }
            ls.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionsManagerListener(String propertyName, ActionsManagerListener l) {
        HashMap<String, List<ActionsManagerListener>> hashMap = this.listeners;
        synchronized (hashMap) {
            List<ActionsManagerListener> ls = this.listeners.get(propertyName);
            if (ls == null) {
                return;
            }
            ls.remove(l);
            if (ls.isEmpty()) {
                this.listeners.remove(propertyName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActionDone(Object action) {
        int i;
        List<ActionsManagerListener> l1;
        this.initListeners();
        ArrayList<ActionsManagerListener> l = new ArrayList<ActionsManagerListener>(this.listener);
        HashMap<String, List<ActionsManagerListener>> hashMap = this.listeners;
        synchronized (hashMap) {
            l1 = this.listeners.get("actionPerformed");
            if (l1 != null) {
                l1 = new ArrayList<ActionsManagerListener>(l1);
            }
        }
        int k = l.size();
        for (i = 0; i < k; ++i) {
            ((ActionsManagerListener)l.get(i)).actionPerformed(action);
        }
        if (l1 != null) {
            k = l1.size();
            for (i = 0; i < k; ++i) {
                l1.get(i).actionPerformed(action);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActionStateChanged(Object action) {
        int i;
        List<ActionsManagerListener> l1;
        boolean enabled = this.isEnabled(action);
        this.initListeners();
        ArrayList<ActionsManagerListener> l = new ArrayList<ActionsManagerListener>(this.listener);
        HashMap<String, List<ActionsManagerListener>> hashMap = this.listeners;
        synchronized (hashMap) {
            l1 = this.listeners.get("actionStateChanged");
            if (l1 != null) {
                l1 = new ArrayList<ActionsManagerListener>(l1);
            }
        }
        int k = l.size();
        for (i = 0; i < k; ++i) {
            ((ActionsManagerListener)l.get(i)).actionStateChanged(action, enabled);
        }
        if (l1 != null) {
            k = l1.size();
            for (i = 0; i < k; ++i) {
                l1.get(i).actionStateChanged(action, enabled);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<ActionsProvider> getActionProvidersForAction(Object action) {
        ArrayList l;
        Object object = this.actionProvidersLock;
        synchronized (object) {
            l = this.actionProviders.get(action);
            if (l != null) {
                l = (ArrayList)l.clone();
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<ActionsProvider> getActionProvidersForActionWithInit(Object action) {
        boolean doInit = false;
        Object object = this.actionProvidersLock;
        synchronized (object) {
            if (this.actionProviders == null) {
                this.actionProviders = new HashMap();
                doInit = true;
            }
        }
        if (doInit) {
            this.initActionImpls();
        } else if (!this.actionProvidersInitialized.get()) {
            object = this.actionProvidersInitialized;
            synchronized (object) {
                if (!this.actionProvidersInitialized.get()) {
                    try {
                        this.actionProvidersInitialized.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
            }
        }
        return this.getActionProvidersForAction(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerActionsProvider(Object action, ActionsProvider p) {
        Object object = this.actionProvidersLock;
        synchronized (object) {
            ArrayList<ActionsProvider> l = this.actionProviders.get(action);
            if (l == null) {
                l = new ArrayList();
                this.actionProviders.put(action, l);
            }
            l.add(p);
        }
        p.addActionsProviderListener(this.actionListener);
        this.fireActionStateChanged(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerActionsProviders(List<? extends ActionsProvider> aps) {
        List<? extends ActionsProvider> list = aps;
        synchronized (list) {
            for (ActionsProvider actionsProvider : aps) {
                Iterator ii = actionsProvider.getActions().iterator();
                while (ii.hasNext()) {
                    this.registerActionsProvider(ii.next(), actionsProvider);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initActionImpls() {
        this.aps = this.lookup.lookup(null, ActionsProvider.class);
        ((Customizer)((Object)this.aps)).addPropertyChangeListener(new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object object = ActionsManager.this.actionProvidersLock;
                synchronized (object) {
                    ActionsManager.this.actionProviders.clear();
                }
                ActionsManager.this.registerActionsProviders(ActionsManager.this.aps);
            }
        });
        this.registerActionsProviders(this.aps);
        AtomicBoolean atomicBoolean = this.actionProvidersInitialized;
        synchronized (atomicBoolean) {
            this.actionProvidersInitialized.set(true);
            this.actionProvidersInitialized.notifyAll();
        }
    }

    private synchronized void initListeners() {
        if (this.listerersLoaded) {
            return;
        }
        this.listerersLoaded = true;
        this.lazyListeners = this.lookup.lookup(null, LazyActionsManagerListener.class);
        int k = this.lazyListeners.size();
        for (int i = 0; i < k; ++i) {
            LazyActionsManagerListener l = (LazyActionsManagerListener)this.lazyListeners.get(i);
            if (l == null) continue;
            String[] props = l.getProperties();
            if (props == null) {
                this.addActionsManagerListener(l);
                continue;
            }
            int jj = props.length;
            for (int j = 0; j < jj; ++j) {
                this.addActionsManagerListener(props[j], l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyIn() {
        Object object = this;
        synchronized (object) {
            if (this.lazyListeners != null) {
                int k = this.lazyListeners.size();
                for (int i = 0; i < k; ++i) {
                    LazyActionsManagerListener l = (LazyActionsManagerListener)this.lazyListeners.get(i);
                    if (l == null) continue;
                    String[] props = l.getProperties();
                    if (props == null) {
                        this.removeActionsManagerListener(l);
                        continue;
                    }
                    int jj = props.length;
                    for (int j = 0; j < jj; ++j) {
                        this.removeActionsManagerListener(props[j], l);
                    }
                    l.destroy();
                }
                this.lazyListeners = new ArrayList();
            }
        }
        object = this.actionProvidersLock;
        synchronized (object) {
            Collection<ArrayList<ActionsProvider>> apsc = this.actionProviders.values();
            for (ArrayList<ActionsProvider> aps : apsc) {
                for (ActionsProvider ap : aps) {
                    ap.removeActionsProviderListener(this.actionListener);
                }
            }
        }
    }

    private static class AsynchActionTask
    extends Task
    implements Cancellable {
        private Collection postedActions;

        public AsynchActionTask(Collection postedActions) {
            this.postedActions = postedActions;
        }

        void actionDone() {
            this.notifyFinished();
        }

        public boolean cancel() {
            for (Object action : this.postedActions) {
                if (action instanceof Cancellable) {
                    if (((Cancellable)action).cancel()) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
    }

    class MyActionListener
    implements ActionsProviderListener {
        MyActionListener() {
        }

        @Override
        public void actionStateChange(Object action, boolean enabled) {
            ActionsManager.this.fireActionStateChanged(action);
        }
    }
}

