/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.coredump.impl;

import com.sun.tools.visualvm.coredump.CoreDumpSupport;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

class CoreDumpConfigurator
extends JPanel {
    private boolean internalChange = false;
    private static CoreDumpConfigurator defaultInstance;
    private JLabel coreDumpFileLabel;
    private JTextField coreDumpFileField;
    private JButton coreDumpFileButton;
    private JLabel javaHomeFileLabel;
    private JTextField javaHomeFileField;
    private JButton javaHomeFileButton;
    private JCheckBox displaynameCheckbox;
    private JTextField displaynameField;
    private JCheckBox deleteSourceCheckbox;
    private JButton okButton;

    public static CoreDumpConfigurator defineCoreDump() {
        CoreDumpConfigurator hc = CoreDumpConfigurator.getDefault();
        hc.setupDefineCoreDump();
        DialogDescriptor dd = new DialogDescriptor((Object)hc, NbBundle.getMessage(CoreDumpConfigurator.class, (String)"Title_Add_VM_Coredump"), true, new Object[]{hc.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)hc.okButton, 0, null, null);
        Dialog d = ProfilerDialogs.createDialog((DialogDescriptor)dd);
        d.pack();
        d.setVisible(true);
        if (dd.getValue() == hc.okButton) {
            return hc;
        }
        return null;
    }

    public String getCoreDumpFile() {
        return this.coreDumpFileField.getText().trim();
    }

    public String getDisplayname() {
        return this.displaynameField.getText().trim();
    }

    public String getJavaHome() {
        return this.javaHomeFileField.getText().trim();
    }

    public boolean deleteSourceFile() {
        return this.deleteSourceCheckbox.isSelected();
    }

    private CoreDumpConfigurator() {
        this.initComponents();
        this.update();
    }

    private static CoreDumpConfigurator getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new CoreDumpConfigurator();
        }
        return defaultInstance;
    }

    private void setupDefineCoreDump() {
        this.coreDumpFileField.setEnabled(true);
        this.displaynameCheckbox.setSelected(false);
        this.displaynameCheckbox.setEnabled(true);
        this.coreDumpFileField.setText("");
        this.displaynameField.setText("");
        this.javaHomeFileField.setText(CoreDumpSupport.getCurrentJDKHome());
        this.javaHomeFileField.setEnabled(true);
        this.deleteSourceCheckbox.setSelected(false);
    }

    private void update() {
        if (this.internalChange) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String coreDumpname = CoreDumpConfigurator.this.getCoreDumpFile();
                File coreDumpFile = new File(coreDumpname);
                String jdkHome = CoreDumpConfigurator.this.getJavaHome();
                File jdkHomeFile = new File(jdkHome);
                if (!CoreDumpConfigurator.this.displaynameCheckbox.isSelected()) {
                    CoreDumpConfigurator.this.internalChange = true;
                    File file = new File(coreDumpname);
                    if (file.isFile()) {
                        CoreDumpConfigurator.this.displaynameField.setText(file.getName());
                    }
                    CoreDumpConfigurator.this.internalChange = false;
                }
                String displayname = CoreDumpConfigurator.this.getDisplayname();
                CoreDumpConfigurator.this.displaynameField.setEnabled(CoreDumpConfigurator.this.displaynameCheckbox.isSelected());
                CoreDumpConfigurator.this.okButton.setEnabled(coreDumpFile.exists() && coreDumpFile.isFile() && jdkHomeFile.exists() && jdkHomeFile.isDirectory() && displayname.length() > 0);
            }
        });
    }

    private void chooseJavaHome() {
        JFileChooser chooser = new JFileChooser(new File(this.getJavaHome()));
        chooser.setDialogTitle(NbBundle.getMessage(CoreDumpConfigurator.class, (String)"LBL_Select_JDK_Home"));
        chooser.setFileSelectionMode(1);
        int returnVal = chooser.showOpenDialog(WindowManager.getDefault().getMainWindow());
        if (returnVal == 0) {
            this.javaHomeFileField.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void chooseCoreDump() {
        JFileChooser chooser = new JFileChooser(new File(this.getCoreDumpFile()));
        chooser.setDialogTitle(NbBundle.getMessage(CoreDumpConfigurator.class, (String)"LBL_Select_VM_Coredump"));
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(CoreDumpSupport.getCategory().getFileFilter());
        int returnVal = chooser.showOpenDialog(WindowManager.getDefault().getMainWindow());
        if (returnVal == 0) {
            this.coreDumpFileField.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.coreDumpFileLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.coreDumpFileLabel, (String)NbBundle.getMessage(CoreDumpConfigurator.class, (String)"LBL_VM_Coredump_file"));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 13;
        constraints.insets = new Insets(15, 10, 0, 0);
        this.add((Component)this.coreDumpFileLabel, constraints);
        this.coreDumpFileField = new JTextField();
        this.coreDumpFileLabel.setLabelFor(this.coreDumpFileField);
        this.coreDumpFileField.setPreferredSize(new Dimension(220, this.coreDumpFileField.getPreferredSize().height));
        this.coreDumpFileField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                CoreDumpConfigurator.this.update();
            }

            public void removeUpdate(DocumentEvent e) {
                CoreDumpConfigurator.this.update();
            }

            public void changedUpdate(DocumentEvent e) {
                CoreDumpConfigurator.this.update();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(15, 5, 0, 0);
        this.add((Component)this.coreDumpFileField, constraints);
        this.coreDumpFileButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.coreDumpFileButton, (String)NbBundle.getMessage(CoreDumpConfigurator.class, (String)"LBL_Browse"));
        this.coreDumpFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CoreDumpConfigurator.this.chooseCoreDump();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(15, 5, 0, 10);
        this.add((Component)this.coreDumpFileButton, constraints);
        this.javaHomeFileLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.javaHomeFileLabel, (String)NbBundle.getMessage(CoreDumpConfigurator.class, (String)"LBL_JDK_home"));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 13;
        constraints.insets = new Insets(8, 10, 0, 0);
        this.add((Component)this.javaHomeFileLabel, constraints);
        this.javaHomeFileField = new JTextField();
        this.javaHomeFileLabel.setLabelFor(this.javaHomeFileField);
        this.javaHomeFileField.setPreferredSize(new Dimension(220, this.javaHomeFileField.getPreferredSize().height));
        this.javaHomeFileField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                CoreDumpConfigurator.this.update();
            }

            public void removeUpdate(DocumentEvent e) {
                CoreDumpConfigurator.this.update();
            }

            public void changedUpdate(DocumentEvent e) {
                CoreDumpConfigurator.this.update();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(8, 5, 0, 0);
        this.add((Component)this.javaHomeFileField, constraints);
        this.javaHomeFileButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.javaHomeFileButton, (String)NbBundle.getMessage(CoreDumpConfigurator.class, (String)"LBL_Browse1"));
        this.javaHomeFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CoreDumpConfigurator.this.chooseJavaHome();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(8, 5, 0, 10);
        this.add((Component)this.javaHomeFileButton, constraints);
        this.displaynameCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.displaynameCheckbox, (String)NbBundle.getMessage(CoreDumpConfigurator.class, (String)"LBL_Display_name"));
        this.displaynameCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CoreDumpConfigurator.this.update();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(8, 10, 0, 0);
        this.add((Component)this.displaynameCheckbox, constraints);
        this.displaynameField = new JTextField();
        this.displaynameField.setPreferredSize(new Dimension(220, this.displaynameField.getPreferredSize().height));
        this.displaynameField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                CoreDumpConfigurator.this.update();
            }

            public void removeUpdate(DocumentEvent e) {
                CoreDumpConfigurator.this.update();
            }

            public void changedUpdate(DocumentEvent e) {
                CoreDumpConfigurator.this.update();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(8, 5, 0, 10);
        this.add((Component)this.displaynameField, constraints);
        this.deleteSourceCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.deleteSourceCheckbox, (String)NbBundle.getMessage(CoreDumpConfigurator.class, (String)"LBL_Delete_source_file"));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(18, 10, 0, 0);
        this.add((Component)this.deleteSourceCheckbox, constraints);
        JPanel spacer = Utils.createFillerPanel();
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 15, 0);
        this.add((Component)spacer, constraints);
        this.okButton = new JButton(NbBundle.getMessage(CoreDumpConfigurator.class, (String)"LBL_OK"));
        this.displaynameCheckbox.setBorder(this.coreDumpFileLabel.getBorder());
        this.deleteSourceCheckbox.setBorder(this.coreDumpFileLabel.getBorder());
    }
}

