/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.support.ModificationResult;
import org.netbeans.modules.css.refactoring.api.CssRefactoring;
import org.netbeans.modules.css.refactoring.api.Entry;
import org.netbeans.modules.css.refactoring.api.RefactoringElementType;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.html.editor.HtmlSourceUtils;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.ElementUtils;
import org.netbeans.modules.html.editor.lib.api.elements.ElementVisitor;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.html.editor.refactoring.DeclarationItem;
import org.netbeans.modules.html.editor.refactoring.DiffElement;
import org.netbeans.modules.html.editor.refactoring.InlinedStyleInfo;
import org.netbeans.modules.html.editor.refactoring.RefactoringContext;
import org.netbeans.modules.html.editor.refactoring.ResolveDeclarationItem;
import org.netbeans.modules.html.editor.refactoring.api.ExtractInlinedStyleRefactoring;
import org.netbeans.modules.html.editor.refactoring.api.SelectorType;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringCommit;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ExtractInlinedStyleRefactoringPlugin
implements RefactoringPlugin {
    private boolean cancelled;
    private ExtractInlinedStyleRefactoring refactoring;

    public ExtractInlinedStyleRefactoringPlugin(ExtractInlinedStyleRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public void cancelRequest() {
        this.cancelled = true;
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        if (this.cancelled) {
            return null;
        }
        ModificationResult modificationResult = new ModificationResult();
        RefactoringContext context = (RefactoringContext)this.refactoring.getRefactoringSource().lookup(RefactoringContext.class);
        assert (context != null);
        switch (this.refactoring.getMode()) {
            case refactorToExistingEmbeddedSection: {
                OffsetRange sectionRange = this.refactoring.getExistingEmbeddedCssSection();
                if (sectionRange == null) {
                    return new Problem(true, NbBundle.getMessage(ExtractInlinedStyleRefactoringPlugin.class, (String)"MSG_ErrorCannotDetermineEmbeddedSectionEnd"));
                }
                this.refactorToEmbeddedSection(modificationResult, context, sectionRange.getEnd());
                break;
            }
            case refactorToNewEmbeddedSection: {
                this.refactorToNewEmbeddedSection(modificationResult, context);
                break;
            }
            case refactorToReferedExternalSheet: {
                this.refactorToStyleSheet(modificationResult, context);
                break;
            }
            case refactorToExistingExternalSheet: {
                if (!this.refactorToStyleSheet(modificationResult, context)) break;
                this.importStyleSheet(modificationResult, context);
            }
        }
        refactoringElements.registerTransaction((Transaction)new RefactoringCommit(Collections.singletonList(modificationResult)));
        for (FileObject fo : modificationResult.getModifiedFileObjects()) {
            for (ModificationResult.Difference diff : modificationResult.getDifferences(fo)) {
                refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)DiffElement.create(diff, fo, modificationResult));
            }
        }
        return null;
    }

    private boolean importStyleSheet(ModificationResult modificationResult, RefactoringContext context) {
        FileObject target = this.refactoring.getExternalSheet();
        return HtmlSourceUtils.importStyleSheet(modificationResult, context.getModel().getParserResult(), target);
    }

    private boolean refactorToStyleSheet(ModificationResult modificationResult, RefactoringContext context) {
        BaseDocument extSheetDoc = GsfUtilities.getDocument((FileObject)this.refactoring.getExternalSheet(), (boolean)true);
        int insertOffset = extSheetDoc.getLength();
        int baseIndent = ExtractInlinedStyleRefactoringPlugin.getPreviousLineIndent((Document)extSheetDoc, insertOffset);
        return this.refactorToEmbeddedSection(modificationResult, context, this.refactoring.getExternalSheet(), insertOffset, baseIndent, null, null);
    }

    private boolean refactorToNewEmbeddedSection(ModificationResult modifications, RefactoringContext context) {
        try {
            HtmlParserResult result = context.getModel().getParserResult();
            final AtomicInteger insertPositionRef = new AtomicInteger(-1);
            final AtomicBoolean increaseIndent = new AtomicBoolean();
            Node jsfHtmlLibRoot = result.root("http://java.sun.com/jsf/html");
            if (jsfHtmlLibRoot != null) {
                ElementUtils.visitChildren((Element)jsfHtmlLibRoot, (ElementVisitor)new ElementVisitor(){

                    public void visit(Element node) {
                        OpenTag t = (OpenTag)node;
                        if (LexerUtils.equals((CharSequence)"head", (CharSequence)t.unqualifiedName(), (boolean)true, (boolean)true)) {
                            insertPositionRef.set(node.to());
                            increaseIndent.set(true);
                        }
                    }
                }, (ElementType)ElementType.OPEN_TAG);
            }
            Node root = result.root();
            ElementUtils.visitChildren((Element)root, (ElementVisitor)new ElementVisitor(){

                public void visit(Element node) {
                    OpenTag t = (OpenTag)node;
                    if (LexerUtils.equals((CharSequence)"html", (CharSequence)t.name(), (boolean)true, (boolean)true)) {
                        if (insertPositionRef.get() == -1) {
                            insertPositionRef.set(node.to());
                            increaseIndent.set(true);
                        } else if (LexerUtils.equals((CharSequence)"head", (CharSequence)t.name(), (boolean)true, (boolean)true)) {
                            insertPositionRef.set(node.to());
                            increaseIndent.set(true);
                        } else if (LexerUtils.equals((CharSequence)"style", (CharSequence)t.name(), (boolean)true, (boolean)true)) {
                            insertPositionRef.set(t.semanticEnd());
                            increaseIndent.set(false);
                        }
                    }
                }
            }, (ElementType)ElementType.OPEN_TAG);
            int embeddedInsertOffset = insertPositionRef.get();
            if (embeddedInsertOffset == -1) {
                return false;
            }
            int insertOffset = context.getModel().getSnapshot().getOriginalOffset(embeddedInsertOffset);
            if (insertOffset == -1) {
                return false;
            }
            int baseIndent = Utilities.getRowIndent((BaseDocument)((BaseDocument)context.getDocument()), (int)insertOffset);
            if (baseIndent == -1) {
                baseIndent = 0;
            }
            if (increaseIndent.get()) {
                baseIndent += IndentUtils.indentLevelSize((Document)context.getDocument());
            }
            String baseIndentString = IndentUtils.createIndentString((Document)context.getDocument(), (int)baseIndent);
            String prefix = '\n' + baseIndentString + "<style type=\"text/css\">\n";
            String postfix = '\n' + baseIndentString + "</style>";
            return this.refactorToEmbeddedSection(modifications, context, context.getFile(), insertOffset, baseIndent, prefix, postfix);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    private boolean refactorToEmbeddedSection(ModificationResult modifications, RefactoringContext context, int insertOffset) {
        int baseIndent = ExtractInlinedStyleRefactoringPlugin.getPreviousLineIndent(context.getDocument(), insertOffset);
        return this.refactorToEmbeddedSection(modifications, context, context.getFile(), insertOffset, baseIndent, null, null);
    }

    private boolean refactorToEmbeddedSection(ModificationResult modifications, RefactoringContext context, FileObject targetStylesheet, int insertOffset, int baseIndent, String prefix, String postfix) {
        List<InlinedStyleInfo> inlinedStyles = context.getInlinedStyles();
        CloneableEditorSupport currentFileEditor = GsfUtilities.findCloneableEditorSupport((FileObject)context.getFile());
        LinkedList<ModificationResult.Difference> diffs = new LinkedList<ModificationResult.Difference>();
        StringBuilder generatedSelectorsSection = new StringBuilder();
        if (prefix != null) {
            generatedSelectorsSection.append(prefix);
        }
        SelectorType selectorType = this.refactoring.getSelectorType();
        RefactoringElementType cssElementType = ExtractInlinedStyleRefactoringPlugin.getCssElementType(selectorType);
        Map<InlinedStyleInfo, ResolveDeclarationItem> resolvedDeclarations = selectorType == SelectorType.CLASS ? context.getClassSelectorsToResolve() : context.getIdSelectorsToResolve();
        boolean atLeastOneRefactorToDefaultLocation = false;
        HashMap usedNames = new HashMap();
        usedNames.put(SelectorType.CLASS, new HashMap());
        usedNames.put(SelectorType.ID, new HashMap());
        ((Map)usedNames.get((Object)selectorType)).put(context.getFile(), ExtractInlinedStyleRefactoringPlugin.getAllSelectorNames(context.getFile(), cssElementType));
        ((Map)usedNames.get((Object)selectorType)).put(targetStylesheet, ExtractInlinedStyleRefactoringPlugin.getAllSelectorNames(targetStylesheet, cssElementType));
        for (InlinedStyleInfo si : inlinedStyles) {
            try {
                ModificationResult.Difference diff;
                String originalText;
                Collection editedFileElements;
                ResolveDeclarationItem declaration = resolvedDeclarations.get(si);
                if (declaration != null) {
                    if (selectorType == SelectorType.ID) {
                        DeclarationItem resolvedDeclaration = declaration.getResolvedTarget();
                        if (resolvedDeclaration == null) {
                            ArrayList<String> lines = new ArrayList<String>();
                            lines.add("");
                            lines.add('.' + si.getTagsId() + '{');
                            ExtractInlinedStyleRefactoringPlugin.appendConvertedInlinedCodeLines(lines, si);
                            lines.add("}");
                            String idSelectorText = this.formatCssCode(context.getDocument(), baseIndent, prefix == null ? 0 : 1, lines.toArray(new String[0]));
                            generatedSelectorsSection.append(idSelectorText);
                            atLeastOneRefactorToDefaultLocation = true;
                        } else {
                            FileObject file = resolvedDeclaration.getSource();
                            Entry entry = resolvedDeclaration.getDeclaration().entry();
                            OffsetRange docBodyRange = entry.getDocumentBodyRange();
                            if (docBodyRange == null) continue;
                            int appendOffset = docBodyRange.getStart();
                            int prevLineIndent = ExtractInlinedStyleRefactoringPlugin.getPreviousLineIndent(resolvedDeclaration.getDocument(), appendOffset);
                            LinkedList<String> lines = new LinkedList<String>();
                            lines.add("");
                            ExtractInlinedStyleRefactoringPlugin.appendConvertedInlinedCodeLines(lines, si);
                            String addedCode = this.formatCssCode(context.getDocument(), prevLineIndent, 0, lines.toArray(new String[0]));
                            CloneableEditorSupport editor = GsfUtilities.findCloneableEditorSupport((FileObject)file);
                            ModificationResult.Difference appendDiff = new ModificationResult.Difference(ModificationResult.Difference.Kind.INSERT, editor.createPositionRef(appendOffset, Position.Bias.Forward), editor.createPositionRef(appendOffset, Position.Bias.Backward), null, addedCode, NbBundle.getMessage(ExtractInlinedStyleRefactoringPlugin.class, (String)"MSG_AppendCssCodeToExistingSelector"));
                            modifications.addDifferences(file, Collections.singletonList(appendDiff));
                        }
                        int deleteFrom = si.getAttributeStartOffset();
                        int deleteTo = si.getRange().getEnd() + (si.isValueQuoted() ? 1 : 0);
                        String originalText2 = context.getDocument().getText(deleteFrom, deleteTo - deleteFrom);
                        ModificationResult.Difference removeDiff = new ModificationResult.Difference(ModificationResult.Difference.Kind.REMOVE, currentFileEditor.createPositionRef(deleteFrom, Position.Bias.Forward), currentFileEditor.createPositionRef(deleteTo, Position.Bias.Backward), originalText2, null, NbBundle.getMessage(ExtractInlinedStyleRefactoringPlugin.class, (String)"MSG_RemoveInlinedCode"));
                        diffs.add(removeDiff);
                        continue;
                    }
                    if (selectorType != SelectorType.CLASS) continue;
                    editedFileElements = (Collection)((Map)usedNames.get((Object)selectorType)).get(context.getFile());
                    Collection targetFileElements = (Collection)((Map)usedNames.get((Object)selectorType)).get(targetStylesheet);
                    String generatedSelectorName = ExtractInlinedStyleRefactoringPlugin.getFirstFreeSelectorName(selectorType, si.getTag(), editedFileElements, targetFileElements);
                    String selectorNamePrefix = selectorType == SelectorType.CLASS ? "." : "#";
                    ArrayList<String> lines = new ArrayList<String>();
                    lines.add("");
                    lines.add(selectorNamePrefix + generatedSelectorName + '{');
                    ExtractInlinedStyleRefactoringPlugin.appendConvertedInlinedCodeLines(lines, si);
                    lines.add("}");
                    String idSelectorText = this.formatCssCode(context.getDocument(), baseIndent, prefix == null ? 0 : 1, lines.toArray(new String[0]));
                    generatedSelectorsSection.append(idSelectorText);
                    atLeastOneRefactorToDefaultLocation = true;
                    int deleteFrom = si.getAttributeStartOffset();
                    int deleteTo = si.getRange().getEnd() + (si.isValueQuoted() ? 1 : 0);
                    originalText = context.getDocument().getText(deleteFrom, deleteTo - deleteFrom);
                    ModificationResult.Difference removeDiff = new ModificationResult.Difference(ModificationResult.Difference.Kind.REMOVE, currentFileEditor.createPositionRef(deleteFrom, Position.Bias.Forward), currentFileEditor.createPositionRef(deleteTo, Position.Bias.Backward), originalText, null, NbBundle.getMessage(ExtractInlinedStyleRefactoringPlugin.class, (String)"MSG_RemoveInlinedCode"));
                    int appendToPosition = si.getClassValueAppendOffset();
                    String toAdd = " " + generatedSelectorName;
                    ModificationResult.Difference appendDiff = new ModificationResult.Difference(ModificationResult.Difference.Kind.INSERT, currentFileEditor.createPositionRef(appendToPosition, Position.Bias.Forward), currentFileEditor.createPositionRef(appendToPosition, Position.Bias.Backward), null, toAdd, NbBundle.getMessage(ExtractInlinedStyleRefactoringPlugin.class, (String)"MSG_AddClassSelectorReference"));
                    diffs.add(removeDiff);
                    diffs.add(appendDiff);
                    continue;
                }
                editedFileElements = (Collection)((Map)usedNames.get((Object)selectorType)).get(context.getFile());
                Collection targetFileElements = (Collection)((Map)usedNames.get((Object)selectorType)).get(targetStylesheet);
                String tagName = si.getTag().replaceAll(":", "_");
                String generatedSelectorName = ExtractInlinedStyleRefactoringPlugin.getFirstFreeSelectorName(selectorType, tagName, editedFileElements, targetFileElements);
                int deleteFrom = si.getAttributeStartOffset();
                int deleteTo = si.getRange().getEnd() + (si.isValueQuoted() ? 1 : 0);
                String selectorName = selectorType == SelectorType.CLASS ? "class" : "id";
                String idSelectorUsageText = selectorName + "=\"" + generatedSelectorName + "\"";
                originalText = context.getDocument().getText(deleteFrom, deleteTo - deleteFrom);
                if (si.getRange().isEmpty()) {
                    diff = new ModificationResult.Difference(ModificationResult.Difference.Kind.REMOVE, currentFileEditor.createPositionRef(deleteFrom, Position.Bias.Forward), currentFileEditor.createPositionRef(deleteTo, Position.Bias.Backward), originalText, null, NbBundle.getMessage(ExtractInlinedStyleRefactoringPlugin.class, (String)"MSG_RemoveEmptyStyleAttribute"));
                } else {
                    diff = new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, currentFileEditor.createPositionRef(deleteFrom, Position.Bias.Forward), currentFileEditor.createPositionRef(deleteTo, Position.Bias.Backward), originalText, idSelectorUsageText, NbBundle.getMessage(ExtractInlinedStyleRefactoringPlugin.class, (String)"MSG_ReplaceInlinedStyleWithIdSelectorReference"));
                    ArrayList<String> lines = new ArrayList<String>();
                    lines.add("");
                    String selectorNamePrefix = selectorType == SelectorType.CLASS ? "." : "#";
                    lines.add(selectorNamePrefix + generatedSelectorName + '{');
                    ExtractInlinedStyleRefactoringPlugin.appendConvertedInlinedCodeLines(lines, si);
                    lines.add("}");
                    String idSelectorText = this.formatCssCode(context.getDocument(), baseIndent, prefix == null ? 0 : 1, lines.toArray(new String[0]));
                    generatedSelectorsSection.append(idSelectorText);
                }
                diffs.add(diff);
                atLeastOneRefactorToDefaultLocation = true;
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        modifications.addDifferences(context.getFile(), diffs);
        if (atLeastOneRefactorToDefaultLocation) {
            if (postfix != null) {
                generatedSelectorsSection.append(postfix);
            }
            CloneableEditorSupport targetStylesheetEditor = GsfUtilities.findCloneableEditorSupport((FileObject)targetStylesheet);
            modifications.addDifferences(targetStylesheet, Collections.singletonList(new ModificationResult.Difference(ModificationResult.Difference.Kind.INSERT, targetStylesheetEditor.createPositionRef(insertOffset, Position.Bias.Forward), targetStylesheetEditor.createPositionRef(insertOffset, Position.Bias.Backward), null, generatedSelectorsSection.toString(), NbBundle.getMessage(ExtractInlinedStyleRefactoringPlugin.class, (String)"MSG_GenerateIDSelectors"))));
            return true;
        }
        return false;
    }

    private String formatCssCode(Document doc, int baseIndent, int additionalIndent, String ... lines) {
        StringBuilder b = new StringBuilder();
        int indentLevelSize = IndentUtils.indentLevelSize((Document)doc);
        for (String line : lines) {
            int i;
            b.append(IndentUtils.createIndentString((Document)doc, (int)baseIndent));
            String indentString = IndentUtils.createIndentString((Document)doc, (int)indentLevelSize);
            for (i = 0; i < additionalIndent; ++i) {
                b.append(indentString);
            }
            for (i = 0; i < line.length(); ++i) {
                char c = line.charAt(i);
                if (c == '\t') {
                    b.append(indentString);
                    continue;
                }
                if (c == '\n') continue;
                b.append(c);
            }
            b.append('\n');
        }
        return b.toString();
    }

    private static int getPreviousLineIndent(final Document doc, final int insertOffset) {
        final AtomicInteger ret = new AtomicInteger(0);
        doc.render(new Runnable(){

            @Override
            public void run() {
                try {
                    int firstNonWhiteBw = Utilities.getFirstNonWhiteBwd((BaseDocument)((BaseDocument)doc), (int)insertOffset);
                    ret.set(firstNonWhiteBw == -1 ? 0 : Utilities.getRowIndent((BaseDocument)((BaseDocument)doc), (int)firstNonWhiteBw));
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        int indent = ret.get();
        return indent == -1 ? 0 : indent;
    }

    private static RefactoringElementType getCssElementType(SelectorType selectorType) {
        switch (selectorType) {
            case CLASS: {
                return RefactoringElementType.CLASS;
            }
            case ID: {
                return RefactoringElementType.ID;
            }
        }
        return null;
    }

    private static Collection<String> getSelectorNames(Collection<Entry> entries) {
        ArrayList<String> names = new ArrayList<String>(entries.size());
        for (Entry e : entries) {
            names.add(e.getName());
        }
        return names;
    }

    private static Collection<String> getAllSelectorNames(FileObject file, RefactoringElementType type) {
        return ExtractInlinedStyleRefactoringPlugin.getSelectorNames(CssRefactoring.getAllSelectors((FileObject)file, (RefactoringElementType)type));
    }

    private static String getFirstFreeSelectorName(SelectorType selectorType, String tagName, Collection<String> ... names) {
        String generatedSelectorName;
        String selectorName = selectorType == SelectorType.CLASS ? "class" : "id";
        String selectorNameBase = tagName + selectorName;
        ArrayList<String> allElements = new ArrayList<String>();
        for (Collection<String> namesCol : names) {
            allElements.addAll(namesCol);
        }
        int counter = 0;
        while (allElements.contains(generatedSelectorName = selectorNameBase + (counter++ == 0 ? "" : Integer.valueOf(counter)))) {
        }
        for (Collection<String> namesCol : names) {
            namesCol.add(generatedSelectorName);
        }
        return generatedSelectorName;
    }

    private static void appendConvertedInlinedCodeLines(List<String> lines, InlinedStyleInfo si) {
        for (String parsedDeclaration : si.getParsedDeclarations()) {
            StringBuilder b = new StringBuilder();
            b.append('\t');
            b.append(parsedDeclaration);
            if (!parsedDeclaration.endsWith(";")) {
                b.append(';');
            }
            lines.add(b.toString());
        }
    }
}

