/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.hints.css;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.html.editor.hints.HtmlRuleContext;
import org.netbeans.modules.html.editor.hints.css.AddStylesheetLinkHintFix;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class MissingCssElement
extends Hint {
    public MissingCssElement(Rule rule, HtmlRuleContext context, OffsetRange range, Collection<FileObject> foundInFiles) {
        super(rule, rule.getDisplayName(), context.getFile(), range, MissingCssElement.getFixes(foundInFiles, context), 10);
    }

    private static List<HintFix> getFixes(Collection<FileObject> foundInFiles, HtmlRuleContext context) {
        if (foundInFiles == null) {
            return Collections.emptyList();
        }
        FileObject sourceFile = context.getFile();
        ArrayList<HintFix> fixes = new ArrayList<HintFix>();
        for (FileObject file : foundInFiles) {
            String path = WebUtils.getRelativePath((FileObject)sourceFile, (FileObject)file);
            fixes.add(new AddStylesheetLinkHintFix(NbBundle.getMessage(MissingCssElement.class, (String)"MSG_AddStyleSheetLink", (Object)path), sourceFile, file));
        }
        return fixes;
    }
}

