/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.hints.css;

import java.io.IOException;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.hints.HtmlRule;
import org.netbeans.modules.html.editor.hints.HtmlRuleContext;
import org.netbeans.modules.html.editor.hints.css.CssClassesVisitor;
import org.netbeans.modules.html.editor.hints.css.MissingCssElement;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.ElementUtils;
import org.netbeans.modules.html.editor.lib.api.elements.ElementVisitor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MissingClassRule
extends HtmlRule {
    private static final String MSG_MISSING_CSS_CLASS = NbBundle.getMessage(MissingCssElement.class, (String)"MSG_MissingCssClass");
    private static final String MSG_MISSING_CSS_CLASS_DESC = NbBundle.getMessage(MissingCssElement.class, (String)"MSG_MissingCssClass_Desc");

    @Override
    protected void run(HtmlRuleContext context, List<Hint> result) {
        try {
            HtmlParserResult parserResult = context.getHtmlParserResult();
            CssClassesVisitor visitor = new CssClassesVisitor((Rule)this, context, result);
            ElementUtils.visitChildren((Element)parserResult.root(), (ElementVisitor)visitor, (ElementType)ElementType.OPEN_TAG);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    @Override
    public boolean appliesTo(RuleContext context) {
        HtmlParserResult result = (HtmlParserResult)context.parserResult;
        FileObject file = result.getSnapshot().getSource().getFileObject();
        if (file == null) {
            return false;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)file);
        return project != null;
    }

    @Override
    public boolean getDefaultEnabled() {
        return true;
    }

    @Override
    public String getDisplayName() {
        return MSG_MISSING_CSS_CLASS;
    }

    @Override
    public String getDescription() {
        return MSG_MISSING_CSS_CLASS_DESC;
    }

    @Override
    public boolean showInTasklist() {
        return false;
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }
}

