/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.hints.css;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.html.editor.hints.EmbeddingUtil;
import org.netbeans.modules.html.editor.hints.HtmlRuleContext;
import org.netbeans.modules.html.editor.hints.css.CssElementType;
import org.netbeans.modules.html.editor.hints.css.MissingCssElement;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.AttributeFilter;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementVisitor;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.openide.filesystems.FileObject;

public class CssIdsVisitor
implements ElementVisitor {
    private static final String ID_ATTR_NAME = "id";
    private final HtmlRuleContext context;
    private final Collection<FileObject> referredFiles;
    private final Map<FileObject, Collection<String>> ids;
    private final Map<String, Collection<FileObject>> ids2files;
    private final Rule rule;
    private final List<Hint> hints;

    public CssIdsVisitor(Rule rule, HtmlRuleContext context, List<Hint> hints) throws IOException {
        this.context = context;
        this.hints = hints;
        this.rule = rule;
        this.referredFiles = context.getCssDependenciesGraph().getAllReferedFiles();
        this.ids = context.getCssIndex().findAllIdDeclarations();
        this.ids2files = CssIdsVisitor.createReversedMap(this.ids);
    }

    private static Map<String, Collection<FileObject>> createReversedMap(Map<FileObject, Collection<String>> file2elements) {
        HashMap<String, Collection<FileObject>> map = new HashMap<String, Collection<FileObject>>();
        for (FileObject file : file2elements.keySet()) {
            for (String element : file2elements.get(file)) {
                HashSet<FileObject> files = (HashSet<FileObject>)map.get(element);
                if (files == null) {
                    files = new HashSet<FileObject>();
                }
                files.add(file);
                map.put(element, files);
            }
        }
        return map;
    }

    public void visit(Element node) {
        OpenTag tag = (OpenTag)node;
        for (Attribute id : tag.attributes(new AttributeFilter(){

            public boolean accepts(Attribute attribute) {
                return LexerUtils.equals((CharSequence)CssIdsVisitor.ID_ATTR_NAME, (CharSequence)attribute.name(), (boolean)true, (boolean)true);
            }
        })) {
            this.processElements(id, CssElementType.ID, this.ids2files);
        }
    }

    private void processElements(Attribute attribute, CssElementType elementType, Map<String, Collection<FileObject>> elements2files) {
        CharSequence value = attribute.unquotedValue();
        if (value == null) {
            return;
        }
        if (value.length() == 0) {
            return;
        }
        Collection<FileObject> filesWithTheId = elements2files.get(((Object)value).toString());
        LinkedList<FileObject> referredFilesWithTheId = new LinkedList<FileObject>();
        if (filesWithTheId != null) {
            referredFilesWithTheId.addAll(filesWithTheId);
            referredFilesWithTheId.retainAll(this.referredFiles);
        }
        if (referredFilesWithTheId.isEmpty()) {
            this.hints.add(new MissingCssElement(this.rule, this.context, CssIdsVisitor.getAttributeValueOffsetRange(attribute, this.context), filesWithTheId));
        }
    }

    private static OffsetRange getAttributeValueOffsetRange(Attribute attr, HtmlRuleContext context) {
        boolean quoted = attr.isValueQuoted();
        int from = attr.valueOffset() + (quoted ? 1 : 0);
        int to = from + attr.unquotedValue().length();
        return EmbeddingUtil.convertToDocumentOffsets(from, to, context.getSnapshot());
    }
}

