/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.hints.css;

import java.util.Collections;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.spi.support.ModificationResult;
import org.netbeans.modules.html.editor.HtmlSourceUtils;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileObject;

public class AddStylesheetLinkHintFix
implements HintFix {
    private final FileObject externalStylesheet;
    private final String message;
    private final FileObject sourceFile;

    public AddStylesheetLinkHintFix(String message, FileObject sourceFile, FileObject externalStylesheet) {
        this.message = message;
        this.sourceFile = sourceFile;
        this.externalStylesheet = externalStylesheet;
    }

    public String getDescription() {
        return this.message;
    }

    public void implement() throws Exception {
        Source source = Source.create((FileObject)this.sourceFile);
        ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

            public void run(ResultIterator resultIterator) throws Exception {
                Parser.Result result = resultIterator.getParserResult();
                if (!(result instanceof HtmlParserResult)) {
                    return;
                }
                ModificationResult modification = new ModificationResult();
                if (HtmlSourceUtils.importStyleSheet(modification, (HtmlParserResult)result, AddStylesheetLinkHintFix.this.externalStylesheet)) {
                    modification.commit();
                }
            }
        });
    }

    public boolean isSafe() {
        return true;
    }

    public boolean isInteractive() {
        return false;
    }
}

