/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.hints;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.css.indexing.api.CssIndex;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.SyntaxAnalyzerResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.common.api.DependenciesGraph;
import org.openide.filesystems.FileObject;

public class HtmlRuleContext {
    private SyntaxAnalyzerResult syntaxAnalyzerResult;
    private HtmlParserResult parserResult;
    private List<HintFix> defaultFixes;
    private List<? extends Error> leftDiagnostics;
    private CssIndex cssIndex;
    private DependenciesGraph cssDependencies;

    public HtmlRuleContext(HtmlParserResult parserResult, SyntaxAnalyzerResult syntaxAnalyzerResult, List<HintFix> defaultFixes) {
        this.parserResult = parserResult;
        this.syntaxAnalyzerResult = syntaxAnalyzerResult;
        this.defaultFixes = defaultFixes;
        this.leftDiagnostics = new ArrayList<Error>(parserResult.getDiagnostics(EnumSet.allOf(Severity.class)));
    }

    public HtmlParserResult getHtmlParserResult() {
        return this.parserResult;
    }

    public SyntaxAnalyzerResult getSyntaxAnalyzerResult() {
        return this.syntaxAnalyzerResult;
    }

    public FileObject getFile() {
        return this.getSnapshot().getSource().getFileObject();
    }

    public Snapshot getSnapshot() {
        return this.getHtmlParserResult().getSnapshot();
    }

    public List<HintFix> getDefaultFixes() {
        return this.defaultFixes;
    }

    public List<? extends Error> getLeftDiagnostics() {
        return this.leftDiagnostics;
    }

    public synchronized CssIndex getCssIndex() throws IOException {
        Project project;
        if (this.cssIndex == null && (project = FileOwnerQuery.getOwner((FileObject)this.getFile())) != null) {
            this.cssIndex = CssIndex.create((Project)project);
        }
        return this.cssIndex;
    }

    public synchronized DependenciesGraph getCssDependenciesGraph() throws IOException {
        CssIndex cssIndex;
        if (this.cssDependencies == null && (cssIndex = this.getCssIndex()) != null) {
            this.cssDependencies = cssIndex.getDependencies(this.getFile());
        }
        return this.cssDependencies;
    }
}

