/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf.embedding;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.html.editor.gsf.embedding.CssHtmlTranslator;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;

public class CssEmbeddingProvider
extends EmbeddingProvider {
    private static final Logger LOG = Logger.getLogger(CssEmbeddingProvider.class.getSimpleName());
    private static final long MAX_SNAPSHOT_SIZE = 0x400000L;
    private String sourceMimeType;
    private Translator translator;

    private CssEmbeddingProvider(String sourceMimeType, Translator translator) {
        this.sourceMimeType = sourceMimeType;
        this.translator = translator;
    }

    public List<Embedding> getEmbeddings(Snapshot snapshot) {
        if (this.sourceMimeType.equals(snapshot.getMimeType())) {
            List<Embedding> embeddings = this.translator.getEmbeddings(snapshot);
            if (embeddings.isEmpty()) {
                return Collections.emptyList();
            }
            return Collections.singletonList(Embedding.create(embeddings));
        }
        LOG.log(Level.WARNING, "Unexpected snapshot type: ''{0}''; expecting ''{1}''", new Object[]{snapshot.getMimeType(), this.sourceMimeType});
        return Collections.emptyList();
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public void cancel() {
    }

    public static class Factory
    extends TaskFactory {
        private static final String HTML_MIME_TYPE = "text/html";
        private static final Map<String, Translator> translators = new HashMap<String, Translator>();

        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            int slen = snapshot.getText().length();
            LOG.fine(String.format("CssEmbeddingProvider.create(snapshot): mimetype: %s, size: %s", snapshot.getMimeType(), slen));
            if ((long)slen > 0x400000L) {
                LOG.fine(String.format("Size %s > maximum (%s) => providing no css embedding", slen, 0x400000L));
                return Collections.emptyList();
            }
            Translator t = translators.get(snapshot.getMimeType());
            if (t != null) {
                return Collections.singleton(new CssEmbeddingProvider(snapshot.getMimeType(), t));
            }
            return Collections.emptyList();
        }

        static {
            translators.put(HTML_MIME_TYPE, new CssHtmlTranslator());
        }
    }

    public static interface Translator {
        public List<Embedding> getEmbeddings(Snapshot var1);
    }
}

