/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.gsf.HtmlElementHandle;
import org.netbeans.modules.html.editor.gsf.HtmlStructureItem;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.ElementUtils;
import org.netbeans.modules.html.editor.lib.api.elements.ElementVisitor;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.common.api.Pair;
import org.openide.filesystems.FileObject;

public class HtmlStructureScanner
implements StructureScanner {
    private static final Logger LOGGER = Logger.getLogger(HtmlStructureScanner.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    private static final long MAX_SNAPSHOT_SIZE = 0x400000L;
    private Reference<Pair<ParserResult, List<HtmlStructureItem>>> cache;

    private boolean isOfSupportedSize(ParserResult info) {
        Snapshot snapshot = info.getSnapshot();
        int slen = snapshot.getText().length();
        return (long)slen < 0x400000L;
    }

    public List<? extends StructureItem> scan(ParserResult info) {
        Pair<ParserResult, List<HtmlStructureItem>> pair;
        if (this.cache != null && (pair = this.cache.get()) != null && info == pair.getA()) {
            return (List)pair.getB();
        }
        if (!this.isOfSupportedSize(info)) {
            return Collections.emptyList();
        }
        HtmlParserResult presult = (HtmlParserResult)info;
        Node root = presult.root();
        if (LOG) {
            LOGGER.log(Level.FINE, "HTML parser tree output:");
            LOGGER.log(Level.FINE, root.toString());
        }
        Snapshot snapshot = info.getSnapshot();
        FileObject file = snapshot.getSource().getFileObject();
        ArrayList<HtmlStructureItem> elements = new ArrayList<HtmlStructureItem>();
        for (OpenTag tag : root.children(OpenTag.class)) {
            HtmlElementHandle handle = new HtmlElementHandle(tag, file);
            HtmlStructureItem si = new HtmlStructureItem(tag, handle, snapshot);
            elements.add(si);
        }
        Pair pair2 = new Pair((Object)info, elements);
        this.cache = new WeakReference<Pair>(pair2);
        return elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<OffsetRange>> folds(final ParserResult info) {
        if (!this.isOfSupportedSize(info)) {
            return Collections.emptyMap();
        }
        final BaseDocument doc = (BaseDocument)info.getSnapshot().getSource().getDocument(false);
        if (doc == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<OffsetRange>> folds = new HashMap<String, List<OffsetRange>>();
        final ArrayList tags = new ArrayList();
        final ArrayList comments = new ArrayList();
        ElementVisitor foldsSearch = new ElementVisitor(){

            public void visit(Element node) {
                if (node.type() == ElementType.OPEN_TAG || node.type() == ElementType.COMMENT) {
                    try {
                        int from = node.from();
                        int to = node.type() == ElementType.OPEN_TAG ? ((OpenTag)node).semanticEnd() : node.to();
                        int so = HtmlStructureScanner.documentPosition(from, info.getSnapshot());
                        int eo = HtmlStructureScanner.documentPosition(to, info.getSnapshot());
                        if (so == -1 || eo == -1) {
                            return;
                        }
                        if (eo > doc.getLength() && so > (eo = doc.getLength())) {
                            so = eo;
                        }
                        if (Utilities.getLineOffset((BaseDocument)doc, (int)so) < Utilities.getLineOffset((BaseDocument)doc, (int)eo)) {
                            if (node.type() == ElementType.OPEN_TAG) {
                                tags.add(new OffsetRange(so, eo));
                            } else {
                                comments.add(new OffsetRange(so, eo));
                            }
                        }
                    }
                    catch (BadLocationException ex) {
                        LOGGER.log(Level.INFO, null, ex);
                    }
                }
            }
        };
        doc.readLock();
        try {
            Collection<Node> roots = ((HtmlParserResult)info).roots().values();
            for (Node root : roots) {
                ElementUtils.visitChildren((Node)root, (ElementVisitor)foldsSearch);
            }
        }
        finally {
            doc.readUnlock();
        }
        folds.put("tags", tags);
        folds.put("comments", comments);
        return folds;
    }

    private static int documentPosition(int astOffset, Snapshot snapshot) {
        return snapshot.getOriginalOffset(astOffset);
    }

    public StructureScanner.Configuration getConfiguration() {
        return new StructureScanner.Configuration(false, false, 0);
    }
}

