/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.html.editor.api.gsf.HtmlExtension;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.gsf.HtmlParserResultAccessor;
import org.netbeans.modules.html.editor.lib.api.HtmlSource;
import org.netbeans.modules.html.editor.lib.api.SyntaxAnalyzer;
import org.netbeans.modules.html.editor.lib.api.SyntaxAnalyzerResult;
import org.netbeans.modules.html.editor.lib.api.UndeclaredContentResolver;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;

public class HtmlGSFParser
extends Parser {
    private HtmlParserResult lastResult;
    private static final Logger TIMERS = Logger.getLogger("TIMER.j2ee.parser");

    public void parse(Snapshot snapshot, Task task, SourceModificationEvent event) throws ParseException {
        this.lastResult = this.parse(snapshot, event);
    }

    public Parser.Result getResult(Task task) throws ParseException {
        assert (this.lastResult != null) : "getResult() called prior parse()";
        return this.lastResult;
    }

    public void cancel() {
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    private HtmlParserResult parse(Snapshot snapshot, SourceModificationEvent event) {
        HtmlSource source = new HtmlSource(snapshot);
        String sourceMimetype = snapshot.getSource().getMimeType();
        Collection<HtmlExtension> exts = HtmlExtension.getRegisteredExtensions(sourceMimetype);
        ArrayList<UndeclaredContentResolver> resolvers = new ArrayList<UndeclaredContentResolver>();
        for (HtmlExtension ex : exts) {
            UndeclaredContentResolver resolver = ex.getUndeclaredContentResolver();
            if (resolver == null) continue;
            resolvers.add(resolver);
        }
        SyntaxAnalyzerResult spresult = SyntaxAnalyzer.create((HtmlSource)source).analyze((UndeclaredContentResolver)new AggregatedUndeclaredContentResolver(resolvers));
        HtmlParserResult result = HtmlParserResultAccessor.get().createInstance(spresult);
        if (TIMERS.isLoggable(Level.FINE)) {
            LogRecord rec = new LogRecord(Level.FINE, "HTML parse result");
            rec.setParameters(new Object[]{result});
            TIMERS.log(rec);
        }
        return result;
    }

    private static class AggregatedUndeclaredContentResolver
    extends UndeclaredContentResolver {
        private Collection<UndeclaredContentResolver> resolvers;

        public AggregatedUndeclaredContentResolver(Collection<UndeclaredContentResolver> resolvers) {
            this.resolvers = resolvers;
        }

        public Map<String, List<String>> getUndeclaredNamespaces(HtmlSource source) {
            HashMap<String, List<String>> aggregated = new HashMap<String, List<String>>();
            for (UndeclaredContentResolver resolver : this.resolvers) {
                aggregated.putAll(resolver.getUndeclaredNamespaces(source));
            }
            return aggregated;
        }
    }
}

