/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.html.editor.HtmlPreferences;
import org.netbeans.modules.html.editor.api.Utils;
import org.netbeans.modules.html.editor.api.completion.HtmlCompletionItem;
import org.netbeans.modules.html.editor.api.gsf.HtmlExtension;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.completion.AttrValuesCompletion;
import org.netbeans.modules.html.editor.lib.api.HtmlParseResult;
import org.netbeans.modules.html.editor.lib.api.HtmlVersion;
import org.netbeans.modules.html.editor.lib.api.ParseResult;
import org.netbeans.modules.html.editor.lib.api.ProblemDescription;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.ElementUtils;
import org.netbeans.modules.html.editor.lib.api.elements.FeaturedNode;
import org.netbeans.modules.html.editor.lib.api.elements.Named;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModel;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTag;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTagAttribute;
import org.netbeans.modules.html.editor.lib.api.model.NamedCharRef;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.common.api.ValueCompletion;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class HtmlCompletionQuery
extends UserTask {
    private static final String SCRIPT_TAG_NAME = "script";
    private static final String STYLE_TAG_NAME = "style";
    private static boolean lowerCase;
    private static boolean isXHtml;
    private Document document;
    private FileObject file;
    private int offset;
    private CompletionResult completionResult;
    private boolean triggeredByAutocompletion;

    public HtmlCompletionQuery(Document document, int offset, boolean triggeredByAutocompletion) {
        this.document = document;
        this.offset = offset;
        this.file = DataLoadersBridge.getDefault().getFileObject(document);
        this.triggeredByAutocompletion = triggeredByAutocompletion;
    }

    public CompletionResult query() throws ParseException {
        Source source = Source.create((Document)this.document);
        ParserManager.parse(Collections.singleton(source), (UserTask)this);
        return this.completionResult;
    }

    public void run(ResultIterator resultIterator) throws Exception {
        final Parser.Result parserResult = resultIterator.getParserResult(this.offset);
        if (parserResult == null) {
            return;
        }
        final Snapshot snapshot = parserResult.getSnapshot();
        final Document doc = snapshot.getSource().getDocument(true);
        if (doc == null) {
            return;
        }
        doc.render(new Runnable(){

            @Override
            public void run() {
                int embeddedOffset = snapshot.getEmbeddedOffset(HtmlCompletionQuery.this.offset);
                String resultMimeType = parserResult.getSnapshot().getMimeType();
                if (resultMimeType.equals("text/html")) {
                    HtmlCompletionQuery.this.completionResult = HtmlCompletionQuery.this.query((HtmlParserResult)parserResult);
                } else if (resultMimeType.equals("text/javascript")) {
                    HtmlCompletionQuery.this.completionResult = HtmlCompletionQuery.this.queryHtmlEndTagInEmbeddedCode(snapshot, doc, embeddedOffset, HtmlCompletionQuery.SCRIPT_TAG_NAME);
                } else if (resultMimeType.equals("text/x-css")) {
                    HtmlCompletionQuery.this.completionResult = HtmlCompletionQuery.this.queryHtmlEndTagInEmbeddedCode(snapshot, doc, embeddedOffset, HtmlCompletionQuery.STYLE_TAG_NAME);
                }
            }
        });
    }

    private CompletionResult queryHtmlEndTagInEmbeddedCode(Snapshot snapshot, Document doc, int embeddedOffset, String endTagName) {
        Token<HTMLTokenId> openTagToken;
        int documentItemOffset = snapshot.getOriginalOffset(embeddedOffset);
        TokenSequence<HTMLTokenId> ts = Utils.getJoinedHtmlSequence(doc, documentItemOffset - 1);
        if (ts != null && ts.token().id() == HTMLTokenId.TAG_CLOSE_SYMBOL && CharSequenceUtilities.equals((CharSequence)ts.token().text(), (Object)">") && (openTagToken = Utils.findTagOpenToken(ts)) != null && CharSequenceUtilities.equals((CharSequence)openTagToken.text(), (Object)endTagName)) {
            List<HtmlCompletionItem> items = Collections.singletonList(HtmlCompletionItem.createAutocompleteEndTag(endTagName, documentItemOffset));
            return new CompletionResult(items, this.offset);
        }
        String expectedCode = "</" + endTagName;
        int patternSize = Math.max(embeddedOffset, embeddedOffset - expectedCode.length());
        CharSequence pattern = snapshot.getText().subSequence(embeddedOffset - patternSize, embeddedOffset);
        int ltIndex = CharSequenceUtilities.lastIndexOf((CharSequence)pattern, (int)60);
        if (ltIndex == -1) {
            return null;
        }
        boolean match = true;
        for (int i = ltIndex; i < pattern.length(); ++i) {
            if (pattern.charAt(i) == expectedCode.charAt(i - ltIndex)) continue;
            match = false;
            break;
        }
        if (match) {
            int itemOffset = embeddedOffset - patternSize + ltIndex;
            documentItemOffset = snapshot.getOriginalOffset(itemOffset);
            List<HtmlCompletionItem> items = Collections.singletonList(HtmlCompletionItem.createEndTag(endTagName, documentItemOffset, null, -1, HtmlCompletionItem.EndTag.Type.DEFAULT));
            return new CompletionResult(items, this.offset);
        }
        return null;
    }

    CompletionResult query(HtmlParserResult parserResult) {
        SequencedCollection<Object> result;
        int anchor;
        block53: {
            Node node;
            TokenId id;
            String itemText;
            String preText;
            int documentItemOffset;
            int itemOffset;
            TokenSequence ts;
            int astOffset;
            String sourceMimetype;
            HtmlModel model;
            block60: {
                String wordAtCursor;
                OpenTag tnode;
                HtmlTag tag;
                boolean queryHtmlContent;
                int len;
                Token item;
                block59: {
                    Node xmlLeafNode;
                    block58: {
                        HtmlParseResult htmlResult;
                        block57: {
                            block56: {
                                block55: {
                                    block54: {
                                        boolean inside;
                                        block52: {
                                            ParseResult plain;
                                            try {
                                                htmlResult = parserResult.getSyntaxAnalyzerResult().parseHtml();
                                            }
                                            catch (org.netbeans.modules.html.editor.lib.api.ParseException ex) {
                                                Exceptions.printStackTrace((Throwable)ex);
                                                return null;
                                            }
                                            model = htmlResult.model();
                                            Snapshot snapshot = parserResult.getSnapshot();
                                            sourceMimetype = snapshot.getSource().getMimeType();
                                            astOffset = snapshot.getEmbeddedOffset(this.offset);
                                            if (astOffset == -1) {
                                                return null;
                                            }
                                            lowerCase = this.usesLowerCase(parserResult, astOffset);
                                            HtmlVersion version = parserResult.getHtmlVersion();
                                            isXHtml = version.isXhtml();
                                            TokenHierarchy hi = snapshot.getTokenHierarchy();
                                            ts = hi.tokenSequence(HTMLTokenId.language());
                                            assert (ts != null);
                                            int diff = ts.move(astOffset);
                                            boolean backward = false;
                                            if (ts.moveNext()) {
                                                if (diff == 0 && (ts.token().id() == HTMLTokenId.TEXT || ts.token().id() == HTMLTokenId.WS || ts.token().id() == HTMLTokenId.TAG_CLOSE_SYMBOL || ts.token().id() == HTMLTokenId.TAG_OPEN_SYMBOL)) {
                                                    backward = true;
                                                    if (!ts.movePrevious()) {
                                                        return null;
                                                    }
                                                }
                                            } else {
                                                backward = true;
                                                if (!ts.movePrevious()) {
                                                    return null;
                                                }
                                            }
                                            anchor = -1;
                                            item = ts.token();
                                            itemOffset = ts.offset();
                                            documentItemOffset = snapshot.getOriginalOffset(itemOffset);
                                            itemText = preText = ((Object)item.text()).toString();
                                            if (astOffset - itemOffset < 0 || preText.length() < astOffset - itemOffset) {
                                                StringBuilder b = new StringBuilder();
                                                b.append("Inconsistency in the snapshot! Detailed info:");
                                                b.append("\n------------------------------------------------");
                                                b.append("\ndocument.getText():");
                                                try {
                                                    b.append(this.document.getText(0, this.document.getLength()));
                                                }
                                                catch (BadLocationException ex) {
                                                    b.append(ex.getMessage());
                                                }
                                                b.append("\n------------------------------------------------");
                                                b.append("\ntoken hierarchy:\n").append(hi.toString());
                                                b.append("\n------------------------------------------------");
                                                b.append("\ntoken sequence:\n").append(ts.toString());
                                                b.append("\n------------------------------------------------");
                                                b.append("\nsnapshot.getText():").append(((Object)snapshot.getText()).toString());
                                                b.append("\n------------------------------------------------");
                                                b.append("\nsnapshot.toString():").append(snapshot).toString();
                                                b.append("\nsource:").append(snapshot.getSource()).toString();
                                                b.append(String.format("\nastOffset = %1$s, itemOffset = %2$s", astOffset, itemOffset));
                                                b.append(String.format("\npreText=%s; len=%s", preText, preText.length()));
                                                Logger.getAnonymousLogger().warning(b.toString());
                                            }
                                            if (diff < preText.length()) {
                                                preText = preText.substring(0, astOffset - itemOffset);
                                            }
                                            id = item.id();
                                            inside = ts.offset() < astOffset;
                                            result = null;
                                            len = 1;
                                            int searchAstOffset = astOffset == snapshot.getText().length() ? astOffset - 1 : astOffset;
                                            node = null;
                                            Node root = null;
                                            boolean useHtmlParseResult = true;
                                            if (version == HtmlVersion.HTML5 || version == HtmlVersion.XHTML5 || version == HtmlVersion.XHTML10_FRAMESET || version == HtmlVersion.XHTML10_STICT || version == HtmlVersion.XHTML10_TRANSATIONAL || version == HtmlVersion.HTML41_FRAMESET || version == HtmlVersion.HTML41_STRICT || version == HtmlVersion.HTML41_TRANSATIONAL) {
                                                for (ProblemDescription pd : htmlResult.getProblems()) {
                                                    if (pd.getType() <= 1) continue;
                                                    useHtmlParseResult = false;
                                                    break;
                                                }
                                            }
                                            if (useHtmlParseResult) {
                                                node = parserResult.findBySemanticRange(searchAstOffset, !backward);
                                                if (node == null || node.equals(parserResult.root())) {
                                                    useHtmlParseResult = false;
                                                } else {
                                                    root = ElementUtils.getRoot((Element)node);
                                                }
                                            }
                                            if (!useHtmlParseResult && (node = ElementUtils.findBySemanticRange((Node)(root = (plain = parserResult.getSyntaxAnalyzerResult().parsePlain()).root()), (int)searchAstOffset, (!backward ? 1 : 0) != 0)) == null) {
                                                node = root;
                                            }
                                            assert (node != null);
                                            assert (root != null);
                                            xmlLeafNode = this.findLeafTag(parserResult, searchAstOffset, !backward);
                                            assert (xmlLeafNode != null);
                                            String namespace = null;
                                            if (root instanceof FeaturedNode) {
                                                namespace = (String)((FeaturedNode)root).getProperty("namespace");
                                            }
                                            queryHtmlContent = namespace == null || namespace.equals(parserResult.getHtmlVersion().getDefaultNamespace());
                                            int ampIndex = preText.lastIndexOf(38);
                                            if (id != HTMLTokenId.TEXT && id != HTMLTokenId.VALUE || ampIndex <= -1) break block52;
                                            anchor = this.offset;
                                            result = this.translateCharRefs(this.offset - len, model.getNamedCharacterReferences(), preText.substring(ampIndex + 1));
                                            break block53;
                                        }
                                        if (id != HTMLTokenId.CHARACTER) break block54;
                                        if (!inside && preText.endsWith(";")) break block53;
                                        anchor = documentItemOffset + 1;
                                        result = this.translateCharRefs(documentItemOffset, model.getNamedCharacterReferences(), preText.length() > 0 ? preText.substring(1) : "");
                                        break block53;
                                    }
                                    if (id != HTMLTokenId.TAG_OPEN) break block55;
                                    OpenTag tag2 = (OpenTag)node;
                                    if (LexerUtils.equals((CharSequence)tag2.unqualifiedName(), (CharSequence)preText, (boolean)false, (boolean)false)) {
                                        node = node.parent();
                                        tag2 = (OpenTag)node;
                                    }
                                    anchor = documentItemOffset;
                                    astOffset -= preText.length() + 1;
                                    result = new ArrayList<CompletionItem>();
                                    if (queryHtmlContent) {
                                        Collection possibleOpenTags = htmlResult.getPossibleOpenTags((Element)tag2);
                                        Collection<HtmlTag> allTags = this.filterHtmlElements(model.getAllTags(), preText);
                                        Collection<HtmlTag> filteredByPrefix = this.filterHtmlElements(possibleOpenTags, preText);
                                        result.addAll(this.translateHtmlTags(documentItemOffset - 1, filteredByPrefix, allTags));
                                    }
                                    HtmlExtension.CompletionContext context = new HtmlExtension.CompletionContext(parserResult, itemOffset, astOffset, documentItemOffset - 1, preText, itemText, (Element)node);
                                    for (HtmlExtension e : HtmlExtension.getRegisteredExtensions(sourceMimetype)) {
                                        result.addAll(e.completeOpenTags(context));
                                    }
                                    break block53;
                                }
                                if ((id == HTMLTokenId.BLOCK_COMMENT || !preText.endsWith("<")) && (id != HTMLTokenId.TAG_OPEN_SYMBOL || !"<".equals(((Object)item.text()).toString()))) break block56;
                                OpenTag tag3 = (OpenTag)node;
                                if (LexerUtils.equals((CharSequence)tag3.unqualifiedName(), (CharSequence)preText, (boolean)false, (boolean)false)) {
                                    node = node.parent();
                                }
                                anchor = this.offset;
                                result = new ArrayList<CompletionItem>();
                                if (queryHtmlContent) {
                                    Collection possibleOpenTags = htmlResult.getPossibleOpenTags((Element)tag3);
                                    Collection allTags = model.getAllTags();
                                    result.addAll(this.translateHtmlTags(this.offset - 1, possibleOpenTags, allTags));
                                    if (HtmlPreferences.completionOffersEndTagAfterLt()) {
                                        int endTagOffset = this.offset + 1;
                                        result.addAll(this.getPossibleEndTags(htmlResult, (Element)node, xmlLeafNode, endTagOffset, "", model));
                                    }
                                }
                                HtmlExtension.CompletionContext context = new HtmlExtension.CompletionContext(parserResult, itemOffset, astOffset, this.offset - 1, "", "", (Element)node);
                                for (HtmlExtension e : HtmlExtension.getRegisteredExtensions(sourceMimetype)) {
                                    List<CompletionItem> items = e.completeOpenTags(context);
                                    result.addAll(items);
                                }
                                break block53;
                            }
                            if ((id != HTMLTokenId.TEXT || !preText.endsWith("</")) && (id != HTMLTokenId.TAG_OPEN_SYMBOL || !preText.endsWith("</"))) break block57;
                            anchor = this.offset;
                            result = this.getPossibleEndTags(htmlResult, (Element)node, xmlLeafNode, this.offset, "", model);
                            break block53;
                        }
                        if (id != HTMLTokenId.TAG_CLOSE) break block58;
                        anchor = documentItemOffset;
                        result = this.getPossibleEndTags(htmlResult, (Element)node, xmlLeafNode, this.offset, preText, model);
                        break block53;
                    }
                    if (id != HTMLTokenId.TAG_CLOSE_SYMBOL) break block59;
                    anchor = this.offset;
                    result = this.getAutocompletedEndTag((Element)node, xmlLeafNode, astOffset, this.offset, model);
                    break block53;
                }
                if (id != HTMLTokenId.WS && id != HTMLTokenId.ARGUMENT) break block60;
                String prefix = id == HTMLTokenId.ARGUMENT ? preText : "";
                len = prefix.length();
                anchor = this.offset - len;
                result = new ArrayList<CompletionItem>();
                ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
                HtmlExtension.CompletionContext context = new HtmlExtension.CompletionContext(parserResult, itemOffset, astOffset, anchor, prefix, itemText, (Element)node);
                for (HtmlExtension e : HtmlExtension.getRegisteredExtensions(sourceMimetype)) {
                    items.addAll(e.completeAttributes(context));
                }
                result.addAll(items);
                if (!queryHtmlContent || node.type() != ElementType.OPEN_TAG || (tag = model.getTag(((Object)(tnode = (OpenTag)node).name()).toString())) == null) break block53;
                Collection<HtmlTagAttribute> possible = this.filterAttributes(tag.getAttributes(), prefix);
                Collection existingAttrs = tnode.attributes();
                ArrayList<String> existingAttrsNames = new ArrayList<String>();
                for (Attribute attr : existingAttrs) {
                    existingAttrsNames.add(((Object)attr.name()).toString());
                }
                String string = wordAtCursor = item == null ? null : ((Object)item.text()).toString();
                if (wordAtCursor == null) {
                    wordAtCursor = "";
                }
                ArrayList<HtmlTagAttribute> complete = new ArrayList<HtmlTagAttribute>();
                for (HtmlTagAttribute attr : possible) {
                    String aName = attr.getName();
                    if (!aName.equals(prefix) && (existingAttrsNames.contains(isXHtml ? aName : aName.toUpperCase(Locale.ENGLISH)) || existingAttrsNames.contains(isXHtml ? aName : aName.toLowerCase(Locale.ENGLISH))) && (!wordAtCursor.equals(aName) || prefix.length() <= 0)) continue;
                    complete.add(attr);
                }
                result.addAll(this.translateAttribs(anchor, complete, tag));
                break block53;
            }
            if (id == HTMLTokenId.VALUE || id == HTMLTokenId.OPERATOR || id == HTMLTokenId.WS) {
                if (id == HTMLTokenId.WS) {
                    ts.move(itemOffset);
                    ts.movePrevious();
                    Token t = ts.token();
                    if (t.id() != HTMLTokenId.OPERATOR) {
                        return null;
                    }
                }
                if (node.type() == ElementType.OPEN_TAG) {
                    HtmlTag tag;
                    OpenTag tnode = (OpenTag)node;
                    ts.move(itemOffset);
                    ts.moveNext();
                    Token argItem = ts.token();
                    while (argItem.id() != HTMLTokenId.ARGUMENT && ts.movePrevious()) {
                        argItem = ts.token();
                    }
                    if (argItem.id() != HTMLTokenId.ARGUMENT) {
                        return null;
                    }
                    String argName = ((Object)argItem.text()).toString();
                    if (!isXHtml) {
                        argName = argName.toLowerCase(Locale.ENGLISH);
                    }
                    HtmlTagAttribute attribute = (tag = model.getTag(((Object)tnode.name()).toString())) != null ? tag.getAttribute(argName) : null;
                    result = new LinkedHashSet();
                    if (id != HTMLTokenId.VALUE) {
                        anchor = this.offset;
                        if (attribute != null) {
                            result.addAll(this.translateValues(anchor, attribute.getPossibleValues()));
                            ValueCompletion<HtmlCompletionItem> valuesCompletion = AttrValuesCompletion.getSupport(((Object)tnode.name()).toString(), argName);
                            if (valuesCompletion != null) {
                                result.addAll(valuesCompletion.getItems(this.file, anchor, ""));
                            }
                        }
                        HtmlExtension.CompletionContext context = new HtmlExtension.CompletionContext(parserResult, itemOffset, astOffset, anchor, "", itemText, (Element)node, argName, false);
                        for (HtmlExtension e : HtmlExtension.getRegisteredExtensions(sourceMimetype)) {
                            result.addAll(e.completeAttributeValue(context));
                        }
                    } else {
                        String quotationChar = null;
                        if (preText != null && preText.length() > 0) {
                            if (preText.substring(0, 1).equals("'")) {
                                quotationChar = "'";
                            }
                            if (preText.substring(0, 1).equals("\"")) {
                                quotationChar = "\"";
                            }
                        }
                        String prefix = quotationChar == null ? preText : preText.substring(1);
                        anchor = documentItemOffset + (quotationChar != null ? 1 : 0);
                        if (attribute != null) {
                            result.addAll(this.translateValues(documentItemOffset, this.filter(attribute.getPossibleValues(), prefix), quotationChar));
                            ValueCompletion<HtmlCompletionItem> valuesCompletion = AttrValuesCompletion.getSupport(((Object)tnode.name()).toString(), argName);
                            if (valuesCompletion != null) {
                                result.addAll(valuesCompletion.getItems(this.file, anchor, prefix));
                            }
                        }
                        HtmlExtension.CompletionContext context = new HtmlExtension.CompletionContext(parserResult, itemOffset, astOffset, anchor, prefix, itemText, (Element)node, argName, quotationChar != null);
                        for (HtmlExtension e : HtmlExtension.getRegisteredExtensions(sourceMimetype)) {
                            result.addAll(e.completeAttributeValue(context));
                        }
                    }
                }
            }
        }
        return result == null ? null : new CompletionResult(result, anchor);
    }

    private boolean usesLowerCase(HtmlParserResult result, int astOffset) {
        Iterator iterator = result.getSyntaxAnalyzerResult().getElementsIterator();
        while (iterator.hasNext()) {
            Element e = (Element)iterator.next();
            switch (e.type()) {
                case OPEN_TAG: 
                case CLOSE_TAG: {
                    Named te = (Named)e;
                    char first = te.name().charAt(0);
                    return Character.isLowerCase(first);
                }
            }
        }
        return true;
    }

    public List<CompletionItem> getAutocompletedEndTag(Element node, Node undeclaredTagsLeafNode, int astOffset, int documentOffset, HtmlModel model) {
        List<CompletionItem> result = this.getAutocompletedEndTag(node, astOffset, documentOffset, model);
        if (result == null) {
            result = this.getAutocompletedEndTag((Element)undeclaredTagsLeafNode, astOffset, documentOffset, model);
        }
        return result == null ? Collections.emptyList() : result;
    }

    public List<CompletionItem> getAutocompletedEndTag(Element node, int astOffset, int documentOffset, HtmlModel model) {
        if (node.type() == ElementType.OPEN_TAG && node.to() == astOffset) {
            boolean hasForbiddenEndTag;
            OpenTag tnode = (OpenTag)node;
            HtmlTag tag = model.getTag(((Object)tnode.name()).toString());
            boolean bl = hasForbiddenEndTag = tag != null && tag.isEmpty();
            if (!tnode.isEmpty() && !hasForbiddenEndTag) {
                return Collections.singletonList(HtmlCompletionItem.createAutocompleteEndTag(((Object)tnode.name()).toString(), documentOffset));
            }
        }
        return null;
    }

    private List<CompletionItem> translateCharRefs(int offset, Collection<? extends NamedCharRef> refs, String prefix) {
        ArrayList<CompletionItem> result = new ArrayList<CompletionItem>(refs.size());
        for (NamedCharRef namedCharRef : refs) {
            String name = namedCharRef.getName();
            if (!name.startsWith(prefix)) continue;
            result.add(HtmlCompletionItem.createCharacterReference(name, namedCharRef.getValue(), offset, name));
        }
        return result;
    }

    private List<CompletionItem> getPossibleEndTags(HtmlParseResult htmlResult, Element leaf, Node undeclaredTagsLeafNode, int offset, String prefix, HtmlModel model) {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.addAll(this.getPossibleEndTags(htmlResult, leaf, offset, prefix, model));
        items.addAll(this.getPossibleHtmlEndTagsForUndeclaredComponents(undeclaredTagsLeafNode, offset, prefix, model));
        return items;
    }

    private Collection<CompletionItem> getPossibleEndTags(HtmlParseResult htmlResult, Element leaf, int offset, String prefix, HtmlModel model) {
        Map possible = htmlResult.getPossibleCloseTags(leaf);
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        for (Map.Entry entry : possible.entrySet()) {
            HtmlTag tag = (HtmlTag)entry.getKey();
            OpenTag node = (OpenTag)entry.getValue();
            int order = offset - (node != null ? node.from() : 0);
            String tagName = isXHtml ? tag.getName() : (lowerCase ? tag.getName().toLowerCase(Locale.ENGLISH) : tag.getName().toUpperCase(Locale.ENGLISH));
            if (!LexerUtils.startsWith((CharSequence)tagName, (CharSequence)prefix, (boolean)true, (boolean)false)) continue;
            items.add(HtmlCompletionItem.createEndTag(tag, tagName, offset - 2 - prefix.length(), tagName, order, this.getEndTagType(leaf, model)));
        }
        return items;
    }

    private List<CompletionItem> getPossibleHtmlEndTagsForUndeclaredComponents(Node leaf, int offset, String prefix, HtmlModel model) {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        while (leaf.type() != ElementType.ROOT) {
            if (leaf.type() == ElementType.OPEN_TAG) {
                String tagName;
                OpenTag tleaf = (OpenTag)leaf;
                String string = isXHtml ? ((Object)tleaf.name()).toString() : (tagName = lowerCase ? ((Object)tleaf.name()).toString().toLowerCase(Locale.ENGLISH) : ((Object)tleaf.name()).toString().toUpperCase(Locale.ENGLISH));
                if (tagName.startsWith(prefix.toLowerCase(Locale.ENGLISH))) {
                    int order = offset - leaf.from();
                    items.add(HtmlCompletionItem.createEndTag(tagName, offset - 2 - prefix.length(), tagName, order++, this.getEndTagType((Element)leaf, model)));
                }
                if (tleaf.matchingCloseTag() == null) break;
            }
            leaf = leaf.parent();
            assert (leaf != null);
        }
        return items;
    }

    private HtmlCompletionItem.EndTag.Type getEndTagType(Element leaf, HtmlModel model) {
        boolean needsMatchingTag;
        switch (leaf.type()) {
            case OPEN_TAG: {
                break;
            }
            default: {
                return HtmlCompletionItem.EndTag.Type.REQUIRED_EXISTING;
            }
        }
        OpenTag tleaf = (OpenTag)leaf;
        String tagName = ((Object)tleaf.name()).toString();
        HtmlTag htmlTag = model.getTag(tagName);
        if (htmlTag == null) {
            return HtmlCompletionItem.EndTag.Type.REQUIRED_EXISTING;
        }
        boolean bl = needsMatchingTag = !htmlTag.hasOptionalEndTag();
        if (tleaf.matchingCloseTag() != null) {
            return needsMatchingTag ? HtmlCompletionItem.EndTag.Type.REQUIRED_EXISTING : HtmlCompletionItem.EndTag.Type.OPTIONAL_EXISTING;
        }
        return needsMatchingTag ? HtmlCompletionItem.EndTag.Type.REQUIRED_MISSING : HtmlCompletionItem.EndTag.Type.OPTIONAL_MISSING;
    }

    private Collection<String> filter(Collection<?> col, String prefix) {
        ArrayList<String> filtered = new ArrayList<String>();
        for (Object o : col) {
            String s = o.toString();
            if (!s.startsWith(prefix)) continue;
            filtered.add(s);
        }
        return filtered;
    }

    private Collection<HtmlTagAttribute> filterAttributes(Collection<HtmlTagAttribute> attrs, String prefix) {
        ArrayList<HtmlTagAttribute> filtered = new ArrayList<HtmlTagAttribute>();
        for (HtmlTagAttribute ta : attrs) {
            if (!ta.getName().startsWith(prefix)) continue;
            filtered.add(ta);
        }
        return filtered;
    }

    private Collection<HtmlTag> filterHtmlElements(Collection<HtmlTag> elements, String elementNamePrefix) {
        ArrayList<HtmlTag> filtered = new ArrayList<HtmlTag>();
        elementNamePrefix = elementNamePrefix.toLowerCase(Locale.ENGLISH);
        for (HtmlTag e : elements) {
            if (!e.getName().toLowerCase(Locale.ENGLISH).startsWith(elementNamePrefix)) continue;
            filtered.add(e);
        }
        return filtered;
    }

    List<CompletionItem> translateHtmlTags(int offset, Collection<HtmlTag> possible, Collection<HtmlTag> all) {
        ArrayList<CompletionItem> result = new ArrayList<CompletionItem>(possible.size());
        HashSet<HtmlTag> allmodifiable = new HashSet<HtmlTag>(all);
        allmodifiable.removeAll(possible);
        for (HtmlTag e : possible) {
            result.add(this.item4HtmlTag(e, offset, true));
        }
        for (HtmlTag e : allmodifiable) {
            result.add(this.item4HtmlTag(e, offset, false));
        }
        return result;
    }

    private HtmlCompletionItem item4HtmlTag(HtmlTag e, int offset, boolean possible) {
        String name = e.getName();
        name = isXHtml ? name : (lowerCase ? name.toLowerCase(Locale.ENGLISH) : name.toUpperCase(Locale.ENGLISH));
        return HtmlCompletionItem.createTag(e, name, offset, name, possible);
    }

    Collection<CompletionItem> translateAttribs(int offset, Collection<HtmlTagAttribute> attribs, HtmlTag tag) {
        ArrayList<CompletionItem> result = new ArrayList<CompletionItem>(attribs.size());
        String tagName = tag.getName() + "#";
        block3: for (HtmlTagAttribute attrib : attribs) {
            String name = attrib.getName();
            switch (attrib.getType()) {
                case BOOLEAN: {
                    result.add(HtmlCompletionItem.createBooleanAttribute(name, offset, attrib.isRequired(), tagName + name));
                    continue block3;
                }
            }
            result.add(HtmlCompletionItem.createAttribute(attrib, name, offset, attrib.isRequired(), tagName + name));
        }
        return result;
    }

    Collection<HtmlCompletionItem> translateValues(int offset, Collection<String> values) {
        return this.translateValues(offset, values, null);
    }

    Collection<HtmlCompletionItem> translateValues(int offset, Collection<String> values, String quotationChar) {
        if (values == null) {
            return Collections.emptyList();
        }
        ArrayList<HtmlCompletionItem> result = new ArrayList<HtmlCompletionItem>(values.size());
        if (quotationChar != null) {
            ++offset;
        }
        for (String value : values) {
            result.add(HtmlCompletionItem.createAttributeValue(value, offset));
        }
        return result;
    }

    private Node findLeafTag(HtmlParserResult result, int offset, boolean forward) {
        Node mostLeaf = ElementUtils.findBySemanticRange((Node)result.rootOfUndeclaredTagsParseTree(), (int)offset, (boolean)forward);
        for (String uri : result.getNamespaces().keySet()) {
            Node root = result.root(uri);
            Node leaf = ElementUtils.findBySemanticRange((Node)root, (int)offset, (boolean)forward);
            if (mostLeaf == null) {
                mostLeaf = leaf;
                continue;
            }
            if (leaf.from() <= mostLeaf.from()) continue;
            mostLeaf = leaf;
        }
        return (OpenTag)mostLeaf;
    }

    static {
        isXHtml = false;
    }

    public static class CompletionResult {
        private Collection<? extends CompletionItem> items;
        int anchor;

        CompletionResult(Collection<? extends CompletionItem> items, int anchor) {
            this.items = items;
            this.anchor = anchor;
        }

        public int getAnchor() {
            return this.anchor;
        }

        public Collection<? extends CompletionItem> getItems() {
            return this.items;
        }
    }
}

