/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.api.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.html.editor.HtmlPreferences;
import org.netbeans.modules.html.editor.completion.HtmlCompletionProvider;
import org.netbeans.modules.html.editor.javadoc.HelpManager;
import org.netbeans.modules.html.editor.lib.api.HelpItem;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTag;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTagAttribute;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.util.ImageUtilities;
import org.openide.xml.XMLUtil;

public class HtmlCompletionItem
implements CompletionItem {
    protected static final int DEFAULT_SORT_PRIORITY = 20;
    protected int substitutionOffset;
    protected String text;
    protected String helpId;
    protected boolean shift;
    protected HelpItem help;

    public static HtmlCompletionItem createTag(HtmlTag tag, String name, int substitutionOffset, String helpId, boolean possible) {
        return new Tag(tag, name, substitutionOffset, helpId, possible);
    }

    public static HtmlCompletionItem createEndTag(HtmlTag tag, String name, int substitutionOffset, String helpId, int order, EndTag.Type type) {
        return new EndTag(tag, name, substitutionOffset, helpId, order, type);
    }

    public static HtmlCompletionItem createEndTag(String name, int substitutionOffset, String helpId, int order, EndTag.Type type) {
        return new EndTag(name, substitutionOffset, helpId, order, type);
    }

    public static HtmlCompletionItem createAutocompleteEndTag(String name, int substitutionOffset) {
        return new AutocompleteEndTag(name, substitutionOffset);
    }

    public static HtmlCompletionItem createBooleanAttribute(String name, int substitutionOffset, boolean required, String helpId) {
        return new BooleanAttribute(name, substitutionOffset, required, helpId);
    }

    public static HtmlCompletionItem createAttribute(HtmlTagAttribute attribute, String name, int substitutionOffset, boolean required, String helpId) {
        return new Attribute(attribute, name, substitutionOffset, required, helpId);
    }

    public static HtmlCompletionItem createAttributeValue(String name, int substitutionOffset, boolean addQuotation) {
        return new AttributeValue(name, substitutionOffset, addQuotation);
    }

    public static HtmlCompletionItem createAttributeValue(String name, int substitutionOffset) {
        return HtmlCompletionItem.createAttributeValue(name, substitutionOffset, false);
    }

    public static HtmlCompletionItem createCharacterReference(String name, char value, int substitutionOffset, String helpId) {
        return new CharRefItem(name, value, substitutionOffset, helpId);
    }

    public static HtmlCompletionItem createFileCompletionItem(String value, int substitutionOffset, Color color, ImageIcon icon) {
        return new FileAttributeValue(value, substitutionOffset, color, icon);
    }

    public static HtmlCompletionItem createGoUpFileCompletionItem(int substitutionOffset, Color color, ImageIcon icon) {
        return new GoUpFileAttributeValue(substitutionOffset, color, icon);
    }

    protected HtmlCompletionItem(HelpItem help, String text, int substitutionOffset, String helpId) {
        this(text, substitutionOffset, helpId);
        this.help = help;
    }

    protected HtmlCompletionItem(String text, int substituteOffset) {
        this.substitutionOffset = substituteOffset;
        this.text = text;
    }

    protected HtmlCompletionItem(String text, int substituteOffset, String helpId) {
        this(text, substituteOffset);
        this.helpId = helpId;
    }

    public String getItemText() {
        return this.text;
    }

    public int getSortPriority() {
        return 20;
    }

    public CharSequence getSortText() {
        return this.getItemText();
    }

    public CharSequence getInsertPrefix() {
        return this.getItemText();
    }

    public void processKeyEvent(KeyEvent e) {
        this.shift = e.getKeyCode() == 10 && e.getID() == 401 && e.isShiftDown();
    }

    public void defaultAction(JTextComponent component) {
        if (component != null) {
            if (!this.shift) {
                Completion.get().hideDocumentation();
                Completion.get().hideCompletion();
            }
            int caretOffset = component.getSelectionEnd();
            this.substituteText(component, caretOffset - this.substitutionOffset);
        }
    }

    protected int getMoveBackLength() {
        return 0;
    }

    protected String getSubstituteText() {
        return this.getItemText();
    }

    protected boolean substituteText(JTextComponent c, int len) {
        return this.substituteText(c, len, this.getMoveBackLength());
    }

    protected boolean substituteText(JTextComponent c, int len, int moveBack) {
        return this.substituteText(c, this.getSubstituteText(), len, moveBack);
    }

    protected boolean substituteText(final JTextComponent c, final String substituteText, final int len, int moveBack) {
        final BaseDocument doc = (BaseDocument)c.getDocument();
        final boolean[] result = new boolean[]{true};
        doc.runAtomic(new Runnable(){

            @Override
            public void run() {
                try {
                    String currentText = doc.getText(HtmlCompletionItem.this.substitutionOffset, doc.getLength() - HtmlCompletionItem.this.substitutionOffset < substituteText.length() ? doc.getLength() - HtmlCompletionItem.this.substitutionOffset : substituteText.length());
                    if (!substituteText.equals(currentText)) {
                        doc.remove(HtmlCompletionItem.this.substitutionOffset, len);
                        doc.insertString(HtmlCompletionItem.this.substitutionOffset, substituteText, null);
                    } else {
                        c.setCaretPosition(c.getCaret().getDot() + substituteText.length() - len);
                    }
                }
                catch (BadLocationException ex) {
                    result[0] = false;
                }
            }
        });
        this.reindent(c);
        if (moveBack != 0) {
            Caret caret = c.getCaret();
            int dot = caret.getDot();
            caret.setDot(dot - moveBack);
        }
        return result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reindent(JTextComponent component) {
        final BaseDocument doc = (BaseDocument)component.getDocument();
        final int dotPos = component.getCaretPosition();
        final Indent indent = Indent.get((Document)doc);
        indent.lock();
        try {
            doc.runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        int startOffset = Utilities.getRowStart((BaseDocument)doc, (int)dotPos);
                        int endOffset = Utilities.getRowEnd((BaseDocument)doc, (int)dotPos);
                        indent.reindent(startOffset, endOffset);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
        }
        finally {
            indent.unlock();
        }
    }

    public boolean instantSubstitution(JTextComponent component) {
        if (component != null) {
            try {
                int caretOffset = component.getSelectionEnd();
                if (caretOffset > this.substitutionOffset) {
                    String currentText = component.getDocument().getText(this.substitutionOffset, caretOffset - this.substitutionOffset);
                    if (!this.getSubstituteText().toString().startsWith(currentText)) {
                        return false;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.defaultAction(component);
        return true;
    }

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)g, (Font)defaultFont);
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
    }

    protected ImageIcon getIcon() {
        return null;
    }

    protected String getLeftHtmlText() {
        return this.getItemText();
    }

    protected String getRightHtmlText() {
        return null;
    }

    public String getHelpId() {
        return this.helpId;
    }

    public URL getHelpURL() {
        if (this.helpId == null || this.helpId.equals("")) {
            return null;
        }
        try {
            return new URL(this.helpId);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getHelp() {
        return HelpManager.getDefault().getHelp(this.helpId);
    }

    private boolean hasLegacyHelp() {
        return this.helpId != null && this.helpId.length() > 0;
    }

    public boolean hasHelp() {
        return this.getHelpItem() != null || this.hasLegacyHelp();
    }

    public CompletionTask createDocumentationTask() {
        return new AsyncCompletionTask((AsyncCompletionQuery)new HtmlCompletionProvider.DocQuery(this, false));
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public HelpItem getHelpItem() {
        return this.help;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HtmlCompletionItem other = (HtmlCompletionItem)obj;
        if (this.substitutionOffset != other.substitutionOffset) {
            return false;
        }
        if (this.text == null ? other.text != null : !this.text.equals(other.text)) {
            return false;
        }
        return !(this.helpId == null ? other.helpId != null : !this.helpId.equals(other.helpId));
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + this.substitutionOffset;
        hash = 97 * hash + (this.text != null ? this.text.hashCode() : 0);
        hash = 97 * hash + (this.helpId != null ? this.helpId.hashCode() : 0);
        return hash;
    }

    public static String hexColorCode(Color c) {
        return Integer.toHexString(c.getRGB()).substring(2);
    }

    private static String escape(String s) {
        if (s != null) {
            try {
                return XMLUtil.toAttributeValue((String)s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s;
    }

    public static class Attribute
    extends HtmlCompletionItem {
        private boolean required;
        private boolean autocompleteQuotes;
        private HtmlTagAttribute attr;
        protected static final String ATTR_NAME_COLOR = Attribute.hexColorCode(Color.green.darker());

        public Attribute(HtmlTagAttribute attr, String value, int offset, boolean required, String helpId) {
            super(attr.getHelp(), value, offset, helpId);
            this.attr = attr;
            this.required = required;
            this.autocompleteQuotes = HtmlPreferences.autocompleteQuotesAfterEqualSign();
        }

        public Attribute(String value, int offset, boolean required, String helpId) {
            super(value, offset, helpId);
            this.required = required;
            this.autocompleteQuotes = HtmlPreferences.autocompleteQuotesAfterEqualSign();
        }

        @Override
        protected String getSubstituteText() {
            return this.getItemText() + (this.autocompleteQuotes ? "=\"\"" : "");
        }

        @Override
        protected int getMoveBackLength() {
            return this.autocompleteQuotes ? 1 : 0;
        }

        @Override
        public int getSortPriority() {
            return super.getSortPriority() - (this.required ? 1 : 0);
        }

        @Override
        protected String getLeftHtmlText() {
            return (this.required ? "<b>" : "") + "<font color=#" + ATTR_NAME_COLOR + ">" + this.getItemText() + "</font>" + (this.required ? "</b>" : "");
        }

        @Override
        public boolean hasHelp() {
            return this.attr != null && this.attr.getHelp() != null || super.hasHelp();
        }
    }

    public static class AttributeValue
    extends HtmlCompletionItem {
        private boolean addQuotation;

        public AttributeValue(String value, int offset, boolean addQuotation) {
            super(value, offset);
            this.addQuotation = addQuotation;
        }

        @Override
        protected String getSubstituteText() {
            return this.addQuotation ? "\"" + super.getSubstituteText() + "\"" : super.getSubstituteText();
        }
    }

    public static class AutocompleteEndTag
    extends EndTag {
        public AutocompleteEndTag(String text, int substitutionOffset) {
            super(text, substitutionOffset, null, -1, EndTag.Type.DEFAULT);
        }

        @Override
        protected int getMoveBackLength() {
            return this.getSubstituteText().length();
        }

        @Override
        public boolean instantSubstitution(JTextComponent component) {
            return false;
        }
    }

    public static class BooleanAttribute
    extends HtmlCompletionItem {
        private boolean required;
        protected static final String ATTR_NAME_COLOR = BooleanAttribute.hexColorCode(Color.green.darker());

        public BooleanAttribute(String value, int offset, boolean required, String helpId) {
            super(value, offset, helpId);
            this.required = required;
        }

        @Override
        protected String getLeftHtmlText() {
            return (this.required ? "<b>" : "") + "<font color=#" + ATTR_NAME_COLOR + ">" + this.getItemText() + "</font>" + (this.required ? "</b>" : "");
        }
    }

    public static class CharRefItem
    extends HtmlCompletionItem {
        private char value;

        CharRefItem(String name, char value, int substitutionOffset, String helpId) {
            super(name, substitutionOffset, helpId);
            this.value = value;
        }

        @Override
        protected String getSubstituteText() {
            return "&" + this.getItemText() + ";";
        }

        @Override
        protected String getLeftHtmlText() {
            return "<b>&amp;" + HtmlCompletionItem.escape(this.getItemText()) + ";</b>";
        }

        @Override
        protected String getRightHtmlText() {
            String strVal = this.value == '>' ? "&gt;" : (this.value == '<' ? "&lt;" : Character.toString(this.value));
            return "<b><font color=#990000>" + strVal + "</font></b>";
        }
    }

    public static class EndTag
    extends HtmlCompletionItem {
        private int orderIndex;
        private Type type;
        private HtmlTag tag;

        EndTag(HtmlTag tag, String name, int substitutionOffset, String helpId, int order, Type type) {
            super(tag.getHelp(), name, substitutionOffset, helpId);
            this.orderIndex = order;
            this.type = type;
            this.tag = tag;
        }

        EndTag(String text, int substitutionOffset, String helpId, int order, Type type) {
            super(text, substitutionOffset, helpId);
            this.orderIndex = order;
            this.type = type;
        }

        @Override
        public CharSequence getSortText() {
            if (this.orderIndex == -1) {
                return super.getSortText();
            }
            char[] result = new char[Integer.toString(Integer.MAX_VALUE).length()];
            char[] orderIndexChars = Integer.toString(this.orderIndex).toCharArray();
            Arrays.fill(result, '0');
            System.arraycopy(orderIndexChars, 0, result, result.length - orderIndexChars.length, orderIndexChars.length);
            return new String(result);
        }

        @Override
        protected String getSubstituteText() {
            return "</" + this.getItemText() + ">";
        }

        @Override
        public int getSortPriority() {
            return this.type.sortPriority;
        }

        @Override
        protected String getLeftHtmlText() {
            return (this.type.bold ? "<b>" : "") + "<font color=#" + this.type.colorCode + ">&lt;/" + this.getItemText() + "&gt;</font>" + (this.type.bold ? "</b>" : "");
        }

        @Override
        public boolean hasHelp() {
            return this.tag != null && this.tag.getHelp() != null || super.hasHelp();
        }

        public static enum Type {
            DEFAULT(HtmlCompletionItem.hexColorCode(Color.BLUE), false, 20),
            OPTIONAL_EXISTING(HtmlCompletionItem.hexColorCode(Color.GRAY), false, 20),
            OPTIONAL_MISSING(HtmlCompletionItem.hexColorCode(Color.BLUE), false, 10),
            REQUIRED_EXISTING(HtmlCompletionItem.hexColorCode(Color.GRAY), false, 20),
            REQUIRED_MISSING(HtmlCompletionItem.hexColorCode(Color.BLUE), false, 10);

            private String colorCode;
            private boolean bold;
            private int sortPriority;

            private Type(String colorCode, boolean bold, int sortPriority) {
                this.colorCode = colorCode;
                this.bold = bold;
                this.sortPriority = sortPriority;
            }
        }
    }

    public static class FileAttributeValue
    extends HtmlCompletionItem {
        private ImageIcon icon;
        private Color color;

        FileAttributeValue(String text, int substitutionOffset, Color color, ImageIcon icon) {
            super(text, substitutionOffset);
            this.color = color;
            this.icon = icon;
        }

        @Override
        protected ImageIcon getIcon() {
            return this.icon;
        }

        @Override
        protected String getLeftHtmlText() {
            return "<font color='" + FileAttributeValue.hexColorCode(this.color) + "'>" + this.getItemText() + "</font>";
        }
    }

    public static class GoUpFileAttributeValue
    extends FileAttributeValue {
        GoUpFileAttributeValue(int substitutionOffset, Color color, ImageIcon icon) {
            super("../", substitutionOffset, color, icon);
        }

        @Override
        public int getSortPriority() {
            return super.getSortPriority() - 1;
        }
    }

    public static class Tag
    extends HtmlCompletionItem {
        private static final ImageIcon HTML_TAG_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/csl/source/resources/icons/html_element.png", (boolean)false);
        private static final ImageIcon SVG_TAG_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/csl/source/resources/icons/class.png", (boolean)false);
        private static final ImageIcon MATHML_TAG_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/html/editor/resources/mathml.png", (boolean)false);
        private String GRAY_COLOR_CODE = Tag.hexColorCode(Color.GRAY);
        private boolean possible;
        private HtmlTag tag;

        protected Tag(HtmlTag tag, String name, int substitutionOffset, String helpId, boolean possible) {
            super(tag.getHelp(), name, substitutionOffset, helpId);
            this.tag = tag;
            this.possible = possible;
        }

        protected Tag(String text, int substitutionOffset, String helpId, boolean possible) {
            super(text, substitutionOffset, helpId);
            this.possible = possible;
        }

        @Override
        public void defaultAction(JTextComponent component) {
            super.defaultAction(component);
        }

        @Override
        protected String getSubstituteText() {
            return "<" + this.getItemText();
        }

        @Override
        public int getSortPriority() {
            return super.getSortPriority() + (this.possible ? -10 : 0);
        }

        @Override
        protected String getLeftHtmlText() {
            return this.possible ? "<font color=#0000ff>&lt;" + this.getItemText() + "&gt;</font>" : "<font color=#" + this.GRAY_COLOR_CODE + ">&lt;" + this.getItemText() + "&gt;</font>";
        }

        @Override
        protected String getRightHtmlText() {
            return null;
        }

        @Override
        protected ImageIcon getIcon() {
            if (this.tag != null) {
                switch (this.tag.getTagClass()) {
                    case HTML: {
                        return HTML_TAG_ICON;
                    }
                    case SVG: {
                        return SVG_TAG_ICON;
                    }
                    case MATHML: {
                        return MATHML_TAG_ICON;
                    }
                }
                return null;
            }
            return null;
        }

        @Override
        public boolean hasHelp() {
            return this.tag != null && this.tag.getHelp() != null || super.hasHelp();
        }
    }
}

