/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.indexing.TransactionContext;
import org.netbeans.modules.java.source.usages.BuildArtifactMapperImpl;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.openide.util.Parameters;

public final class ClassIndexEventsTransaction
extends TransactionContext.Service {
    private final boolean source;
    private final Set<URL> removedRoots;
    private final Collection<ElementHandle<TypeElement>> addedTypes;
    private final Collection<ElementHandle<TypeElement>> removedTypes;
    private final Collection<ElementHandle<TypeElement>> changedTypes;
    private final Collection<File> addedFiles;
    private final Collection<File> removedFiles;
    private URL addedRoot;
    private URL changesInRoot;
    private boolean commited;

    private ClassIndexEventsTransaction(boolean src) {
        this.source = src;
        this.removedRoots = new HashSet<URL>();
        this.addedTypes = new HashSet<ElementHandle<TypeElement>>();
        this.removedTypes = new HashSet<ElementHandle<TypeElement>>();
        this.changedTypes = new HashSet<ElementHandle<TypeElement>>();
        this.addedFiles = new ArrayDeque<File>();
        this.removedFiles = new ArrayDeque<File>();
    }

    public void rootAdded(@NonNull URL root) {
        assert (root != null);
        assert (this.addedRoot == null);
        assert (this.changesInRoot == null || this.changesInRoot.equals(root));
        this.addedRoot = root;
    }

    public void rootRemoved(@NonNull URL root) {
        assert (root != null);
        this.removedRoots.add(root);
    }

    public void addedTypes(@NonNull URL root, @NonNull Collection<? extends ElementHandle<TypeElement>> added) {
        assert (root != null);
        assert (added != null);
        assert (this.changesInRoot == null || this.changesInRoot.equals(root));
        assert (this.addedRoot == null || this.addedRoot.equals(root));
        this.addedTypes.addAll(added);
        this.changesInRoot = root;
    }

    public void removedTypes(@NonNull URL root, @NonNull Collection<? extends ElementHandle<TypeElement>> removed) {
        assert (root != null);
        assert (removed != null);
        assert (this.changesInRoot == null || this.changesInRoot.equals(root));
        assert (this.addedRoot == null || this.addedRoot.equals(root));
        this.removedTypes.addAll(removed);
        this.changesInRoot = root;
    }

    public void changedTypes(@NonNull URL root, @NonNull Collection<? extends ElementHandle<TypeElement>> changed) {
        assert (root != null);
        assert (changed != null);
        assert (this.changesInRoot == null || this.changesInRoot.equals(root));
        assert (this.addedRoot == null || this.addedRoot.equals(root));
        this.changedTypes.addAll(changed);
        this.changesInRoot = root;
    }

    public void addedCacheFiles(@NonNull URL root, @NonNull Collection<? extends File> files) throws IllegalStateException {
        Parameters.notNull((CharSequence)"root", (Object)root);
        Parameters.notNull((CharSequence)"files", files);
        if (!this.source) {
            throw new IllegalStateException("The addedCacheFiles can be called only for source root.");
        }
        assert (this.changesInRoot == null || this.changesInRoot.equals(root));
        assert (this.addedRoot == null || this.addedRoot.equals(root));
        this.addedFiles.addAll(files);
        this.changesInRoot = root;
    }

    public void removedCacheFiles(@NonNull URL root, @NonNull Collection<? extends File> files) throws IllegalStateException {
        Parameters.notNull((CharSequence)"root", (Object)root);
        Parameters.notNull((CharSequence)"files", files);
        if (!this.source) {
            throw new IllegalStateException("The removedCacheFiles can be called only for source root.");
        }
        assert (this.changesInRoot == null || this.changesInRoot.equals(root));
        assert (this.addedRoot == null || this.addedRoot.equals(root));
        this.removedFiles.addAll(files);
        this.changesInRoot = root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void commit() throws IOException {
        ClassIndexImpl ci;
        block6: {
            if (this.commited) {
                throw new IllegalStateException("Already commited transaction");
            }
            this.commited = true;
            try {
                if (this.addedFiles.isEmpty() && this.removedFiles.isEmpty()) break block6;
                assert (this.changesInRoot != null);
                BuildArtifactMapperImpl.classCacheUpdated(this.changesInRoot, JavaIndex.getClassFolder(this.changesInRoot), this.removedFiles, this.addedFiles, false);
            }
            catch (Throwable throwable) {
                ClassIndexImpl ci2;
                ClassIndexManager ciManager = ClassIndexManager.getDefault();
                ciManager.fire(this.addedRoot == null ? Collections.emptySet() : Collections.singleton(this.addedRoot), this.removedRoots);
                ClassIndexImpl classIndexImpl = ci2 = this.changesInRoot == null ? null : ciManager.getUsagesQuery(this.changesInRoot, false);
                if (ci2 != null) {
                    ci2.typesEvent(this.addedTypes, this.removedTypes, this.changedTypes);
                }
                throw throwable;
            }
        }
        ClassIndexManager ciManager = ClassIndexManager.getDefault();
        ciManager.fire(this.addedRoot == null ? Collections.emptySet() : Collections.singleton(this.addedRoot), this.removedRoots);
        ClassIndexImpl classIndexImpl = ci = this.changesInRoot == null ? null : ciManager.getUsagesQuery(this.changesInRoot, false);
        if (ci != null) {
            ci.typesEvent(this.addedTypes, this.removedTypes, this.changedTypes);
        }
    }

    @Override
    protected void rollBack() throws IOException {
    }

    @NonNull
    public static ClassIndexEventsTransaction create(boolean source) {
        return new ClassIndexEventsTransaction(source);
    }
}

