/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import javax.tools.JavaFileObject;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.indexing.TransactionContext;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.ForwardingInferableJavaFileObject;
import org.netbeans.modules.java.source.parsing.InferableJavaFileObject;
import org.netbeans.modules.java.source.parsing.PrefetchableJavaFileObject;
import org.netbeans.modules.java.source.parsing.WriteBackTransaction;

public abstract class FileManagerTransaction
extends TransactionContext.Service {
    private final boolean writeable;

    protected FileManagerTransaction(boolean writeable) {
        this.writeable = writeable;
    }

    public final boolean canWrite() {
        return this.writeable;
    }

    public abstract void delete(@NonNull File var1);

    @NonNull
    abstract Iterable<JavaFileObject> filter(@NonNull String var1, @NonNull Iterable<JavaFileObject> var2);

    abstract JavaFileObject createFileObject(@NonNull File var1, @NonNull File var2, @NullAllowed JavaFileFilterImplementation var3, @NullAllowed Charset var4);

    JavaFileObject readFileObject(String dirName, String relativeName) {
        return null;
    }

    public static FileManagerTransaction writeBack(URL root) {
        return new WriteBackTransaction(root);
    }

    public static FileManagerTransaction writeThrough() {
        return new WriteThrogh();
    }

    public static FileManagerTransaction read() {
        return new Read();
    }

    public static FileManagerTransaction nullWrite() {
        return new Null();
    }

    static InferableJavaFileObject nullFileObject(@NonNull InferableJavaFileObject delegate) {
        return delegate instanceof NullFileObject ? delegate : new NullFileObject(delegate);
    }

    private static class Null
    extends FileManagerTransaction {
        public Null() {
            super(true);
        }

        @Override
        public void delete(@NonNull File file) {
        }

        @Override
        JavaFileObject createFileObject(File file, File root, JavaFileFilterImplementation filter, Charset encoding) {
            PrefetchableJavaFileObject ifo = FileObjects.fileFileObject(file, root, filter, encoding);
            return new NullFileObject(ifo);
        }

        @Override
        @NonNull
        Iterable<JavaFileObject> filter(String packageName, @NonNull Iterable<JavaFileObject> files) {
            return files;
        }

        @Override
        protected void commit() throws IOException {
        }

        @Override
        protected void rollBack() throws IOException {
        }
    }

    private static final class NullFileObject
    extends ForwardingInferableJavaFileObject {
        private NullFileObject(@NonNull InferableJavaFileObject delegate) {
            super(delegate);
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return new NullOutputStream();
        }

        @Override
        public Writer openWriter() throws IOException {
            return new OutputStreamWriter(this.openOutputStream());
        }
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }

    private static class Read
    extends FileManagerTransaction {
        private Read() {
            super(false);
        }

        @Override
        public void delete(@NonNull File file) {
            throw new UnsupportedOperationException("Delete not supported, read-only.");
        }

        @Override
        JavaFileObject createFileObject(File file, File root, JavaFileFilterImplementation filter, Charset encoding) {
            throw new UnsupportedOperationException("Create File not supported, read-only.");
        }

        @Override
        @NonNull
        Iterable<JavaFileObject> filter(String packageName, @NonNull Iterable<JavaFileObject> files) {
            return files;
        }

        @Override
        protected void commit() throws IOException {
        }

        @Override
        protected void rollBack() throws IOException {
        }
    }

    private static class WriteThrogh
    extends FileManagerTransaction {
        private WriteThrogh() {
            super(true);
        }

        @Override
        public void delete(@NonNull File file) {
            assert (file != null);
            file.delete();
        }

        @Override
        @NonNull
        Iterable<JavaFileObject> filter(String packageName, @NonNull Iterable<JavaFileObject> files) {
            return files;
        }

        @Override
        protected void commit() throws IOException {
        }

        @Override
        protected void rollBack() throws IOException {
            throw new UnsupportedOperationException("RollBack is unsupported");
        }

        @Override
        JavaFileObject createFileObject(File file, File root, JavaFileFilterImplementation filter, Charset encoding) {
            return FileObjects.fileFileObject(file, root, filter, encoding);
        }
    }
}

