/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.source.parsing.Archive;
import org.netbeans.modules.java.source.parsing.CachingArchiveProvider;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public final class CachingArchiveClassLoader
extends ClassLoader {
    private static final int INI_SIZE = 16384;
    private static final Logger LOG = Logger.getLogger(CachingArchiveClassLoader.class.getName());
    private final Archive[] archives;
    private byte[] buffer;

    private CachingArchiveClassLoader(@NonNull Archive[] archives, ClassLoader parent) {
        super(parent);
        assert (archives != null);
        this.archives = archives;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        StringBuilder sb = new StringBuilder(FileObjects.convertPackage2Folder(name, '/'));
        sb.append(JavaFileObject.Kind.CLASS.extension);
        FileObject file = this.findFileObject(sb.toString());
        if (file != null) {
            try {
                String pack;
                int len = this.readJavaFileObject(file);
                int lastDot = name.lastIndexOf(46);
                if (lastDot != -1 && this.getPackage(pack = name.substring(0, lastDot)) == null) {
                    this.definePackage(pack, null, null, null, null, null, null, null);
                }
                return this.defineClass(name, this.buffer, 0, len);
            }
            catch (FileNotFoundException fnf) {
                LOG.log(Level.FINE, "Resource: {0} does not exist.", file.toUri());
            }
            catch (IOException ioe) {
                LOG.log(Level.INFO, "Resource: {0} cannot be read.", file.toUri());
            }
        }
        return super.findClass(name);
    }

    @Override
    protected URL findResource(String name) {
        FileObject file = this.findFileObject(name);
        if (file != null) {
            try {
                return file.toUri().toURL();
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return super.findResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        Vector<URL> v = new Vector<URL>();
        for (Archive archive : this.archives) {
            JavaFileObject file = archive.getFile(name);
            if (file == null) continue;
            v.add(file.toUri().toURL());
        }
        return v.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readJavaFileObject(FileObject jfo) throws IOException {
        if (this.buffer == null) {
            this.buffer = new byte[16384];
        }
        int len = 0;
        InputStream in = jfo.openInputStream();
        try {
            while (true) {
                int l;
                if (this.buffer.length == len) {
                    byte[] nb = new byte[2 * this.buffer.length];
                    System.arraycopy(this.buffer, 0, nb, 0, len);
                    this.buffer = nb;
                }
                if ((l = in.read(this.buffer, len, this.buffer.length - len)) <= 0) {
                    break;
                }
                len += l;
            }
        }
        finally {
            in.close();
        }
        return len;
    }

    private FileObject findFileObject(String resName) {
        try {
            for (Archive archive : this.archives) {
                JavaFileObject file = archive.getFile(resName);
                if (file == null) continue;
                return file;
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        return null;
    }

    public static ClassLoader forClassPath(@NonNull ClassPath classPath, @NullAllowed ClassLoader parent) {
        Parameters.notNull((CharSequence)"classPath", (Object)classPath);
        List entries = classPath.entries();
        URL[] urls = new URL[entries.size()];
        Iterator eit = entries.iterator();
        int i = 0;
        while (eit.hasNext()) {
            urls[i] = ((ClassPath.Entry)eit.next()).getURL();
            ++i;
        }
        return CachingArchiveClassLoader.forURLs(urls, parent);
    }

    public static ClassLoader forURLs(@NonNull URL[] urls, @NullAllowed ClassLoader parent) {
        Parameters.notNull((CharSequence)"urls", (Object)urls);
        ArrayList<Archive> archives = new ArrayList<Archive>(urls.length);
        for (URL url : urls) {
            Archive arch = CachingArchiveProvider.getDefault().getArchive(url, false);
            if (arch == null) continue;
            archives.add(arch);
        }
        return new CachingArchiveClassLoader(archives.toArray(new Archive[archives.size()]), parent);
    }
}

