/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.indexing;

import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.source.indexing.JavaCustomIndexer;
import org.netbeans.modules.parsing.spi.indexing.SuspendStatus;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

class SourcePrefetcher
implements Iterator<JavaCustomIndexer.CompileTuple> {
    private static final Logger LOG = Logger.getLogger(SourcePrefetcher.class.getName());
    private static final int DEFAULT_PROC_COUNT = 2;
    private static final int DEFAULT_BUFFER_SIZE = 0x100000;
    private static final int MIN_PROC = 4;
    private static final int MIN_FILES = 10;
    private static final boolean PREFETCH_DISABLED = Boolean.getBoolean("SourcePrefetcher.disabled");
    private static final int PROC_COUNT = Integer.getInteger("SourcePrefetcher.proc.count", 2);
    static int BUFFER_SIZE = Integer.getInteger("SourcePrefetcher.buffer.size", 0x100000);
    static Boolean TEST_DO_PREFETCH;
    private final Iterator<? extends JavaCustomIndexer.CompileTuple> iterator;
    private boolean active;

    private SourcePrefetcher(@NonNull Iterator<? extends JavaCustomIndexer.CompileTuple> iterator) {
        assert (iterator != null);
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    @CheckForNull
    public JavaCustomIndexer.CompileTuple next() {
        if (this.active) {
            throw new IllegalStateException("Call remove to free resources");
        }
        JavaCustomIndexer.CompileTuple res = this.iterator.next();
        this.active = true;
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() {
        if (!this.active) {
            throw new IllegalStateException("Call next before remove");
        }
        try {
            this.iterator.remove();
        }
        finally {
            this.active = false;
        }
    }

    static SourcePrefetcher create(@NonNull Collection<? extends JavaCustomIndexer.CompileTuple> files, @NonNull SuspendStatus suspendStatus) {
        return new SourcePrefetcher(SourcePrefetcher.getIterator(files, suspendStatus));
    }

    private static Iterator<? extends JavaCustomIndexer.CompileTuple> getIterator(@NonNull Collection<? extends JavaCustomIndexer.CompileTuple> files, @NonNull SuspendStatus suspendStatus) {
        boolean doPrefetch;
        boolean supportsPar;
        int procCount = Runtime.getRuntime().availableProcessors();
        int probSize = files.size();
        LOG.log(Level.FINER, "Proc Count: {0} File count: {1} Prefetch disabled: {2}", new Object[]{procCount, probSize, PREFETCH_DISABLED});
        boolean bl = supportsPar = procCount >= 4 && probSize > 10;
        boolean bl2 = TEST_DO_PREFETCH != null ? TEST_DO_PREFETCH : (doPrefetch = supportsPar && !PREFETCH_DISABLED);
        if (doPrefetch) {
            LOG.log(Level.FINE, "Using concurrent iterator, {0} workers", PROC_COUNT);
            return new ConcurrentIterator(files, suspendStatus);
        }
        LOG.fine("Using sequential iterator");
        return new NopRemoveItDecorator(files.iterator(), suspendStatus);
    }

    static /* synthetic */ int access$000() {
        return PROC_COUNT;
    }

    private static final class ConcurrentIterator
    extends SuspendableIterator {
        private static final JavaCustomIndexer.CompileTuple DUMMY = new JavaCustomIndexer.CompileTuple(null, null);
        private static final RequestProcessor RP = new RequestProcessor(SourcePrefetcher.class.getName(), SourcePrefetcher.access$000(), false, false);
        private final CompletionService<JavaCustomIndexer.CompileTuple> cs = new ExecutorCompletionService<JavaCustomIndexer.CompileTuple>((Executor)RP);
        private final Semaphore sem = new Semaphore(BUFFER_SIZE);
        private int count;
        private JavaCustomIndexer.CompileTuple active;

        private ConcurrentIterator(@NonNull Iterable<? extends JavaCustomIndexer.CompileTuple> files, @NonNull SuspendStatus suspendStatus) {
            super(suspendStatus);
            for (final JavaCustomIndexer.CompileTuple compileTuple : files) {
                this.cs.submit(new Callable<JavaCustomIndexer.CompileTuple>(){

                    @Override
                    public JavaCustomIndexer.CompileTuple call() throws Exception {
                        ConcurrentIterator.this.safePark();
                        int len = Math.min(BUFFER_SIZE, compileTuple.jfo.prefetch());
                        if (LOG.isLoggable(Level.FINEST) && ConcurrentIterator.this.sem.availablePermits() - len < 0) {
                            LOG.finest("Buffer full");
                        }
                        ConcurrentIterator.this.sem.acquire(len);
                        return compileTuple;
                    }
                });
                ++this.count;
            }
        }

        @Override
        public boolean hasNext() {
            return this.count > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JavaCustomIndexer.CompileTuple next() {
            if (this.active != null) {
                throw new IllegalStateException("Call remove to free resources");
            }
            if (!this.hasNext()) {
                throw new IllegalStateException("No more tuples.");
            }
            this.safePark();
            try {
                this.active = this.cs.take().get();
            }
            catch (InterruptedException ex) {
                this.active = DUMMY;
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ExecutionException ex) {
                this.active = DUMMY;
                Throwable rootCause = ex.getCause();
                if (rootCause instanceof FileNotFoundException) {
                    LOG.log(Level.INFO, rootCause.getLocalizedMessage());
                } else {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            finally {
                --this.count;
            }
            return this.active == DUMMY ? null : this.active;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.active == null) {
                throw new IllegalStateException("Call next before remove");
            }
            try {
                if (this.active != DUMMY) {
                    int len = Math.min(BUFFER_SIZE, this.active.jfo.dispose());
                    this.sem.release(len);
                }
            }
            finally {
                this.active = null;
            }
        }
    }

    private static final class NopRemoveItDecorator
    extends SuspendableIterator {
        private final Iterator<? extends JavaCustomIndexer.CompileTuple> delegate;

        private NopRemoveItDecorator(@NonNull Iterator<? extends JavaCustomIndexer.CompileTuple> delegate, @NonNull SuspendStatus suspendStatus) {
            super(suspendStatus);
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public JavaCustomIndexer.CompileTuple next() {
            return this.delegate.next();
        }

        @Override
        public void remove() {
        }
    }

    private static abstract class SuspendableIterator
    implements Iterator<JavaCustomIndexer.CompileTuple> {
        private final SuspendStatus suspendStatus;

        protected SuspendableIterator(@NonNull SuspendStatus suspendStatus) {
            assert (suspendStatus != null);
            this.suspendStatus = suspendStatus;
        }

        protected final void safePark() {
            try {
                this.suspendStatus.parkWhileSuspended();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

