/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.ref.Reference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.swing.text.BadLocationException;
import javax.tools.JavaFileObject;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.NullUnknown;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.PositionConverter;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.source.builder.TreeFactory;
import org.netbeans.modules.java.source.parsing.CompilationInfoImpl;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.JavacParserResult;
import org.netbeans.modules.java.source.pretty.ImportAnalysis2;
import org.netbeans.modules.java.source.save.CasualDiff;
import org.netbeans.modules.java.source.save.DiffContext;
import org.netbeans.modules.java.source.save.DiffUtilities;
import org.netbeans.modules.java.source.save.ElementOverlay;
import org.netbeans.modules.java.source.save.OverlayTemplateAttributesProvider;
import org.netbeans.modules.java.source.transform.ImmutableTreeTranslator;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public class WorkingCopy
extends CompilationController {
    static Reference<WorkingCopy> instance;
    private Map<Tree, Tree> changes;
    private Map<JavaFileObject, CompilationUnitTree> externalChanges;
    private List<CasualDiff.Diff> textualChanges;
    private Map<Integer, String> userInfo;
    private boolean afterCommit = false;
    private TreeMaker treeMaker;
    private Map<Tree, Object> tree2Tag;
    private final ElementOverlay overlay;
    private static boolean REWRITE_WHOLE_FILE;

    WorkingCopy(CompilationInfoImpl impl, ElementOverlay overlay) {
        super(impl);
        this.overlay = overlay;
    }

    private synchronized void init() {
        if (this.changes != null) {
            return;
        }
        this.treeMaker = new TreeMaker(this, TreeFactory.instance(this.getContext()));
        this.changes = new IdentityHashMap<Tree, Tree>();
        this.tree2Tag = new IdentityHashMap<Tree, Object>();
        this.externalChanges = null;
        this.textualChanges = new ArrayList<CasualDiff.Diff>();
        this.userInfo = new HashMap<Integer, String>();
        this.getContext().put(ElementOverlay.class, (ElementOverlay)null);
        this.getContext().put(ElementOverlay.class, this.overlay);
    }

    private Context getContext() {
        return this.impl.getJavacTask().getContext();
    }

    @NullUnknown
    public static WorkingCopy get(@NonNull Parser.Result result) {
        JavacParserResult javacResult;
        CompilationController controller;
        WorkingCopy copy;
        Parameters.notNull((CharSequence)"result", (Object)result);
        WorkingCopy workingCopy = copy = instance != null ? instance.get() : null;
        if (copy != null && result instanceof JavacParserResult && (controller = (javacResult = (JavacParserResult)result).get(CompilationController.class)) != null && controller.impl == copy.impl) {
            return copy;
        }
        return null;
    }

    @Override
    @NonNull
    public JavaSource.Phase toPhase(@NonNull JavaSource.Phase phase) throws IOException {
        JavaSource.Phase result = super.toPhase(phase);
        if (result.compareTo(JavaSource.Phase.PARSED) >= 0) {
            this.init();
        }
        return result;
    }

    @NonNull
    public synchronized TreeMaker getTreeMaker() throws IllegalStateException {
        this.checkConfinement();
        if (this.treeMaker == null) {
            throw new IllegalStateException("Cannot call getTreeMaker before toPhase.");
        }
        return this.treeMaker;
    }

    Map<Tree, Tree> getChangeSet() {
        return this.changes;
    }

    public synchronized void rewrite(@NullAllowed Tree oldTree, @NonNull Tree newTree) {
        this.checkConfinement();
        if (this.changes == null) {
            throw new IllegalStateException("Cannot call rewrite before toPhase.");
        }
        if (oldTree == newTree) {
            return;
        }
        if (oldTree == null && Tree.Kind.COMPILATION_UNIT == newTree.getKind()) {
            this.createCompilationUnit((JCTree.JCCompilationUnit)newTree);
            return;
        }
        if (oldTree == null || newTree == null) {
            throw new IllegalArgumentException("Null values are not allowed.");
        }
        this.changes.put(oldTree, newTree);
    }

    public synchronized void rewriteInComment(int start, int length, @NonNull String newText) throws IllegalArgumentException {
        int commentSuffix;
        int commentPrefix;
        this.checkConfinement();
        TokenSequence ts = this.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        ts.move(start);
        if (!ts.moveNext()) {
            throw new IllegalArgumentException("Cannot rewriteInComment start=" + start + ", text length=" + this.getText().length());
        }
        if (ts.token().id() != JavaTokenId.LINE_COMMENT && ts.token().id() != JavaTokenId.BLOCK_COMMENT && ts.token().id() != JavaTokenId.JAVADOC_COMMENT) {
            throw new IllegalArgumentException("Cannot rewriteInComment: attempt to rewrite non-comment token: " + ts.token().id());
        }
        if (ts.offset() + ts.token().length() < start + length) {
            throw new IllegalArgumentException("Cannot rewriteInComment: attempt to rewrite text after comment token. Token end offset: " + (ts.offset() + ts.token().length()) + ", rewrite end offset: " + (start + length));
        }
        switch ((JavaTokenId)ts.token().id()) {
            case LINE_COMMENT: {
                commentPrefix = 2;
                commentSuffix = 0;
                break;
            }
            case BLOCK_COMMENT: {
                commentPrefix = 2;
                commentSuffix = 2;
                break;
            }
            case JAVADOC_COMMENT: {
                commentPrefix = 3;
                commentSuffix = 2;
                break;
            }
            default: {
                throw new IllegalStateException("Internal error");
            }
        }
        if (ts.offset() + commentPrefix > start) {
            throw new IllegalArgumentException("Cannot rewriteInComment: attempt to rewrite comment prefix");
        }
        if (ts.offset() + ts.token().length() - commentSuffix < start + length) {
            throw new IllegalArgumentException("Cannot rewriteInComment: attempt to rewrite comment suffix");
        }
        this.textualChanges.add(CasualDiff.Diff.delete(start, start + length));
        this.textualChanges.add(CasualDiff.Diff.insert(start + length, newText));
        this.userInfo.put(start, NbBundle.getMessage(CasualDiff.class, (String)"TXT_RenameInComment"));
    }

    public synchronized void tag(@NonNull Tree t, @NonNull Object tag) {
        this.tree2Tag.put(t, tag);
    }

    @NonNull
    public synchronized Tree resolveRewriteTarget(@NonNull Tree in) {
        IdentityHashMap<Tree, Tree> localChanges = new IdentityHashMap<Tree, Tree>(this.changes);
        while (localChanges.containsKey(in)) {
            in = (Tree)localChanges.remove(in);
        }
        return in;
    }

    private static String codeForCompilationUnit(CompilationUnitTree topLevel) throws IOException {
        return ((Object)((JCTree.JCCompilationUnit)topLevel).sourcefile.getCharContent(true)).toString();
    }

    private void addSyntheticTrees(DiffContext diffContext, Tree node) {
        ExpressionTree select;
        ExpressionTree est;
        if (node != null && node.getKind() == Tree.Kind.EXPRESSION_STATEMENT && (est = ((ExpressionStatementTree)node).getExpression()).getKind() == Tree.Kind.METHOD_INVOCATION && (select = ((MethodInvocationTree)est).getMethodSelect()).getKind() == Tree.Kind.IDENTIFIER && ((IdentifierTree)select).getName().contentEquals("super") && this.getTreeUtilities().isSynthetic(diffContext.origUnit, node)) {
            diffContext.syntheticTrees.add(node);
        }
    }

    private List<ModificationResult.Difference> processCurrentCompilationUnit(final DiffContext diffContext, Map<?, int[]> tag2Span) throws IOException, BadLocationException {
        Set<? extends Element> nueImports;
        final LinkedHashSet<TreePath> pathsToRewrite = new LinkedHashSet<TreePath>();
        final IdentityHashMap<TreePath, Map<Tree, Tree>> parent2Rewrites = new IdentityHashMap<TreePath, Map<Tree, Tree>>();
        boolean fillImports = true;
        HashMap<Integer, String> userInfo = new HashMap<Integer, String>();
        final HashSet<Tree> oldTrees = new HashSet<Tree>();
        if (CasualDiff.OLD_TREES_VERBATIM) {
            new TreeScanner<Void, Void>(){
                private boolean synthetic = false;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void scan(Tree node, Void p) {
                    if (node == null) {
                        return null;
                    }
                    boolean oldSynthetic = this.synthetic;
                    try {
                        this.synthetic |= WorkingCopy.this.getTreeUtilities().isSynthetic(diffContext.origUnit, node);
                        if (!this.synthetic) {
                            oldTrees.add(node);
                        }
                        WorkingCopy.this.addSyntheticTrees(diffContext, node);
                        Void void_ = (Void)super.scan(node, p);
                        return void_;
                    }
                    finally {
                        this.synthetic = oldSynthetic;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void visitForLoop(ForLoopTree node, Void p) {
                    try {
                        Void void_ = (Void)super.visitForLoop(node, p);
                        return void_;
                    }
                    finally {
                        oldTrees.removeAll(node.getInitializer());
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void visitEnhancedForLoop(EnhancedForLoopTree node, Void p) {
                    try {
                        Void void_ = (Void)super.visitEnhancedForLoop(node, p);
                        return void_;
                    }
                    finally {
                        oldTrees.remove(node.getVariable());
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void visitTry(TryTree node, Void p) {
                    try {
                        Void void_ = (Void)super.visitTry(node, p);
                        return void_;
                    }
                    finally {
                        oldTrees.removeAll(node.getResources());
                    }
                }
            }.scan((Tree)diffContext.origUnit, (Void)null);
        } else {
            new TreeScanner<Void, Void>(){

                @Override
                public Void scan(Tree node, Void p) {
                    WorkingCopy.this.addSyntheticTrees(diffContext, node);
                    return (Void)super.scan(node, p);
                }
            }.scan((Tree)diffContext.origUnit, (Void)null);
        }
        if (!REWRITE_WHOLE_FILE) {
            new TreePathScanner<Void, Void>(){
                private TreePath currentParent;
                private final Map<Tree, TreePath> tree2Path = new IdentityHashMap<Tree, TreePath>();
                private final ElementOverlay.FQNComputer fqn = new ElementOverlay.FQNComputer();

                private TreePath getParentPath(TreePath tp, Tree t) {
                    Tree parent;
                    if (tp != null) {
                        while (tp.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT && WorkingCopy.this.getTreeUtilities().isSynthetic(tp)) {
                            tp = tp.getParentPath();
                        }
                        parent = tp.getLeaf();
                    } else {
                        parent = t;
                    }
                    TreePath c = this.tree2Path.get(parent);
                    if (c == null) {
                        c = tp != null ? tp : new TreePath((CompilationUnitTree)t);
                        this.tree2Path.put(parent, c);
                    }
                    return c;
                }

                @Override
                public Void scan(Tree tree, Void p) {
                    if (WorkingCopy.this.changes.containsKey(tree)) {
                        boolean clearCurrentParent = false;
                        if (this.currentParent == null) {
                            clearCurrentParent = true;
                            this.currentParent = this.getParentPath(this.getCurrentPath(), tree);
                            pathsToRewrite.add(this.currentParent);
                            if (!parent2Rewrites.containsKey(this.currentParent)) {
                                parent2Rewrites.put(this.currentParent, new IdentityHashMap());
                            }
                        }
                        Map rewrites = (Map)parent2Rewrites.get(this.currentParent);
                        Tree rev = (Tree)WorkingCopy.this.changes.remove(tree);
                        rewrites.put(tree, rev);
                        this.scan(rev, p);
                        if (clearCurrentParent) {
                            this.currentParent = null;
                        }
                    } else {
                        super.scan(tree, p);
                    }
                    return null;
                }

                @Override
                public Void visitCompilationUnit(CompilationUnitTree node, Void p) {
                    this.fqn.setCompilationUnit(node);
                    return (Void)super.visitCompilationUnit(node, p);
                }

                @Override
                public Void visitClass(ClassTree node, Void p) {
                    String parent = this.fqn.getFQN();
                    this.fqn.enterClass(node);
                    WorkingCopy.this.overlay.registerClass(parent, this.fqn.getFQN(), node);
                    super.visitClass(node, p);
                    this.fqn.leaveClass();
                    return null;
                }
            }.scan((Tree)diffContext.origUnit, (Void)null);
        } else {
            TreePath topLevel = new TreePath(diffContext.origUnit);
            pathsToRewrite.add(topLevel);
            parent2Rewrites.put(topLevel, this.changes);
            fillImports = false;
        }
        ArrayList<CasualDiff.Diff> diffs = new ArrayList<CasualDiff.Diff>();
        ImportAnalysis2 ia = new ImportAnalysis2(this);
        boolean importsFilled = false;
        for (TreePath path : pathsToRewrite) {
            ArrayList<ClassTree> classes = new ArrayList<ClassTree>();
            if (path.getParentPath() != null) {
                for (Tree t : path.getParentPath()) {
                    if (t.getKind() == Tree.Kind.COMPILATION_UNIT && !importsFilled) {
                        CompilationUnitTree cutt = (CompilationUnitTree)t;
                        ia.setCompilationUnit(cutt);
                        ia.setPackage(cutt.getPackageName());
                        ia.setImports(cutt.getImports());
                        importsFilled = true;
                    }
                    if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)t.getKind())) continue;
                    classes.add((ClassTree)t);
                }
            } else if (path.getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT && ((Map)parent2Rewrites.get(path)).size() == 1) {
                CompilationUnitTree origCUT = (CompilationUnitTree)path.getLeaf();
                Tree nue = (Tree)((Map)parent2Rewrites.get(path)).get(origCUT);
                if (nue != null && nue.getKind() == Tree.Kind.COMPILATION_UNIT) {
                    CompilationUnitTree nueCUT = (CompilationUnitTree)nue;
                    if (Utilities.compareObjects(origCUT.getPackageAnnotations(), nueCUT.getPackageAnnotations()) && Utilities.compareObjects((Object)origCUT.getPackageName(), (Object)nueCUT.getPackageName()) && Utilities.compareObjects(origCUT.getTypeDecls(), nueCUT.getTypeDecls())) {
                        fillImports = false;
                        diffs.addAll(CasualDiff.diff(this.getContext(), diffContext, origCUT.getImports(), nueCUT.getImports(), userInfo, this.tree2Tag, tag2Span, oldTrees));
                        continue;
                    }
                }
            }
            Collections.reverse(classes);
            for (ClassTree ct : classes) {
                ia.classEntered(ct);
                ia.enterVisibleThroughClasses(ct);
            }
            Tree brandNew = this.getTreeUtilities().translate(path.getLeaf(), (Map)parent2Rewrites.get(path), ia, this.tree2Tag);
            for (ClassTree ct : classes) {
                ia.classLeft();
            }
            if (brandNew.getKind() == Tree.Kind.COMPILATION_UNIT) {
                fillImports = false;
            }
            diffs.addAll(CasualDiff.diff(this.getContext(), diffContext, path, (JCTree)brandNew, userInfo, this.tree2Tag, tag2Span, oldTrees));
        }
        if (fillImports && (nueImports = ia.getImports()) != null && !nueImports.isEmpty()) {
            CompilationUnitTree ncut = GeneratorUtilities.get(this).addImports(diffContext.origUnit, nueImports);
            diffs.addAll(CasualDiff.diff(this.getContext(), diffContext, diffContext.origUnit.getImports(), ncut.getImports(), userInfo, this.tree2Tag, tag2Span, oldTrees));
        }
        diffs.addAll(this.textualChanges);
        userInfo.putAll(this.userInfo);
        try {
            return DiffUtilities.diff2ModificationResultDifference(diffContext.file, diffContext.positionConverter, userInfo, WorkingCopy.codeForCompilationUnit(diffContext.origUnit), diffs);
        }
        catch (IOException ex) {
            if (!diffContext.file.isValid()) {
                Logger.getLogger(WorkingCopy.class.getName()).log(Level.FINE, null, ex);
                return Collections.emptyList();
            }
            throw ex;
        }
    }

    private List<ModificationResult.Difference> processExternalCUs(Map<?, int[]> tag2Span, Set<Tree> syntheticTrees) {
        if (this.externalChanges == null) {
            return Collections.emptyList();
        }
        LinkedList<ModificationResult.Difference> result = new LinkedList<ModificationResult.Difference>();
        for (CompilationUnitTree t : this.externalChanges.values()) {
            try {
                FileObject targetFile = this.doCreateFromTemplate(t);
                CompilationUnitTree templateCUT = (CompilationUnitTree)this.impl.getJavacTask().parse(new JavaFileObject[]{FileObjects.nbFileObject(targetFile, targetFile.getParent())}).iterator().next();
                CompilationUnitTree importComments = GeneratorUtilities.get(this).importComments(templateCUT, templateCUT);
                this.changes.put(importComments, t);
                StringWriter target = new StringWriter();
                ModificationResult.commit(targetFile, this.processCurrentCompilationUnit(new DiffContext(this, templateCUT, WorkingCopy.codeForCompilationUnit(templateCUT), new PositionConverter(), targetFile, syntheticTrees, this.getFileObject() != null ? this.getCompilationUnit() : null, this.getFileObject() != null ? this.getText() : null), tag2Span), target);
                result.add(new ModificationResult.CreateChange(t.getSourceFile(), target.toString()));
                target.close();
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return result;
    }

    String template(ElementKind kind) {
        if (kind == null) {
            return "Templates/Classes/Empty.java";
        }
        switch (kind) {
            case CLASS: {
                return "Templates/Classes/Class.java";
            }
            case INTERFACE: {
                return "Templates/Classes/Interface.java";
            }
            case ANNOTATION_TYPE: {
                return "Templates/Classes/AnnotationType.java";
            }
            case ENUM: {
                return "Templates/Classes/Enum.java";
            }
            case PACKAGE: {
                return "Templates/Classes/package-info.java";
            }
        }
        Logger.getLogger(WorkingCopy.class.getName()).log(Level.SEVERE, "Cannot resolve template for {0}", (Object)kind);
        return "Templates/Classes/Empty.java";
    }

    FileObject doCreateFromTemplate(CompilationUnitTree cut) throws IOException {
        ElementKind kind;
        if ("package-info.java".equals(cut.getSourceFile().getName())) {
            kind = ElementKind.PACKAGE;
        } else if (cut.getTypeDecls().isEmpty()) {
            kind = null;
        } else {
            switch (cut.getTypeDecls().get(0).getKind()) {
                case CLASS: {
                    kind = ElementKind.CLASS;
                    break;
                }
                case INTERFACE: {
                    kind = ElementKind.INTERFACE;
                    break;
                }
                case ANNOTATION_TYPE: {
                    kind = ElementKind.ANNOTATION_TYPE;
                    break;
                }
                case ENUM: {
                    kind = ElementKind.ENUM;
                    break;
                }
                default: {
                    Logger.getLogger(WorkingCopy.class.getName()).log(Level.SEVERE, "Cannot resolve template for {0}", (Object)cut.getTypeDecls().get(0).getKind());
                    kind = null;
                }
            }
        }
        FileObject template = FileUtil.getConfigFile((String)this.template(kind));
        return this.doCreateFromTemplate(template, cut.getSourceFile());
    }

    FileObject doCreateFromTemplate(FileObject template, JavaFileObject sourceFile) throws IOException {
        FileObject scratchFolder = FileUtil.createMemoryFileSystem().getRoot();
        if (template == null) {
            return scratchFolder.createData("out", "java");
        }
        DataObject templateDO = DataObject.find((FileObject)template);
        if (!templateDO.isTemplate()) {
            return scratchFolder.createData("out", "java");
        }
        File pack = Utilities.toFile((URI)sourceFile.toUri()).getParentFile();
        while (FileUtil.toFileObject((File)pack) == null) {
            pack = pack.getParentFile();
        }
        FileObject targetFolder = FileUtil.toFileObject((File)pack);
        DataFolder targetDataFolder = DataFolder.findFolder((FileObject)targetFolder);
        scratchFolder.setAttribute(OverlayTemplateAttributesProvider.ATTR_ORIG_FILE, (Object)targetDataFolder);
        String name = FileObjects.getName(sourceFile, true);
        DataObject newFile = templateDO.createFromTemplate(DataFolder.findFolder((FileObject)scratchFolder), name);
        return newFile.getPrimaryFile();
    }

    List<ModificationResult.Difference> getChanges(Map<?, int[]> tag2Span) throws IOException, BadLocationException {
        if (this.afterCommit) {
            throw new IllegalStateException("The commit method can be called only once on a WorkingCopy instance");
        }
        this.afterCommit = true;
        if (this.changes == null) {
            return null;
        }
        if (this.externalChanges != null) {
            for (CompilationUnitTree t : this.externalChanges.values()) {
                final ElementOverlay.FQNComputer fqn = new ElementOverlay.FQNComputer();
                fqn.setCompilationUnit(t);
                this.overlay.registerPackage(fqn.getFQN());
                new TreeScanner<Void, Void>(){

                    @Override
                    public Void visitClass(ClassTree node, Void p) {
                        String parent = fqn.getFQN();
                        fqn.enterClass(node);
                        WorkingCopy.this.overlay.registerClass(parent, fqn.getFQN(), node);
                        super.visitClass(node, p);
                        fqn.leaveClass();
                        return null;
                    }
                }.scan(t, null);
            }
        }
        LinkedList<ModificationResult.Difference> result = new LinkedList<ModificationResult.Difference>();
        HashSet<Tree> syntheticTrees = new HashSet<Tree>();
        if (this.getFileObject() != null) {
            result.addAll(this.processCurrentCompilationUnit(new DiffContext(this, syntheticTrees), tag2Span));
        }
        result.addAll(this.processExternalCUs(tag2Span, syntheticTrees));
        this.overlay.clearElementsCache();
        return result;
    }

    private void createCompilationUnit(JCTree.JCCompilationUnit unitTree) {
        if (this.externalChanges == null) {
            this.externalChanges = new HashMap<JavaFileObject, CompilationUnitTree>();
        }
        this.externalChanges.put(unitTree.getSourceFile(), unitTree);
    }

    static {
        REWRITE_WHOLE_FILE = Boolean.getBoolean(WorkingCopy.class.getName() + ".rewrite-whole-file");
    }

    class Translator
    extends ImmutableTreeTranslator {
        private Map<Tree, Tree> changeMap;

        public Translator() {
            super(WorkingCopy.this);
        }

        Tree translate(Tree tree, Map<Tree, Tree> changeMap) {
            this.changeMap = new HashMap<Tree, Tree>(changeMap);
            return this.translate(tree);
        }

        @Override
        public Tree translate(Tree tree) {
            assert (this.changeMap != null);
            if (tree == null) {
                return null;
            }
            Tree repl = this.changeMap.remove(tree);
            Tree newRepl = repl != null ? this.translate(repl) : super.translate(tree);
            return newRepl;
        }
    }
}

