/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.javadoc.Doc;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Scope;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.JavacScope;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javadoc.DocEnv;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.java.source.JavadocEnv;
import org.netbeans.modules.java.source.builder.ElementsService;

public final class ElementUtilities {
    private final Context ctx;
    private final ElementsService delegate;
    private final CompilationInfo info;

    ElementUtilities(@NonNull CompilationInfo info) {
        this(info.impl.getJavacTask(), info);
    }

    ElementUtilities(@NonNull JavacTaskImpl jt) {
        this(jt, null);
    }

    private ElementUtilities(@NonNull JavacTaskImpl jt, @NullAllowed CompilationInfo info) {
        this.ctx = jt.getContext();
        this.delegate = ElementsService.instance(this.ctx);
        this.info = info;
    }

    public TypeElement enclosingTypeElement(Element element) throws IllegalArgumentException {
        return ElementUtilities.enclosingTypeElementImpl(element);
    }

    static TypeElement enclosingTypeElementImpl(Element element) throws IllegalArgumentException {
        if (element.getKind() == ElementKind.PACKAGE) {
            throw new IllegalArgumentException();
        }
        if ((element = element.getEnclosingElement()).getKind() == ElementKind.PACKAGE) {
            return null;
        }
        while (element != null && !element.getKind().isClass() && !element.getKind().isInterface()) {
            element = element.getEnclosingElement();
        }
        return (TypeElement)element;
    }

    public TypeElement outermostTypeElement(Element element) {
        return this.delegate.outermostTypeElement(element);
    }

    public Element getImplementationOf(ExecutableElement method, TypeElement origin) {
        return this.delegate.getImplementationOf(method, origin);
    }

    public boolean isSynthetic(Element element) {
        return (((Symbol)element).flags() & 0x1000L) != 0L || (((Symbol)element).flags() & 0x1000000000L) != 0L;
    }

    public boolean overridesMethod(ExecutableElement element) {
        return this.delegate.overridesMethod(element);
    }

    public static String getBinaryName(TypeElement element) throws IllegalArgumentException {
        if (element instanceof Symbol.TypeSymbol) {
            return ((Symbol.TypeSymbol)((Object)element)).flatName().toString();
        }
        throw new IllegalArgumentException();
    }

    public Doc javaDocFor(Element element) {
        if (element != null) {
            DocEnv env = DocEnv.instance((Context)this.ctx);
            switch (element.getKind()) {
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    return env.getClassDoc((Symbol.ClassSymbol)element);
                }
                case ENUM_CONSTANT: 
                case FIELD: {
                    return env.getFieldDoc((Symbol.VarSymbol)element);
                }
                case METHOD: {
                    if (((Symbol.MethodSymbol)element).enclClass().getKind() == ElementKind.ANNOTATION_TYPE) {
                        return env.getAnnotationTypeElementDoc((Symbol.MethodSymbol)element);
                    }
                    return env.getMethodDoc((Symbol.MethodSymbol)element);
                }
                case CONSTRUCTOR: {
                    return env.getConstructorDoc((Symbol.MethodSymbol)element);
                }
                case PACKAGE: {
                    return env.getPackageDoc((Symbol.PackageSymbol)element);
                }
            }
        }
        return null;
    }

    public Element elementFor(Doc doc) {
        return doc instanceof JavadocEnv.ElementHolder ? ((JavadocEnv.ElementHolder)doc).getElement() : null;
    }

    public Iterable<? extends Element> getMembers(TypeMirror type, ElementAcceptor acceptor) {
        ArrayList<Element> members = new ArrayList<Element>();
        if (type != null) {
            JavacElements elements = JavacElements.instance(this.ctx);
            switch (type.getKind()) {
                case DECLARED: 
                case UNION: {
                    TypeElement te = (TypeElement)((DeclaredType)type).asElement();
                    for (Element element : elements.getAllMembers(te)) {
                        if (acceptor != null && !acceptor.accept(element, type) || this.isHidden(element, members, elements)) continue;
                        members.add(element);
                    }
                    if (te.getKind().isClass()) {
                        Symbol.VarSymbol thisPseudoMember = new Symbol.VarSymbol(262160L, Names.instance((Context)this.ctx)._this, (Type.ClassType)te.asType(), (Symbol.ClassSymbol)te);
                        if (acceptor == null || acceptor.accept(thisPseudoMember, type)) {
                            members.add(thisPseudoMember);
                        }
                        if (te.getSuperclass().getKind() == TypeKind.DECLARED) {
                            Symbol.VarSymbol varSymbol = new Symbol.VarSymbol(262160L, Names.instance((Context)this.ctx)._super, (Type.ClassType)te.getSuperclass(), (Symbol.ClassSymbol)te);
                            if (acceptor == null || acceptor.accept(varSymbol, type)) {
                                members.add(varSymbol);
                            }
                        }
                    }
                }
                case BOOLEAN: 
                case BYTE: 
                case CHAR: 
                case DOUBLE: 
                case FLOAT: 
                case INT: 
                case LONG: 
                case SHORT: 
                case VOID: {
                    Type t = Symtab.instance((Context)this.ctx).classType;
                    List<Type> list = Source.instance(this.ctx).allowGenerics() ? List.of((Type)type) : List.nil();
                    t = new Type.ClassType(t.getEnclosingType(), list, t.tsym);
                    Symbol.VarSymbol classPseudoMember = new Symbol.VarSymbol(25L, Names.instance((Context)this.ctx)._class, t, ((Type)type).tsym);
                    if (acceptor != null && !acceptor.accept(classPseudoMember, type)) break;
                    members.add(classPseudoMember);
                    break;
                }
                case ARRAY: {
                    for (Element element : elements.getAllMembers((TypeElement)((Object)((Type)type).tsym))) {
                        if (acceptor != null && !acceptor.accept(element, type)) continue;
                        members.add(element);
                    }
                    Type t = Symtab.instance((Context)this.ctx).classType;
                    List<Type> list = Source.instance(this.ctx).allowGenerics() ? List.of((Type)type) : List.nil();
                    t = new Type.ClassType(t.getEnclosingType(), list, t.tsym);
                    Symbol.VarSymbol classPseudoMember = new Symbol.VarSymbol(25L, Names.instance((Context)this.ctx)._class, t, ((Type)type).tsym);
                    if (acceptor != null && !acceptor.accept(classPseudoMember, type)) break;
                    members.add(classPseudoMember);
                }
            }
        }
        return members;
    }

    public Iterable<? extends Element> getLocalMembersAndVars(Scope scope, ElementAcceptor acceptor) {
        ArrayList<Element> members = new ArrayList<Element>();
        JavacElements elements = JavacElements.instance(this.ctx);
        while (scope != null) {
            TypeElement cls = scope.getEnclosingClass();
            if (cls != null) {
                for (Element element : scope.getLocalElements()) {
                    if (acceptor != null && !acceptor.accept(element, null) || this.isHidden(element, members, elements)) continue;
                    members.add(element);
                }
                TypeMirror type = cls.asType();
                for (Element element : elements.getAllMembers(cls)) {
                    if (acceptor != null && !acceptor.accept(element, type) || this.isHidden(element, members, elements)) continue;
                    members.add(element);
                }
            } else {
                for (Element element : scope.getLocalElements()) {
                    if (element.getKind().isClass() || element.getKind().isInterface() || acceptor != null && !acceptor.accept(element, element.getEnclosingElement().asType()) || this.isHidden(element, members, elements)) continue;
                    members.add(element);
                }
            }
            scope = scope.getEnclosingScope();
        }
        return members;
    }

    public Iterable<? extends Element> getLocalVars(Scope scope, ElementAcceptor acceptor) {
        ArrayList<Element> members = new ArrayList<Element>();
        JavacElements elements = JavacElements.instance(this.ctx);
        while (scope != null && scope.getEnclosingClass() != null) {
            for (Element element : scope.getLocalElements()) {
                if (acceptor != null && !acceptor.accept(element, null) || this.isHidden(element, members, elements)) continue;
                members.add(element);
            }
            scope = scope.getEnclosingScope();
        }
        return members;
    }

    public Iterable<? extends TypeElement> getGlobalTypes(ElementAcceptor acceptor) {
        ArrayList<TypeElement> members = new ArrayList<TypeElement>();
        JavacTrees trees = JavacTrees.instance(this.ctx);
        JavacElements elements = JavacElements.instance(this.ctx);
        for (CompilationUnitTree unit : Collections.singletonList(this.info.getCompilationUnit())) {
            Scope scope;
            TreePath path = new TreePath(unit);
            for (scope = ((Trees)trees).getScope(path); scope != null && scope instanceof JavacScope && !((JavacScope)scope).isStarImportScope(); scope = scope.getEnclosingScope()) {
                for (Element element : scope.getLocalElements()) {
                    if (!element.getKind().isClass() && !element.getKind().isInterface() || this.isHidden(element, members, elements) || acceptor != null && !acceptor.accept(element, null)) continue;
                    members.add((TypeElement)element);
                }
            }
            Element element = ((Trees)trees).getElement(path);
            if (element != null && element.getKind() == ElementKind.PACKAGE) {
                for (Element element2 : element.getEnclosedElements()) {
                    if (this.isHidden(element2, members, elements) || acceptor != null && !acceptor.accept(element2, null)) continue;
                    members.add((TypeElement)element2);
                }
            }
            while (scope != null) {
                for (Element element3 : scope.getLocalElements()) {
                    if (!element3.getKind().isClass() && !element3.getKind().isInterface() || this.isHidden(element3, members, elements) || acceptor != null && !acceptor.accept(element3, null)) continue;
                    members.add((TypeElement)element3);
                }
                scope = scope.getEnclosingScope();
            }
        }
        return members;
    }

    private boolean isHidden(Element member, java.util.List<? extends Element> members, Elements elements) {
        ListIterator<? extends Element> it = members.listIterator();
        while (it.hasNext()) {
            Element hider = it.next();
            if (hider == member) {
                return true;
            }
            if (hider.getSimpleName() != member.getSimpleName()) continue;
            if (elements.hides(hider, member)) {
                return true;
            }
            if (!elements.hides(member, hider)) continue;
            it.remove();
        }
        return false;
    }

    public boolean isLocal(Element element) {
        return this.delegate.isLocal(element);
    }

    public boolean alreadyDefinedIn(CharSequence name, ExecutableType method, TypeElement enclClass) {
        return this.delegate.alreadyDefinedIn(name, method, enclClass);
    }

    public boolean isMemberOf(Element e, TypeElement type) {
        return this.delegate.isMemberOf(e, type);
    }

    public ExecutableElement getOverriddenMethod(ExecutableElement method) {
        return this.delegate.getOverriddenMethod(method);
    }

    public boolean implementsMethod(ExecutableElement element) {
        return this.delegate.implementsMethod(element);
    }

    public java.util.List<? extends ExecutableElement> findUnimplementedMethods(TypeElement impl) {
        return this.findUnimplementedMethods(impl, impl);
    }

    public boolean isErroneous(@NullAllowed Element e) {
        if (e == null) {
            return true;
        }
        TypeMirror type = e.asType();
        if (type == null) {
            return false;
        }
        if (type.getKind() == TypeKind.ERROR || type.getKind() == TypeKind.OTHER) {
            return true;
        }
        return type instanceof Type && ((Type)type).isErroneous();
    }

    private java.util.List<? extends ExecutableElement> findUnimplementedMethods(TypeElement impl, TypeElement element) {
        ArrayList<ExecutableElement> undef = new ArrayList<ExecutableElement>();
        if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            for (Element element2 : element.getEnclosedElements()) {
                ExecutableElement ee;
                Element eeImpl;
                if (element2.getKind() != ElementKind.METHOD || !element2.getModifiers().contains((Object)Modifier.ABSTRACT) || (eeImpl = this.getImplementationOf(ee = (ExecutableElement)element2, impl)) != null && (eeImpl != ee || impl == element)) continue;
                undef.add(ee);
            }
        }
        JavacTypes types = JavacTypes.instance(this.ctx);
        com.sun.tools.javac.code.Types types2 = com.sun.tools.javac.code.Types.instance(this.ctx);
        DeclaredType implType = (DeclaredType)impl.asType();
        for (TypeMirror typeMirror : types.directSupertypes(element.asType())) {
            for (ExecutableElement executableElement : this.findUnimplementedMethods(impl, (TypeElement)((DeclaredType)typeMirror).asElement())) {
                boolean exists = false;
                ExecutableType eeType = (ExecutableType)types.asMemberOf(implType, executableElement);
                for (ExecutableElement existing : undef) {
                    TypeMirror eeReturnType;
                    ExecutableType existingType;
                    if (!existing.getSimpleName().contentEquals(executableElement.getSimpleName()) || !types.isSubsignature(existingType = (ExecutableType)types.asMemberOf(implType, existing), eeType)) continue;
                    TypeMirror existingReturnType = existingType.getReturnType();
                    if (!types.isSubtype(existingReturnType, eeReturnType = eeType.getReturnType())) {
                        if (types.isSubtype(eeReturnType, existingReturnType)) {
                            undef.remove(existing);
                            undef.add(executableElement);
                        } else if (existingReturnType.getKind() == TypeKind.DECLARED && eeReturnType.getKind() == TypeKind.DECLARED) {
                            DeclaredType subType;
                            Env<AttrContext> env = Enter.instance(this.ctx).getClassEnv((Symbol.TypeSymbol)((Object)impl));
                            DeclaredType declaredType = subType = env != null ? this.findCommonSubtype((DeclaredType)existingReturnType, (DeclaredType)eeReturnType, env) : null;
                            if (subType != null) {
                                Type mt;
                                undef.remove(existing);
                                Symbol.MethodSymbol ms = ((Symbol.MethodSymbol)existing).clone((Symbol)((Object)impl));
                                ms.type = mt = types2.createMethodTypeWithReturn((Type.MethodType)ms.type, (Type)((Object)subType));
                                undef.add(ms);
                            }
                        }
                    }
                    exists = true;
                    break;
                }
                if (exists) continue;
                undef.add(executableElement);
            }
        }
        return undef;
    }

    private DeclaredType findCommonSubtype(DeclaredType type1, DeclaredType type2, Env<AttrContext> env) {
        java.util.List<DeclaredType> subtypes1 = this.getSubtypes(type1, env);
        java.util.List<DeclaredType> subtypes2 = this.getSubtypes(type2, env);
        Types types = this.info.getTypes();
        for (DeclaredType subtype1 : subtypes1) {
            for (DeclaredType subtype2 : subtypes2) {
                if (types.isSubtype(subtype1, subtype2)) {
                    return subtype1;
                }
                if (!types.isSubtype(subtype2, subtype1)) continue;
                return subtype2;
            }
        }
        return null;
    }

    private java.util.List<DeclaredType> getSubtypes(DeclaredType baseType, Env<AttrContext> env) {
        LinkedList<DeclaredType> subtypes = new LinkedList<DeclaredType>();
        HashSet<TypeElement> elems = new HashSet<TypeElement>();
        LinkedList<DeclaredType> bases = new LinkedList<DeclaredType>();
        bases.add(baseType);
        ClassIndex index = this.info.getClasspathInfo().getClassIndex();
        Trees trees = this.info.getTrees();
        Types types = this.info.getTypes();
        Resolve resolve = Resolve.instance(this.ctx);
        while (!bases.isEmpty()) {
            DeclaredType head = (DeclaredType)bases.remove();
            TypeElement elem = (TypeElement)head.asElement();
            if (!elems.add(elem)) continue;
            subtypes.add(head);
            java.util.List<? extends TypeMirror> tas = head.getTypeArguments();
            boolean isRaw = !tas.iterator().hasNext();
            block1: for (ElementHandle<TypeElement> eh : index.getElements(ElementHandle.create(elem), EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.allOf(ClassIndex.SearchScope.class))) {
                TypeElement e = eh.resolve(this.info);
                if (e == null || !resolve.isAccessible(env, (Symbol.TypeSymbol)((Object)e))) continue;
                if (isRaw) {
                    DeclaredType dt = types.getDeclaredType(e, new TypeMirror[0]);
                    bases.add(dt);
                    continue;
                }
                HashMap<Element, TypeMirror> map = new HashMap<Element, TypeMirror>();
                TypeMirror sup = e.getSuperclass();
                if (sup.getKind() == TypeKind.DECLARED && ((DeclaredType)sup).asElement() == elem) {
                    DeclaredType dt = (DeclaredType)sup;
                    Iterator<? extends TypeMirror> iterator = tas.iterator();
                    Iterator<? extends TypeMirror> it = dt.getTypeArguments().iterator();
                    while (it.hasNext() && iterator.hasNext()) {
                        TypeMirror stm;
                        TypeMirror basetm = iterator.next();
                        if (basetm == (stm = it.next())) continue;
                        if (stm.getKind() != TypeKind.TYPEVAR) continue block1;
                        map.put(((TypeVariable)stm).asElement(), basetm);
                    }
                    if (it.hasNext() != iterator.hasNext()) {
                        continue;
                    }
                } else {
                    for (TypeMirror typeMirror : e.getInterfaces()) {
                        if (((DeclaredType)typeMirror).asElement() != elem) continue;
                        DeclaredType dt = (DeclaredType)typeMirror;
                        Iterator<? extends TypeMirror> ittas = tas.iterator();
                        Iterator<? extends TypeMirror> it = dt.getTypeArguments().iterator();
                        while (it.hasNext() && ittas.hasNext()) {
                            TypeMirror stm;
                            TypeMirror basetm = ittas.next();
                            if (basetm == (stm = it.next())) continue;
                            if (stm.getKind() != TypeKind.TYPEVAR) continue block1;
                            map.put(((TypeVariable)stm).asElement(), basetm);
                        }
                        if (it.hasNext() != ittas.hasNext()) continue block1;
                    }
                }
                bases.add(this.getDeclaredType(e, map, types));
            }
        }
        return subtypes;
    }

    private DeclaredType getDeclaredType(TypeElement e, HashMap<? extends Element, ? extends TypeMirror> map, Types types) {
        java.util.List<? extends TypeParameterElement> tpes = e.getTypeParameters();
        TypeMirror[] targs = new TypeMirror[tpes.size()];
        int i = 0;
        for (TypeParameterElement typeParameterElement : tpes) {
            TypeMirror t = map.get(typeParameterElement);
            targs[i++] = t != null ? t : typeParameterElement.asType();
        }
        Element encl = e.getEnclosingElement();
        if ((encl.getKind().isClass() || encl.getKind().isInterface()) && !((TypeElement)encl).getTypeParameters().isEmpty()) {
            return types.getDeclaredType(this.getDeclaredType((TypeElement)encl, map, types), e, targs);
        }
        return types.getDeclaredType(e, targs);
    }

    public static interface ElementAcceptor {
        public boolean accept(Element var1, TypeMirror var2);
    }
}

