/*
 * Decompiled with CFR 0.152.
 */
package b2s.clipboard.history;

import b2s.clipboard.history.ClipboardHistory;
import b2s.clipboard.history.ClipboardHistoryInstaller;
import b2s.clipboard.history.EditorCookieUtil;
import b2s.clipboard.history.HistoryDialogDisplayer;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JEditorPane;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;
import org.openide.util.datatransfer.ExClipboard;

public class PasteFromHistoryAction
extends CookieAction {
    private ClipboardHistory clipboardHistory;
    private ExClipboard clipboard;
    private HistoryDialogDisplayer dialogDisplayer = new HistoryDialogDisplayer();
    private EditorCookieUtil editorCookieUtil;

    public PasteFromHistoryAction() {
        this.clipboardHistory = ClipboardHistoryInstaller.CLIPBOARD_HISTORY;
        this.clipboard = (ExClipboard)Lookup.getDefault().lookup(ExClipboard.class);
        this.editorCookieUtil = new EditorCookieUtil();
    }

    protected boolean enable(Node[] activatedNodes) {
        if (this.editorCookieUtil.hasEditor(activatedNodes)) {
            JEditorPane editor = this.editorCookieUtil.editor(activatedNodes);
            ActionMap actions = editor.getActionMap();
            return actions.get("paste").isEnabled();
        }
        return false;
    }

    protected int mode() {
        return 8;
    }

    protected Class<?>[] cookieClasses() {
        return new Class[]{EditorCookie.class};
    }

    protected void performAction(Node[] nodes) {
        int row;
        if (this.clipboardHistory.hasContents() && (row = this.dialogDisplayer.display(this.clipboardHistory)) >= 0) {
            this.clipboardHistory.moveToTop(row);
            StringSelection string = new StringSelection(this.clipboardHistory.top());
            this.clipboard.setContents((Transferable)string, (ClipboardOwner)string);
            JEditorPane editor = this.editorCookieUtil.editor(nodes);
            ActionMap actions = editor.getActionMap();
            Action paste = actions.get("paste");
            paste.actionPerformed(new ActionEvent(editor, editor.hashCode(), ""));
        }
    }

    public String getName() {
        return NbBundle.getMessage(PasteFromHistoryAction.class, (String)"CTL_PasteFromHistoryAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    void setHistoryDialogDisplayer(HistoryDialogDisplayer dialogDisplayer) {
        this.dialogDisplayer = dialogDisplayer;
    }

    void setClipboardHistory(ClipboardHistory clipboardHistory) {
        this.clipboardHistory = clipboardHistory;
    }

    void setClipboard(ExClipboard clipboard) {
        this.clipboard = clipboard;
    }

    void setEditorCookieUtil(EditorCookieUtil editorCookieUtil) {
        this.editorCookieUtil = editorCookieUtil;
    }
}

