/*
 * Decompiled with CFR 0.152.
 */
package b2s.clipboard.history;

import b2s.clipboard.history.ClipboardContentsCellRenderer;
import b2s.clipboard.history.ClipboardHistory;
import b2s.clipboard.history.ClipboardHistoryTableModel;
import b2s.clipboard.history.WrappedScrollingListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.jdesktop.layout.GroupLayout;

public class ClipboardHistoryPanel
extends JPanel {
    public static final int ID_WIDTH = 30;
    private int selectedRow;
    private JTable clipboardEntries;
    private JEditorPane content;

    public ClipboardHistoryPanel(ClipboardHistory clipboardHistory) {
        this.initComponents();
        final ClipboardHistoryTableModel model = new ClipboardHistoryTableModel(clipboardHistory.toList());
        this.clipboardEntries.setModel(model);
        TableColumn idColumn = this.clipboardEntries.getColumnModel().getColumn(0);
        idColumn.setWidth(30);
        idColumn.setPreferredWidth(30);
        idColumn.setMaxWidth(30);
        idColumn.setMinWidth(30);
        idColumn.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!isSelected) {
                    component.setForeground(Color.GRAY);
                }
                return component;
            }
        });
        this.clipboardEntries.getColumnModel().getColumn(1).setCellRenderer(new ClipboardContentsCellRenderer());
        this.clipboardEntries.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                String text = "";
                int row = ClipboardHistoryPanel.this.clipboardEntries.getSelectedRow();
                if (row >= 0) {
                    text = model.getValueAt(row, 1).toString();
                }
                ClipboardHistoryPanel.this.content.setText(text);
                ClipboardHistoryPanel.this.content.setCaretPosition(0);
                ClipboardHistoryPanel.this.selectedRow = row;
            }
        });
        if (clipboardHistory.hasContents()) {
            this.clipboardEntries.setRowSelectionInterval(0, 0);
        }
        this.clipboardEntries.getInputMap(1).put(KeyStroke.getKeyStroke(9, 0), "focusNextComponent");
        this.clipboardEntries.getActionMap().put("focusNextComponent", new ForwardFocusAction(this.clipboardEntries));
        this.clipboardEntries.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "cancel");
        this.clipboardEntries.addKeyListener(new WrappedScrollingListener(this.clipboardEntries));
    }

    public int getSelectedRow() {
        return this.selectedRow;
    }

    private void initComponents() {
        JSplitPane jSplitPane1 = new JSplitPane();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.clipboardEntries = new JTable();
        JScrollPane jScrollPane2 = new JScrollPane();
        this.content = new JEditorPane();
        jSplitPane1.setDividerLocation(150);
        jSplitPane1.setOrientation(0);
        this.clipboardEntries.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.clipboardEntries.setIntercellSpacing(new Dimension(0, 0));
        this.clipboardEntries.setSelectionMode(1);
        this.clipboardEntries.setShowHorizontalLines(false);
        this.clipboardEntries.setShowVerticalLines(false);
        this.clipboardEntries.setSurrendersFocusOnKeystroke(true);
        this.clipboardEntries.setTableHeader(null);
        jScrollPane1.setViewportView(this.clipboardEntries);
        jSplitPane1.setTopComponent(jScrollPane1);
        this.content.setEditable(false);
        this.content.setFont(new Font("Courier New", 0, 14));
        this.content.setFocusable(false);
        jScrollPane2.setViewportView(this.content);
        jSplitPane1.setRightComponent(jScrollPane2);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(12, 12, 12).add(jSplitPane1, -2, 451, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(20, 20, 20).add(jSplitPane1, -1, 373, Short.MAX_VALUE).addContainerGap()));
    }

    private static class ForwardFocusAction
    extends AbstractAction {
        private JComponent component;

        public ForwardFocusAction(JComponent component) {
            this.component = component;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FocusManager.getCurrentKeyboardFocusManager().focusNextComponent(this.component);
        }
    }
}

