/*
 * Decompiled with CFR 0.152.
 */
package b2s.clipboard.history;

import b2s.clipboard.history.ClipboardContentGrabber;
import b2s.clipboard.history.ClipboardHistory;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import org.openide.modules.ModuleInstall;
import org.openide.util.Lookup;
import org.openide.util.datatransfer.ClipboardEvent;
import org.openide.util.datatransfer.ClipboardListener;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.windows.WindowManager;

public class ClipboardHistoryInstaller
extends ModuleInstall
implements ClipboardListener,
WindowFocusListener {
    private static final ClipboardContentGrabber CLIPBOARD_CONTENT_GRABBER = new ClipboardContentGrabber();
    public static ClipboardHistory CLIPBOARD_HISTORY;

    public void restored() {
        CLIPBOARD_HISTORY = new ClipboardHistory();
        ExClipboard clipboard = (ExClipboard)Lookup.getDefault().lookup(ExClipboard.class);
        clipboard.addClipboardListener((ClipboardListener)this);
        this.addClipboardContentsToHistory();
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                Frame window = WindowManager.getDefault().getMainWindow();
                window.addWindowFocusListener(ClipboardHistoryInstaller.this);
            }
        });
    }

    public void clipboardChanged(ClipboardEvent ce) {
        this.addClipboardContentsToHistory();
    }

    private void addClipboardContentsToHistory() {
        CLIPBOARD_HISTORY.add(CLIPBOARD_CONTENT_GRABBER.grab());
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        this.addClipboardContentsToHistory();
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
    }
}

