/*
 * Decompiled with CFR 0.152.
 */
package b2s.clipboard.history;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ClipboardHistory {
    private LinkedList<String> contents = new LinkedList();
    private final int maxNumberOfContents;

    public ClipboardHistory() {
        this(20);
    }

    public ClipboardHistory(int maxNumberOfContents) {
        this.maxNumberOfContents = maxNumberOfContents;
    }

    public void add(String text) {
        if (text == null) {
            return;
        }
        if (!this.contents.contains(text)) {
            this.contents.addFirst(text);
        } else {
            int index = this.contents.indexOf(text);
            this.moveToTop(index);
        }
        if (this.contents.size() > this.maxNumberOfContents) {
            this.contents.removeLast();
        }
    }

    public List<String> toList() {
        return Collections.unmodifiableList(this.contents);
    }

    public void moveToTop(int row) {
        this.contents.addFirst(this.contents.remove(row));
    }

    public boolean hasContents() {
        return this.contents.size() > 0;
    }

    public String top() {
        return this.hasContents() ? this.contents.getFirst() : null;
    }
}

