/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgijavaeebase;

import com.sun.enterprise.deploy.shared.AbstractReadableArchive;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.osgijavaeebase.BundleResource;
import org.glassfish.osgijavaeebase.JarHelper;
import org.glassfish.osgijavaeebase.URIable;
import org.osgi.framework.Bundle;
import org.osgi.service.url.AbstractURLStreamHandlerService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiBundleArchive
extends AbstractReadableArchive
implements URIable,
Iterable<BundleResource> {
    private Bundle b;
    private String name;
    private URI uri;
    private Map<String, ReadableArchive> subArchives = new HashMap<String, ReadableArchive>();

    public OSGiBundleArchive(Bundle b) {
        this.b = b;
        this.init();
    }

    private void init() {
        File file;
        String location = this.b.getLocation();
        if (location != null && location.startsWith("reference:") && (location = location.substring("reference:".length())).startsWith("file:") && (file = new File((location = URLDecoder.decode(location)).substring("file:".length()))).exists()) {
            this.uri = file.toURI();
        }
        String symName = this.b.getSymbolicName();
        String version = (String)this.b.getHeaders().get("Bundle-Version");
        this.name = symName != null ? (version == null ? symName : symName.concat("_").concat(version)) : location;
    }

    public void close() throws IOException {
    }

    public Enumeration<String> entries() {
        ArrayList<String> entries = new ArrayList<String>();
        this.getEntryPaths(entries, "/");
        ListIterator<String> entriesIter = entries.listIterator();
        while (entriesIter.hasNext()) {
            String next = entriesIter.next();
            if (!next.endsWith("/")) continue;
            entriesIter.remove();
        }
        return Collections.enumeration(entries);
    }

    public Collection<String> getDirectories() throws IOException {
        return this.getSubDiretcories("/");
    }

    private Collection<String> getSubDiretcories(String path) {
        Enumeration firstLevelEntries = this.b.getEntryPaths(path);
        if (firstLevelEntries == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> firstLevelDirs = new ArrayList<String>();
        while (firstLevelEntries.hasMoreElements()) {
            String firstLevelEntry = (String)firstLevelEntries.nextElement();
            if (!firstLevelEntry.endsWith("/")) continue;
            firstLevelDirs.add(firstLevelEntry);
        }
        return firstLevelDirs;
    }

    private void getEntryPaths(Collection<String> entries, String path) {
        Enumeration subPaths = this.b.getEntryPaths(path);
        if (subPaths != null) {
            while (subPaths.hasMoreElements()) {
                String next = (String)subPaths.nextElement();
                if ("META-INF/".equals(next) && entries.contains(next)) continue;
                entries.add(next);
                this.getEntryPaths(entries, next);
            }
        }
    }

    private void getEntryPaths2(Collection<String> entries, String path) {
        Enumeration e = this.b.findEntries(path.startsWith("/") ? path : "/".concat(path), "*", true);
        if (e != null) {
            while (e.hasMoreElements()) {
                URL next = (URL)e.nextElement();
                String nextPath = next.getPath();
                entries.add(nextPath.substring(1));
            }
        }
    }

    public Enumeration<String> entries(String prefix) {
        ArrayList<String> entries = new ArrayList<String>();
        this.getEntryPaths(entries, prefix);
        return Collections.enumeration(entries);
    }

    public boolean isDirectory(String name) {
        return this.b.getEntry(name.endsWith("/") ? name : name + "/") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Manifest getManifest() throws IOException {
        URL url = this.b.getEntry("META-INF/MANIFEST.MF");
        if (url != null) {
            Manifest manifest;
            InputStream is = url.openStream();
            try {
                manifest = new Manifest(is);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                is.close();
                throw throwable;
            }
            is.close();
            return manifest;
        }
        return null;
    }

    public URI getURI() {
        return this.uri;
    }

    public long getArchiveSize() throws SecurityException {
        return -1L;
    }

    public String getName() {
        return this.name;
    }

    public InputStream getEntry(String name) throws IOException {
        URL entry = this.b.getEntry(name);
        return entry != null ? entry.openStream() : null;
    }

    public boolean exists(String name) {
        return this.b.getEntry(name) != null;
    }

    public long getEntrySize(String name) {
        return 0L;
    }

    public void open(URI uri) throws IOException {
        throw new UnsupportedOperationException("Not applicable method");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadableArchive getSubArchive(String name) throws IOException {
        if (!this.exists(name)) {
            return null;
        }
        OSGiBundleArchive oSGiBundleArchive = this;
        synchronized (oSGiBundleArchive) {
            if (!this.subArchives.containsKey(name)) {
                AbstractReadableArchive subArchive = this.isDirectory(name) ? new EmbeddedDirectoryArchive(name) : new EmbeddedJarArchive(name);
                this.subArchives.put(name, (ReadableArchive)subArchive);
            }
            return this.subArchives.get(name);
        }
    }

    public boolean exists() {
        return true;
    }

    public boolean delete() {
        return false;
    }

    public boolean renameTo(String name) {
        return false;
    }

    public void setParentArchive(ReadableArchive parentArchive) {
        throw new UnsupportedOperationException("Not supported");
    }

    public ReadableArchive getParentArchive() {
        return null;
    }

    @Override
    public URI getEntryURI(String name) {
        try {
            return this.b.getEntry(name).toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getDistanceFromTop() {
        return "";
    }

    @Override
    public Iterator<BundleResource> iterator() {
        return new BundleResourceIterator();
    }

    public InputStream getInputStream() throws IOException {
        if (this.uri != null) {
            return this.uri.toURL().openStream();
        }
        PipedInputStream is = new PipedInputStream();
        final PipedOutputStream os = new PipedOutputStream(is);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    JarOutputStream jos = new JarOutputStream((OutputStream)os, OSGiBundleArchive.this.getManifest());
                    ByteBuffer buf = ByteBuffer.allocate(1024);
                    for (String s : Collections.list(OSGiBundleArchive.this.entries())) {
                        if (s.equals("META-INF/MANIFEST.MF")) continue;
                        jos.putNextEntry(new JarEntry(s));
                        if (!OSGiBundleArchive.this.isDirectory(s)) {
                            IOException e2;
                            Object var7_7;
                            InputStream in = OSGiBundleArchive.this.getEntry(s);
                            try {
                                JarHelper.copy(in, jos, buf);
                                var7_7 = null;
                            }
                            catch (Throwable throwable) {
                                var7_7 = null;
                                try {
                                    in.close();
                                }
                                catch (IOException e2) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                            try {
                                in.close();
                            }
                            catch (IOException e2) {}
                        }
                        jos.closeEntry();
                    }
                    jos.close();
                    os.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }.start();
        return is;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BundleResourceIterator
    implements Iterator<BundleResource> {
        private static final String DOT = ".";
        private final Iterator<BundleResource> delegate;
        private final Collection<BundleResource> bundleResources = new ArrayList<BundleResource>();

        private BundleResourceIterator() {
            String bcp = (String)OSGiBundleArchive.this.b.getHeaders().get("Bundle-ClassPath");
            if (bcp == null || bcp.isEmpty()) {
                bcp = DOT;
            }
            String seps = ";,";
            StringTokenizer bcpes = new StringTokenizer(bcp, seps);
            ArrayList<OSGiBundleArchive> archives = new ArrayList<OSGiBundleArchive>();
            while (bcpes.hasMoreTokens()) {
                String bcpe = bcpes.nextToken();
                if ((bcpe = bcpe.trim()).startsWith("/")) {
                    bcpe = bcpe.substring(1);
                }
                if (bcpe.equals(DOT)) {
                    archives.add(OSGiBundleArchive.this);
                    continue;
                }
                if (OSGiBundleArchive.this.isDirectory(bcpe) && !bcpe.endsWith("/")) {
                    bcpe = bcpe.concat("/");
                }
                try {
                    ReadableArchive readableArchive = OSGiBundleArchive.this.getSubArchive(bcpe);
                    if (readableArchive == null) continue;
                    archives.add((OSGiBundleArchive)readableArchive);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            for (ReadableArchive readableArchive : archives) {
                Enumeration entries = readableArchive.entries();
                URIable urIable = (URIable)URIable.class.cast(readableArchive);
                while (entries.hasMoreElements()) {
                    String entry = (String)entries.nextElement();
                    URI uri = urIable.getEntryURI(entry);
                    String archivePath = urIable.getDistanceFromTop();
                    BundleResource bundleResource = new BundleResource(uri, entry, archivePath);
                    this.bundleResources.add(bundleResource);
                }
            }
            this.delegate = this.bundleResources.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public BundleResource next() {
            return this.delegate.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EmbeddedDirectoryArchive
    extends AbstractReadableArchive
    implements ReadableArchive,
    URIable {
        private String distanceFromTop;

        public EmbeddedDirectoryArchive(String distanceFromTop) {
            this.distanceFromTop = distanceFromTop;
        }

        public InputStream getEntry(String name) throws IOException {
            if (!this.exists(name)) {
                return null;
            }
            String bundleEntry = this.distanceFromTop + name;
            return OSGiBundleArchive.this.b.getEntry(bundleEntry).openStream();
        }

        public boolean exists(String name) {
            return OSGiBundleArchive.this.exists(this.distanceFromTop + name);
        }

        public long getEntrySize(String name) {
            return OSGiBundleArchive.this.getEntrySize(this.distanceFromTop + name);
        }

        public void open(URI uri) throws IOException {
            throw new UnsupportedOperationException();
        }

        public ReadableArchive getSubArchive(String name) throws IOException {
            return null;
        }

        public boolean exists() {
            return true;
        }

        public boolean delete() {
            return false;
        }

        public boolean renameTo(String name) {
            return false;
        }

        public void setParentArchive(ReadableArchive parentArchive) {
            throw new UnsupportedOperationException();
        }

        public ReadableArchive getParentArchive() {
            return OSGiBundleArchive.this;
        }

        public void close() throws IOException {
        }

        public Enumeration<String> entries() {
            return this.entries("");
        }

        public Enumeration<String> entries(String prefix) {
            ArrayList<String> entries = new ArrayList<String>();
            OSGiBundleArchive.this.getEntryPaths(entries, this.distanceFromTop + prefix);
            Collection<String> subEntries = this.stripEntryName(entries);
            return Collections.enumeration(subEntries);
        }

        private Collection<String> stripEntryName(Collection<String> entries) {
            ArrayList<String> subEntries = new ArrayList<String>(entries.size());
            int idx = this.distanceFromTop.length();
            for (String entry : entries) {
                subEntries.add(entry.substring(idx));
            }
            return subEntries;
        }

        public Collection<String> getDirectories() throws IOException {
            return this.stripEntryName(OSGiBundleArchive.this.getSubDiretcories(this.distanceFromTop));
        }

        public boolean isDirectory(String name) {
            return this.exists(name.endsWith("/") ? name : name + "/");
        }

        public Manifest getManifest() throws IOException {
            return null;
        }

        public URI getURI() {
            try {
                return OSGiBundleArchive.this.b.getEntry(this.distanceFromTop).toURI();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        public long getArchiveSize() throws SecurityException {
            return 0L;
        }

        public String getName() {
            return this.distanceFromTop;
        }

        @Override
        public URI getEntryURI(String name) {
            return OSGiBundleArchive.this.getEntryURI(this.distanceFromTop + name);
        }

        @Override
        public String getDistanceFromTop() {
            return this.distanceFromTop;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EmbeddedJarArchive
    extends AbstractReadableArchive
    implements URIable {
        private String distanceFromTop;
        private List<String> entries = new ArrayList<String>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EmbeddedJarArchive(String distanceFromTop) throws IOException {
            this.distanceFromTop = distanceFromTop;
            ZipInputStream zis = this.getZIS();
            try {
                ZipEntry ze;
                while ((ze = zis.getNextEntry()) != null) {
                    this.entries.add(ze.getName());
                }
                Object var6_5 = null;
                this.closeZIS(zis);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.closeZIS(zis);
                throw throwable;
            }
        }

        private ZipInputStream getZIS() throws IOException {
            return new ZipInputStream(OSGiBundleArchive.this.b.getEntry(this.distanceFromTop).openStream());
        }

        private Collection<String> getEntries() {
            return this.entries;
        }

        public InputStream getEntry(String name) throws IOException {
            ZipEntry ze;
            if (!this.exists(name)) {
                return null;
            }
            ZipInputStream zis = this.getZIS();
            while ((ze = zis.getNextEntry()) != null) {
                if (!ze.getName().equals(name)) continue;
                return zis;
            }
            assert (false);
            return null;
        }

        public boolean exists(String name) {
            return this.getEntries().contains(name);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public long getEntrySize(String name) {
            if (!this.exists(name)) {
                return 0L;
            }
            ZipInputStream zis = null;
            try {
                try {
                    ZipEntry ze;
                    zis = this.getZIS();
                    while (!name.equals((ze = zis.getNextEntry()).getName())) {
                    }
                    long l = ze.getSize();
                    Object var7_6 = null;
                    if (zis == null) return l;
                    this.closeZIS(zis);
                    return l;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (zis != null) {
                    this.closeZIS(zis);
                }
                throw throwable;
            }
        }

        public void open(URI uri) throws IOException {
            throw new UnsupportedOperationException("Not Applicable");
        }

        public ReadableArchive getSubArchive(String name) throws IOException {
            return null;
        }

        public boolean exists() {
            return true;
        }

        public boolean delete() {
            return false;
        }

        public boolean renameTo(String name) {
            return false;
        }

        public void setParentArchive(ReadableArchive parentArchive) {
            throw new UnsupportedOperationException();
        }

        public ReadableArchive getParentArchive() {
            return OSGiBundleArchive.this;
        }

        public void close() throws IOException {
        }

        public Enumeration<String> entries() {
            return Collections.enumeration(this.getEntries());
        }

        public Enumeration<String> entries(String prefix) {
            ArrayList<String> result = new ArrayList<String>();
            for (String entry : this.getEntries()) {
                if (!entry.startsWith(prefix)) continue;
                result.add(entry);
            }
            return Collections.enumeration(result);
        }

        public Collection<String> getDirectories() throws IOException {
            ArrayList<String> result = new ArrayList<String>();
            for (String entry : this.getEntries()) {
                int idx = entry.indexOf(47);
                if (idx == -1 || idx != entry.length() - 1) continue;
                result.add(entry);
            }
            return result;
        }

        public boolean isDirectory(String name) {
            return this.exists(name.endsWith("/") ? name : name + "/");
        }

        public Manifest getManifest() throws IOException {
            String name = "META-INF/MANIFEST.MF";
            return this.exists(name) ? new Manifest(this.getEntry(name)) : null;
        }

        public URI getURI() {
            try {
                return OSGiBundleArchive.this.b.getEntry(this.distanceFromTop).toURI();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        public long getArchiveSize() throws SecurityException {
            return 0L;
        }

        public String getName() {
            return this.distanceFromTop;
        }

        @Override
        public URI getEntryURI(String name) {
            return URI.create("embeddedjar:" + this.getURI() + "!/" + name);
        }

        @Override
        public String getDistanceFromTop() {
            return this.distanceFromTop;
        }

        private void closeZIS(ZipInputStream zis) {
            try {
                zis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static class EmbeddedJarURLStreamHandlerService
    extends AbstractURLStreamHandlerService {
        static final String EMBEDDED_JAR_SCHEME = "embeddedjar";
        static final String SEPARATOR = "!/";

        EmbeddedJarURLStreamHandlerService() {
        }

        public URLConnection openConnection(URL u) throws IOException {
            assert (u.getProtocol().equals(EMBEDDED_JAR_SCHEME));
            try {
                String schemeSpecificPart = u.toURI().getSchemeSpecificPart();
                int idx = schemeSpecificPart.indexOf(SEPARATOR);
                assert (idx > 0);
                URL embeddedURL = URI.create(schemeSpecificPart.substring(0, idx)).toURL();
                final URLConnection con = embeddedURL.openConnection();
                final String entryPath = schemeSpecificPart.substring(idx + 2);
                assert (entryPath.length() > 0);
                return new URLConnection(u){

                    public void connect() throws IOException {
                        con.connect();
                    }

                    public InputStream getInputStream() throws IOException {
                        JarInputStream jis = new JarInputStream(con.getInputStream());
                        JarEntry je = jis.getNextJarEntry();
                        while (je != null) {
                            if (je.getName().equals(entryPath)) {
                                return jis;
                            }
                            je = jis.getNextJarEntry();
                        }
                        throw new IOException("No entry by name " + entryPath);
                    }
                };
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

