/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.commons.collections;

import com.sun.org.apache.commons.collections.CollectionUtils;
import com.sun.org.apache.commons.collections.Predicate;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedSet;

public class SetUtils {
    private SetUtils() {
    }

    public static Set predicatedSet(Set set, Predicate predicate) {
        return new PredicatedSet(set, predicate);
    }

    public static SortedSet predicatedSortedSet(SortedSet sortedSet, Predicate predicate) {
        return new PredicatedSortedSet(sortedSet, predicate);
    }

    static class PredicatedSet
    extends CollectionUtils.PredicatedCollection
    implements Set {
        public PredicatedSet(Set set, Predicate predicate) {
            super(set, predicate);
        }
    }

    static class PredicatedSortedSet
    extends PredicatedSet
    implements SortedSet {
        public PredicatedSortedSet(SortedSet sortedSet, Predicate predicate) {
            super(sortedSet, predicate);
        }

        public SortedSet subSet(Object object, Object object2) {
            SortedSet<Object> sortedSet = this.getSortedSet().subSet(object, object2);
            return new PredicatedSortedSet(sortedSet, this.predicate);
        }

        public SortedSet headSet(Object object) {
            SortedSet<Object> sortedSet = this.getSortedSet().headSet(object);
            return new PredicatedSortedSet(sortedSet, this.predicate);
        }

        public SortedSet tailSet(Object object) {
            SortedSet<Object> sortedSet = this.getSortedSet().tailSet(object);
            return new PredicatedSortedSet(sortedSet, this.predicate);
        }

        public Object first() {
            return this.getSortedSet().first();
        }

        public Object last() {
            return this.getSortedSet().last();
        }

        public Comparator comparator() {
            return this.getSortedSet().comparator();
        }

        private SortedSet getSortedSet() {
            return (SortedSet)this.collection;
        }
    }
}

