/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.commons.collections;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class DoubleOrderedMap
extends AbstractMap {
    private Node[] rootNode = new Node[]{null, null};
    private int nodeCount = 0;
    private int modifications = 0;
    private Set[] setOfKeys = new Set[]{null, null};
    private Set[] setOfEntries = new Set[]{null, null};
    private Collection[] collectionOfValues = new Collection[]{null, null};
    private static final int KEY = 0;
    private static final int VALUE = 1;
    private static final int SUM_OF_INDICES = 1;
    private static final int FIRST_INDEX = 0;
    private static final int NUMBER_OF_INDICES = 2;
    private static final String[] dataName = new String[]{"key", "value"};

    public DoubleOrderedMap() {
    }

    public DoubleOrderedMap(Map map) throws ClassCastException, NullPointerException, IllegalArgumentException {
        this.putAll(map);
    }

    public Object getKeyForValue(Object object) throws ClassCastException, NullPointerException {
        return this.doGet((Comparable)object, 1);
    }

    public Object removeValue(Object object) {
        return this.doRemove((Comparable)object, 1);
    }

    public Set entrySetByValue() {
        if (this.setOfEntries[1] == null) {
            this.setOfEntries[1] = new AbstractSet(){

                public Iterator iterator() {
                    return new DoubleOrderedMapIterator(this, 1){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        protected Object doGetNext() {
                            return this.lastReturnedNode;
                        }
                    };
                }

                public boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object k = entry.getKey();
                    Node node = DoubleOrderedMap.this.lookup((Comparable)entry.getValue(), 1);
                    return node != null && node.getData(0).equals(k);
                }

                public boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object k = entry.getKey();
                    Node node = DoubleOrderedMap.this.lookup((Comparable)entry.getValue(), 1);
                    if (node != null && node.getData(0).equals(k)) {
                        DoubleOrderedMap.this.doRedBlackDelete(node);
                        return true;
                    }
                    return false;
                }

                public int size() {
                    return DoubleOrderedMap.this.size();
                }

                public void clear() {
                    DoubleOrderedMap.this.clear();
                }

                static /* synthetic */ DoubleOrderedMap access$000(1 var0) {
                    return var0.DoubleOrderedMap.this;
                }
            };
        }
        return this.setOfEntries[1];
    }

    public Set keySetByValue() {
        if (this.setOfKeys[1] == null) {
            this.setOfKeys[1] = new AbstractSet(){

                public Iterator iterator() {
                    return new DoubleOrderedMapIterator(this, 1){
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        protected Object doGetNext() {
                            return Node.access$200(this.lastReturnedNode, 0);
                        }
                    };
                }

                public int size() {
                    return DoubleOrderedMap.this.size();
                }

                public boolean contains(Object object) {
                    return DoubleOrderedMap.this.containsKey(object);
                }

                public boolean remove(Object object) {
                    int n = DoubleOrderedMap.this.nodeCount;
                    DoubleOrderedMap.this.remove(object);
                    return DoubleOrderedMap.this.nodeCount != n;
                }

                public void clear() {
                    DoubleOrderedMap.this.clear();
                }

                static /* synthetic */ DoubleOrderedMap access$400(3 var0) {
                    return var0.DoubleOrderedMap.this;
                }
            };
        }
        return this.setOfKeys[1];
    }

    public Collection valuesByValue() {
        if (this.collectionOfValues[1] == null) {
            this.collectionOfValues[1] = new AbstractCollection(){

                public Iterator iterator() {
                    return new DoubleOrderedMapIterator(this, 1){
                        private final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        protected Object doGetNext() {
                            return Node.access$200(this.lastReturnedNode, 1);
                        }
                    };
                }

                public int size() {
                    return DoubleOrderedMap.this.size();
                }

                public boolean contains(Object object) {
                    return DoubleOrderedMap.this.containsValue(object);
                }

                public boolean remove(Object object) {
                    int n = DoubleOrderedMap.this.nodeCount;
                    DoubleOrderedMap.this.removeValue(object);
                    return DoubleOrderedMap.this.nodeCount != n;
                }

                public boolean removeAll(Collection collection) {
                    boolean bl = false;
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        if (DoubleOrderedMap.this.removeValue(iterator.next()) == null) continue;
                        bl = true;
                    }
                    return bl;
                }

                public void clear() {
                    DoubleOrderedMap.this.clear();
                }

                static /* synthetic */ DoubleOrderedMap access$600(5 var0) {
                    return var0.DoubleOrderedMap.this;
                }
            };
        }
        return this.collectionOfValues[1];
    }

    private Object doRemove(Comparable comparable, int n) {
        Node node = this.lookup(comparable, n);
        Comparable comparable2 = null;
        if (node != null) {
            comparable2 = node.getData(this.oppositeIndex(n));
            this.doRedBlackDelete(node);
        }
        return comparable2;
    }

    private Object doGet(Comparable comparable, int n) {
        DoubleOrderedMap.checkNonNullComparable(comparable, n);
        Node node = this.lookup(comparable, n);
        return node == null ? null : node.getData(this.oppositeIndex(n));
    }

    private int oppositeIndex(int n) {
        return 1 - n;
    }

    private Node lookup(Comparable comparable, int n) {
        Node node = null;
        Node node2 = this.rootNode[n];
        while (node2 != null) {
            int n2 = DoubleOrderedMap.compare(comparable, node2.getData(n));
            if (n2 == 0) {
                node = node2;
                break;
            }
            node2 = n2 < 0 ? node2.getLeft(n) : node2.getRight(n);
        }
        return node;
    }

    private static int compare(Comparable comparable, Comparable comparable2) {
        return comparable.compareTo(comparable2);
    }

    private static Node leastNode(Node node, int n) {
        Node node2 = node;
        if (node2 != null) {
            while (node2.getLeft(n) != null) {
                node2 = node2.getLeft(n);
            }
        }
        return node2;
    }

    private Node nextGreater(Node node, int n) {
        Node node2 = null;
        if (node == null) {
            node2 = null;
        } else if (node.getRight(n) != null) {
            node2 = DoubleOrderedMap.leastNode(node.getRight(n), n);
        } else {
            Node node3 = node.getParent(n);
            Node node4 = node;
            while (node3 != null && node4 == node3.getRight(n)) {
                node4 = node3;
                node3 = node3.getParent(n);
            }
            node2 = node3;
        }
        return node2;
    }

    private static void copyColor(Node node, Node node2, int n) {
        if (node2 != null) {
            if (node == null) {
                node2.setBlack(n);
            } else {
                node2.copyColor(node, n);
            }
        }
    }

    private static boolean isRed(Node node, int n) {
        return node == null ? false : node.isRed(n);
    }

    private static boolean isBlack(Node node, int n) {
        return node == null ? true : node.isBlack(n);
    }

    private static void makeRed(Node node, int n) {
        if (node != null) {
            node.setRed(n);
        }
    }

    private static void makeBlack(Node node, int n) {
        if (node != null) {
            node.setBlack(n);
        }
    }

    private static Node getGrandParent(Node node, int n) {
        return DoubleOrderedMap.getParent(DoubleOrderedMap.getParent(node, n), n);
    }

    private static Node getParent(Node node, int n) {
        return node == null ? null : node.getParent(n);
    }

    private static Node getRightChild(Node node, int n) {
        return node == null ? null : node.getRight(n);
    }

    private static Node getLeftChild(Node node, int n) {
        return node == null ? null : node.getLeft(n);
    }

    private static boolean isLeftChild(Node node, int n) {
        return node == null ? true : (node.getParent(n) == null ? false : node == node.getParent(n).getLeft(n));
    }

    private static boolean isRightChild(Node node, int n) {
        return node == null ? true : (node.getParent(n) == null ? false : node == node.getParent(n).getRight(n));
    }

    private void rotateLeft(Node node, int n) {
        Node node2 = node.getRight(n);
        node.setRight(node2.getLeft(n), n);
        if (node2.getLeft(n) != null) {
            node2.getLeft(n).setParent(node, n);
        }
        node2.setParent(node.getParent(n), n);
        if (node.getParent(n) == null) {
            this.rootNode[n] = node2;
        } else if (node.getParent(n).getLeft(n) == node) {
            node.getParent(n).setLeft(node2, n);
        } else {
            node.getParent(n).setRight(node2, n);
        }
        node2.setLeft(node, n);
        node.setParent(node2, n);
    }

    private void rotateRight(Node node, int n) {
        Node node2 = node.getLeft(n);
        node.setLeft(node2.getRight(n), n);
        if (node2.getRight(n) != null) {
            node2.getRight(n).setParent(node, n);
        }
        node2.setParent(node.getParent(n), n);
        if (node.getParent(n) == null) {
            this.rootNode[n] = node2;
        } else if (node.getParent(n).getRight(n) == node) {
            node.getParent(n).setRight(node2, n);
        } else {
            node.getParent(n).setLeft(node2, n);
        }
        node2.setRight(node, n);
        node.setParent(node2, n);
    }

    private void doRedBlackInsert(Node node, int n) {
        Node node2 = node;
        DoubleOrderedMap.makeRed(node2, n);
        while (node2 != null && node2 != this.rootNode[n] && DoubleOrderedMap.isRed(node2.getParent(n), n)) {
            Node node3;
            if (DoubleOrderedMap.isLeftChild(DoubleOrderedMap.getParent(node2, n), n)) {
                node3 = DoubleOrderedMap.getRightChild(DoubleOrderedMap.getGrandParent(node2, n), n);
                if (DoubleOrderedMap.isRed(node3, n)) {
                    DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(node2, n), n);
                    DoubleOrderedMap.makeBlack(node3, n);
                    DoubleOrderedMap.makeRed(DoubleOrderedMap.getGrandParent(node2, n), n);
                    node2 = DoubleOrderedMap.getGrandParent(node2, n);
                    continue;
                }
                if (DoubleOrderedMap.isRightChild(node2, n)) {
                    node2 = DoubleOrderedMap.getParent(node2, n);
                    this.rotateLeft(node2, n);
                }
                DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(node2, n), n);
                DoubleOrderedMap.makeRed(DoubleOrderedMap.getGrandParent(node2, n), n);
                if (DoubleOrderedMap.getGrandParent(node2, n) == null) continue;
                this.rotateRight(DoubleOrderedMap.getGrandParent(node2, n), n);
                continue;
            }
            node3 = DoubleOrderedMap.getLeftChild(DoubleOrderedMap.getGrandParent(node2, n), n);
            if (DoubleOrderedMap.isRed(node3, n)) {
                DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(node2, n), n);
                DoubleOrderedMap.makeBlack(node3, n);
                DoubleOrderedMap.makeRed(DoubleOrderedMap.getGrandParent(node2, n), n);
                node2 = DoubleOrderedMap.getGrandParent(node2, n);
                continue;
            }
            if (DoubleOrderedMap.isLeftChild(node2, n)) {
                node2 = DoubleOrderedMap.getParent(node2, n);
                this.rotateRight(node2, n);
            }
            DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(node2, n), n);
            DoubleOrderedMap.makeRed(DoubleOrderedMap.getGrandParent(node2, n), n);
            if (DoubleOrderedMap.getGrandParent(node2, n) == null) continue;
            this.rotateLeft(DoubleOrderedMap.getGrandParent(node2, n), n);
        }
        DoubleOrderedMap.makeBlack(this.rootNode[n], n);
    }

    private void doRedBlackDelete(Node node) {
        for (int i = 0; i < 2; ++i) {
            Node node2;
            if (node.getLeft(i) != null && node.getRight(i) != null) {
                this.swapPosition(this.nextGreater(node, i), node, i);
            }
            Node node3 = node2 = node.getLeft(i) != null ? node.getLeft(i) : node.getRight(i);
            if (node2 != null) {
                node2.setParent(node.getParent(i), i);
                if (node.getParent(i) == null) {
                    this.rootNode[i] = node2;
                } else if (node == node.getParent(i).getLeft(i)) {
                    node.getParent(i).setLeft(node2, i);
                } else {
                    node.getParent(i).setRight(node2, i);
                }
                node.setLeft(null, i);
                node.setRight(null, i);
                node.setParent(null, i);
                if (!DoubleOrderedMap.isBlack(node, i)) continue;
                this.doRedBlackDeleteFixup(node2, i);
                continue;
            }
            if (node.getParent(i) == null) {
                this.rootNode[i] = null;
                continue;
            }
            if (DoubleOrderedMap.isBlack(node, i)) {
                this.doRedBlackDeleteFixup(node, i);
            }
            if (node.getParent(i) == null) continue;
            if (node == node.getParent(i).getLeft(i)) {
                node.getParent(i).setLeft(null, i);
            } else {
                node.getParent(i).setRight(null, i);
            }
            node.setParent(null, i);
        }
        this.shrink();
    }

    private void doRedBlackDeleteFixup(Node node, int n) {
        Node node2 = node;
        while (node2 != this.rootNode[n] && DoubleOrderedMap.isBlack(node2, n)) {
            Node node3;
            if (DoubleOrderedMap.isLeftChild(node2, n)) {
                node3 = DoubleOrderedMap.getRightChild(DoubleOrderedMap.getParent(node2, n), n);
                if (DoubleOrderedMap.isRed(node3, n)) {
                    DoubleOrderedMap.makeBlack(node3, n);
                    DoubleOrderedMap.makeRed(DoubleOrderedMap.getParent(node2, n), n);
                    this.rotateLeft(DoubleOrderedMap.getParent(node2, n), n);
                    node3 = DoubleOrderedMap.getRightChild(DoubleOrderedMap.getParent(node2, n), n);
                }
                if (DoubleOrderedMap.isBlack(DoubleOrderedMap.getLeftChild(node3, n), n) && DoubleOrderedMap.isBlack(DoubleOrderedMap.getRightChild(node3, n), n)) {
                    DoubleOrderedMap.makeRed(node3, n);
                    node2 = DoubleOrderedMap.getParent(node2, n);
                    continue;
                }
                if (DoubleOrderedMap.isBlack(DoubleOrderedMap.getRightChild(node3, n), n)) {
                    DoubleOrderedMap.makeBlack(DoubleOrderedMap.getLeftChild(node3, n), n);
                    DoubleOrderedMap.makeRed(node3, n);
                    this.rotateRight(node3, n);
                    node3 = DoubleOrderedMap.getRightChild(DoubleOrderedMap.getParent(node2, n), n);
                }
                DoubleOrderedMap.copyColor(DoubleOrderedMap.getParent(node2, n), node3, n);
                DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(node2, n), n);
                DoubleOrderedMap.makeBlack(DoubleOrderedMap.getRightChild(node3, n), n);
                this.rotateLeft(DoubleOrderedMap.getParent(node2, n), n);
                node2 = this.rootNode[n];
                continue;
            }
            node3 = DoubleOrderedMap.getLeftChild(DoubleOrderedMap.getParent(node2, n), n);
            if (DoubleOrderedMap.isRed(node3, n)) {
                DoubleOrderedMap.makeBlack(node3, n);
                DoubleOrderedMap.makeRed(DoubleOrderedMap.getParent(node2, n), n);
                this.rotateRight(DoubleOrderedMap.getParent(node2, n), n);
                node3 = DoubleOrderedMap.getLeftChild(DoubleOrderedMap.getParent(node2, n), n);
            }
            if (DoubleOrderedMap.isBlack(DoubleOrderedMap.getRightChild(node3, n), n) && DoubleOrderedMap.isBlack(DoubleOrderedMap.getLeftChild(node3, n), n)) {
                DoubleOrderedMap.makeRed(node3, n);
                node2 = DoubleOrderedMap.getParent(node2, n);
                continue;
            }
            if (DoubleOrderedMap.isBlack(DoubleOrderedMap.getLeftChild(node3, n), n)) {
                DoubleOrderedMap.makeBlack(DoubleOrderedMap.getRightChild(node3, n), n);
                DoubleOrderedMap.makeRed(node3, n);
                this.rotateLeft(node3, n);
                node3 = DoubleOrderedMap.getLeftChild(DoubleOrderedMap.getParent(node2, n), n);
            }
            DoubleOrderedMap.copyColor(DoubleOrderedMap.getParent(node2, n), node3, n);
            DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(node2, n), n);
            DoubleOrderedMap.makeBlack(DoubleOrderedMap.getLeftChild(node3, n), n);
            this.rotateRight(DoubleOrderedMap.getParent(node2, n), n);
            node2 = this.rootNode[n];
        }
        DoubleOrderedMap.makeBlack(node2, n);
    }

    private void swapPosition(Node node, Node node2, int n) {
        boolean bl;
        Node node3 = node.getParent(n);
        Node node4 = node.getLeft(n);
        Node node5 = node.getRight(n);
        Node node6 = node2.getParent(n);
        Node node7 = node2.getLeft(n);
        Node node8 = node2.getRight(n);
        boolean bl2 = node.getParent(n) != null && node == node.getParent(n).getLeft(n);
        boolean bl3 = bl = node2.getParent(n) != null && node2 == node2.getParent(n).getLeft(n);
        if (node == node6) {
            node.setParent(node2, n);
            if (bl) {
                node2.setLeft(node, n);
                node2.setRight(node5, n);
            } else {
                node2.setRight(node, n);
                node2.setLeft(node4, n);
            }
        } else {
            node.setParent(node6, n);
            if (node6 != null) {
                if (bl) {
                    node6.setLeft(node, n);
                } else {
                    node6.setRight(node, n);
                }
            }
            node2.setLeft(node4, n);
            node2.setRight(node5, n);
        }
        if (node2 == node3) {
            node2.setParent(node, n);
            if (bl2) {
                node.setLeft(node2, n);
                node.setRight(node8, n);
            } else {
                node.setRight(node2, n);
                node.setLeft(node7, n);
            }
        } else {
            node2.setParent(node3, n);
            if (node3 != null) {
                if (bl2) {
                    node3.setLeft(node2, n);
                } else {
                    node3.setRight(node2, n);
                }
            }
            node.setLeft(node7, n);
            node.setRight(node8, n);
        }
        if (node.getLeft(n) != null) {
            node.getLeft(n).setParent(node, n);
        }
        if (node.getRight(n) != null) {
            node.getRight(n).setParent(node, n);
        }
        if (node2.getLeft(n) != null) {
            node2.getLeft(n).setParent(node2, n);
        }
        if (node2.getRight(n) != null) {
            node2.getRight(n).setParent(node2, n);
        }
        node.swapColors(node2, n);
        if (this.rootNode[n] == node) {
            this.rootNode[n] = node2;
        } else if (this.rootNode[n] == node2) {
            this.rootNode[n] = node;
        }
    }

    private static void checkNonNullComparable(Object object, int n) {
        if (object == null) {
            throw new NullPointerException(dataName[n] + " cannot be null");
        }
        if (!(object instanceof Comparable)) {
            throw new ClassCastException(dataName[n] + " must be Comparable");
        }
    }

    private static void checkKey(Object object) {
        DoubleOrderedMap.checkNonNullComparable(object, 0);
    }

    private static void checkValue(Object object) {
        DoubleOrderedMap.checkNonNullComparable(object, 1);
    }

    private static void checkKeyAndValue(Object object, Object object2) {
        DoubleOrderedMap.checkKey(object);
        DoubleOrderedMap.checkValue(object2);
    }

    private void modify() {
        ++this.modifications;
    }

    private void grow() {
        this.modify();
        ++this.nodeCount;
    }

    private void shrink() {
        this.modify();
        --this.nodeCount;
    }

    private void insertValue(Node node) throws IllegalArgumentException {
        block4: {
            Node node2 = this.rootNode[1];
            while (true) {
                int n;
                if ((n = DoubleOrderedMap.compare(node.getData(1), node2.getData(1))) == 0) {
                    throw new IllegalArgumentException("Cannot store a duplicate value (\"" + node.getData(1) + "\") in this Map");
                }
                if (n < 0) {
                    if (node2.getLeft(1) != null) {
                        node2 = node2.getLeft(1);
                        continue;
                    }
                    node2.setLeft(node, 1);
                    node.setParent(node2, 1);
                    this.doRedBlackInsert(node, 1);
                    break block4;
                }
                if (node2.getRight(1) == null) break;
                node2 = node2.getRight(1);
            }
            node2.setRight(node, 1);
            node.setParent(node2, 1);
            this.doRedBlackInsert(node, 1);
        }
    }

    public int size() {
        return this.nodeCount;
    }

    public boolean containsKey(Object object) throws ClassCastException, NullPointerException {
        DoubleOrderedMap.checkKey(object);
        return this.lookup((Comparable)object, 0) != null;
    }

    public boolean containsValue(Object object) {
        DoubleOrderedMap.checkValue(object);
        return this.lookup((Comparable)object, 1) != null;
    }

    public Object get(Object object) throws ClassCastException, NullPointerException {
        return this.doGet((Comparable)object, 0);
    }

    public Object put(Object object, Object object2) throws ClassCastException, NullPointerException, IllegalArgumentException {
        block6: {
            DoubleOrderedMap.checkKeyAndValue(object, object2);
            Node node = this.rootNode[0];
            if (node == null) {
                Node node2;
                this.rootNode[0] = node2 = new Node((Comparable)object, (Comparable)object2);
                this.rootNode[1] = node2;
                this.grow();
            } else {
                while (true) {
                    int n;
                    if ((n = DoubleOrderedMap.compare((Comparable)object, node.getData(0))) == 0) {
                        throw new IllegalArgumentException("Cannot store a duplicate key (\"" + object + "\") in this Map");
                    }
                    if (n < 0) {
                        if (node.getLeft(0) != null) {
                            node = node.getLeft(0);
                            continue;
                        }
                        Node node3 = new Node((Comparable)object, (Comparable)object2);
                        this.insertValue(node3);
                        node.setLeft(node3, 0);
                        node3.setParent(node, 0);
                        this.doRedBlackInsert(node3, 0);
                        this.grow();
                        break block6;
                    }
                    if (node.getRight(0) == null) break;
                    node = node.getRight(0);
                }
                Node node4 = new Node((Comparable)object, (Comparable)object2);
                this.insertValue(node4);
                node.setRight(node4, 0);
                node4.setParent(node, 0);
                this.doRedBlackInsert(node4, 0);
                this.grow();
            }
        }
        return null;
    }

    public Object remove(Object object) {
        return this.doRemove((Comparable)object, 0);
    }

    public void clear() {
        this.modify();
        this.nodeCount = 0;
        this.rootNode[0] = null;
        this.rootNode[1] = null;
    }

    public Set keySet() {
        if (this.setOfKeys[0] == null) {
            this.setOfKeys[0] = new AbstractSet(){

                public Iterator iterator() {
                    return new DoubleOrderedMapIterator(this, 0){
                        private final /* synthetic */ 7 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        protected Object doGetNext() {
                            return Node.access$200(this.lastReturnedNode, 0);
                        }
                    };
                }

                public int size() {
                    return DoubleOrderedMap.this.size();
                }

                public boolean contains(Object object) {
                    return DoubleOrderedMap.this.containsKey(object);
                }

                public boolean remove(Object object) {
                    int n = DoubleOrderedMap.this.nodeCount;
                    DoubleOrderedMap.this.remove(object);
                    return DoubleOrderedMap.this.nodeCount != n;
                }

                public void clear() {
                    DoubleOrderedMap.this.clear();
                }

                static /* synthetic */ DoubleOrderedMap access$1900(7 var0) {
                    return var0.DoubleOrderedMap.this;
                }
            };
        }
        return this.setOfKeys[0];
    }

    public Collection values() {
        if (this.collectionOfValues[0] == null) {
            this.collectionOfValues[0] = new AbstractCollection(){

                public Iterator iterator() {
                    return new DoubleOrderedMapIterator(this, 0){
                        private final /* synthetic */ 9 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        protected Object doGetNext() {
                            return Node.access$200(this.lastReturnedNode, 1);
                        }
                    };
                }

                public int size() {
                    return DoubleOrderedMap.this.size();
                }

                public boolean contains(Object object) {
                    return DoubleOrderedMap.this.containsValue(object);
                }

                public boolean remove(Object object) {
                    int n = DoubleOrderedMap.this.nodeCount;
                    DoubleOrderedMap.this.removeValue(object);
                    return DoubleOrderedMap.this.nodeCount != n;
                }

                public boolean removeAll(Collection collection) {
                    boolean bl = false;
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        if (DoubleOrderedMap.this.removeValue(iterator.next()) == null) continue;
                        bl = true;
                    }
                    return bl;
                }

                public void clear() {
                    DoubleOrderedMap.this.clear();
                }

                static /* synthetic */ DoubleOrderedMap access$2000(9 var0) {
                    return var0.DoubleOrderedMap.this;
                }
            };
        }
        return this.collectionOfValues[0];
    }

    public Set entrySet() {
        if (this.setOfEntries[0] == null) {
            this.setOfEntries[0] = new AbstractSet(){

                public Iterator iterator() {
                    return new DoubleOrderedMapIterator(this, 0){
                        private final /* synthetic */ 11 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        protected Object doGetNext() {
                            return this.lastReturnedNode;
                        }
                    };
                }

                public boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object v = entry.getValue();
                    Node node = DoubleOrderedMap.this.lookup((Comparable)entry.getKey(), 0);
                    return node != null && node.getData(1).equals(v);
                }

                public boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object v = entry.getValue();
                    Node node = DoubleOrderedMap.this.lookup((Comparable)entry.getKey(), 0);
                    if (node != null && node.getData(1).equals(v)) {
                        DoubleOrderedMap.this.doRedBlackDelete(node);
                        return true;
                    }
                    return false;
                }

                public int size() {
                    return DoubleOrderedMap.this.size();
                }

                public void clear() {
                    DoubleOrderedMap.this.clear();
                }

                static /* synthetic */ DoubleOrderedMap access$2100(11 var0) {
                    return var0.DoubleOrderedMap.this;
                }
            };
        }
        return this.setOfEntries[0];
    }

    private abstract class DoubleOrderedMapIterator
    implements Iterator {
        private int expectedModifications;
        protected Node lastReturnedNode;
        private Node nextNode;
        private int iteratorType;

        DoubleOrderedMapIterator(int n) {
            this.iteratorType = n;
            this.expectedModifications = DoubleOrderedMap.this.modifications;
            this.lastReturnedNode = null;
            this.nextNode = DoubleOrderedMap.leastNode(DoubleOrderedMap.this.rootNode[this.iteratorType], this.iteratorType);
        }

        protected abstract Object doGetNext();

        public final boolean hasNext() {
            return this.nextNode != null;
        }

        public final Object next() throws NoSuchElementException, ConcurrentModificationException {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            if (DoubleOrderedMap.this.modifications != this.expectedModifications) {
                throw new ConcurrentModificationException();
            }
            this.lastReturnedNode = this.nextNode;
            this.nextNode = DoubleOrderedMap.this.nextGreater(this.nextNode, this.iteratorType);
            return this.doGetNext();
        }

        public final void remove() throws IllegalStateException, ConcurrentModificationException {
            if (this.lastReturnedNode == null) {
                throw new IllegalStateException();
            }
            if (DoubleOrderedMap.this.modifications != this.expectedModifications) {
                throw new ConcurrentModificationException();
            }
            DoubleOrderedMap.this.doRedBlackDelete(this.lastReturnedNode);
            ++this.expectedModifications;
            this.lastReturnedNode = null;
        }
    }

    private static final class Node
    implements Map.Entry {
        private Comparable[] data;
        private Node[] leftNode;
        private Node[] rightNode;
        private Node[] parentNode;
        private boolean[] blackColor;
        private int hashcodeValue;
        private boolean calculatedHashCode;

        Node(Comparable comparable, Comparable comparable2) {
            this.data = new Comparable[]{comparable, comparable2};
            this.leftNode = new Node[]{null, null};
            this.rightNode = new Node[]{null, null};
            this.parentNode = new Node[]{null, null};
            this.blackColor = new boolean[]{true, true};
            this.calculatedHashCode = false;
        }

        private Comparable getData(int n) {
            return this.data[n];
        }

        private void setLeft(Node node, int n) {
            this.leftNode[n] = node;
        }

        private Node getLeft(int n) {
            return this.leftNode[n];
        }

        private void setRight(Node node, int n) {
            this.rightNode[n] = node;
        }

        private Node getRight(int n) {
            return this.rightNode[n];
        }

        private void setParent(Node node, int n) {
            this.parentNode[n] = node;
        }

        private Node getParent(int n) {
            return this.parentNode[n];
        }

        private void swapColors(Node node, int n) {
            int n2 = n;
            this.blackColor[n2] = this.blackColor[n2] ^ node.blackColor[n];
            int n3 = n;
            node.blackColor[n3] = node.blackColor[n3] ^ this.blackColor[n];
            int n4 = n;
            this.blackColor[n4] = this.blackColor[n4] ^ node.blackColor[n];
        }

        private boolean isBlack(int n) {
            return this.blackColor[n];
        }

        private boolean isRed(int n) {
            return !this.blackColor[n];
        }

        private void setBlack(int n) {
            this.blackColor[n] = true;
        }

        private void setRed(int n) {
            this.blackColor[n] = false;
        }

        private void copyColor(Node node, int n) {
            this.blackColor[n] = node.blackColor[n];
        }

        public Object getKey() {
            return this.data[0];
        }

        public Object getValue() {
            return this.data[1];
        }

        public Object setValue(Object object) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Map.Entry.setValue is not supported");
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return this.data[0].equals(entry.getKey()) && this.data[1].equals(entry.getValue());
        }

        public int hashCode() {
            if (!this.calculatedHashCode) {
                this.hashcodeValue = this.data[0].hashCode() ^ this.data[1].hashCode();
                this.calculatedHashCode = true;
            }
            return this.hashcodeValue;
        }
    }
}

