/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseContextMap<V>
extends AbstractMap<String, V> {
    private Set<Map.Entry<String, V>> entrySet;
    private Set<String> keySet;
    private Collection<V> values;

    BaseContextMap() {
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public Set<String> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new ValueCollection();
        }
        return this.values;
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    protected boolean removeKey(Object key) {
        return this.remove(key) != null;
    }

    protected boolean removeValue(Object value) {
        boolean valueRemoved = false;
        if (value == null) {
            return false;
        }
        if (this.containsValue(value)) {
            for (Map.Entry<String, V> e : this.entrySet()) {
                if (!value.equals(e.getValue())) continue;
                valueRemoved = this.remove(e.getKey()) != null;
            }
        }
        return valueRemoved;
    }

    protected abstract Iterator<Map.Entry<String, V>> getEntryIterator();

    protected abstract Iterator<String> getKeyIterator();

    protected abstract Iterator<V> getValueIterator();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class BaseIterator<E>
    implements Iterator<E> {
        protected Enumeration e;
        protected String currentKey;
        protected boolean removeCalled = false;

        BaseIterator(Enumeration e) {
            this.e = e;
        }

        @Override
        public boolean hasNext() {
            return this.e.hasMoreElements();
        }

        public String nextKey() {
            this.removeCalled = false;
            this.currentKey = (String)this.e.nextElement();
            return this.currentKey;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class BaseSet<E>
    extends AbstractSet<E> {
        BaseSet() {
        }

        @Override
        public int size() {
            int size = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                i.next();
                ++size;
            }
            return size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Entry<V>
    implements Map.Entry<String, V> {
        private final String key;
        private final V value;

        Entry(String key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry input = (Map.Entry)obj;
            Object inputKey = input.getKey();
            Object inputValue = input.getValue();
            return (inputKey == this.key || inputKey != null && inputKey.equals(this.key)) && (inputValue == this.value || inputValue != null && inputValue.equals(this.value));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntryIterator
    extends BaseIterator<Map.Entry<String, V>> {
        EntryIterator(Enumeration e) {
            super(e);
        }

        @Override
        public void remove() {
            if (this.currentKey == null || this.removeCalled) {
                throw new IllegalStateException();
            }
            this.removeCalled = true;
            BaseContextMap.this.removeKey(this.currentKey);
        }

        @Override
        public Map.Entry<String, V> next() {
            this.nextKey();
            return new Entry(this.currentKey, BaseContextMap.this.get(this.currentKey));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntrySet
    extends BaseSet<Map.Entry<String, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<String, V>> iterator() {
            return BaseContextMap.this.getEntryIterator();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            return BaseContextMap.this.removeKey(((Map.Entry)o).getKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class KeyIterator
    extends BaseIterator<String> {
        KeyIterator(Enumeration e) {
            super(e);
        }

        @Override
        public void remove() {
            if (this.currentKey == null || this.removeCalled) {
                throw new IllegalStateException();
            }
            this.removeCalled = true;
            BaseContextMap.this.removeKey(this.currentKey);
        }

        @Override
        public String next() {
            return this.nextKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class KeySet
    extends BaseSet<String> {
        KeySet() {
        }

        @Override
        public Iterator<String> iterator() {
            return BaseContextMap.this.getKeyIterator();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof String)) {
                return false;
            }
            return BaseContextMap.this.removeKey((String)o);
        }

        @Override
        public boolean contains(Object o) {
            return BaseContextMap.this.containsKey(o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ValueCollection
    extends AbstractCollection<V> {
        ValueCollection() {
        }

        @Override
        public int size() {
            int size = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                i.next();
                ++size;
            }
            return size;
        }

        @Override
        public Iterator<V> iterator() {
            return BaseContextMap.this.getValueIterator();
        }

        @Override
        public boolean remove(Object o) {
            return BaseContextMap.this.removeValue(o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ValueIterator
    extends BaseIterator<V> {
        ValueIterator(Enumeration e) {
            super(e);
        }

        @Override
        public void remove() {
            if (this.currentKey == null || this.removeCalled) {
                throw new IllegalStateException();
            }
            this.removeCalled = true;
            BaseContextMap.this.removeValue(BaseContextMap.this.get(this.currentKey));
        }

        @Override
        public V next() {
            this.nextKey();
            return BaseContextMap.this.get(this.currentKey);
        }
    }
}

